package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonFinalInstanceFields}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNonFinalInstanceFields.builder()}.
 */
@Generated(from = "NonFinalInstanceFields", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNonFinalInstanceFields
    implements NonFinalInstanceFields {
  private int a;
  private String b;
  private ImmutableList<Boolean> c;

  protected ImmutableNonFinalInstanceFields() {
    this.a = 0;
    this.b = null;
    this.c = null;
  }

  private ImmutableNonFinalInstanceFields(int a, String b, ImmutableList<Boolean> c) {
    this.a = a;
    this.b = b;
    this.c = c;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public ImmutableList<Boolean> c() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonFinalInstanceFields#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNonFinalInstanceFields withA(int value) {
    if (this.a == value) return this;
    return new ImmutableNonFinalInstanceFields(value, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonFinalInstanceFields#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNonFinalInstanceFields withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (Objects.equals(this.b, newValue)) return this;
    return new ImmutableNonFinalInstanceFields(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonFinalInstanceFields#c() c}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonFinalInstanceFields withC(boolean... elements) {
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(Booleans.asList(elements));
    return new ImmutableNonFinalInstanceFields(this.a, this.b, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonFinalInstanceFields#c() c}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of c elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonFinalInstanceFields withC(Iterable<Boolean> elements) {
    if (this.c == elements) return this;
    ImmutableList<Boolean> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNonFinalInstanceFields(this.a, this.b, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNonFinalInstanceFields} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNonFinalInstanceFields
        && equalTo(0, (ImmutableNonFinalInstanceFields) another);
  }

  private boolean equalTo(int synthetic, ImmutableNonFinalInstanceFields another) {
    return a == another.a
        && b.equals(another.b)
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code NonFinalInstanceFields} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NonFinalInstanceFields")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link NonFinalInstanceFields} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NonFinalInstanceFields instance
   */
  public static ImmutableNonFinalInstanceFields copyOf(NonFinalInstanceFields instance) {
    if (instance instanceof ImmutableNonFinalInstanceFields) {
      return (ImmutableNonFinalInstanceFields) instance;
    }
    return ImmutableNonFinalInstanceFields.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNonFinalInstanceFields ImmutableNonFinalInstanceFields}.
   * <pre>
   * ImmutableNonFinalInstanceFields.builder()
   *    .a(int) // required {@link NonFinalInstanceFields#a() a}
   *    .b(String) // required {@link NonFinalInstanceFields#b() b}
   *    .addC|addAllC(boolean) // {@link NonFinalInstanceFields#c() c} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNonFinalInstanceFields builder
   */
  public static ImmutableNonFinalInstanceFields.Builder builder() {
    return new ImmutableNonFinalInstanceFields.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNonFinalInstanceFields ImmutableNonFinalInstanceFields}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NonFinalInstanceFields", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private long initBits = 0x3L;

    private int a;
    private @Nullable String b;
    private ImmutableList.Builder<Boolean> c = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NonFinalInstanceFields} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NonFinalInstanceFields instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      addAllC(instance.c());
      return this;
    }

    /**
     * Initializes the value for the {@link NonFinalInstanceFields#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link NonFinalInstanceFields#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Adds one element to {@link NonFinalInstanceFields#c() c} list.
     * @param element A c element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addC(boolean element) {
      this.c.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NonFinalInstanceFields#c() c} list.
     * @param elements An array of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addC(boolean... elements) {
      this.c.addAll(Booleans.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NonFinalInstanceFields#c() c} list.
     * @param elements An iterable of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(Iterable<Boolean> elements) {
      this.c = ImmutableList.builder();
      return addAllC(elements);
    }

    /**
     * Adds elements to {@link NonFinalInstanceFields#c() c} list.
     * @param elements An iterable of c elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllC(Iterable<Boolean> elements) {
      this.c.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNonFinalInstanceFields ImmutableNonFinalInstanceFields}.
     * @return An immutable instance of NonFinalInstanceFields
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNonFinalInstanceFields build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNonFinalInstanceFields(a, b, c.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      return "Cannot build NonFinalInstanceFields, some of required attributes are not set " + attributes;
    }
  }
}
