package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionalWithoutNullable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionalWithoutNullable.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableOptionalWithoutNullable.of()}.
 */
@Generated(from = "OptionalWithoutNullable", generator = "Immutables")
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionalWithoutNullable
    implements OptionalWithoutNullable {
  private final @Nullable String javaOptional;
  private final @Nullable Integer javaOptionalInt;
  private final Optional<String> guavaOptional;
  private final @Nullable String javaOptionalStringParameter;

  private ImmutableOptionalWithoutNullable(java.util.Optional<String> javaOptionalStringParameter) {
    this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
    this.javaOptional = null;
    this.javaOptionalInt = null;
    this.guavaOptional = Optional.absent();
  }

  private ImmutableOptionalWithoutNullable(
      @Nullable String javaOptional,
      @Nullable Integer javaOptionalInt,
      Optional<String> guavaOptional,
      @Nullable String javaOptionalStringParameter) {
    this.javaOptional = javaOptional;
    this.javaOptionalInt = javaOptionalInt;
    this.guavaOptional = guavaOptional;
    this.javaOptionalStringParameter = javaOptionalStringParameter;
  }

  /**
   * @return The value of the {@code javaOptional} attribute
   */
  @Override
  public java.util.Optional<String> getJavaOptional() {
    return java.util.Optional.ofNullable(javaOptional);
  }

  /**
   * @return The value of the {@code javaOptionalInt} attribute
   */
  @Override
  public OptionalInt getJavaOptionalInt() {
    return javaOptionalInt != null
        ? OptionalInt.of(javaOptionalInt)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code guavaOptional} attribute
   */
  @Override
  public Optional<String> getGuavaOptional() {
    return guavaOptional;
  }

  /**
   * @return The value of the {@code javaOptionalStringParameter} attribute
   */
  @Override
  public java.util.Optional<String> getJavaOptionalStringParameter() {
    return java.util.Optional.ofNullable(javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithoutNullable#getJavaOptional() javaOptional} attribute.
   * @param value The value for javaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptional(String value) {
    String newValue = Objects.requireNonNull(value, "javaOptional");
    if (Objects.equals(this.javaOptional, newValue)) return this;
    return new ImmutableOptionalWithoutNullable(newValue, this.javaOptionalInt, this.guavaOptional, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithoutNullable#getJavaOptional() javaOptional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptional(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.javaOptional, value)) return this;
    return new ImmutableOptionalWithoutNullable(value, this.javaOptionalInt, this.guavaOptional, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithoutNullable#getJavaOptionalInt() javaOptionalInt} attribute.
   * @param value The value for javaOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptionalInt(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.javaOptionalInt, newValue)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, newValue, this.guavaOptional, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithoutNullable#getJavaOptionalInt() javaOptionalInt} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptionalInt(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.javaOptionalInt, value)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, value, this.guavaOptional, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithoutNullable#getGuavaOptional() guavaOptional} attribute.
   * @param value The value for guavaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withGuavaOptional(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.guavaOptional.equals(newValue)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, newValue, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithoutNullable#getGuavaOptional() guavaOptional} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for guavaOptional
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withGuavaOptional(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.guavaOptional.equals(value)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, value, this.javaOptionalStringParameter);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionalWithoutNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} attribute.
   * @param value The value for javaOptionalStringParameter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptionalStringParameter(String value) {
    String newValue = Objects.requireNonNull(value, "javaOptionalStringParameter");
    if (Objects.equals(this.javaOptionalStringParameter, newValue)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionalWithoutNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for javaOptionalStringParameter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionalWithoutNullable withJavaOptionalStringParameter(java.util.Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.javaOptionalStringParameter, value)) return this;
    return new ImmutableOptionalWithoutNullable(this.javaOptional, this.javaOptionalInt, this.guavaOptional, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionalWithoutNullable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionalWithoutNullable
        && equalTo(0, (ImmutableOptionalWithoutNullable) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionalWithoutNullable another) {
    return Objects.equals(javaOptional, another.javaOptional)
        && Objects.equals(javaOptionalInt, another.javaOptionalInt)
        && guavaOptional.equals(another.guavaOptional)
        && Objects.equals(javaOptionalStringParameter, another.javaOptionalStringParameter);
  }

  /**
   * Computes a hash code from attributes: {@code javaOptional}, {@code javaOptionalInt}, {@code guavaOptional}, {@code javaOptionalStringParameter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(javaOptional);
    h += (h << 5) + Objects.hashCode(javaOptionalInt);
    h += (h << 5) + guavaOptional.hashCode();
    h += (h << 5) + Objects.hashCode(javaOptionalStringParameter);
    return h;
  }

  /**
   * Prints the immutable value {@code OptionalWithoutNullable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionalWithoutNullable")
        .omitNullValues()
        .add("javaOptional", javaOptional)
        .add("javaOptionalInt", javaOptionalInt)
        .add("guavaOptional", guavaOptional.orNull())
        .add("javaOptionalStringParameter", javaOptionalStringParameter)
        .toString();
  }

  /**
   * Construct a new immutable {@code OptionalWithoutNullable} instance.
   * @param javaOptionalStringParameter The value for the {@code javaOptionalStringParameter} attribute
   * @return An immutable OptionalWithoutNullable instance
   */
  public static ImmutableOptionalWithoutNullable of(java.util.Optional<String> javaOptionalStringParameter) {
    return new ImmutableOptionalWithoutNullable(javaOptionalStringParameter);
  }

  /**
   * Creates an immutable copy of a {@link OptionalWithoutNullable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionalWithoutNullable instance
   */
  public static ImmutableOptionalWithoutNullable copyOf(OptionalWithoutNullable instance) {
    if (instance instanceof ImmutableOptionalWithoutNullable) {
      return (ImmutableOptionalWithoutNullable) instance;
    }
    return ImmutableOptionalWithoutNullable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionalWithoutNullable ImmutableOptionalWithoutNullable}.
   * <pre>
   * ImmutableOptionalWithoutNullable.builder()
   *    .javaOptional(String) // optional {@link OptionalWithoutNullable#getJavaOptional() javaOptional}
   *    .javaOptionalInt(int) // optional {@link OptionalWithoutNullable#getJavaOptionalInt() javaOptionalInt}
   *    .guavaOptional(String) // optional {@link OptionalWithoutNullable#getGuavaOptional() guavaOptional}
   *    .javaOptionalStringParameter(String) // optional {@link OptionalWithoutNullable#getJavaOptionalStringParameter() javaOptionalStringParameter}
   *    .build();
   * </pre>
   * @return A new ImmutableOptionalWithoutNullable builder
   */
  public static ImmutableOptionalWithoutNullable.Builder builder() {
    return new ImmutableOptionalWithoutNullable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionalWithoutNullable ImmutableOptionalWithoutNullable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionalWithoutNullable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String javaOptional;
    private @Nullable Integer javaOptionalInt;
    private Optional<String> guavaOptional = Optional.absent();
    private @Nullable String javaOptionalStringParameter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionalWithoutNullable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionalWithoutNullable instance) {
      Objects.requireNonNull(instance, "instance");
      java.util.Optional<String> javaOptionalOptional = instance.getJavaOptional();
      if (javaOptionalOptional.isPresent()) {
        javaOptional(javaOptionalOptional);
      }
      OptionalInt javaOptionalIntOptional = instance.getJavaOptionalInt();
      if (javaOptionalIntOptional.isPresent()) {
        javaOptionalInt(javaOptionalIntOptional);
      }
      Optional<String> guavaOptionalOptional = instance.getGuavaOptional();
      if (guavaOptionalOptional.isPresent()) {
        guavaOptional(guavaOptionalOptional);
      }
      java.util.Optional<String> javaOptionalStringParameterOptional = instance.getJavaOptionalStringParameter();
      if (javaOptionalStringParameterOptional.isPresent()) {
        javaOptionalStringParameter(javaOptionalStringParameterOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptional() javaOptional} to javaOptional.
     * @param javaOptional The value for javaOptional
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptional(String javaOptional) {
      this.javaOptional = Objects.requireNonNull(javaOptional, "javaOptional");
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptional() javaOptional} to javaOptional.
     * @param javaOptional The value for javaOptional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptional(java.util.Optional<String> javaOptional) {
      this.javaOptional = javaOptional.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptionalInt() javaOptionalInt} to javaOptionalInt.
     * @param javaOptionalInt The value for javaOptionalInt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInt(int javaOptionalInt) {
      this.javaOptionalInt = javaOptionalInt;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptionalInt() javaOptionalInt} to javaOptionalInt.
     * @param javaOptionalInt The value for javaOptionalInt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalInt(OptionalInt javaOptionalInt) {
      this.javaOptionalInt = javaOptionalInt.isPresent() ? javaOptionalInt.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getGuavaOptional() guavaOptional} to guavaOptional.
     * @param guavaOptional The value for guavaOptional
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder guavaOptional(String guavaOptional) {
      this.guavaOptional = Optional.of(guavaOptional);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getGuavaOptional() guavaOptional} to guavaOptional.
     * @param guavaOptional The value for guavaOptional
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder guavaOptional(Optional<String> guavaOptional) {
      this.guavaOptional = guavaOptional;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} to javaOptionalStringParameter.
     * @param javaOptionalStringParameter The value for javaOptionalStringParameter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalStringParameter(String javaOptionalStringParameter) {
      this.javaOptionalStringParameter = Objects.requireNonNull(javaOptionalStringParameter, "javaOptionalStringParameter");
      return this;
    }

    /**
     * Initializes the optional value {@link OptionalWithoutNullable#getJavaOptionalStringParameter() javaOptionalStringParameter} to javaOptionalStringParameter.
     * @param javaOptionalStringParameter The value for javaOptionalStringParameter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder javaOptionalStringParameter(java.util.Optional<String> javaOptionalStringParameter) {
      this.javaOptionalStringParameter = javaOptionalStringParameter.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionalWithoutNullable ImmutableOptionalWithoutNullable}.
     * @return An immutable instance of OptionalWithoutNullable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionalWithoutNullable build() {
      return new ImmutableOptionalWithoutNullable(javaOptional, javaOptionalInt, guavaOptional, javaOptionalStringParameter);
    }
  }
}
