package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransientDerivedFields.Ser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSer.builder()}.
 */
@Generated(from = "TransientDerivedFields.Ser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSer implements TransientDerivedFields.Ser {
  private final int def;

  private ImmutableSer(ImmutableSer.Builder builder) {
    this.def = TransientDerivedFields.Ser.super.def();
  }

  /**
   * @return The computed-at-construction value of the {@code def} attribute
   */
  @Override
  public int def() {
    return def;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSer
        && equalTo(0, (ImmutableSer) another);
  }

  private boolean equalTo(int synthetic, ImmutableSer another) {
    return def == another.def;
  }

  /**
   * Computes a hash code from attributes: {@code def}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + def;
    return h;
  }

  /**
   * Prints the immutable value {@code Ser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Ser")
        .omitNullValues()
        .add("def", def)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransientDerivedFields.Ser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Ser instance
   */
  public static ImmutableSer copyOf(TransientDerivedFields.Ser instance) {
    if (instance instanceof ImmutableSer) {
      return (ImmutableSer) instance;
    }
    return ImmutableSer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSer ImmutableSer}.
   * <pre>
   * ImmutableSer.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableSer builder
   */
  public static ImmutableSer.Builder builder() {
    return new ImmutableSer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSer ImmutableSer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransientDerivedFields.Ser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Ser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransientDerivedFields.Ser instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSer ImmutableSer}.
     * @return An immutable instance of Ser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSer build() {
      return new ImmutableSer(this);
    }
  }
}
