package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UnderrideObjectMethods.StaticUnderride}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStaticUnderride.builder()}.
 */
@Generated(from = "UnderrideObjectMethods.StaticUnderride", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStaticUnderride
    implements UnderrideObjectMethods.StaticUnderride {

  private ImmutableStaticUnderride(ImmutableStaticUnderride.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStaticUnderride} that have equal attribute values or
   * as defined by custom equality check method in supertype.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return another instanceof ImmutableStaticUnderride
        && UnderrideObjectMethods.StaticUnderride.equalTo(this, (ImmutableStaticUnderride)another);
  }

  /**
   * Returns a hashCode computed by customized in supertype implementation.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return UnderrideObjectMethods.StaticUnderride.hash(this);
  }

  /**
   * Prints the immutable value {@code StaticUnderride} delegating to a customized method.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return UnderrideObjectMethods.StaticUnderride.stringify(this);
  }

  /**
   * Creates an immutable copy of a {@link UnderrideObjectMethods.StaticUnderride} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StaticUnderride instance
   */
  public static ImmutableStaticUnderride copyOf(UnderrideObjectMethods.StaticUnderride instance) {
    if (instance instanceof ImmutableStaticUnderride) {
      return (ImmutableStaticUnderride) instance;
    }
    return ImmutableStaticUnderride.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStaticUnderride ImmutableStaticUnderride}.
   * <pre>
   * ImmutableStaticUnderride.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableStaticUnderride builder
   */
  public static ImmutableStaticUnderride.Builder builder() {
    return new ImmutableStaticUnderride.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStaticUnderride ImmutableStaticUnderride}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UnderrideObjectMethods.StaticUnderride", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableStaticUnderride} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableStaticUnderride instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code StaticUnderride} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(UnderrideObjectMethods.StaticUnderride instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableStaticUnderride) {
        return from((ModifiableStaticUnderride) instance);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStaticUnderride ImmutableStaticUnderride}.
     * @return An immutable instance of StaticUnderride
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStaticUnderride build() {
      return new ImmutableStaticUnderride(this);
    }
  }
}
