package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransientDerivedFields.StrSer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStrSer.builder()}.
 */
@Generated(from = "TransientDerivedFields.StrSer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStrSer implements TransientDerivedFields.StrSer {
  private transient final int def;

  private ImmutableStrSer(ImmutableStrSer.Builder builder) {
    this.def = TransientDerivedFields.StrSer.super.def();
  }

  /**
   * @return The computed-at-construction value of the {@code def} attribute
   */
  @Override
  public int def() {
    return def;
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStrSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStrSer
        && equalTo(0, (ImmutableStrSer) another);
  }

  private boolean equalTo(int synthetic, ImmutableStrSer another) {
    return def == another.def;
  }

  /**
   * Computes a hash code from attributes: {@code def}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + def;
    return h;
  }

  /**
   * Prints the immutable value {@code StrSer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StrSer")
        .omitNullValues()
        .add("def", def)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransientDerivedFields.StrSer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StrSer instance
   */
  public static ImmutableStrSer copyOf(TransientDerivedFields.StrSer instance) {
    if (instance instanceof ImmutableStrSer) {
      return (ImmutableStrSer) instance;
    }
    return ImmutableStrSer.builder()
        .from(instance)
        .build();
  }

  /**
   * The serialized form captures the structural content of the value object,
   * providing the ability to reconstruct values with the capability to migrate
   * data. Uses optional, nullable, and provides flexible handling of
   * collection attributes.
   */
  @Generated(from = "TransientDerivedFields.StrSer", generator = "Immutables")
  private static class SerialForm implements Serializable {
    private static final long serialVersionUID = 0L;
    private final String[] names;
    private final Object[] values;
    SerialForm(ImmutableStrSer instance) {
      List<String> names = new ArrayList<>(0);
      List<Object> values = new ArrayList<>(0);
      this.names = names.toArray(new String[names.size()]);
      this.values = values.toArray();
    }

    Object readResolve() {
      ImmutableStrSer.Builder builder = ImmutableStrSer.builder();

      for (int i = 0; i < names.length; i++) {
        String name = names[i];
      }
      return builder.build();
    }

    private static Object toSingle(String attribute, Object value) {
      if (value instanceof Object[]) {
        Object[] elements = (Object[]) value;
        if (elements.length == 1) {
          return elements[0];
        }
        throw new IllegalStateException("Cannot extract scalar value for attribute '"
            + attribute + "' from array of length " + elements.length);
      }
      return value;
    }
  }

  private Object writeReplace() {
    return new SerialForm(this);
  }

  /**
   * Creates a builder for {@link ImmutableStrSer ImmutableStrSer}.
   * <pre>
   * ImmutableStrSer.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableStrSer builder
   */
  public static ImmutableStrSer.Builder builder() {
    return new ImmutableStrSer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStrSer ImmutableStrSer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransientDerivedFields.StrSer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StrSer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransientDerivedFields.StrSer instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableStrSer ImmutableStrSer}.
     * @return An immutable instance of StrSer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStrSer build() {
      return new ImmutableStrSer(this);
    }
  }
}
