package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Feature combination
 * <ul>
 * <li>Abstract type and accessor name detection
 * <li>Generated builder naming customization
 * </ul>
 */
@Generated(from = "AbstractValueNamingDetected", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ValueNamingDetected extends AbstractValueNamingDetected {
  private final int val;
  private final ImmutableSet<String> str;

  private ValueNamingDetected(int val, ImmutableSet<String> str) {
    this.val = val;
    this.str = str;
  }

  /**
   * @return The value of the {@code val} attribute
   */
  @Override
  public int extractVal() {
    return val;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public ImmutableSet<String> collectStr() {
    return str;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueNamingDetected#extractVal() val} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for val
   * @return A modified copy of the {@code this} object
   */
  public final ValueNamingDetected withVal(int value) {
    if (this.val == value) return this;
    return new ValueNamingDetected(value, this.str);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueNamingDetected#collectStr() str}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ValueNamingDetected withStr(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ValueNamingDetected(this.val, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ValueNamingDetected#collectStr() str}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of str elements to set
   * @return A modified copy of {@code this} object
   */
  public final ValueNamingDetected withStr(Iterable<String> elements) {
    if (this.str == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ValueNamingDetected(this.val, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ValueNamingDetected} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ValueNamingDetected
        && equalTo(0, (ValueNamingDetected) another);
  }

  private boolean equalTo(int synthetic, ValueNamingDetected another) {
    return val == another.val
        && str.equals(another.str);
  }

  /**
   * Computes a hash code from attributes: {@code val}, {@code str}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + val;
    h += (h << 5) + str.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ValueNamingDetected} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueNamingDetected")
        .omitNullValues()
        .add("val", val)
        .add("str", str)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractValueNamingDetected} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueNamingDetected instance
   */
  static ValueNamingDetected copyOf(AbstractValueNamingDetected instance) {
    if (instance instanceof ValueNamingDetected) {
      return (ValueNamingDetected) instance;
    }
    return ValueNamingDetected.newBuilder()
        .from(instance)
        .buildValueNamingDetected();
  }

  /**
   * Creates a builder for {@link ValueNamingDetected ValueNamingDetected}.
   * <pre>
   * ValueNamingDetected.newBuilder()
   *    .usingVal(int) // required {@link ValueNamingDetected#extractVal() val}
   *    .withStrAppended|addAllStr(String) // {@link ValueNamingDetected#collectStr() str} elements
   *    .buildValueNamingDetected();
   * </pre>
   * @return A new ValueNamingDetected builder
   */
  public static ValueNamingDetected.Builder newBuilder() {
    return new ValueNamingDetected.Builder();
  }

  /**
   * Builds instances of type {@link ValueNamingDetected ValueNamingDetected}.
   * Initialize attributes and then invoke the {@link #buildValueNamingDetected()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractValueNamingDetected", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VAL = 0x1L;
    private long initBits = 0x1L;

    private int val;
    private ImmutableSet.Builder<String> str = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ValueNamingDetected} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ValueNamingDetected instance) {
      return from((AbstractValueNamingDetected) instance);
    }

    /**
     * Copy abstract value type {@code AbstractValueNamingDetected} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(AbstractValueNamingDetected instance) {
      Objects.requireNonNull(instance, "instance");
      usingVal(instance.extractVal());
      addAllStr(instance.collectStr());
      return this;
    }

    /**
     * Initializes the value for the {@link ValueNamingDetected#extractVal() val} attribute.
     * @param val The value for val 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder usingVal(int val) {
      this.val = val;
      initBits &= ~INIT_BIT_VAL;
      return this;
    }

    /**
     * Adds one element to {@link ValueNamingDetected#collectStr() str} set.
     * @param element A str element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder withStrAppended(String element) {
      this.str.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ValueNamingDetected#collectStr() str} set.
     * @param elements An array of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder withStrAppended(String... elements) {
      this.str.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ValueNamingDetected#collectStr() str} set.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder usingStr(Iterable<String> elements) {
      this.str = ImmutableSet.builder();
      return addAllStr(elements);
    }

    /**
     * Adds elements to {@link ValueNamingDetected#collectStr() str} set.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStr(Iterable<String> elements) {
      this.str.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ValueNamingDetected ValueNamingDetected}.
     * @return An immutable instance of ValueNamingDetected
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ValueNamingDetected buildValueNamingDetected() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ValueNamingDetected(val, str.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VAL) != 0) attributes.add("val");
      return "Cannot build ValueNamingDetected, some of required attributes are not set " + attributes;
    }
  }
}
