package org.immutables.fixture.subpack;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code SillySubstructure}.
 * @see ImmutableSillySubstructure
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.subpack", generator = "Gsons")
public final class GsonAdaptersSillySubstructure implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (SillySubstructureTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new SillySubstructureTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersSillySubstructure(SillySubstructure)";
  }

  @org.immutables.value.Generated(from = "SillySubstructure", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class SillySubstructureTypeAdapter extends TypeAdapter<SillySubstructure> {
    public final RetentionPolicy enum1TypeSample = null;
    public final ElementType set2TypeSample = null;
    public final Integer set3TypeSample = null;
    public final Float floats4TypeSample = null;
    private final TypeAdapter<RetentionPolicy> enum1TypeAdapter;
    private final TypeAdapter<ElementType> set2TypeAdapter;
    private final TypeAdapter<Integer> set3TypeAdapter;
    private final TypeAdapter<Float> floats4TypeAdapter;

    SillySubstructureTypeAdapter(Gson gson) {
      this.enum1TypeAdapter = gson.getAdapter( RetentionPolicy.class);
      this.set2TypeAdapter = gson.getAdapter( ElementType.class);
      this.set3TypeAdapter = gson.getAdapter( Integer.class);
      this.floats4TypeAdapter = gson.getAdapter( Float.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return SillySubstructure.class == type.getRawType()
          || ImmutableSillySubstructure.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, SillySubstructure value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeSillySubstructure(out, value);
      }
    }

    @Override
    public SillySubstructure read(JsonReader in) throws IOException {
      return readSillySubstructure(in);
    }

    private void writeSillySubstructure(JsonWriter out, SillySubstructure instance)
        throws IOException {
      out.beginObject();
      out.name("e1");
      enum1TypeAdapter.write(out, instance.enum1());
      Set<ElementType> set2Elements = instance.set2();
      out.name("set2");
      out.beginArray();
      for (ElementType e : set2Elements) {
        set2TypeAdapter.write(out, e);
      }
      out.endArray();
      Set<Integer> set3Elements = instance.set3();
      out.name("set3");
      out.beginArray();
      for (Integer e : set3Elements) {
        set3TypeAdapter.write(out, e);
      }
      out.endArray();
      List<Float> floats4Elements = instance.floats4();
      out.name("floats4");
      out.beginArray();
      for (Float e : floats4Elements) {
        floats4TypeAdapter.write(out, e);
      }
      out.endArray();
      out.endObject();
    }

    private  SillySubstructure readSillySubstructure(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableSillySubstructure.Builder builder = ImmutableSillySubstructure.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableSillySubstructure.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'e':
        if ("e1".equals(attributeName)) {
          readInEnum1(in, builder);
          return;
        }
        break;
      case 's':
        if ("set2".equals(attributeName)) {
          readInSet2(in, builder);
          return;
        }
        if ("set3".equals(attributeName)) {
          readInSet3(in, builder);
          return;
        }
        break;
      case 'f':
        if ("floats4".equals(attributeName)) {
          readInFloats4(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInEnum1(JsonReader in, ImmutableSillySubstructure.Builder builder)
        throws IOException {
      RetentionPolicy value = enum1TypeAdapter.read(in);
      builder.enum1(value);
    }

    private void readInSet2(JsonReader in, ImmutableSillySubstructure.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          ElementType value = set2TypeAdapter.read(in);
          builder.addSet2(value);
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        ElementType value = set2TypeAdapter.read(in);
        builder.addSet2(value);
      }
    }

    private void readInSet3(JsonReader in, ImmutableSillySubstructure.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addSet3(in.nextInt());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addSet3(in.nextInt());
      }
    }

    private void readInFloats4(JsonReader in, ImmutableSillySubstructure.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.BEGIN_ARRAY) {
        in.beginArray();
        while(in.hasNext()) {
          builder.addFloats4((float) in.nextDouble());
        }
        in.endArray();
      } else if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        builder.addFloats4((float) in.nextDouble());
      }
    }
  }
}
