package org.immutables.fixture.subpack;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.bson.codecs.Encoder;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.immutables.mongo.concurrent.FluentFuture;
import org.immutables.mongo.repository.Repositories;
import org.immutables.mongo.repository.RepositorySetup;
import org.immutables.mongo.repository.internal.Constraints;
import org.immutables.mongo.repository.internal.Support;
import org.immutables.value.Generated;

/**
 * A {@code SillySubstructureRepository} provides type-safe access for storing and retrieving documents
 * from the MongoDB collection {@code "sillySubstructure"}.
 */
@Generated(from = "SillySubstructure", generator = "Repositories")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@ThreadSafe
public class SillySubstructureRepository extends Repositories.Repository<SillySubstructure> {
  private static final String DOCUMENT_COLLECTION_NAME = "sillySubstructure";

  private final Serialization serialization;
  private final Criteria anyCriteria;

  /**
   * Constructs a {@link SillySubstructure} repository using {@link RepositorySetup configuration}.
   * @param configuration The repository configuration
   */
  public SillySubstructureRepository(RepositorySetup configuration) {
    super(configuration, DOCUMENT_COLLECTION_NAME, SillySubstructure.class);
    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());
    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());
  }

  /**
   * Inserts a single document into the collection.
   * @param document The sillySubstructure to insert
   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(SillySubstructure document) {
    return super.doInsert(ImmutableList.of(document));
  }

  /**
   * Insert documents into the collection.
   * @param documents The documents to insert
   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.
   */
  public FluentFuture<Integer> insert(Iterable<? extends SillySubstructure> documents) {
    return super.doInsert(ImmutableList.copyOf(documents));
  }

  /**
   * Finds all documents. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch all} or other operations.
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder findAll() {
    return find(criteria());
  }

  /**
   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.
   * @param jsonCriteria A JSON string for native criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(String jsonCriteria) {
    return new Finder(this, Support.jsonQuery(jsonCriteria));
  }

  /**
   * Find a document by the given {@link SillySubstructureRepository#criteria() criteria}. Use the returned {@link Finder} object to complete
   * {@link Finder#fetchAll() fetch}  operations.
   * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}
   * operations to update / delete the document(s).
   * @param criteria The search criteria
   * @return A finder object used to complete operations
   */
  @CheckReturnValue
  public Finder find(Criteria criteria) {
    return new Finder(this, criteria.constraint);
  }

  /**
   * The finder object used to proceed with find operations via the
   * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}, {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()} methods.
   * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.
   * @see SillySubstructureRepository#find(Criteria)
   */
  @Generated(from = "SillySubstructure", generator = "Repositories")
  @NotThreadSafe
  public static final class Finder extends Repositories.FinderWithDelete<SillySubstructure, Finder> {
    private final Serialization serialization;

    private Finder(SillySubstructureRepository repository, Constraints.ConstraintHost criteria) {
      super(repository);
      this.criteria = criteria;
      this.serialization = repository.serialization;
    }

    /**
     * Order by {@link SillySubstructure#enum1() enum1} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#enum1() enum1} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByEnum1() {
      ordering = ordering.equal(serialization.enum1Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#enum1() enum1} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#enum1() enum1} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByEnum1Desceding() {
      ordering = ordering.equal(serialization.enum1Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#set2() set2} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#set2() set2} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySet2() {
      ordering = ordering.equal(serialization.set2Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#set2() set2} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#set2() set2} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySet2Desceding() {
      ordering = ordering.equal(serialization.set2Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#set3() set3} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#set3() set3} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySet3() {
      ordering = ordering.equal(serialization.set3Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#set3() set3} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#set3() set3} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderBySet3Desceding() {
      ordering = ordering.equal(serialization.set3Name, false, -1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#floats4() floats4} in the ascending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#floats4() floats4} attribute using ascending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByFloats4() {
      ordering = ordering.equal(serialization.floats4Name, false, 1);
      return this;
    }

    /**
     * Order by {@link SillySubstructure#floats4() floats4} in the descending direction.
     * Specify that the next attribute to sort will be the {@link SillySubstructure#floats4() floats4} attribute using descending order
     * in the the chain of comparisons performed to sort results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder orderByFloats4Desceding() {
      ordering = ordering.equal(serialization.floats4Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillySubstructure#set2() set2} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeSet2() {
      exclusion = exclusion.equal(serialization.set2Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillySubstructure#set3() set3} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeSet3() {
      exclusion = exclusion.equal(serialization.set3Name, false, -1);
      return this;
    }

    /**
     * Exclude the {@link SillySubstructure#floats4() floats4} attribute from each document in the results.
     * @return {@code this} finder for use in a chained invocation
     */
    public Finder excludeFloats4() {
      exclusion = exclusion.equal(serialization.floats4Name, false, -1);
      return this;
    }

    /**
     * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}
     * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}
     * (and other attribute-specific) methods to describe the modification.
     * @return A modifier object to complete the {@code findAndModify} operation
     */
    @CheckReturnValue
    public Modifier andModifyFirst() {
      return new Modifier((SillySubstructureRepository) repository, criteria, ordering, exclusion);
    }

    /**
     * Used to replace in-place existing version of the document
     */
    @CheckReturnValue
    public Replacer andReplaceFirst(SillySubstructure document) {
      return new Replacer((SillySubstructureRepository) repository, document, criteria, ordering);
    }
  }

  /**
   * Update the set of {@code "sillySubstructure"} documents.
   * @param criteria The search criteria for update
   * @return An updater object that will be used to complete the update.
   */
  @CheckReturnValue
  public Updater update(Criteria criteria) {
    return new Updater(this, criteria);
  }

  /**
   * {@link #update(Criteria) Given} the criteria updater describes how to perform
   * update operations on sets of documents.
   */
  @Generated(from = "SillySubstructure", generator = "Repositories")
  @NotThreadSafe
  public static final class Updater extends Repositories.Updater<SillySubstructure> {
    private final Serialization serialization;

    private Updater(SillySubstructureRepository repository, Criteria criteria) {
      super(repository);
      this.criteria = criteria.constraint;
      this.serialization = repository.serialization;
    }

    /**
     * Specify a new value for the {@code enum1} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code enum1} attribute
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater setEnum1(RetentionPolicy value) {
      setFields = setFields.equal(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code enum1} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code enum1} value for an insert.
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater initEnum1(RetentionPolicy value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, value));
      return this;
    }


    /**
     * Clear the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearSet2() {
      setFields = setFields.equal(serialization.set2Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeSet2(ElementType value) {
      pullFields = pullFields.equal(serialization.set2Name, false, Support.writable(serialization.set2Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addSet2(ElementType value) {
      pushFields = pushFields.equal(serialization.set2Name, false, Support.writable(serialization.set2Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code set2} set attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setSet2(Iterable<ElementType> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ElementType value : values) {
         wrappedValues.add(Support.writable(serialization.set2Encoder, value));
       }

       setFields = setFields.equal(serialization.set2Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllSet2(Iterable<ElementType> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ElementType value : values) {
        wrappedValues.add(Support.writable(serialization.set2Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.set2Name, false, v);
      return this;
    }


    /**
     * Clear the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearSet3() {
      setFields = setFields.equal(serialization.set3Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeSet3(int value) {
      pullFields = pullFields.equal(serialization.set3Name, false, Support.writable(serialization.set3Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $addToSet} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addSet3(int value) {
      addToSetFields = addToSetFields.equal(serialization.set3Name, false, Support.writable(serialization.set3Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code set3} set attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setSet3(Iterable<java.lang.Integer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (java.lang.Integer value : values) {
         wrappedValues.add(Support.writable(serialization.set3Encoder, value));
       }

       setFields = setFields.equal(serialization.set3Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $addToSet} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllSet3(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.set3Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      addToSetFields = addToSetFields.equal(serialization.set3Name, false, v);
      return this;
    }


    /**
     * Clear the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater clearFloats4() {
      setFields = setFields.equal(serialization.floats4Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater removeFloats4(float value) {
      pullFields = pullFields.equal(serialization.floats4Name, false, Support.writable(serialization.floats4Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addFloats4(float value) {
      pushFields = pushFields.equal(serialization.floats4Name, false, Support.writable(serialization.floats4Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code floats4} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} updater to be used to complete the update operation
     */
     public Updater setFloats4(Iterable<Float> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Float value : values) {
         wrappedValues.add(Support.writable(serialization.floats4Encoder, value));
       }

       setFields = setFields.equal(serialization.floats4Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} updater to be used to complete the update operation
     */
    public Updater addAllFloats4(Iterable<Float> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Float value : values) {
        wrappedValues.add(Support.writable(serialization.floats4Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.floats4Name, false, v);
      return this;
    }

  }

  @Generated(from = "SillySubstructure", generator = "Repositories")
  @NotThreadSafe
  public static final class Modifier extends Repositories.Modifier<SillySubstructure, Modifier> {
    private final Serialization serialization;

    private Modifier(
        SillySubstructureRepository repository,
        Constraints.ConstraintHost criteria,
        Constraints.Constraint ordering,
        Constraints.Constraint exclusion) {
      super(repository);
      this.serialization = repository.serialization;
      this.criteria = criteria;
      this.ordering = ordering;
      this.exclusion = exclusion;
    }

    /**
     * Specify a new value for the {@code enum1} attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator.
     * @param value A new value for the {@code enum1} attribute
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier setEnum1(RetentionPolicy value) {
      setFields = setFields.equal(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, value));
      return this;
    }

    /**
     * Specify an initial value for the {@code enum1} attribute. The value will be used if the document is
     * to be inserted. If one or more documents are found for an update, this value will not be used.
     * <p>
     * Corresponds to the MongoDB {@code $setOnInsert} operator.
     * @param value The {@code enum1} value for an insert.
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier initEnum1(RetentionPolicy value) {
      setOnInsertFields = setOnInsertFields.equal(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, value));
      return this;
    }


    /**
     * Clear the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearSet2() {
      setFields = setFields.equal(serialization.set2Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeSet2(ElementType value) {
      pullFields = pullFields.equal(serialization.set2Name, false, Support.writable(serialization.set2Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addSet2(ElementType value) {
      pushFields = pushFields.equal(serialization.set2Name, false, Support.writable(serialization.set2Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code set2} set attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setSet2(Iterable<ElementType> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (ElementType value : values) {
         wrappedValues.add(Support.writable(serialization.set2Encoder, value));
       }

       setFields = setFields.equal(serialization.set2Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code set2} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllSet2(Iterable<ElementType> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ElementType value : values) {
        wrappedValues.add(Support.writable(serialization.set2Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.set2Name, false, v);
      return this;
    }


    /**
     * Clear the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearSet3() {
      setFields = setFields.equal(serialization.set3Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeSet3(int value) {
      pullFields = pullFields.equal(serialization.set3Name, false, Support.writable(serialization.set3Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $addToSet} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addSet3(int value) {
      addToSetFields = addToSetFields.equal(serialization.set3Name, false, Support.writable(serialization.set3Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code set3} set attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setSet3(Iterable<java.lang.Integer> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (java.lang.Integer value : values) {
         wrappedValues.add(Support.writable(serialization.set3Encoder, value));
       }

       setFields = setFields.equal(serialization.set3Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code set3} set attribute.
     * <p>
     * Corresponds to the MongoDB {@code $addToSet} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllSet3(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.set3Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      addToSetFields = addToSetFields.equal(serialization.set3Name, false, v);
      return this;
    }


    /**
     * Clear the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $set} operator resetting to empty array
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier clearFloats4() {
      setFields = setFields.equal(serialization.floats4Name, false, ImmutableList.<Object>of());
      return this;
    }

    /**
     * Remove a value from the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $pull} operator.
     * @param value The value to remove
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier removeFloats4(float value) {
      pullFields = pullFields.equal(serialization.floats4Name, false, Support.writable(serialization.floats4Encoder, value));
      return this;
    }

    /**
     * Add a value to the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator.
     * @param value The value to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addFloats4(float value) {
      pushFields = pushFields.equal(serialization.floats4Name, false, Support.writable(serialization.floats4Encoder, value));
      return this;
    }

    /**
     * Override all values of {@code floats4} list attribute.
     *
     * <p>Corresponds to the MongoDB {@code $set} operator on the array field.
     * @param values The values to set
     * @return {@code this} modifier to be used to complete the update operation
     */
     public Modifier setFloats4(Iterable<Float> values) {
       List<Object> wrappedValues = new ArrayList<>();
       for (Float value : values) {
         wrappedValues.add(Support.writable(serialization.floats4Encoder, value));
       }

       setFields = setFields.equal(serialization.floats4Name, false, wrappedValues);
       return this;
     }

    /**
     * Add all of the given values to the {@code floats4} list attribute.
     * <p>
     * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.
     * @param values The values to add
     * @return {@code this} modifier to be used to complete the update operation
     */
    public Modifier addAllFloats4(Iterable<Float> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Float value : values) {
        wrappedValues.add(Support.writable(serialization.floats4Encoder, value));
      }
      if (wrappedValues.isEmpty()) {
        return this;
      }
      Object v = wrappedValues.size() == 1
          ? wrappedValues.get(0)
          : Support.bsonObjectAttribute("$each", wrappedValues);

      pushFields = pushFields.equal(serialization.floats4Name, false, v);
      return this;
    }

  }

  @Generated(from = "SillySubstructure", generator = "Repositories")
  @NotThreadSafe
  public static final class Replacer extends Repositories.Replacer<SillySubstructure, Replacer> {
    protected Replacer(SillySubstructureRepository repository, SillySubstructure document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {
      super(repository, document, criteria, ordering);
    }
  }

  /**
   * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection sillySubstructure by one or
   * more attributes using the family of {@code with*()} attribute-specific methods.
   * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient
   * to ensure an index on application startup.
   * @see Indexer#named(String)
   * @see Indexer#unique()
   * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.
   */
  @CheckReturnValue
  public Indexer index() {
    return new Indexer(this);
  }

  /**
   * An indexer used to create an index on the {@code "sillySubstructure"} collection if it does not exist by one or more attributes.
   * @see DBCollection#createIndex(DBObject, DBObject)
   */
  @Generated(from = "SillySubstructure", generator = "Repositories")
  @NotThreadSafe
  public static final class Indexer extends Repositories.Indexer<SillySubstructure, Indexer> {
    private final Serialization serialization;

    private Indexer(SillySubstructureRepository repository) {
      super(repository);
      this.serialization = repository.serialization;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#enum1() enum1}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withEnum1() {
      fields = fields.equal(serialization.enum1Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#enum1() enum1}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withEnum1Desceding() {
      fields = fields.equal(serialization.enum1Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#set2() set2}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSet2() {
      fields = fields.equal(serialization.set2Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#set2() set2}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSet2Desceding() {
      fields = fields.equal(serialization.set2Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#set3() set3}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSet3() {
      fields = fields.equal(serialization.set3Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#set3() set3}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withSet3Desceding() {
      fields = fields.equal(serialization.set3Name, false, -1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#floats4() floats4}, in the ascending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withFloats4() {
      fields = fields.equal(serialization.floats4Name, false, 1);
      return this;
    }

    /**
     * Specify that the next attribute to index will be {@link SillySubstructure#floats4() floats4}, in the descending direction.
     * @return {@code this} indexer for use in a chained invocation
     */
    public Indexer withFloats4Desceding() {
      fields = fields.equal(serialization.floats4Name, false, -1);
      return this;
    }
  }

  /**
   * Search criteria.
   * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.
   * @return An empty immutable criteria
   */
  public Criteria criteria() {
    return anyCriteria;
  }

  @Beta
  Bson toBson(Criteria criteria) {
    return Support.convertToBson(criteria.constraint);
  }

  /**
   * {@code SillySubstructureRepository.Criteria} is a SillySubstructure document search query.
   * Call methods on the criteria to add constraints for search queries.
   */
  @Generated(from = "SillySubstructure", generator = "Repositories")
  @Immutable
  @SuppressWarnings("unchecked")
  public static final class Criteria extends Repositories.Criteria {
    private final Constraints.Constraint constraint;
    private final Serialization serialization;

    Criteria(Serialization serialization, Constraints.Constraint constraint) {
      this.constraint = constraint;
      this.serialization = serialization;
    }

    public Criteria enum1(RetentionPolicy value) {
      return new Criteria(serialization, constraint.equal(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, value)));
    }

    public Criteria enum1Not(RetentionPolicy value) {
      return new Criteria(serialization, constraint.equal(serialization.enum1Name, true, Support.writable(serialization.enum1Encoder, value)));
    }

    public Criteria enum1In(Iterable<RetentionPolicy> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (RetentionPolicy value : values) {
        wrappedValues.add(Support.writable(serialization.enum1Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.enum1Name, false, wrappedValues));
    }

    public Criteria enum1In(RetentionPolicy first, RetentionPolicy second, RetentionPolicy... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.enum1Encoder, first));
      values.add(Support.writable(serialization.enum1Encoder, second));
      for (RetentionPolicy value : rest) {
        values.add(Support.writable(serialization.enum1Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.enum1Name, false, values));
    }

    public Criteria enum1NotIn(Iterable<RetentionPolicy> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (RetentionPolicy value : values) {
        wrappedValues.add(Support.writable(serialization.enum1Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.enum1Name, true, wrappedValues));
    }

    public Criteria enum1NotIn(RetentionPolicy first, RetentionPolicy second, RetentionPolicy... rest) {
      List<Object> values = new ArrayList<>(2 + rest.length);
      values.add(Support.writable(serialization.enum1Encoder, first));
      values.add(Support.writable(serialization.enum1Encoder, second));
      for (RetentionPolicy value : rest) {
        values.add(Support.writable(serialization.enum1Encoder, value));
      }
      return new Criteria(serialization, constraint.in(serialization.enum1Name, true, values));
    }

    public Criteria enum1GreaterThan(RetentionPolicy lower) {
      return enum1In(Range.greaterThan(lower));
    }

    public Criteria enum1LessThan(RetentionPolicy upper) {
      return enum1In(Range.lessThan(upper));
    }

    public Criteria enum1AtMost(RetentionPolicy upperInclusive) {
      return enum1In(Range.atMost(upperInclusive));
    }

    public Criteria enum1AtLeast(RetentionPolicy lowerInclusive) {
      return enum1In(Range.atLeast(lowerInclusive));
    }

    public Criteria enum1In(Range<RetentionPolicy> range) {
      return new Criteria(serialization, constraint.range(serialization.enum1Name, false, Support.writable(serialization.enum1Encoder, range)));
    }

    public Criteria enum1NotIn(Range<RetentionPolicy> range) {
      return new Criteria(serialization, constraint.range(serialization.enum1Name, true, Support.writable(serialization.enum1Encoder, range)));
    }

    public Criteria set2Empty() {
      return new Criteria(serialization, constraint.size(serialization.set2Name, false, 0));
    }

    public Criteria set2NonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.set2Name, true, 0));
    }

    public Criteria set2Size(int size) {
      return new Criteria(serialization, constraint.size(serialization.set2Name, false, size));
    }

    public Criteria set2Contains(ElementType value) {
      return new Criteria(serialization, constraint.equal(serialization.set2Name, false, Support.writable(serialization.set2Encoder, value)));
    }

    public Criteria set2ContainsAll(Iterable<ElementType> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (ElementType value : values) {
        wrappedValues.add(Support.writable(serialization.set2Encoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.set2Name, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria set3Empty() {
      return new Criteria(serialization, constraint.size(serialization.set3Name, false, 0));
    }

    public Criteria set3NonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.set3Name, true, 0));
    }

    public Criteria set3Size(int size) {
      return new Criteria(serialization, constraint.size(serialization.set3Name, false, size));
    }

    public Criteria set3Contains(int value) {
      return new Criteria(serialization, constraint.equal(serialization.set3Name, false, Support.writable(serialization.set3Encoder, value)));
    }

    public Criteria set3ContainsAll(Iterable<java.lang.Integer> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (java.lang.Integer value : values) {
        wrappedValues.add(Support.writable(serialization.set3Encoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.set3Name, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    public Criteria floats4Empty() {
      return new Criteria(serialization, constraint.size(serialization.floats4Name, false, 0));
    }

    public Criteria floats4NonEmpty() {
      return new Criteria(serialization, constraint.size(serialization.floats4Name, true, 0));
    }

    public Criteria floats4Size(int size) {
      return new Criteria(serialization, constraint.size(serialization.floats4Name, false, size));
    }

    public Criteria floats4Contains(float value) {
      return new Criteria(serialization, constraint.equal(serialization.floats4Name, false, Support.writable(serialization.floats4Encoder, value)));
    }

    public Criteria floats4ContainsAll(Iterable<Float> values) {
      List<Object> wrappedValues = new ArrayList<>();
      for (Float value : values) {
        wrappedValues.add(Support.writable(serialization.floats4Encoder, value));
      }
      return new Criteria(serialization, constraint.nested(serialization.floats4Name, Constraints.nilConstraint().equal("$all", false, wrappedValues)));
    }

    @Override
    public Criteria or() {
      return new Criteria(serialization, constraint.disjunction());
    }

    public Criteria with(Criteria criteria) {
      return new Criteria(serialization, criteria.constraint.accept(constraint));
    }

    @Override
    public String toString() {
      return "SillySubstructureRepository.criteria(" + Support.stringify(constraint) + ")";
    }
  }

  @Generated(from = "SillySubstructure", generator = "Repositories")
  private static class Serialization {
    final Encoder<RetentionPolicy> enum1Encoder;
    final Encoder<ElementType> set2Encoder;
    final Encoder<java.lang.Integer> set3Encoder;
    final Encoder<Float> floats4Encoder;
    final CodecRegistry registry;
    final String enum1Name;
    final String set2Name;
    final String set3Name;
    final String floats4Name;

    Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {
      this.registry = registry;
      this.enum1Encoder = this.registry.get(RetentionPolicy.class);
      this.set2Encoder = this.registry.get(ElementType.class);
      this.set3Encoder = this.registry.get(java.lang.Integer.class);
      this.floats4Encoder = this.registry.get(Float.class);
      this.enum1Name = "e1";
      this.set2Name = translateName(fieldNamingStrategy, "set2");
      this.set3Name = translateName(fieldNamingStrategy, "set3");
      this.floats4Name = translateName(fieldNamingStrategy, "floats4");
    }

    @Generated(from = "SillySubstructure", generator = "Repositories")
    static final class SillySubstructureNamingFields {
      public RetentionPolicy enum1;
      public Set<ElementType> set2;
      public Set<java.lang.Integer> set3;
      public List<Float> floats4;
    }

    private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {
      try {
        return fieldNamingStrategy.translateName(
            SillySubstructureNamingFields.class.getField(fieldName));
      } catch (NoSuchFieldException noSuchField) {
        throw new AssertionError(noSuchField);
      }
    }
  }
}
