package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ForEquals}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForEquals.builder()}.
 */
@Generated(from = "ForEquals", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableForEquals extends ForEquals {
  private final int myInt;
  private final @Nullable Integer myOptionalInt;
  private final ImmutableList<Integer> myIntList;
  private final BigDecimal myBigDecimal;
  private final @Nullable BigDecimal myOptionalBigDecimal;
  private final ImmutableList<BigDecimal> myBigDecimalList;
  private final RoundingMode myRoundingMode;
  private final @Nullable RoundingMode myOptionalRoundingMode;
  private final ImmutableList<RoundingMode> myRoundingModeList;
  private final Object myObject;
  private final @Nullable Object myOptionalObject;
  private final ImmutableList<Object> myObjectList;

  private ImmutableForEquals(
      int myInt,
      @Nullable Integer myOptionalInt,
      ImmutableList<Integer> myIntList,
      BigDecimal myBigDecimal,
      @Nullable BigDecimal myOptionalBigDecimal,
      ImmutableList<BigDecimal> myBigDecimalList,
      RoundingMode myRoundingMode,
      @Nullable RoundingMode myOptionalRoundingMode,
      ImmutableList<RoundingMode> myRoundingModeList,
      Object myObject,
      @Nullable Object myOptionalObject,
      ImmutableList<Object> myObjectList) {
    this.myInt = myInt;
    this.myOptionalInt = myOptionalInt;
    this.myIntList = myIntList;
    this.myBigDecimal = myBigDecimal;
    this.myOptionalBigDecimal = myOptionalBigDecimal;
    this.myBigDecimalList = myBigDecimalList;
    this.myRoundingMode = myRoundingMode;
    this.myOptionalRoundingMode = myOptionalRoundingMode;
    this.myRoundingModeList = myRoundingModeList;
    this.myObject = myObject;
    this.myOptionalObject = myOptionalObject;
    this.myObjectList = myObjectList;
  }

  /**
   * @return The value of the {@code myInt} attribute
   */
  @Override
  public int myInt() {
    return myInt;
  }

  /**
   * @return The value of the {@code myOptionalInt} attribute
   */
  @Override
  public Optional<Integer> myOptionalInt() {
    return Optional.ofNullable(myOptionalInt);
  }

  /**
   * @return The value of the {@code myIntList} attribute
   */
  @Override
  public ImmutableList<Integer> myIntList() {
    return myIntList;
  }

  /**
   * @return The value of the {@code myBigDecimal} attribute
   */
  @Override
  public BigDecimal myBigDecimal() {
    return myBigDecimal;
  }

  /**
   * @return The value of the {@code myOptionalBigDecimal} attribute
   */
  @Override
  public Optional<BigDecimal> myOptionalBigDecimal() {
    return Optional.ofNullable(myOptionalBigDecimal);
  }

  /**
   * @return The value of the {@code myBigDecimalList} attribute
   */
  @Override
  public ImmutableList<BigDecimal> myBigDecimalList() {
    return myBigDecimalList;
  }

  /**
   * @return The value of the {@code myRoundingMode} attribute
   */
  @Override
  public RoundingMode myRoundingMode() {
    return myRoundingMode;
  }

  /**
   * @return The value of the {@code myOptionalRoundingMode} attribute
   */
  @Override
  public Optional<RoundingMode> myOptionalRoundingMode() {
    return Optional.ofNullable(myOptionalRoundingMode);
  }

  /**
   * @return The value of the {@code myRoundingModeList} attribute
   */
  @Override
  public ImmutableList<RoundingMode> myRoundingModeList() {
    return myRoundingModeList;
  }

  /**
   * @return The value of the {@code myObject} attribute
   */
  @Override
  public Object myObject() {
    return myObject;
  }

  /**
   * @return The value of the {@code myOptionalObject} attribute
   */
  @Override
  public Optional<Object> myOptionalObject() {
    return Optional.ofNullable(myOptionalObject);
  }

  /**
   * @return The value of the {@code myObjectList} attribute
   */
  @Override
  public ImmutableList<Object> myObjectList() {
    return myObjectList;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForEquals#myInt() myInt} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for myInt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForEquals withMyInt(int value) {
    if (this.myInt == value) return this;
    return new ImmutableForEquals(
        value,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ForEquals#myOptionalInt() myOptionalInt} attribute.
   * @param value The value for myOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyOptionalInt(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.myOptionalInt, newValue)) return this;
    return new ImmutableForEquals(
        this.myInt,
        newValue,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ForEquals#myOptionalInt() myOptionalInt} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for myOptionalInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyOptionalInt(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.myOptionalInt, value)) return this;
    return new ImmutableForEquals(
        this.myInt,
        value,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myIntList() myIntList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyIntList(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        newValue,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myIntList() myIntList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of myIntList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyIntList(Iterable<Integer> elements) {
    if (this.myIntList == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        newValue,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForEquals#myBigDecimal() myBigDecimal} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for myBigDecimal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForEquals withMyBigDecimal(BigDecimal value) {
    BigDecimal newValue = Objects.requireNonNull(value, "myBigDecimal");
    if (this.myBigDecimal.equals(newValue)) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        newValue,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ForEquals#myOptionalBigDecimal() myOptionalBigDecimal} attribute.
   * @param value The value for myOptionalBigDecimal
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyOptionalBigDecimal(BigDecimal value) {
    BigDecimal newValue = Objects.requireNonNull(value, "myOptionalBigDecimal");
    if (Objects.equals(this.myOptionalBigDecimal, newValue)) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        newValue,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ForEquals#myOptionalBigDecimal() myOptionalBigDecimal} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for myOptionalBigDecimal
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableForEquals withMyOptionalBigDecimal(Optional<? extends BigDecimal> optional) {
    @Nullable BigDecimal value = optional.orElse(null);
    if (Objects.equals(this.myOptionalBigDecimal, value)) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        value,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myBigDecimalList() myBigDecimalList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyBigDecimalList(BigDecimal... elements) {
    ImmutableList<BigDecimal> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        newValue,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myBigDecimalList() myBigDecimalList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of myBigDecimalList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyBigDecimalList(Iterable<? extends BigDecimal> elements) {
    if (this.myBigDecimalList == elements) return this;
    ImmutableList<BigDecimal> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        newValue,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForEquals#myRoundingMode() myRoundingMode} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for myRoundingMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForEquals withMyRoundingMode(RoundingMode value) {
    RoundingMode newValue = Objects.requireNonNull(value, "myRoundingMode");
    if (this.myRoundingMode == newValue) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        newValue,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ForEquals#myOptionalRoundingMode() myOptionalRoundingMode} attribute.
   * @param value The value for myOptionalRoundingMode
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyOptionalRoundingMode(RoundingMode value) {
    RoundingMode newValue = Objects.requireNonNull(value, "myOptionalRoundingMode");
    if (this.myOptionalRoundingMode == newValue) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        newValue,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ForEquals#myOptionalRoundingMode() myOptionalRoundingMode} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for myOptionalRoundingMode
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableForEquals withMyOptionalRoundingMode(Optional<? extends RoundingMode> optional) {
    @Nullable RoundingMode value = optional.orElse(null);
    if (this.myOptionalRoundingMode == value) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        value,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myRoundingModeList() myRoundingModeList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyRoundingModeList(RoundingMode... elements) {
    ImmutableList<RoundingMode> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        newValue,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myRoundingModeList() myRoundingModeList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of myRoundingModeList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyRoundingModeList(Iterable<? extends RoundingMode> elements) {
    if (this.myRoundingModeList == elements) return this;
    ImmutableList<RoundingMode> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        newValue,
        this.myObject,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForEquals#myObject() myObject} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for myObject
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForEquals withMyObject(Object value) {
    if (this.myObject == value) return this;
    Object newValue = Objects.requireNonNull(value, "myObject");
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        newValue,
        this.myOptionalObject,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ForEquals#myOptionalObject() myOptionalObject} attribute.
   * @param value The value for myOptionalObject
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyOptionalObject(Object value) {
    Object newValue = Objects.requireNonNull(value, "myOptionalObject");
    if (this.myOptionalObject == newValue) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        newValue,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ForEquals#myOptionalObject() myOptionalObject} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for myOptionalObject
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableForEquals withMyOptionalObject(Optional<? extends Object> optional) {
    @Nullable Object value = optional.orElse(null);
    if (this.myOptionalObject == value) return this;
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        value,
        this.myObjectList);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myObjectList() myObjectList}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyObjectList(Object... elements) {
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForEquals#myObjectList() myObjectList}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of myObjectList elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForEquals withMyObjectList(Iterable<? extends Object> elements) {
    if (this.myObjectList == elements) return this;
    ImmutableList<Object> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForEquals(
        this.myInt,
        this.myOptionalInt,
        this.myIntList,
        this.myBigDecimal,
        this.myOptionalBigDecimal,
        this.myBigDecimalList,
        this.myRoundingMode,
        this.myOptionalRoundingMode,
        this.myRoundingModeList,
        this.myObject,
        this.myOptionalObject,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForEquals} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForEquals
        && equalTo(0, (ImmutableForEquals) another);
  }

  private boolean equalTo(int synthetic, ImmutableForEquals another) {
    return myInt == another.myInt
        && Objects.equals(myOptionalInt, another.myOptionalInt)
        && myIntList.equals(another.myIntList)
        && myBigDecimal.equals(another.myBigDecimal)
        && Objects.equals(myOptionalBigDecimal, another.myOptionalBigDecimal)
        && myBigDecimalList.equals(another.myBigDecimalList)
        && myRoundingMode.equals(another.myRoundingMode)
        && Objects.equals(myOptionalRoundingMode, another.myOptionalRoundingMode)
        && myRoundingModeList.equals(another.myRoundingModeList)
        && myObject.equals(another.myObject)
        && Objects.equals(myOptionalObject, another.myOptionalObject)
        && myObjectList.equals(another.myObjectList);
  }

  /**
   * Computes a hash code from attributes: {@code myInt}, {@code myOptionalInt}, {@code myIntList}, {@code myBigDecimal}, {@code myOptionalBigDecimal}, {@code myBigDecimalList}, {@code myRoundingMode}, {@code myOptionalRoundingMode}, {@code myRoundingModeList}, {@code myObject}, {@code myOptionalObject}, {@code myObjectList}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + myInt;
    h += (h << 5) + Objects.hashCode(myOptionalInt);
    h += (h << 5) + myIntList.hashCode();
    h += (h << 5) + myBigDecimal.hashCode();
    h += (h << 5) + Objects.hashCode(myOptionalBigDecimal);
    h += (h << 5) + myBigDecimalList.hashCode();
    h += (h << 5) + myRoundingMode.hashCode();
    h += (h << 5) + Objects.hashCode(myOptionalRoundingMode);
    h += (h << 5) + myRoundingModeList.hashCode();
    h += (h << 5) + myObject.hashCode();
    h += (h << 5) + Objects.hashCode(myOptionalObject);
    h += (h << 5) + myObjectList.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ForEquals} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ForEquals")
        .omitNullValues()
        .add("myInt", myInt)
        .add("myOptionalInt", myOptionalInt)
        .add("myIntList", myIntList)
        .add("myBigDecimal", myBigDecimal)
        .add("myOptionalBigDecimal", myOptionalBigDecimal)
        .add("myBigDecimalList", myBigDecimalList)
        .add("myRoundingMode", myRoundingMode)
        .add("myOptionalRoundingMode", myOptionalRoundingMode)
        .add("myRoundingModeList", myRoundingModeList)
        .add("myObject", myObject)
        .add("myOptionalObject", myOptionalObject)
        .add("myObjectList", myObjectList)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ForEquals} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ForEquals instance
   */
  public static ImmutableForEquals copyOf(ForEquals instance) {
    if (instance instanceof ImmutableForEquals) {
      return (ImmutableForEquals) instance;
    }
    return ImmutableForEquals.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableForEquals ImmutableForEquals}.
   * <pre>
   * ImmutableForEquals.builder()
   *    .myInt(int) // required {@link ForEquals#myInt() myInt}
   *    .myOptionalInt(Integer) // optional {@link ForEquals#myOptionalInt() myOptionalInt}
   *    .addMyIntList|addAllMyIntList(int) // {@link ForEquals#myIntList() myIntList} elements
   *    .myBigDecimal(java.math.BigDecimal) // required {@link ForEquals#myBigDecimal() myBigDecimal}
   *    .myOptionalBigDecimal(java.math.BigDecimal) // optional {@link ForEquals#myOptionalBigDecimal() myOptionalBigDecimal}
   *    .addMyBigDecimalList|addAllMyBigDecimalList(java.math.BigDecimal) // {@link ForEquals#myBigDecimalList() myBigDecimalList} elements
   *    .myRoundingMode(java.math.RoundingMode) // required {@link ForEquals#myRoundingMode() myRoundingMode}
   *    .myOptionalRoundingMode(java.math.RoundingMode) // optional {@link ForEquals#myOptionalRoundingMode() myOptionalRoundingMode}
   *    .addMyRoundingModeList|addAllMyRoundingModeList(java.math.RoundingMode) // {@link ForEquals#myRoundingModeList() myRoundingModeList} elements
   *    .myObject(Object) // required {@link ForEquals#myObject() myObject}
   *    .myOptionalObject(Object) // optional {@link ForEquals#myOptionalObject() myOptionalObject}
   *    .addMyObjectList|addAllMyObjectList(Object) // {@link ForEquals#myObjectList() myObjectList} elements
   *    .build();
   * </pre>
   * @return A new ImmutableForEquals builder
   */
  public static ImmutableForEquals.Builder builder() {
    return new ImmutableForEquals.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForEquals ImmutableForEquals}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ForEquals", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MY_INT = 0x1L;
    private static final long INIT_BIT_MY_BIG_DECIMAL = 0x2L;
    private static final long INIT_BIT_MY_ROUNDING_MODE = 0x4L;
    private static final long INIT_BIT_MY_OBJECT = 0x8L;
    private long initBits = 0xfL;

    private int myInt;
    private @Nullable Integer myOptionalInt;
    private ImmutableList.Builder<Integer> myIntList = ImmutableList.builder();
    private @Nullable BigDecimal myBigDecimal;
    private @Nullable BigDecimal myOptionalBigDecimal;
    private ImmutableList.Builder<BigDecimal> myBigDecimalList = ImmutableList.builder();
    private @Nullable RoundingMode myRoundingMode;
    private @Nullable RoundingMode myOptionalRoundingMode;
    private ImmutableList.Builder<RoundingMode> myRoundingModeList = ImmutableList.builder();
    private @Nullable Object myObject;
    private @Nullable Object myOptionalObject;
    private ImmutableList.Builder<Object> myObjectList = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ForEquals} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ForEquals instance) {
      Objects.requireNonNull(instance, "instance");
      myInt(instance.myInt());
      Optional<Integer> myOptionalIntOptional = instance.myOptionalInt();
      if (myOptionalIntOptional.isPresent()) {
        myOptionalInt(myOptionalIntOptional);
      }
      addAllMyIntList(instance.myIntList());
      myBigDecimal(instance.myBigDecimal());
      Optional<BigDecimal> myOptionalBigDecimalOptional = instance.myOptionalBigDecimal();
      if (myOptionalBigDecimalOptional.isPresent()) {
        myOptionalBigDecimal(myOptionalBigDecimalOptional);
      }
      addAllMyBigDecimalList(instance.myBigDecimalList());
      myRoundingMode(instance.myRoundingMode());
      Optional<RoundingMode> myOptionalRoundingModeOptional = instance.myOptionalRoundingMode();
      if (myOptionalRoundingModeOptional.isPresent()) {
        myOptionalRoundingMode(myOptionalRoundingModeOptional);
      }
      addAllMyRoundingModeList(instance.myRoundingModeList());
      myObject(instance.myObject());
      Optional<Object> myOptionalObjectOptional = instance.myOptionalObject();
      if (myOptionalObjectOptional.isPresent()) {
        myOptionalObject(myOptionalObjectOptional);
      }
      addAllMyObjectList(instance.myObjectList());
      return this;
    }

    /**
     * Initializes the value for the {@link ForEquals#myInt() myInt} attribute.
     * @param myInt The value for myInt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myInt(int myInt) {
      this.myInt = myInt;
      initBits &= ~INIT_BIT_MY_INT;
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalInt() myOptionalInt} to myOptionalInt.
     * @param myOptionalInt The value for myOptionalInt
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalInt(int myOptionalInt) {
      this.myOptionalInt = myOptionalInt;
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalInt() myOptionalInt} to myOptionalInt.
     * @param myOptionalInt The value for myOptionalInt
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalInt(Optional<Integer> myOptionalInt) {
      this.myOptionalInt = myOptionalInt.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ForEquals#myIntList() myIntList} list.
     * @param element A myIntList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyIntList(int element) {
      this.myIntList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForEquals#myIntList() myIntList} list.
     * @param elements An array of myIntList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyIntList(int... elements) {
      this.myIntList.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForEquals#myIntList() myIntList} list.
     * @param elements An iterable of myIntList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myIntList(Iterable<Integer> elements) {
      this.myIntList = ImmutableList.builder();
      return addAllMyIntList(elements);
    }

    /**
     * Adds elements to {@link ForEquals#myIntList() myIntList} list.
     * @param elements An iterable of myIntList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMyIntList(Iterable<Integer> elements) {
      this.myIntList.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ForEquals#myBigDecimal() myBigDecimal} attribute.
     * @param myBigDecimal The value for myBigDecimal 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myBigDecimal(BigDecimal myBigDecimal) {
      this.myBigDecimal = Objects.requireNonNull(myBigDecimal, "myBigDecimal");
      initBits &= ~INIT_BIT_MY_BIG_DECIMAL;
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalBigDecimal() myOptionalBigDecimal} to myOptionalBigDecimal.
     * @param myOptionalBigDecimal The value for myOptionalBigDecimal
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalBigDecimal(BigDecimal myOptionalBigDecimal) {
      this.myOptionalBigDecimal = Objects.requireNonNull(myOptionalBigDecimal, "myOptionalBigDecimal");
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalBigDecimal() myOptionalBigDecimal} to myOptionalBigDecimal.
     * @param myOptionalBigDecimal The value for myOptionalBigDecimal
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalBigDecimal(Optional<? extends BigDecimal> myOptionalBigDecimal) {
      this.myOptionalBigDecimal = myOptionalBigDecimal.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ForEquals#myBigDecimalList() myBigDecimalList} list.
     * @param element A myBigDecimalList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyBigDecimalList(BigDecimal element) {
      this.myBigDecimalList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForEquals#myBigDecimalList() myBigDecimalList} list.
     * @param elements An array of myBigDecimalList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyBigDecimalList(BigDecimal... elements) {
      this.myBigDecimalList.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForEquals#myBigDecimalList() myBigDecimalList} list.
     * @param elements An iterable of myBigDecimalList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myBigDecimalList(Iterable<? extends BigDecimal> elements) {
      this.myBigDecimalList = ImmutableList.builder();
      return addAllMyBigDecimalList(elements);
    }

    /**
     * Adds elements to {@link ForEquals#myBigDecimalList() myBigDecimalList} list.
     * @param elements An iterable of myBigDecimalList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMyBigDecimalList(Iterable<? extends BigDecimal> elements) {
      this.myBigDecimalList.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ForEquals#myRoundingMode() myRoundingMode} attribute.
     * @param myRoundingMode The value for myRoundingMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myRoundingMode(RoundingMode myRoundingMode) {
      this.myRoundingMode = Objects.requireNonNull(myRoundingMode, "myRoundingMode");
      initBits &= ~INIT_BIT_MY_ROUNDING_MODE;
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalRoundingMode() myOptionalRoundingMode} to myOptionalRoundingMode.
     * @param myOptionalRoundingMode The value for myOptionalRoundingMode
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalRoundingMode(RoundingMode myOptionalRoundingMode) {
      this.myOptionalRoundingMode = Objects.requireNonNull(myOptionalRoundingMode, "myOptionalRoundingMode");
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalRoundingMode() myOptionalRoundingMode} to myOptionalRoundingMode.
     * @param myOptionalRoundingMode The value for myOptionalRoundingMode
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalRoundingMode(Optional<? extends RoundingMode> myOptionalRoundingMode) {
      this.myOptionalRoundingMode = myOptionalRoundingMode.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ForEquals#myRoundingModeList() myRoundingModeList} list.
     * @param element A myRoundingModeList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyRoundingModeList(RoundingMode element) {
      this.myRoundingModeList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForEquals#myRoundingModeList() myRoundingModeList} list.
     * @param elements An array of myRoundingModeList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyRoundingModeList(RoundingMode... elements) {
      this.myRoundingModeList.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForEquals#myRoundingModeList() myRoundingModeList} list.
     * @param elements An iterable of myRoundingModeList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myRoundingModeList(Iterable<? extends RoundingMode> elements) {
      this.myRoundingModeList = ImmutableList.builder();
      return addAllMyRoundingModeList(elements);
    }

    /**
     * Adds elements to {@link ForEquals#myRoundingModeList() myRoundingModeList} list.
     * @param elements An iterable of myRoundingModeList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMyRoundingModeList(Iterable<? extends RoundingMode> elements) {
      this.myRoundingModeList.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link ForEquals#myObject() myObject} attribute.
     * @param myObject The value for myObject 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myObject(Object myObject) {
      this.myObject = Objects.requireNonNull(myObject, "myObject");
      initBits &= ~INIT_BIT_MY_OBJECT;
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalObject() myOptionalObject} to myOptionalObject.
     * @param myOptionalObject The value for myOptionalObject
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalObject(Object myOptionalObject) {
      this.myOptionalObject = Objects.requireNonNull(myOptionalObject, "myOptionalObject");
      return this;
    }

    /**
     * Initializes the optional value {@link ForEquals#myOptionalObject() myOptionalObject} to myOptionalObject.
     * @param myOptionalObject The value for myOptionalObject
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myOptionalObject(Optional<? extends Object> myOptionalObject) {
      this.myOptionalObject = myOptionalObject.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ForEquals#myObjectList() myObjectList} list.
     * @param element A myObjectList element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyObjectList(Object element) {
      this.myObjectList.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForEquals#myObjectList() myObjectList} list.
     * @param elements An array of myObjectList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMyObjectList(Object... elements) {
      this.myObjectList.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForEquals#myObjectList() myObjectList} list.
     * @param elements An iterable of myObjectList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder myObjectList(Iterable<? extends Object> elements) {
      this.myObjectList = ImmutableList.builder();
      return addAllMyObjectList(elements);
    }

    /**
     * Adds elements to {@link ForEquals#myObjectList() myObjectList} list.
     * @param elements An iterable of myObjectList elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMyObjectList(Iterable<? extends Object> elements) {
      this.myObjectList.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableForEquals ImmutableForEquals}.
     * @return An immutable instance of ForEquals
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForEquals build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableForEquals(
          myInt,
          myOptionalInt,
          myIntList.build(),
          myBigDecimal,
          myOptionalBigDecimal,
          myBigDecimalList.build(),
          myRoundingMode,
          myOptionalRoundingMode,
          myRoundingModeList.build(),
          myObject,
          myOptionalObject,
          myObjectList.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MY_INT) != 0) attributes.add("myInt");
      if ((initBits & INIT_BIT_MY_BIG_DECIMAL) != 0) attributes.add("myBigDecimal");
      if ((initBits & INIT_BIT_MY_ROUNDING_MODE) != 0) attributes.add("myRoundingMode");
      if ((initBits & INIT_BIT_MY_OBJECT) != 0) attributes.add("myObject");
      return "Cannot build ForEquals, some of required attributes are not set " + attributes;
    }
  }
}
