/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.LazyHash;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LazyHash", generator="Immutables")
@Immutable
public final class ImmutableLazyHash
implements LazyHash {
    private final String s;
    private final boolean b;
    private final int i;
    private transient int hashCode;

    private ImmutableLazyHash(String s, boolean b, int i) {
        this.s = s;
        this.b = b;
        this.i = i;
    }

    @Override
    public String s() {
        return this.s;
    }

    @Override
    public boolean b() {
        return this.b;
    }

    @Override
    public int i() {
        return this.i;
    }

    public final ImmutableLazyHash withS(String value) {
        String newValue = Objects.requireNonNull(value, "s");
        if (this.s.equals(newValue)) {
            return this;
        }
        return new ImmutableLazyHash(newValue, this.b, this.i);
    }

    public final ImmutableLazyHash withB(boolean value) {
        if (this.b == value) {
            return this;
        }
        return new ImmutableLazyHash(this.s, value, this.i);
    }

    public final ImmutableLazyHash withI(int value) {
        if (this.i == value) {
            return this;
        }
        return new ImmutableLazyHash(this.s, this.b, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLazyHash && this.equalTo(0, (ImmutableLazyHash)another);
    }

    private boolean equalTo(int synthetic, ImmutableLazyHash another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.s.equals(another.s) && this.b == another.b && this.i == another.i;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.s.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.b);
        h += (h << 5) + this.i;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"LazyHash").omitNullValues().add("s", (Object)this.s).add("b", this.b).add("i", this.i).toString();
    }

    public static ImmutableLazyHash copyOf(LazyHash instance) {
        if (instance instanceof ImmutableLazyHash) {
            return (ImmutableLazyHash)instance;
        }
        return ImmutableLazyHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LazyHash", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_S = 1L;
        private static final long INIT_BIT_B = 2L;
        private static final long INIT_BIT_I = 4L;
        private long initBits = 7L;
        @Nullable
        private String s;
        private boolean b;
        private int i;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LazyHash instance) {
            Objects.requireNonNull(instance, "instance");
            this.s(instance.s());
            this.b(instance.b());
            this.i(instance.i());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder s(String s) {
            this.s = Objects.requireNonNull(s, "s");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder b(boolean b) {
            this.b = b;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder i(int i) {
            this.i = i;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableLazyHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLazyHash(this.s, this.b, this.i);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("s");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("i");
            }
            return "Cannot build LazyHash, some of required attributes are not set " + attributes;
        }
    }
}

