/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.Redacted;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Redacted", generator="Immutables")
@Immutable
public final class ImmutableRedacted
implements Redacted {
    private final long id;
    private final int code;
    private final String ssn;
    private final String[] data;

    private ImmutableRedacted(long id, int code, String ssn, String[] data) {
        this.id = id;
        this.code = code;
        this.ssn = ssn;
        this.data = data;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public String ssn() {
        return this.ssn;
    }

    @Override
    public String[] data() {
        return (String[])this.data.clone();
    }

    public final ImmutableRedacted withId(long value) {
        if (this.id == value) {
            return this;
        }
        return new ImmutableRedacted(value, this.code, this.ssn, this.data);
    }

    public final ImmutableRedacted withCode(int value) {
        if (this.code == value) {
            return this;
        }
        return new ImmutableRedacted(this.id, value, this.ssn, this.data);
    }

    public final ImmutableRedacted withSsn(String value) {
        String newValue = Objects.requireNonNull(value, "ssn");
        if (this.ssn.equals(newValue)) {
            return this;
        }
        return new ImmutableRedacted(this.id, this.code, newValue, this.data);
    }

    public final ImmutableRedacted withData(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableRedacted(this.id, this.code, this.ssn, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRedacted && this.equalTo(0, (ImmutableRedacted)another);
    }

    private boolean equalTo(int synthetic, ImmutableRedacted another) {
        return this.id == another.id && this.code == another.code && this.ssn.equals(another.ssn) && Arrays.equals(this.data, another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.id);
        h += (h << 5) + this.code;
        h += (h << 5) + this.ssn.hashCode();
        h += (h << 5) + Arrays.hashCode(this.data);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Redacted").omitNullValues().add("id", this.id).toString();
    }

    public static ImmutableRedacted copyOf(Redacted instance) {
        if (instance instanceof ImmutableRedacted) {
            return (ImmutableRedacted)instance;
        }
        return ImmutableRedacted.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Redacted", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CODE = 2L;
        private static final long INIT_BIT_SSN = 4L;
        private static final long INIT_BIT_DATA = 8L;
        private long initBits = 15L;
        private long id;
        private int code;
        @Nullable
        private String ssn;
        @Nullable
        private String[] data;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Redacted instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.code(instance.code());
            this.ssn(instance.ssn());
            this.data(instance.data());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(long id) {
            this.id = id;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder code(int code) {
            this.code = code;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ssn(String ssn) {
            this.ssn = Objects.requireNonNull(ssn, "ssn");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder data(String ... data) {
            this.data = (String[])data.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableRedacted build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRedacted(this.id, this.code, this.ssn, this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("code");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ssn");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build Redacted, some of required attributes are not set " + attributes;
        }
    }
}

