/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.SillyValidatedBuiltValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SillyValidatedBuiltValue", generator="Immutables")
@Immutable
public final class ImmutableSillyValidatedBuiltValue
extends SillyValidatedBuiltValue {
    private final int value;
    private final boolean negativeOnly;

    private ImmutableSillyValidatedBuiltValue(int value, boolean negativeOnly) {
        this.value = value;
        this.negativeOnly = negativeOnly;
    }

    @Override
    public int value() {
        return this.value;
    }

    @Override
    public boolean negativeOnly() {
        return this.negativeOnly;
    }

    public final ImmutableSillyValidatedBuiltValue withValue(int value) {
        if (this.value == value) {
            return this;
        }
        return ImmutableSillyValidatedBuiltValue.validate(new ImmutableSillyValidatedBuiltValue(value, this.negativeOnly));
    }

    public final ImmutableSillyValidatedBuiltValue withNegativeOnly(boolean value) {
        if (this.negativeOnly == value) {
            return this;
        }
        return ImmutableSillyValidatedBuiltValue.validate(new ImmutableSillyValidatedBuiltValue(this.value, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSillyValidatedBuiltValue && this.equalTo(0, (ImmutableSillyValidatedBuiltValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSillyValidatedBuiltValue another) {
        return this.value == another.value && this.negativeOnly == another.negativeOnly;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value;
        h += (h << 5) + Booleans.hashCode((boolean)this.negativeOnly);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SillyValidatedBuiltValue").omitNullValues().add("value", this.value).add("negativeOnly", this.negativeOnly).toString();
    }

    private static ImmutableSillyValidatedBuiltValue validate(ImmutableSillyValidatedBuiltValue instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableSillyValidatedBuiltValue copyOf(SillyValidatedBuiltValue instance) {
        if (instance instanceof ImmutableSillyValidatedBuiltValue) {
            return (ImmutableSillyValidatedBuiltValue)instance;
        }
        return ImmutableSillyValidatedBuiltValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SillyValidatedBuiltValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_NEGATIVE_ONLY = 2L;
        private long initBits = 3L;
        private int value;
        private boolean negativeOnly;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(SillyValidatedBuiltValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.value(instance.value());
            this.negativeOnly(instance.negativeOnly());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder value(int value) {
            this.value = value;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder negativeOnly(boolean negativeOnly) {
            this.negativeOnly = negativeOnly;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSillyValidatedBuiltValue build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableSillyValidatedBuiltValue.validate(new ImmutableSillyValidatedBuiltValue(this.value, this.negativeOnly));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("negativeOnly");
            }
            return "Cannot build SillyValidatedBuiltValue, some of required attributes are not set " + attributes;
        }
    }
}

