/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.custann;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import nonimmutables.CustColl;
import org.immutables.fixture.custann.CustomCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomCollection", generator="Immutables")
@Immutable
public final class ImmutableCustomCollection<E>
implements CustomCollection<E> {
    private final CustColl<E> col;
    private final CustColl<Integer> cint;

    private ImmutableCustomCollection(Iterable<? extends E> col) {
        this.col = CustColl.from(col);
        this.cint = CustColl.of();
    }

    private ImmutableCustomCollection(CustColl<E> col, CustColl<Integer> cint) {
        this.col = col;
        this.cint = cint;
    }

    @Override
    public CustColl<E> col() {
        return this.col;
    }

    @Override
    public CustColl<Integer> cint() {
        return this.cint;
    }

    @SafeVarargs
    public final ImmutableCustomCollection<E> withCol(E ... elements) {
        CustColl<E> newValue = CustColl.from(Arrays.asList(elements));
        return new ImmutableCustomCollection<E>(newValue, this.cint);
    }

    public final ImmutableCustomCollection<E> withCol(Iterable<? extends E> elements) {
        if (this.col == elements) {
            return this;
        }
        CustColl<? extends E> newValue = CustColl.from(elements);
        return new ImmutableCustomCollection<E>(newValue, this.cint);
    }

    public final ImmutableCustomCollection<E> withCint(int ... elements) {
        CustColl<Integer> newValue = CustColl.from(Ints.asList((int[])elements));
        return new ImmutableCustomCollection<E>(this.col, newValue);
    }

    public final ImmutableCustomCollection<E> withCint(Iterable<Integer> elements) {
        if (this.cint == elements) {
            return this;
        }
        CustColl<Integer> newValue = CustColl.from(elements);
        return new ImmutableCustomCollection<E>(this.col, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomCollection && this.equalTo(0, (ImmutableCustomCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomCollection<?> another) {
        return this.col.equals(another.col) && this.cint.equals(another.cint);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.col.hashCode();
        h += (h << 5) + this.cint.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomCollection").omitNullValues().add("col", this.col).add("cint", this.cint).toString();
    }

    public static <E> ImmutableCustomCollection<E> of(CustColl<E> col) {
        return ImmutableCustomCollection.of(col);
    }

    public static <E> ImmutableCustomCollection<E> of(Iterable<? extends E> col) {
        return new ImmutableCustomCollection<E>(col);
    }

    public static <E> ImmutableCustomCollection<E> copyOf(CustomCollection<E> instance) {
        if (instance instanceof ImmutableCustomCollection) {
            return (ImmutableCustomCollection)instance;
        }
        return new CustomCollection.Builder<E>().from(instance).build();
    }

    @Generated(from="CustomCollection", generator="Immutables")
    @NotThreadSafe
    public static class Builder<E> {
        private CustColl.Builder<E> col = CustColl.builder();
        private CustColl.Builder<Integer> cint = CustColl.builder();

        public Builder() {
            if (!(this instanceof CustomCollection.Builder)) {
                throw new UnsupportedOperationException("Use: new CustomCollection.Builder<E>()");
            }
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> from(CustomCollection<E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCol(instance.col());
            this.addAllCint(instance.cint());
            return (CustomCollection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addCol(E element) {
            this.col.add(element);
            return (CustomCollection.Builder)this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addCol(E ... elements) {
            this.col.addAll(Arrays.asList(elements));
            return (CustomCollection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> col(Iterable<? extends E> elements) {
            this.col = CustColl.builder();
            return this.addAllCol(elements);
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addAllCol(Iterable<? extends E> elements) {
            this.col.addAll(elements);
            return (CustomCollection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addCint(int element) {
            this.cint.add(element);
            return (CustomCollection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addCint(int ... elements) {
            this.cint.addAll(Ints.asList((int[])elements));
            return (CustomCollection.Builder)this;
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> cint(Iterable<Integer> elements) {
            this.cint = CustColl.builder();
            return this.addAllCint(elements);
        }

        @CanIgnoreReturnValue
        public final CustomCollection.Builder<E> addAllCint(Iterable<Integer> elements) {
            this.cint.addAll(elements);
            return (CustomCollection.Builder)this;
        }

        public ImmutableCustomCollection<E> build() {
            return new ImmutableCustomCollection(this.col.build(), this.cint.build());
        }
    }
}

