/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.DeepChild;
import org.immutables.fixture.deep.DeepNullable;
import org.immutables.fixture.deep.DeepStepChild;
import org.immutables.fixture.deep.ImmutableDeepChild;
import org.immutables.fixture.deep.ImmutableDeepStepChild;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeepNullable", generator="Immutables")
@Immutable
final class ImmutableDeepNullable
implements DeepNullable {
    @Nullable
    private final ImmutableDeepChild child;
    @Nullable
    private final ImmutableDeepStepChild another;

    private ImmutableDeepNullable(@Nullable DeepChild child, @Nullable DeepStepChild another) {
        this.child = child == null ? null : ImmutableDeepChild.copyOf(child);
        this.another = another == null ? null : ImmutableDeepStepChild.copyOf(another);
    }

    private ImmutableDeepNullable(ImmutableDeepNullable original, @Nullable ImmutableDeepChild child, @Nullable ImmutableDeepStepChild another) {
        this.child = child;
        this.another = another;
    }

    @Override
    @Nullable
    public ImmutableDeepChild child() {
        return this.child;
    }

    @Override
    @Nullable
    public ImmutableDeepStepChild another() {
        return this.another;
    }

    public final ImmutableDeepNullable withChild(@Nullable DeepChild value) {
        if (this.child == value) {
            return this;
        }
        ImmutableDeepChild newValue = value == null ? null : ImmutableDeepChild.copyOf(value);
        return new ImmutableDeepNullable(this, newValue, this.another);
    }

    public final ImmutableDeepNullable withAnother(@Nullable DeepStepChild value) {
        if (this.another == value) {
            return this;
        }
        ImmutableDeepStepChild newValue = value == null ? null : ImmutableDeepStepChild.copyOf(value);
        return new ImmutableDeepNullable(this, this.child, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeepNullable && this.equalTo(0, (ImmutableDeepNullable)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeepNullable another) {
        return Objects.equals(this.child, another.child) && Objects.equals(this.another, another.another);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.child);
        h += (h << 5) + Objects.hashCode(this.another);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DeepNullable").omitNullValues().add("child", (Object)this.child).add("another", (Object)this.another).toString();
    }

    public static ImmutableDeepNullable of(@Nullable DeepChild child, @Nullable DeepStepChild another) {
        return new ImmutableDeepNullable(child, another);
    }

    public static ImmutableDeepNullable copyOf(DeepNullable instance) {
        if (instance instanceof ImmutableDeepNullable) {
            return (ImmutableDeepNullable)instance;
        }
        return ImmutableDeepNullable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeepNullable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private DeepChild child;
        @Nullable
        private DeepStepChild another;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeepNullable instance) {
            DeepStepChild anotherValue;
            Objects.requireNonNull(instance, "instance");
            DeepChild childValue = instance.child();
            if (childValue != null) {
                this.child(childValue);
            }
            if ((anotherValue = instance.another()) != null) {
                this.another(anotherValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder child(@Nullable DeepChild child) {
            this.child = child == null ? null : ImmutableDeepChild.copyOf(child);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder another(@Nullable DeepStepChild another) {
            this.another = another == null ? null : ImmutableDeepStepChild.copyOf(another);
            return this;
        }

        public ImmutableDeepNullable build() {
            return new ImmutableDeepNullable(null, this.child == null ? null : ImmutableDeepChild.copyOf(this.child), this.another == null ? null : ImmutableDeepStepChild.copyOf(this.another));
        }
    }
}

