/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ModifiablePoint;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Canvas.Point", generator="Immutables")
@Immutable
public final class ImmutablePoint
implements Canvas.Point {
    private final int x;
    private final int y;

    private ImmutablePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    private ImmutablePoint(ImmutablePoint original, int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    public final ImmutablePoint withX(int value) {
        if (this.x == value) {
            return this;
        }
        return new ImmutablePoint(this, value, this.y);
    }

    public final ImmutablePoint withY(int value) {
        if (this.y == value) {
            return this;
        }
        return new ImmutablePoint(this, this.x, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePoint && this.equalTo(0, (ImmutablePoint)another);
    }

    private boolean equalTo(int synthetic, ImmutablePoint another) {
        return this.x == another.x && this.y == another.y;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.x;
        h += (h << 5) + this.y;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Point").omitNullValues().add("x", this.x).add("y", this.y).toString();
    }

    public static ImmutablePoint of(int x, int y) {
        return new ImmutablePoint(x, y);
    }

    public static ImmutablePoint copyOf(Canvas.Point instance) {
        if (instance instanceof ImmutablePoint) {
            return (ImmutablePoint)instance;
        }
        return ImmutablePoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Canvas.Point", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_X = 1L;
        private static final long INIT_BIT_Y = 2L;
        private long initBits = 3L;
        private int x;
        private int y;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiablePoint instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance.xIsSet()) {
                this.x(instance.x());
            }
            if (instance.yIsSet()) {
                this.y(instance.y());
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Canvas.Point instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiablePoint) {
                return this.from((ModifiablePoint)instance);
            }
            this.x(instance.x());
            this.y(instance.y());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder x(int x) {
            this.x = x;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder y(int y) {
            this.y = y;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePoint(null, this.x, this.y);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("x");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("y");
            }
            return "Cannot build Point, some of required attributes are not set " + attributes;
        }
    }
}

