/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.deep;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.deep.Canvas;
import org.immutables.fixture.deep.ImmutableLine;
import org.immutables.fixture.deep.ModifiableColor;
import org.immutables.fixture.deep.ModifiablePoint;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Canvas.Line", generator="Modifiables")
@NotThreadSafe
public final class ModifiableLine
implements Canvas.Line {
    private static final long INIT_BIT_COLOR = 1L;
    private long initBits = 1L;
    private final ArrayList<Canvas.Point> points = new ArrayList();
    private ModifiableColor color;
    private Optional<Canvas.Color> shadow = Optional.empty();

    private ModifiableLine() {
    }

    public static ModifiableLine create() {
        return new ModifiableLine();
    }

    @Override
    public final List<Canvas.Point> points() {
        return this.points;
    }

    @Override
    public final ModifiableColor color() {
        if (!this.colorIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.color;
    }

    @Override
    public final Optional<Canvas.Color> shadow() {
        return this.shadow;
    }

    @CanIgnoreReturnValue
    public ModifiableLine clear() {
        this.initBits = 1L;
        this.points.clear();
        this.color = null;
        this.shadow = Optional.empty();
        return this;
    }

    public ModifiableLine from(Canvas.Line instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableLine) {
            this.from((ModifiableLine)instance);
            return this;
        }
        this.addAllPoints(instance.points());
        this.setColor(instance.color());
        Optional<Canvas.Color> shadowOptional = instance.shadow();
        if (shadowOptional.isPresent()) {
            this.setShadow(shadowOptional);
        }
        return this;
    }

    public ModifiableLine from(ModifiableLine instance) {
        Optional<Canvas.Color> shadowOptional;
        Objects.requireNonNull(instance, "instance");
        this.addAllPoints(instance.points());
        if (instance.colorIsSet()) {
            this.setColor(instance.color());
        }
        if ((shadowOptional = instance.shadow()).isPresent()) {
            this.setShadow(shadowOptional);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine addPoint(Canvas.Point element) {
        Objects.requireNonNull(element, "points element");
        this.points.add(element instanceof ModifiablePoint ? element : ModifiablePoint.create().from(element));
        return this;
    }

    @CanIgnoreReturnValue
    public final ModifiableLine addPoints(Canvas.Point ... elements) {
        for (Canvas.Point e : elements) {
            this.addPoint(e);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine setPoints(Iterable<? extends Canvas.Point> elements) {
        this.points.clear();
        this.addAllPoints(elements);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine addAllPoints(Iterable<? extends Canvas.Point> elements) {
        for (Canvas.Point point : elements) {
            this.addPoint(point);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine setColor(Canvas.Color color) {
        this.color = color instanceof ModifiableColor ? (ModifiableColor)color : ModifiableColor.create().from(color);
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine setShadow(Canvas.Color shadow) {
        this.shadow = Optional.of(shadow);
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableLine setShadow(Optional<Canvas.Color> shadow) {
        this.shadow = Objects.requireNonNull(shadow, "shadow");
        return this;
    }

    public final boolean colorIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableLine unsetColor() {
        this.initBits |= 1L;
        this.color = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.colorIsSet()) {
            attributes.add("color");
        }
        return "Line is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableLine toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableLine.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableLine)) {
            return false;
        }
        ModifiableLine other = (ModifiableLine)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableLine another) {
        return this.points.equals(another.points) && this.color.equals(another.color) && Objects.equals(this.shadow, another.shadow);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.points.hashCode();
        h += (h << 5) + this.color.hashCode();
        h += (h << 5) + this.shadow.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableLine").add("points", this.points()).add("color", this.colorIsSet() ? this.color() : "?").add("shadow", this.shadow()).toString();
    }
}

