/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.encoding.defs;

import java.util.Objects;
import java.util.OptionalDouble;

class CompactOptionalDouble {
    private final OptionalDouble opt = OptionalDouble.empty();
    private final double value = this.opt.orElse(0.0);
    private final boolean present = this.opt.isPresent();

    CompactOptionalDouble() {
    }

    static OptionalDouble from(Object ddd) {
        if (Double.isNaN((Double)ddd)) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of((Double)ddd);
    }

    OptionalDouble get() {
        return this.present ? OptionalDouble.of(this.value) : OptionalDouble.empty();
    }

    static final class Builder {
        private OptionalDouble builder = OptionalDouble.empty();

        Builder() {
        }

        void set(double value) {
            this.builder = OptionalDouble.of(value);
        }

        void setOpt(OptionalDouble value) {
            this.builder = Objects.requireNonNull(value);
        }

        boolean isSet() {
            return this.builder.isPresent();
        }

        OptionalDouble build() {
            return this.builder;
        }
    }
}

