/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.generics.AbstractValidate;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractValidate.Concrete2", generator="Immutables")
@Immutable
public final class ImmutableConcrete2<T>
extends AbstractValidate.Concrete2<T> {
    private final T reference;

    private ImmutableConcrete2(T reference) {
        this.reference = Objects.requireNonNull(reference, "reference");
    }

    private ImmutableConcrete2(ImmutableConcrete2<T> original, T reference) {
        this.reference = reference;
    }

    @Override
    T reference() {
        return this.reference;
    }

    public final ImmutableConcrete2<T> withReference(T value) {
        if (this.reference == value) {
            return this;
        }
        T newValue = Objects.requireNonNull(value, "reference");
        return ImmutableConcrete2.validate(new ImmutableConcrete2<T>(this, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConcrete2 && this.equalTo(0, (ImmutableConcrete2)another);
    }

    private boolean equalTo(int synthetic, ImmutableConcrete2<?> another) {
        return this.reference.equals(another.reference);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.reference.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Concrete2").omitNullValues().add("reference", this.reference).toString();
    }

    public static <T> ImmutableConcrete2<T> of(T reference) {
        return ImmutableConcrete2.validate(new ImmutableConcrete2<T>(reference));
    }

    private static <T> ImmutableConcrete2<T> validate(ImmutableConcrete2<T> instance) {
        instance.check();
        return instance;
    }

    public static <T> ImmutableConcrete2<T> copyOf(AbstractValidate.Concrete2<T> instance) {
        if (instance instanceof ImmutableConcrete2) {
            return (ImmutableConcrete2)instance;
        }
        return ImmutableConcrete2.builder().from(instance).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="AbstractValidate.Concrete2", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T> {
        private static final long INIT_BIT_REFERENCE = 1L;
        private long initBits = 1L;
        @Nullable
        private T reference;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AbstractValidate.Concrete2<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.reference(instance.reference());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> reference(T reference) {
            this.reference = Objects.requireNonNull(reference, "reference");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConcrete2<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableConcrete2.validate(new ImmutableConcrete2(null, this.reference));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reference");
            }
            return "Cannot build Concrete2, some of required attributes are not set " + attributes;
        }
    }
}

