/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.DefaultCollection;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DefaultCollection", generator="Immutables")
@Immutable
public final class ImmutableDefaultCollection
implements DefaultCollection {
    @Nullable
    private final ImmutableList<String> nullable;
    private final ImmutableList<String> defaults;
    @Nullable
    private final ImmutableList<Integer> defnullable;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDefaultCollection(Builder builder) {
        ImmutableList<String> immutableList = this.nullable = builder.nullable == null ? null : builder.nullable.build();
        if (builder.defaultsIsSet()) {
            this.initShim.defaults((ImmutableList<String>)builder.defaults.build());
        }
        if (builder.defnullableIsSet()) {
            this.initShim.defnullable(builder.defnullable == null ? null : builder.defnullable.build());
        }
        this.defaults = this.initShim.defaults();
        this.defnullable = this.initShim.defnullable();
        this.initShim = null;
    }

    private ImmutableDefaultCollection(@Nullable ImmutableList<String> nullable, ImmutableList<String> defaults, @Nullable ImmutableList<Integer> defnullable) {
        this.nullable = nullable;
        this.defaults = defaults;
        this.defnullable = defnullable;
        this.initShim = null;
    }

    private List<String> defaultsInitialize() {
        return DefaultCollection.super.defaults();
    }

    @Nullable
    private List<Integer> defnullableInitialize() {
        return DefaultCollection.super.defnullable();
    }

    @JsonProperty(value="nullable")
    @Nullable
    public ImmutableList<String> nullable() {
        return this.nullable;
    }

    @JsonProperty(value="defaults")
    public ImmutableList<String> defaults() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaults() : this.defaults;
    }

    @JsonProperty(value="defnullable")
    @Nullable
    public ImmutableList<Integer> defnullable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defnullable() : this.defnullable;
    }

    public final ImmutableDefaultCollection withNullable(String ... elements) {
        if (elements == null) {
            return new ImmutableDefaultCollection(null, this.defaults, this.defnullable);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableDefaultCollection((ImmutableList<String>)newValue, this.defaults, this.defnullable);
    }

    public final ImmutableDefaultCollection withNullable(@Nullable Iterable<String> elements) {
        if (this.nullable == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableDefaultCollection((ImmutableList<String>)newValue, this.defaults, this.defnullable);
    }

    public final ImmutableDefaultCollection withDefaults(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableDefaultCollection(this.nullable, (ImmutableList<String>)newValue, this.defnullable);
    }

    public final ImmutableDefaultCollection withDefaults(Iterable<String> elements) {
        if (this.defaults == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableDefaultCollection(this.nullable, (ImmutableList<String>)newValue, this.defnullable);
    }

    public final ImmutableDefaultCollection withDefnullable(int ... elements) {
        if (elements == null) {
            return new ImmutableDefaultCollection(this.nullable, this.defaults, null);
        }
        ImmutableList newValue = Ints.asList((int[])elements) == null ? null : ImmutableList.copyOf((Collection)Ints.asList((int[])elements));
        return new ImmutableDefaultCollection(this.nullable, this.defaults, (ImmutableList<Integer>)newValue);
    }

    public final ImmutableDefaultCollection withDefnullable(@Nullable Iterable<Integer> elements) {
        if (this.defnullable == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableDefaultCollection(this.nullable, this.defaults, (ImmutableList<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDefaultCollection && this.equalTo(0, (ImmutableDefaultCollection)another);
    }

    private boolean equalTo(int synthetic, ImmutableDefaultCollection another) {
        return Objects.equals(this.nullable, another.nullable) && this.defaults.equals(another.defaults) && Objects.equals(this.defnullable, another.defnullable);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.nullable);
        h += (h << 5) + this.defaults.hashCode();
        h += (h << 5) + Objects.hashCode(this.defnullable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DefaultCollection").omitNullValues().add("nullable", this.nullable).add("defaults", this.defaults).add("defnullable", this.defnullable).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDefaultCollection fromJson(Json json) {
        Builder builder = ImmutableDefaultCollection.builder();
        if (json.nullable != null) {
            builder.addAllNullable(json.nullable);
        }
        if (json.defaultsIsSet) {
            builder.addAllDefaults(json.defaults);
        }
        if (json.defnullableIsSet) {
            builder.addAllDefnullable(json.defnullable);
        }
        return builder.build();
    }

    public static ImmutableDefaultCollection copyOf(DefaultCollection instance) {
        if (instance instanceof ImmutableDefaultCollection) {
            return (ImmutableDefaultCollection)instance;
        }
        return ImmutableDefaultCollection.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DefaultCollection", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_DEFAULTS = 1L;
        private static final long OPT_BIT_DEFNULLABLE = 2L;
        private long optBits;
        private ImmutableList.Builder<String> nullable = null;
        private ImmutableList.Builder<String> defaults = ImmutableList.builder();
        private ImmutableList.Builder<Integer> defnullable = null;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DefaultCollection instance) {
            Objects.requireNonNull(instance, "instance");
            List<String> nullableValue = instance.nullable();
            if (nullableValue != null) {
                this.addAllNullable(nullableValue);
            }
            this.addAllDefaults(instance.defaults());
            List<Integer> defnullableValue = instance.defnullable();
            if (defnullableValue != null) {
                this.addAllDefnullable(defnullableValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNullable(String element) {
            if (this.nullable == null) {
                this.nullable = ImmutableList.builder();
            }
            this.nullable.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNullable(String ... elements) {
            if (this.nullable == null) {
                this.nullable = ImmutableList.builder();
            }
            this.nullable.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="nullable")
        @CanIgnoreReturnValue
        public final Builder nullable(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.nullable = null;
                return this;
            }
            this.nullable = ImmutableList.builder();
            return this.addAllNullable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNullable(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nullable element");
            if (this.nullable == null) {
                this.nullable = ImmutableList.builder();
            }
            this.nullable.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaults(String element) {
            this.defaults.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefaults(String ... elements) {
            this.defaults.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="defaults")
        @CanIgnoreReturnValue
        public final Builder defaults(Iterable<String> elements) {
            this.defaults = ImmutableList.builder();
            return this.addAllDefaults(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDefaults(Iterable<String> elements) {
            this.defaults.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefnullable(int element) {
            if (this.defnullable == null) {
                this.defnullable = ImmutableList.builder();
            }
            this.defnullable.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDefnullable(int ... elements) {
            if (this.defnullable == null) {
                this.defnullable = ImmutableList.builder();
            }
            this.defnullable.addAll((Iterable)Ints.asList((int[])elements));
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="defnullable")
        @CanIgnoreReturnValue
        public final Builder defnullable(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.defnullable = null;
                this.optBits |= 2L;
                return this;
            }
            this.defnullable = ImmutableList.builder();
            return this.addAllDefnullable(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDefnullable(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "defnullable element");
            if (this.defnullable == null) {
                this.defnullable = ImmutableList.builder();
            }
            this.defnullable.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        public ImmutableDefaultCollection build() {
            return new ImmutableDefaultCollection(this);
        }

        private boolean defaultsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean defnullableIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DefaultCollection", generator="Immutables")
    static final class Json
    implements DefaultCollection {
        @Nullable
        List<String> nullable = null;
        @Nullable
        List<String> defaults = ImmutableList.of();
        boolean defaultsIsSet;
        @Nullable
        List<Integer> defnullable = null;
        boolean defnullableIsSet;

        Json() {
        }

        @JsonProperty(value="nullable")
        public void setNullable(@Nullable List<String> nullable) {
            this.nullable = nullable;
        }

        @JsonProperty(value="defaults")
        public void setDefaults(List<String> defaults) {
            this.defaults = defaults;
            this.defaultsIsSet = null != defaults;
        }

        @JsonProperty(value="defnullable")
        public void setDefnullable(@Nullable List<Integer> defnullable) {
            this.defnullable = defnullable;
            this.defnullableIsSet = true;
        }

        @Override
        public List<String> nullable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> defaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> defnullable() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="DefaultCollection", generator="Immutables")
    private final class InitShim {
        private byte defaultsBuildStage = 0;
        private ImmutableList<String> defaults;
        private byte defnullableBuildStage = 0;
        private ImmutableList<Integer> defnullable;

        private InitShim() {
        }

        ImmutableList<String> defaults() {
            if (this.defaultsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultsBuildStage == 0) {
                this.defaultsBuildStage = (byte)-1;
                this.defaults = ImmutableList.copyOf((Collection)ImmutableDefaultCollection.this.defaultsInitialize());
                this.defaultsBuildStage = 1;
            }
            return this.defaults;
        }

        void defaults(ImmutableList<String> defaults) {
            this.defaults = defaults;
            this.defaultsBuildStage = 1;
        }

        ImmutableList<Integer> defnullable() {
            if (this.defnullableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defnullableBuildStage == 0) {
                this.defnullableBuildStage = (byte)-1;
                this.defnullable = ImmutableDefaultCollection.this.defnullableInitialize() == null ? null : ImmutableList.copyOf((Collection)ImmutableDefaultCollection.this.defnullableInitialize());
                this.defnullableBuildStage = 1;
            }
            return this.defnullable;
        }

        void defnullable(ImmutableList<Integer> defnullable) {
            this.defnullable = defnullable;
            this.defnullableBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.defaultsBuildStage == -1) {
                attributes.add("defaults");
            }
            if (this.defnullableBuildStage == -1) {
                attributes.add("defnullable");
            }
            return "Cannot build DefaultCollection, attribute initializers form cycle " + attributes;
        }
    }
}

