/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.fixture.jackson.PackageNoBuilderHidden;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PackageNoBuilderHidden", generator="Immutables")
@Immutable
final class ImmutablePackageNoBuilderHidden
implements PackageNoBuilderHidden {
    private final List<String> strings;
    @Nullable
    private final Integer getInt;
    private static final ImmutablePackageNoBuilderHidden INSTANCE = ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden());

    private ImmutablePackageNoBuilderHidden() {
        this.strings = Collections.emptyList();
        this.getInt = null;
    }

    private ImmutablePackageNoBuilderHidden(List<String> strings, @Nullable Integer getInt) {
        this.strings = strings;
        this.getInt = getInt;
    }

    @Override
    @JsonProperty(value="strings")
    public List<String> getStrings() {
        return this.strings;
    }

    @Override
    @JsonProperty(value="int")
    public Optional<Integer> getInt() {
        return Optional.ofNullable(this.getInt);
    }

    public final ImmutablePackageNoBuilderHidden withStrings(String ... elements) {
        List<String> newValue = ImmutablePackageNoBuilderHidden.createUnmodifiableList(false, ImmutablePackageNoBuilderHidden.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
    }

    public final ImmutablePackageNoBuilderHidden withStrings(Iterable<String> elements) {
        if (this.strings == elements) {
            return this;
        }
        List<String> newValue = ImmutablePackageNoBuilderHidden.createUnmodifiableList(false, ImmutablePackageNoBuilderHidden.createSafeList(elements, true, false));
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
    }

    public final ImmutablePackageNoBuilderHidden withInt(int value) {
        Integer newValue = value;
        if (Objects.equals(this.getInt, newValue)) {
            return this;
        }
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(this.strings, newValue));
    }

    public final ImmutablePackageNoBuilderHidden withInt(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.getInt, value)) {
            return this;
        }
        return ImmutablePackageNoBuilderHidden.validate(new ImmutablePackageNoBuilderHidden(this.strings, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePackageNoBuilderHidden && this.equalTo(0, (ImmutablePackageNoBuilderHidden)another);
    }

    private boolean equalTo(int synthetic, ImmutablePackageNoBuilderHidden another) {
        return this.strings.equals(another.strings) && Objects.equals(this.getInt, another.getInt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.strings.hashCode();
        h += (h << 5) + Objects.hashCode(this.getInt);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PackageNoBuilderHidden{");
        builder.append("strings=").append(this.strings);
        if (this.getInt != null) {
            builder.append(", ");
            builder.append("int=").append(this.getInt);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePackageNoBuilderHidden fromJson(Json json) {
        ImmutablePackageNoBuilderHidden instance = (ImmutablePackageNoBuilderHidden)ImmutablePackageNoBuilderHidden.of();
        if (json.strings != null) {
            instance = instance.withStrings(json.strings);
        }
        if (json.getInt != null) {
            instance = instance.withInt(json.getInt);
        }
        return instance;
    }

    public static PackageNoBuilderHidden of() {
        return INSTANCE;
    }

    private static ImmutablePackageNoBuilderHidden validate(ImmutablePackageNoBuilderHidden instance) {
        return instance;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PackageNoBuilderHidden", generator="Immutables")
    static final class Json
    implements PackageNoBuilderHidden {
        @Nullable
        List<String> strings = Collections.emptyList();
        @Nullable
        Optional<Integer> getInt = Optional.empty();

        Json() {
        }

        @JsonProperty(value="strings")
        public void setStrings(List<String> strings) {
            this.strings = strings;
        }

        @JsonProperty(value="int")
        public void setInt(Optional<Integer> getInt) {
            this.getInt = getInt;
        }

        @Override
        public List<String> getStrings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getInt() {
            throw new UnsupportedOperationException();
        }
    }
}

