/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jackson.PackageHidden;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="PackageHidden", generator="Immutables")
@NotThreadSafe
public final class PackageHiddenBuilder {
    private List<String> strings = new ArrayList<String>();

    @CanIgnoreReturnValue
    public final PackageHiddenBuilder from(PackageHidden instance) {
        Objects.requireNonNull(instance, "instance");
        this.addAllStrings(instance.getStrings());
        return this;
    }

    @CanIgnoreReturnValue
    public final PackageHiddenBuilder addStrings(String element) {
        this.strings.add(Objects.requireNonNull(element, "strings element"));
        return this;
    }

    @CanIgnoreReturnValue
    public final PackageHiddenBuilder addStrings(String ... elements) {
        for (String element : elements) {
            this.strings.add(Objects.requireNonNull(element, "strings element"));
        }
        return this;
    }

    @JsonProperty(value="strings")
    @CanIgnoreReturnValue
    public final PackageHiddenBuilder strings(Iterable<String> elements) {
        this.strings.clear();
        return this.addAllStrings(elements);
    }

    @CanIgnoreReturnValue
    public final PackageHiddenBuilder addAllStrings(Iterable<String> elements) {
        for (String element : elements) {
            this.strings.add(Objects.requireNonNull(element, "strings element"));
        }
        return this;
    }

    public PackageHidden build() {
        return new ImmutablePackageHidden(PackageHiddenBuilder.createUnmodifiableList(true, this.strings));
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @CheckReturnValue
    @Generated(from="PackageHidden", generator="Immutables")
    @Immutable
    static final class ImmutablePackageHidden
    implements PackageHidden {
        private final List<String> strings;

        private ImmutablePackageHidden(List<String> strings) {
            this.strings = strings;
        }

        @Override
        @JsonProperty(value="strings")
        public List<String> getStrings() {
            return this.strings;
        }

        public final ImmutablePackageHidden withStrings(String ... elements) {
            List newValue = PackageHiddenBuilder.createUnmodifiableList(false, PackageHiddenBuilder.createSafeList(Arrays.asList(elements), true, false));
            return new ImmutablePackageHidden(newValue);
        }

        public final ImmutablePackageHidden withStrings(Iterable<String> elements) {
            if (this.strings == elements) {
                return this;
            }
            List newValue = PackageHiddenBuilder.createUnmodifiableList(false, PackageHiddenBuilder.createSafeList(elements, true, false));
            return new ImmutablePackageHidden(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutablePackageHidden && this.equalTo(0, (ImmutablePackageHidden)another);
        }

        private boolean equalTo(int synthetic, ImmutablePackageHidden another) {
            return this.strings.equals(another.strings);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.strings.hashCode();
            return h;
        }

        public String toString() {
            return "PackageHidden{strings=" + this.strings + "}";
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static ImmutablePackageHidden fromJson(Json json) {
            PackageHiddenBuilder builder = new PackageHiddenBuilder();
            if (json.strings != null) {
                builder.addAllStrings(json.strings);
            }
            return (ImmutablePackageHidden)builder.build();
        }

        public static PackageHidden copyOf(PackageHidden instance) {
            if (instance instanceof ImmutablePackageHidden) {
                return (ImmutablePackageHidden)instance;
            }
            return new PackageHiddenBuilder().from(instance).build();
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="PackageHidden", generator="Immutables")
        static final class Json
        implements PackageHidden {
            @Nullable
            List<String> strings = Collections.emptyList();

            Json() {
            }

            @JsonProperty(value="strings")
            public void setStrings(List<String> strings) {
                this.strings = strings;
            }

            @Override
            public List<String> getStrings() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

