/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.jdkonly.HasOptionalToFloat;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="HasOptionalToFloat", generator="Immutables")
@Immutable
final class ImmutableHasOptionalToFloat
implements HasOptionalToFloat {
    @Nullable
    private final Integer into;
    private final Float mandatory;
    @Nullable
    private final Float nullable;
    @Nullable
    private final Float optional;

    private ImmutableHasOptionalToFloat(@Nullable Integer into, Float mandatory, @Nullable Float nullable, @Nullable Float optional) {
        this.into = into;
        this.mandatory = mandatory;
        this.nullable = nullable;
        this.optional = optional;
    }

    @Override
    public OptionalInt into() {
        return this.into != null ? OptionalInt.of(this.into) : OptionalInt.empty();
    }

    @Override
    public Float mandatory() {
        return this.mandatory;
    }

    @Override
    @Nullable
    public Float nullable() {
        return this.nullable;
    }

    @Override
    public Optional<Float> optional() {
        return Optional.ofNullable(this.optional);
    }

    public final ImmutableHasOptionalToFloat withInto(int value) {
        Integer newValue = value;
        if (Objects.equals(this.into, newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(newValue, this.mandatory, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToFloat withInto(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.into, value)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(value, this.mandatory, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToFloat withMandatory(Float value) {
        Float newValue = Objects.requireNonNull(value, "mandatory");
        if (this.mandatory.equals(newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(this.into, newValue, this.nullable, this.optional);
    }

    public final ImmutableHasOptionalToFloat withNullable(@Nullable Float value) {
        if (Objects.equals(this.nullable, value)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(this.into, this.mandatory, value, this.optional);
    }

    public final ImmutableHasOptionalToFloat withOptional(float value) {
        Float newValue = Float.valueOf(value);
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(this.into, this.mandatory, this.nullable, newValue);
    }

    public final ImmutableHasOptionalToFloat withOptional(Optional<Float> optional) {
        Float value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return new ImmutableHasOptionalToFloat(this.into, this.mandatory, this.nullable, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHasOptionalToFloat && this.equalTo(0, (ImmutableHasOptionalToFloat)another);
    }

    private boolean equalTo(int synthetic, ImmutableHasOptionalToFloat another) {
        return Objects.equals(this.into, another.into) && this.mandatory.equals(another.mandatory) && Objects.equals(this.nullable, another.nullable) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.into);
        h += (h << 5) + this.mandatory.hashCode();
        h += (h << 5) + Objects.hashCode(this.nullable);
        h += (h << 5) + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HasOptionalToFloat{");
        if (this.into != null) {
            builder.append("into=").append(this.into);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("mandatory=").append(this.mandatory);
        if (this.nullable != null) {
            builder.append(", ");
            builder.append("nullable=").append(this.nullable);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        return builder.append("}").toString();
    }

    public static ImmutableHasOptionalToFloat copyOf(HasOptionalToFloat instance) {
        if (instance instanceof ImmutableHasOptionalToFloat) {
            return (ImmutableHasOptionalToFloat)instance;
        }
        return ImmutableHasOptionalToFloat.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HasOptionalToFloat", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MANDATORY = 1L;
        private long initBits = 1L;
        @Nullable
        private Integer into;
        @Nullable
        private Float mandatory;
        @Nullable
        private Float nullable;
        @Nullable
        private Float optional;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(HasOptionalToFloat instance) {
            Optional<Float> optionalOptional;
            Objects.requireNonNull(instance, "instance");
            OptionalInt intoOptional = instance.into();
            if (intoOptional.isPresent()) {
                this.into(intoOptional);
            }
            this.mandatory(instance.mandatory());
            Float nullableValue = instance.nullable();
            if (nullableValue != null) {
                this.nullable(nullableValue);
            }
            if ((optionalOptional = instance.optional()).isPresent()) {
                this.optional(optionalOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder into(int into) {
            this.into = into;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder into(OptionalInt into) {
            this.into = into.isPresent() ? Integer.valueOf(into.getAsInt()) : null;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mandatory(Float mandatory) {
            this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nullable(@Nullable Float nullable) {
            this.nullable = nullable;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optional(float optional) {
            this.optional = Float.valueOf(optional);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optional(Optional<Float> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public ImmutableHasOptionalToFloat build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableHasOptionalToFloat(this.into, this.mandatory, this.nullable, this.optional);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mandatory");
            }
            return "Cannot build HasOptionalToFloat, some of required attributes are not set " + attributes;
        }
    }
}

