/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.immutables.fixture.modifiable.AbstractImmutableWithModifiable;
import org.immutables.fixture.modifiable.ModifiableImmutableWithModifiable;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AbstractImmutableWithModifiable", generator="Immutables")
@Immutable
public final class ImmutableWithModifiable
implements AbstractImmutableWithModifiable {
    private final int id;
    private final String description;
    private final List<String> names;
    private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

    private ImmutableWithModifiable(int id, String description, List<String> names) {
        this.id = id;
        this.description = description;
        this.names = names;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    public final ImmutableWithModifiable withId(int value) {
        if (this.id == value) {
            return this;
        }
        return ImmutableWithModifiable.validate(new ImmutableWithModifiable(value, this.description, this.names));
    }

    public final ImmutableWithModifiable withDescription(String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return ImmutableWithModifiable.validate(new ImmutableWithModifiable(this.id, value, this.names));
    }

    public final ImmutableWithModifiable withNames(String ... elements) {
        List<String> newValue = ImmutableWithModifiable.createUnmodifiableList(false, ImmutableWithModifiable.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableWithModifiable.validate(new ImmutableWithModifiable(this.id, this.description, newValue));
    }

    public final ImmutableWithModifiable withNames(Iterable<String> elements) {
        if (this.names == elements) {
            return this;
        }
        List<String> newValue = ImmutableWithModifiable.createUnmodifiableList(false, ImmutableWithModifiable.createSafeList(elements, true, false));
        return ImmutableWithModifiable.validate(new ImmutableWithModifiable(this.id, this.description, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithModifiable && this.equalTo(0, (ImmutableWithModifiable)another);
    }

    private boolean equalTo(int synthetic, ImmutableWithModifiable another) {
        return this.id == another.id && Objects.equals(this.description, another.description) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "ImmutableWithModifiable{id=" + this.id + ", description=" + this.description + ", names=" + this.names + "}";
    }

    private static ImmutableWithModifiable validate(ImmutableWithModifiable instance) {
        Set constraintViolations = validator.validate((Object)instance, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        return instance;
    }

    public static ImmutableWithModifiable copyOf(AbstractImmutableWithModifiable instance) {
        if (instance instanceof ImmutableWithModifiable) {
            return (ImmutableWithModifiable)instance;
        }
        return ImmutableWithModifiable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractImmutableWithModifiable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private int id;
        @Nullable
        private String description;
        private List<String> names = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ModifiableImmutableWithModifiable instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.setDescription(descriptionValue);
            }
            this.addAllNames(instance.getNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractImmutableWithModifiable instance) {
            Objects.requireNonNull(instance, "instance");
            if (instance instanceof ModifiableImmutableWithModifiable) {
                return this.from((ModifiableImmutableWithModifiable)instance);
            }
            this.setId(instance.getId());
            String descriptionValue = instance.getDescription();
            if (descriptionValue != null) {
                this.setDescription(descriptionValue);
            }
            this.addAllNames(instance.getNames());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setId(int id) {
            this.id = id;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNames(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addNames(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder setNames(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public ImmutableWithModifiable build() {
            return ImmutableWithModifiable.validate(new ImmutableWithModifiable(this.id, this.description, ImmutableWithModifiable.createUnmodifiableList(true, this.names)));
        }
    }
}

