/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.modifiable.GenericHolder;
import org.immutables.fixture.modifiable.ImmutableGenericHolder;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GenericHolder", generator="Modifiables")
@NotThreadSafe
public final class ModifiableGenericHolder<T>
implements GenericHolder<T> {
    private static final long INIT_BIT_MANDATORY = 1L;
    private long initBits = 1L;
    private T mandatory;
    @Nullable
    private T optional;

    private ModifiableGenericHolder() {
    }

    public static <T> ModifiableGenericHolder<T> create() {
        return new ModifiableGenericHolder<T>();
    }

    @Override
    public final T mandatory() {
        if (!this.mandatoryIsSet()) {
            this.checkRequiredAttributes();
        }
        return this.mandatory;
    }

    @Override
    @Nullable
    public final T optional() {
        return this.optional;
    }

    @CanIgnoreReturnValue
    public ModifiableGenericHolder<T> clear() {
        this.initBits = 1L;
        this.mandatory = null;
        this.optional = null;
        return this;
    }

    public ModifiableGenericHolder<T> from(GenericHolder<T> instance) {
        Objects.requireNonNull(instance, "instance");
        if (instance instanceof ModifiableGenericHolder) {
            this.from((ModifiableGenericHolder)instance);
            return this;
        }
        this.setMandatory(instance.mandatory());
        T optionalValue = instance.optional();
        if (optionalValue != null) {
            this.setOptional(optionalValue);
        }
        return this;
    }

    public ModifiableGenericHolder<T> from(ModifiableGenericHolder<T> instance) {
        T optionalValue;
        Objects.requireNonNull(instance, "instance");
        if (instance.mandatoryIsSet()) {
            this.setMandatory(instance.mandatory());
        }
        if ((optionalValue = instance.optional()) != null) {
            this.setOptional(optionalValue);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableGenericHolder<T> setMandatory(T mandatory) {
        this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    @CanIgnoreReturnValue
    public ModifiableGenericHolder<T> setOptional(@Nullable T optional) {
        this.optional = optional;
        return this;
    }

    public final boolean mandatoryIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    @CanIgnoreReturnValue
    public final ModifiableGenericHolder<T> unsetMandatory() {
        this.initBits |= 1L;
        this.mandatory = null;
        return this;
    }

    public final boolean isInitialized() {
        return this.initBits == 0L;
    }

    private void checkRequiredAttributes() {
        if (!this.isInitialized()) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.mandatoryIsSet()) {
            attributes.add("mandatory");
        }
        return "GenericHolder is not initialized, some of the required attributes are not set " + attributes;
    }

    public final ImmutableGenericHolder<T> toImmutable() {
        this.checkRequiredAttributes();
        return ImmutableGenericHolder.copyOf(this);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        if (!(another instanceof ModifiableGenericHolder)) {
            return false;
        }
        ModifiableGenericHolder other = (ModifiableGenericHolder)another;
        if (!this.isInitialized() || !other.isInitialized()) {
            return false;
        }
        return this.equalTo(other);
    }

    private boolean equalTo(ModifiableGenericHolder<?> another) {
        return this.mandatory.equals(another.mandatory) && Objects.equals(this.optional, another.optional);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.mandatory.hashCode();
        h += (h << 5) + Objects.hashCode(this.optional);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ModifiableGenericHolder").add("mandatory", this.mandatoryIsSet() ? this.mandatory() : "?").add("optional", this.optional()).toString();
    }
}

