/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nested.Foo;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Foo", generator="Immutables")
public final class ImmutableFoo {
    private ImmutableFoo() {
    }

    @CheckReturnValue
    @Generated(from="Foo.Bar", generator="Immutables")
    @Immutable
    public static final class Bar
    implements Foo.Bar {
        private final String value;

        private Bar(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }

        public final Bar withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new Bar(newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Bar && this.equalTo(0, (Bar)another);
        }

        private boolean equalTo(int synthetic, Bar another) {
            return this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Bar").omitNullValues().add("value", (Object)this.value).toString();
        }

        public static Bar copyOf(Foo.Bar instance) {
            if (instance instanceof Bar) {
                return (Bar)instance;
            }
            return Bar.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="Foo.Bar", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_VALUE = 1L;
            private long initBits = 1L;
            @Nullable
            private String value;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(Foo instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(Foo.Bar instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Foo instance;
                long bits = 0L;
                if (object instanceof Foo) {
                    instance = (Foo)object;
                    if ((bits & 1L) == 0L) {
                        this.value(instance.value());
                        bits |= 1L;
                    }
                }
                if (object instanceof Foo.Bar) {
                    instance = (Foo.Bar)object;
                    if ((bits & 1L) == 0L) {
                        this.value(instance.value());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Bar build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Bar(this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build Bar, some of required attributes are not set " + attributes;
            }
        }
    }
}

