/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.nullable.NonnullConstruction;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NonnullConstruction", generator="Immutables")
@Immutable
public final class ImmutableNonnullConstruction
implements NonnullConstruction {
    private final String[] arr;
    @Nullable
    private final String[] brr;
    private final ImmutableList<String> ax;
    private final transient int a;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNonnullConstruction(String[] arr, @Nullable String[] brr, Iterable<String> ax) {
        this.arr = (String[])arr.clone();
        this.brr = brr;
        this.initShim.ax((ImmutableList<String>)ImmutableList.copyOf(ax));
        this.ax = this.initShim.ax();
        this.a = this.initShim.a();
        this.initShim = null;
    }

    private ImmutableNonnullConstruction(Builder builder) {
        this.arr = builder.arr;
        this.brr = builder.brr;
        if (builder.axIsSet()) {
            this.initShim.ax((ImmutableList<String>)builder.ax.build());
        }
        this.ax = this.initShim.ax();
        this.a = this.initShim.a();
        this.initShim = null;
    }

    private ImmutableNonnullConstruction(ImmutableNonnullConstruction original, String[] arr, @Nullable String[] brr, ImmutableList<String> ax) {
        this.arr = arr;
        this.brr = brr;
        this.initShim.ax(ax);
        this.ax = this.initShim.ax();
        this.a = this.initShim.a();
        this.initShim = null;
    }

    private List<String> axInitialize() {
        return NonnullConstruction.super.ax();
    }

    private int aInitialize() {
        return NonnullConstruction.super.a();
    }

    @Override
    @JsonProperty(value="arr")
    public String[] arr() {
        return (String[])this.arr.clone();
    }

    @Override
    @JsonProperty(value="brr")
    @Nullable
    public String[] brr() {
        return this.brr;
    }

    @JsonProperty(value="ax")
    public ImmutableList<String> ax() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ax() : this.ax;
    }

    @Override
    @JsonProperty(value="a")
    public int a() {
        InitShim shim = this.initShim;
        return shim != null ? shim.a() : this.a;
    }

    public final ImmutableNonnullConstruction withArr(String ... elements) {
        String[] newValue = (String[])elements.clone();
        return new ImmutableNonnullConstruction(this, newValue, this.brr, this.ax);
    }

    public final ImmutableNonnullConstruction withBrr(String ... elements) {
        String[] newValue = elements == null ? null : (String[])elements.clone();
        return new ImmutableNonnullConstruction(this, this.arr, newValue, this.ax);
    }

    public final ImmutableNonnullConstruction withAx(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableNonnullConstruction(this, this.arr, this.brr, (ImmutableList<String>)newValue);
    }

    public final ImmutableNonnullConstruction withAx(Iterable<String> elements) {
        if (this.ax == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableNonnullConstruction(this, this.arr, this.brr, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNonnullConstruction && this.equalTo(0, (ImmutableNonnullConstruction)another);
    }

    private boolean equalTo(int synthetic, ImmutableNonnullConstruction another) {
        return Arrays.equals(this.arr, another.arr) && Arrays.equals(this.brr, another.brr) && this.ax.equals(another.ax) && this.a == another.a;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Arrays.hashCode(this.arr);
        h += (h << 5) + Arrays.hashCode(this.brr);
        h += (h << 5) + this.ax.hashCode();
        h += (h << 5) + this.a;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NonnullConstruction").omitNullValues().add("arr", (Object)Arrays.toString(this.arr)).add("brr", (Object)Arrays.toString(this.brr)).add("ax", this.ax).add("a", this.a).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNonnullConstruction fromJson(Json json) {
        Builder builder = ImmutableNonnullConstruction.builder();
        if (json.arr != null) {
            builder.arr(json.arr);
        }
        if (json.brr != null) {
            builder.brr(json.brr);
        }
        if (json.axIsSet) {
            builder.addAllAx(json.ax);
        }
        return builder.build();
    }

    public static ImmutableNonnullConstruction of(String[] arr, @Nullable String[] brr, List<String> ax) {
        return ImmutableNonnullConstruction.of(arr, brr, ax);
    }

    public static ImmutableNonnullConstruction of(String[] arr, @Nullable String[] brr, Iterable<String> ax) {
        return new ImmutableNonnullConstruction(arr, brr, ax);
    }

    public static ImmutableNonnullConstruction copyOf(NonnullConstruction instance) {
        if (instance instanceof ImmutableNonnullConstruction) {
            return (ImmutableNonnullConstruction)instance;
        }
        return ImmutableNonnullConstruction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NonnullConstruction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ARR = 1L;
        private static final long OPT_BIT_AX = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String[] arr;
        @Nullable
        private String[] brr;
        private ImmutableList.Builder<String> ax = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NonnullConstruction instance) {
            Objects.requireNonNull(instance, "instance");
            this.arr(instance.arr());
            String[] brrValue = instance.brr();
            if (brrValue != null) {
                this.brr(brrValue);
            }
            this.addAllAx(instance.ax());
            return this;
        }

        @JsonProperty(value="arr")
        @CanIgnoreReturnValue
        public final Builder arr(String ... arr) {
            this.arr = (String[])arr.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="brr")
        @CanIgnoreReturnValue
        public final Builder brr(String ... brr) {
            this.brr = brr;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAx(String element) {
            this.ax.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAx(String ... elements) {
            this.ax.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="ax")
        @CanIgnoreReturnValue
        public final Builder ax(Iterable<String> elements) {
            this.ax = ImmutableList.builder();
            return this.addAllAx(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAx(Iterable<String> elements) {
            this.ax.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        public ImmutableNonnullConstruction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNonnullConstruction(this);
        }

        private boolean axIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("arr");
            }
            return "Cannot build NonnullConstruction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NonnullConstruction", generator="Immutables")
    static final class Json
    implements NonnullConstruction {
        @Nullable
        String[] arr;
        @Nullable
        String[] brr;
        @Nullable
        List<String> ax = ImmutableList.of();
        boolean axIsSet;

        Json() {
        }

        @JsonProperty(value="arr")
        public void setArr(String[] arr) {
            this.arr = arr;
        }

        @JsonProperty(value="brr")
        public void setBrr(@Nullable String[] brr) {
            this.brr = brr;
        }

        @JsonProperty(value="ax")
        public void setAx(List<String> ax) {
            this.ax = ax;
            this.axIsSet = null != ax;
        }

        @Override
        public String[] arr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String[] brr() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> ax() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public int a() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="NonnullConstruction", generator="Immutables")
    private final class InitShim {
        private byte axBuildStage = 0;
        private ImmutableList<String> ax;
        private byte aBuildStage = 0;
        private int a;

        private InitShim() {
        }

        ImmutableList<String> ax() {
            if (this.axBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.axBuildStage == 0) {
                this.axBuildStage = (byte)-1;
                this.ax = ImmutableList.copyOf((Collection)ImmutableNonnullConstruction.this.axInitialize());
                this.axBuildStage = 1;
            }
            return this.ax;
        }

        void ax(ImmutableList<String> ax) {
            this.ax = ax;
            this.axBuildStage = 1;
        }

        int a() {
            if (this.aBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.aBuildStage == 0) {
                this.aBuildStage = (byte)-1;
                this.a = ImmutableNonnullConstruction.this.aInitialize();
                this.aBuildStage = 1;
            }
            return this.a;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.axBuildStage == -1) {
                attributes.add("ax");
            }
            if (this.aBuildStage == -1) {
                attributes.add("a");
            }
            return "Cannot build NonnullConstruction, attribute initializers form cycle " + attributes;
        }
    }
}

