/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.fixture.with;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.fixture.with.WithMapUnary;
import org.immutables.fixture.with.WithUnaryOperator;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="WithMapUnary", generator="Immutables")
@Immutable
public final class ImmutableWithMapUnary
implements WithMapUnary {
    private final int a;
    private final String b;
    @Nullable
    private final String o;
    private final ImmutableList<String> l;
    @Nullable
    private final Integer i;
    @Nullable
    private final Double d;
    private final com.google.common.base.Optional<Integer> oi;

    private ImmutableWithMapUnary(int a, String b, @Nullable String o, ImmutableList<String> l, @Nullable Integer i, @Nullable Double d, com.google.common.base.Optional<Integer> oi) {
        this.a = a;
        this.b = b;
        this.o = o;
        this.l = l;
        this.i = i;
        this.d = d;
        this.oi = oi;
    }

    @Override
    public int a() {
        return this.a;
    }

    @Override
    public String b() {
        return this.b;
    }

    @Override
    public Optional<String> o() {
        return Optional.ofNullable(this.o);
    }

    public ImmutableList<String> l() {
        return this.l;
    }

    @Override
    public OptionalInt i() {
        return this.i != null ? OptionalInt.of(this.i) : OptionalInt.empty();
    }

    @Override
    public OptionalDouble d() {
        return this.d != null ? OptionalDouble.of(this.d) : OptionalDouble.empty();
    }

    @Override
    public com.google.common.base.Optional<Integer> oi() {
        return this.oi;
    }

    @Override
    public final ImmutableWithMapUnary withA(int value) {
        if (this.a == value) {
            return this;
        }
        return new ImmutableWithMapUnary(value, this.b, this.o, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapA(UnaryOperator<Integer> operator) {
        int value = (Integer)operator.apply(this.a);
        return new ImmutableWithMapUnary(value, this.b, this.o, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withB(String value) {
        String newValue = Objects.requireNonNull(value, "b");
        if (this.b.equals(newValue)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, newValue, this.o, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapB(UnaryOperator<String> operator) {
        String value = (String)operator.apply(this.b);
        return new ImmutableWithMapUnary(this.a, value, this.o, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withO(String value) {
        String newValue = Objects.requireNonNull(value, "o");
        if (Objects.equals(this.o, newValue)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, newValue, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withO(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.o, value)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, value, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapO(UnaryOperator<String> operator) {
        if (this.o == null) {
            return this;
        }
        String value = (String)operator.apply(this.o);
        return new ImmutableWithMapUnary(this.a, this.b, value, this.l, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withL(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableWithMapUnary(this.a, this.b, this.o, (ImmutableList<String>)newValue, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withL(Iterable<String> elements) {
        if (this.l == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWithMapUnary(this.a, this.b, this.o, (ImmutableList<String>)newValue, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapL(UnaryOperator<String> operator) {
        if (this.l.isEmpty()) {
            return this;
        }
        List elements = this.l.stream().map(operator).collect(Collectors.toList());
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableWithMapUnary(this.a, this.b, this.o, (ImmutableList<String>)newValue, this.i, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withI(int value) {
        Integer newValue = value;
        if (Objects.equals(this.i, newValue)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, newValue, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withI(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.i, value)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, value, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapI(UnaryOperator<Integer> operator) {
        if (this.i == null) {
            return this;
        }
        Integer value = (Integer)operator.apply(this.i);
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, value, this.d, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withD(double value) {
        Double newValue = value;
        if (Objects.equals(this.d, newValue)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, newValue, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withD(OptionalDouble optional) {
        Double value;
        Double d = value = optional.isPresent() ? Double.valueOf(optional.getAsDouble()) : null;
        if (Objects.equals(this.d, value)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, value, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary mapD(UnaryOperator<Double> operator) {
        if (this.d == null) {
            return this;
        }
        Double value = (Double)operator.apply(this.d);
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, value, this.oi);
    }

    @Override
    public final ImmutableWithMapUnary withOi(int value) {
        com.google.common.base.Optional newValue = com.google.common.base.Optional.of((Object)value);
        if (this.oi.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, (com.google.common.base.Optional<Integer>)newValue);
    }

    @Override
    public final ImmutableWithMapUnary withOi(com.google.common.base.Optional<Integer> optional) {
        com.google.common.base.Optional<Integer> value = optional;
        if (this.oi.equals(value)) {
            return this;
        }
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, value);
    }

    @Override
    public final ImmutableWithMapUnary mapOi(UnaryOperator<Integer> operator) {
        if (!this.oi.isPresent()) {
            return this;
        }
        com.google.common.base.Optional value = com.google.common.base.Optional.of(operator.apply((Integer)this.oi.get()));
        return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l, this.i, this.d, (com.google.common.base.Optional<Integer>)value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWithMapUnary && this.equalTo(0, (ImmutableWithMapUnary)another);
    }

    private boolean equalTo(int synthetic, ImmutableWithMapUnary another) {
        return this.a == another.a && this.b.equals(another.b) && Objects.equals(this.o, another.o) && this.l.equals(another.l) && Objects.equals(this.i, another.i) && Objects.equals(this.d, another.d) && this.oi.equals(another.oi);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.a;
        h += (h << 5) + this.b.hashCode();
        h += (h << 5) + Objects.hashCode(this.o);
        h += (h << 5) + this.l.hashCode();
        h += (h << 5) + Objects.hashCode(this.i);
        h += (h << 5) + Objects.hashCode(this.d);
        h += (h << 5) + this.oi.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WithMapUnary").omitNullValues().add("a", this.a).add("b", (Object)this.b).add("o", (Object)this.o).add("l", this.l).add("i", (Object)this.i).add("d", (Object)this.d).add("oi", this.oi.orNull()).toString();
    }

    public static ImmutableWithMapUnary copyOf(WithMapUnary instance) {
        if (instance instanceof ImmutableWithMapUnary) {
            return (ImmutableWithMapUnary)instance;
        }
        return new WithMapUnary.Builder().from(instance).build();
    }

    @Generated(from="WithMapUnary", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_A = 1L;
        private static final long INIT_BIT_B = 2L;
        private long initBits = 3L;
        private int a;
        @Nullable
        private String b;
        @Nullable
        private String o;
        private ImmutableList.Builder<String> l = ImmutableList.builder();
        @Nullable
        private Integer i;
        @Nullable
        private Double d;
        private com.google.common.base.Optional<Integer> oi = com.google.common.base.Optional.absent();

        public Builder() {
            if (!(this instanceof WithMapUnary.Builder)) {
                throw new UnsupportedOperationException("Use: new WithMapUnary.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder from(WithMapUnary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder from(WithUnaryOperator instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (WithMapUnary.Builder)this;
        }

        private void from(Object object) {
            Optional<String> oOptional;
            com.google.common.base.Optional<Integer> oiOptional;
            OptionalInt iOptional;
            OptionalDouble dOptional;
            WithUnaryOperator instance;
            long bits = 0L;
            if (object instanceof WithMapUnary) {
                instance = (WithMapUnary)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.b(instance.b());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    dOptional = instance.d();
                    if (dOptional.isPresent()) {
                        this.d(dOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    iOptional = instance.i();
                    if (iOptional.isPresent()) {
                        this.i(iOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    oiOptional = instance.oi();
                    if (oiOptional.isPresent()) {
                        this.oi(oiOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllL(instance.l());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    oOptional = instance.o();
                    if (oOptional.isPresent()) {
                        this.o(oOptional);
                    }
                    bits |= 0x40L;
                }
            }
            if (object instanceof WithUnaryOperator) {
                instance = (WithUnaryOperator)object;
                if ((bits & 1L) == 0L) {
                    this.a(instance.a());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.b(instance.b());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    dOptional = instance.d();
                    if (dOptional.isPresent()) {
                        this.d(dOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    iOptional = instance.i();
                    if (iOptional.isPresent()) {
                        this.i(iOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    oiOptional = instance.oi();
                    if (oiOptional.isPresent()) {
                        this.oi(oiOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.addAllL(instance.l());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    oOptional = instance.o();
                    if (oOptional.isPresent()) {
                        this.o(oOptional);
                    }
                    bits |= 0x40L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder a(int a) {
            this.a = a;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder b(String b) {
            this.b = Objects.requireNonNull(b, "b");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder o(String o) {
            this.o = Objects.requireNonNull(o, "o");
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder o(Optional<String> o) {
            this.o = o.orElse(null);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder addL(String element) {
            this.l.add((Object)element);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder addL(String ... elements) {
            this.l.add((Object[])elements);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder l(Iterable<String> elements) {
            this.l = ImmutableList.builder();
            return this.addAllL(elements);
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder addAllL(Iterable<String> elements) {
            this.l.addAll(elements);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder i(int i) {
            this.i = i;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder i(OptionalInt i) {
            this.i = i.isPresent() ? Integer.valueOf(i.getAsInt()) : null;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder d(double d) {
            this.d = d;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder d(OptionalDouble d) {
            this.d = d.isPresent() ? Double.valueOf(d.getAsDouble()) : null;
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder oi(int oi) {
            this.oi = com.google.common.base.Optional.of((Object)oi);
            return (WithMapUnary.Builder)this;
        }

        @CanIgnoreReturnValue
        public final WithMapUnary.Builder oi(com.google.common.base.Optional<Integer> oi) {
            this.oi = oi;
            return (WithMapUnary.Builder)this;
        }

        public ImmutableWithMapUnary build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWithMapUnary(this.a, this.b, this.o, this.l.build(), this.i, this.d, this.oi);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("a");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("b");
            }
            return "Cannot build WithMapUnary, some of required attributes are not set " + attributes;
        }
    }
}

