/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.processor.OkJsons;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.ValueType;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableOkTypeAdapterTypes
extends OkJsons.OkTypeAdapterTypes {
    private final Proto.AbstractDeclaring definedBy;
    private final String packageGenerated;
    private final ImmutableList<ValueType> types;
    private final OkJsons.EnumAllDefinitions enums;

    private ImmutableOkTypeAdapterTypes(Builder builder) {
        this.definedBy = builder.definedBy;
        this.packageGenerated = builder.packageGenerated;
        this.types = builder.typesBuilder.build();
        this.enums = (OkJsons.EnumAllDefinitions)Preconditions.checkNotNull((Object)super.enums());
    }

    private ImmutableOkTypeAdapterTypes(ImmutableOkTypeAdapterTypes original, Proto.AbstractDeclaring definedBy, String packageGenerated, ImmutableList<ValueType> types, OkJsons.EnumAllDefinitions enums) {
        this.definedBy = definedBy;
        this.packageGenerated = packageGenerated;
        this.types = types;
        this.enums = enums;
    }

    public final ImmutableOkTypeAdapterTypes withDefinedBy(Proto.AbstractDeclaring value) {
        if (this.definedBy == value) {
            return this;
        }
        Proto.AbstractDeclaring newValue = (Proto.AbstractDeclaring)Preconditions.checkNotNull((Object)value);
        return ImmutableOkTypeAdapterTypes.checkPreconditions(new ImmutableOkTypeAdapterTypes(this, newValue, this.packageGenerated, this.types, this.enums));
    }

    public final ImmutableOkTypeAdapterTypes withPackageGenerated(String value) {
        if (this.packageGenerated == value) {
            return this;
        }
        String newValue = (String)Preconditions.checkNotNull((Object)value);
        return ImmutableOkTypeAdapterTypes.checkPreconditions(new ImmutableOkTypeAdapterTypes(this, this.definedBy, newValue, this.types, this.enums));
    }

    public final ImmutableOkTypeAdapterTypes withTypes(ValueType ... elements) {
        ImmutableList newValue = ImmutableList.copyOf(Arrays.asList(elements));
        return ImmutableOkTypeAdapterTypes.checkPreconditions(new ImmutableOkTypeAdapterTypes(this, this.definedBy, this.packageGenerated, (ImmutableList<ValueType>)newValue, this.enums));
    }

    public final ImmutableOkTypeAdapterTypes withTypes(Iterable<? extends ValueType> elements) {
        if (this.types == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableOkTypeAdapterTypes.checkPreconditions(new ImmutableOkTypeAdapterTypes(this, this.definedBy, this.packageGenerated, (ImmutableList<ValueType>)newValue, this.enums));
    }

    @Override
    public Proto.AbstractDeclaring definedBy() {
        return this.definedBy;
    }

    @Override
    public String packageGenerated() {
        return this.packageGenerated;
    }

    public ImmutableList<ValueType> types() {
        return this.types;
    }

    @Override
    public OkJsons.EnumAllDefinitions enums() {
        return this.enums;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableOkTypeAdapterTypes && this.equalTo((ImmutableOkTypeAdapterTypes)another);
    }

    private boolean equalTo(ImmutableOkTypeAdapterTypes another) {
        return this.definedBy.equals(another.definedBy) && this.packageGenerated.equals(another.packageGenerated) && this.types.equals(another.types) && this.enums.equals(another.enums);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.definedBy.hashCode();
        h = h * 17 + this.packageGenerated.hashCode();
        h = h * 17 + this.types.hashCode();
        h = h * 17 + this.enums.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OkTypeAdapterTypes").omitNullValues().add("definedBy", (Object)this.definedBy).add("packageGenerated", (Object)this.packageGenerated).add("types", this.types).add("enums", (Object)this.enums).toString();
    }

    private static ImmutableOkTypeAdapterTypes checkPreconditions(ImmutableOkTypeAdapterTypes instance) {
        return instance;
    }

    static ImmutableOkTypeAdapterTypes copyOf(OkJsons.OkTypeAdapterTypes instance) {
        if (instance instanceof ImmutableOkTypeAdapterTypes) {
            return (ImmutableOkTypeAdapterTypes)instance;
        }
        Preconditions.checkNotNull((Object)instance);
        return ImmutableOkTypeAdapterTypes.builder().definedBy(instance.definedBy()).packageGenerated(instance.packageGenerated()).addAllTypes(instance.types()).build();
    }

    @Deprecated
    static ImmutableOkTypeAdapterTypes copyOf(ImmutableOkTypeAdapterTypes instance) {
        return (ImmutableOkTypeAdapterTypes)Preconditions.checkNotNull((Object)instance);
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL_ = 3L;
        private static final long INITIALIZED_BIT_DEFINED_BY = 1L;
        private static final long INITIALIZED_BIT_PACKAGE_GENERATED = 2L;
        private long initializedBitset;
        @Nullable
        private Proto.AbstractDeclaring definedBy;
        @Nullable
        private String packageGenerated;
        private ImmutableList.Builder<ValueType> typesBuilder = ImmutableList.builder();

        private Builder() {
        }

        public final Builder definedBy(Proto.AbstractDeclaring definedBy) {
            this.definedBy = (Proto.AbstractDeclaring)Preconditions.checkNotNull((Object)definedBy);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder packageGenerated(String packageGenerated) {
            this.packageGenerated = (String)Preconditions.checkNotNull((Object)packageGenerated);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addTypes(ValueType element) {
            this.typesBuilder.add((Object)element);
            return this;
        }

        public final Builder addTypes(ValueType ... elements) {
            this.typesBuilder.addAll((Iterable)ImmutableList.copyOf(Arrays.asList(elements)));
            return this;
        }

        public final Builder addAllTypes(Iterable<? extends ValueType> elements) {
            this.typesBuilder.addAll(elements);
            return this;
        }

        public ImmutableOkTypeAdapterTypes build() {
            this.checkRequiredAttributes();
            return ImmutableOkTypeAdapterTypes.checkPreconditions(new ImmutableOkTypeAdapterTypes(this));
        }

        private boolean definedByIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean packageGeneratedIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            return MoreObjects.toStringHelper((String)"Cannot build OkTypeAdapterTypes, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.definedByIsSet() ? "definedBy" : null)).addValue((Object)(!this.packageGeneratedIsSet() ? "packageGenerated" : null)).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ImmutableOkTypeAdapterTypes.Builder").omitNullValues().add("definedBy", (Object)this.definedBy).add("packageGenerated", (Object)this.packageGenerated).add("types", (Object)this.typesBuilder.build()).toString();
        }
    }
}

