/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import java.util.Set;
import javax.annotation.processing.SupportedAnnotationTypes;
import org.immutables.generator.AbstractGenerator;
import org.immutables.value.processor.Generator_Asts;
import org.immutables.value.processor.Generator_Funcs;
import org.immutables.value.processor.Generator_Gsons;
import org.immutables.value.processor.Generator_Immutables;
import org.immutables.value.processor.Generator_Modifiables;
import org.immutables.value.processor.Generator_Repositories;
import org.immutables.value.processor.Generator_Transformers;
import org.immutables.value.processor.meta.CustomImmutableAnnotations;
import org.immutables.value.processor.meta.ImmutableRound;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Round;
import org.immutables.value.processor.meta.ValueType;

@SupportedAnnotationTypes(value={"org.immutables.builder.Builder.Factory", "org.immutables.value.Value.Immutable", "org.immutables.value.Value.Enclosing", "org.immutables.value.Value.Include", "org.immutables.value.Value.Modifiable", "org.immutables.value.Value"})
public final class Processor
extends AbstractGenerator {
    protected void process() {
        ImmutableRound round = ImmutableRound.builder().addAllAnnotations(this.annotations()).processing(this.processing()).addAllCustomImmutableAnnotations((Iterable<String>)CustomImmutableAnnotations.annotations()).round(this.round()).build();
        Multimap<Proto.DeclaringPackage, ValueType> values = round.collectValues();
        this.invoke(new Generator_Immutables().usingValues(values).generate());
        this.invoke(new Generator_Modifiables().usingValues(values).generate());
        if (((Round)round).environment().hasGsonLib()) {
            this.invoke(new Generator_Gsons().usingValues(values).generate());
        }
        if (((Round)round).environment().hasMongoModule()) {
            this.invoke(new Generator_Repositories().usingValues(values).generate());
        }
        if (((Round)round).environment().hasFuncModule()) {
            this.invoke(new Generator_Funcs().usingValues(values).generate());
        }
        if (((Round)round).environment().hasTransformModule()) {
            this.invoke(new Generator_Transformers().usingValues(values).generate());
        }
        if (((Round)round).environment().hasAstModule()) {
            this.invoke(new Generator_Asts().usingValues(values).generate());
        }
    }

    public Set<String> getSupportedAnnotationTypes() {
        return FluentIterable.from((Iterable)super.getSupportedAnnotationTypes()).append(CustomImmutableAnnotations.annotations()).toSet();
    }
}

