/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.immutables.value.processor.meta.BuilderMirrors;

public class FactoryMirror
implements BuilderMirrors.Factory {
    public static final String QUALIFIED_NAME = "org.immutables.builder.Builder.Factory";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.BuilderMirrors.Factory";
    private final AnnotationMirror annotationMirror;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Factory";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<FactoryMirror> find(Element element) {
        return FactoryMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<FactoryMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new FactoryMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<FactoryMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new FactoryMirror(annotationMirror));
        }
        return builder.build();
    }

    public static FactoryMirror from(TypeElement element) {
        return new FactoryMirror(element);
    }

    public static Optional<FactoryMirror> from(AnnotationMirror mirror) {
        return FactoryMirror.find(Collections.singleton(mirror));
    }

    private FactoryMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
    }

    private FactoryMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return BuilderMirrors.Factory.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        return h;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof FactoryMirror) {
            FactoryMirror otherMirror = (FactoryMirror)other;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return "FactoryMirror:" + this.annotationMirror;
    }
}

