/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.immutables.value.processor.meta.LongBits;
import org.immutables.value.processor.meta.ValueAttribute;

public final class FromSupertypesModel {
    public final ImmutableList<FromSupertype> supertypes;
    public final ImmutableList<String> repeating;
    public final LongBits.LongPositions positions;

    FromSupertypesModel(String abstractTypeName, Collection<ValueAttribute> attributes, ImmutableListMultimap<String, TypeElement> accessorMapping) {
        HashMultimap typesByAttribute = HashMultimap.create();
        for (ValueAttribute a : attributes) {
            String name = a.name();
            ImmutableList elements = accessorMapping.get((Object)a.names.get);
            for (TypeElement typeElement : elements) {
                String type = this.isEligibleFromType(typeElement) ? typeElement.getQualifiedName().toString() : abstractTypeName;
                typesByAttribute.put((Object)name, (Object)type);
            }
        }
        SetMultimap attributeByType = (SetMultimap)Multimaps.invertFrom((Multimap)typesByAttribute, (Multimap)HashMultimap.create());
        HashMap attributeMap = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (ValueAttribute a : attributes) {
            attributeMap.put(a.name(), a);
        }
        Function getAttribute = Functions.forMap((Map)attributeMap);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : attributeByType.asMap().entrySet()) {
            builder.add((Object)new FromSupertype((String)entry.getKey(), Iterables.transform((Iterable)((Iterable)entry.getValue()), (Function)getAttribute)));
        }
        if (!attributeByType.containsKey((Object)abstractTypeName)) {
            builder.add((Object)new FromSupertype(abstractTypeName, (Iterable<ValueAttribute>)ImmutableList.of()));
        }
        this.supertypes = builder.build();
        ImmutableList.Builder repeatingBuilder = ImmutableList.builder();
        for (Map.Entry e : typesByAttribute.asMap().entrySet()) {
            if (((Collection)e.getValue()).size() <= 1) continue;
            repeatingBuilder.add(e.getKey());
        }
        this.repeating = repeatingBuilder.build();
        this.positions = new LongBits().apply((Iterable<? extends Object>)this.repeating);
    }

    private boolean isEligibleFromType(TypeElement typeElement) {
        return typeElement.getTypeParameters().isEmpty();
    }

    public boolean hasManySupertypes() {
        return this.supertypes.size() > 1;
    }

    public static final class FromSupertype {
        public final String type;
        public final ImmutableList<ValueAttribute> attributes;

        FromSupertype(String type, Iterable<ValueAttribute> attribute) {
            this.type = type;
            this.attributes = ImmutableList.copyOf(attribute);
        }

        public String toString() {
            return this.type + " -> " + this.attributes;
        }
    }
}

