/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.immutables.generator.SourceExtraction;
import org.immutables.value.processor.meta.Constitution;
import org.immutables.value.processor.meta.IncludeMirror;
import org.immutables.value.processor.meta.OkTypeAdaptersMirror;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.RepositoryMirror;
import org.immutables.value.processor.meta.Round;
import org.immutables.value.processor.meta.StyleInfo;
import org.immutables.value.processor.meta.Styles;
import org.immutables.value.processor.meta.TransformMirror;
import org.immutables.value.processor.meta.TypeAdaptersMirror;
import org.immutables.value.processor.meta.ValueImmutableInfo;
import org.immutables.value.processor.meta.Visibility;

@ParametersAreNonnullByDefault
public final class ImmutableProto {
    private ImmutableProto() {
    }

    @Immutable
    public static final class DeclaringType
    extends Proto.DeclaringType {
        private final TypeElement element;
        private final String name;
        private final Proto.DeclaringPackage packageOf;
        private final boolean isTopLevel;
        private final Round.Interning interner;
        private final Proto.Environment environment;
        private final String simpleName;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long ENCLOSING_TOP_LEVEL_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private Optional<Proto.DeclaringType> enclosingTopLevel;
        private static final long REPOSITORY_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private Optional<RepositoryMirror> repository;
        private static final long ENCLOSING_OF_LAZY_INIT_BIT = 4L;
        @GuardedBy(value="this")
        private Optional<Proto.DeclaringType> enclosingOf;
        private static final long FEATURES_LAZY_INIT_BIT = 8L;
        @GuardedBy(value="this")
        private Optional<ValueImmutableInfo> features;
        private static final long USE_IMMUTABLE_DEFAULTS_LAZY_INIT_BIT = 16L;
        @GuardedBy(value="this")
        private boolean useImmutableDefaults;
        private static final long IS_ENCLOSING_LAZY_INIT_BIT = 32L;
        @GuardedBy(value="this")
        private boolean isEnclosing;
        private static final long IS_MODIFIABLE_LAZY_INIT_BIT = 64L;
        @GuardedBy(value="this")
        private boolean isModifiable;
        private static final long HEADER_COMMENTS_LAZY_INIT_BIT = 128L;
        @GuardedBy(value="this")
        private CharSequence headerComments;
        private static final long SOURCE_IMPORTS_LAZY_INIT_BIT = 256L;
        @GuardedBy(value="this")
        private SourceExtraction.Imports sourceImports;
        private static final long GET_TRANSFORM_LAZY_INIT_BIT = 512L;
        @GuardedBy(value="this")
        private Optional<TransformMirror> getTransform;
        private static final long IS_AST_LAZY_INIT_BIT = 1024L;
        @GuardedBy(value="this")
        private boolean isAst;
        private static final long INCLUDE_LAZY_INIT_BIT = 2048L;
        @GuardedBy(value="this")
        private Optional<IncludeMirror> include;
        private static final long TYPE_ADAPTERS_LAZY_INIT_BIT = 4096L;
        @GuardedBy(value="this")
        private Optional<TypeAdaptersMirror> typeAdapters;
        private static final long OK_TYPE_ADAPTERS_LAZY_INIT_BIT = 8192L;
        @GuardedBy(value="this")
        private Optional<OkTypeAdaptersMirror> okTypeAdapters;
        private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 16384L;
        @GuardedBy(value="this")
        private List<TypeElement> includedTypes;
        private static final long STYLE_LAZY_INIT_BIT = 32768L;
        @GuardedBy(value="this")
        private Optional<StyleInfo> style;
        private static final long SERIAL_VERSION_LAZY_INIT_BIT = 65536L;
        @GuardedBy(value="this")
        private Optional<Long> serialVersion;
        private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 131072L;
        @GuardedBy(value="this")
        private boolean isSerialStructural;
        private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 262144L;
        @GuardedBy(value="this")
        private boolean isJacksonSerialized;
        private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 524288L;
        @GuardedBy(value="this")
        private boolean isJacksonDeserialized;
        private static final long IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT = 0x100000L;
        @GuardedBy(value="this")
        private boolean isJacksonDeserializedAnnotated;
        private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 0x200000L;
        @GuardedBy(value="this")
        private boolean isJacksonJsonTypeInfo;

        private DeclaringType(Builder builder) {
            this.element = builder.element;
            this.interner = builder.interner;
            this.environment = builder.environment;
            this.name = (String)Preconditions.checkNotNull((Object)super.name());
            this.packageOf = (Proto.DeclaringPackage)Preconditions.checkNotNull((Object)super.packageOf());
            this.isTopLevel = super.isTopLevel();
            this.simpleName = (String)Preconditions.checkNotNull((Object)super.simpleName());
        }

        private DeclaringType(DeclaringType original, TypeElement element, String name, Proto.DeclaringPackage packageOf, boolean isTopLevel, Round.Interning interner, Proto.Environment environment, String simpleName) {
            this.element = element;
            this.name = name;
            this.packageOf = packageOf;
            this.isTopLevel = isTopLevel;
            this.interner = interner;
            this.environment = environment;
            this.simpleName = simpleName;
        }

        public final DeclaringType withElement(TypeElement value) {
            if (this.element == value) {
                return this;
            }
            TypeElement newValue = (TypeElement)Preconditions.checkNotNull((Object)value);
            return DeclaringType.checkPreconditions(new DeclaringType(this, newValue, this.name, this.packageOf, this.isTopLevel, this.interner, this.environment, this.simpleName));
        }

        public final DeclaringType withInterner(Round.Interning value) {
            if (this.interner == value) {
                return this;
            }
            Round.Interning newValue = (Round.Interning)Preconditions.checkNotNull((Object)value);
            return DeclaringType.checkPreconditions(new DeclaringType(this, this.element, this.name, this.packageOf, this.isTopLevel, newValue, this.environment, this.simpleName));
        }

        public final DeclaringType withEnvironment(Proto.Environment value) {
            if (this.environment == value) {
                return this;
            }
            Proto.Environment newValue = (Proto.Environment)Preconditions.checkNotNull((Object)value);
            return DeclaringType.checkPreconditions(new DeclaringType(this, this.element, this.name, this.packageOf, this.isTopLevel, this.interner, newValue, this.simpleName));
        }

        @Override
        public TypeElement element() {
            return this.element;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Proto.DeclaringPackage packageOf() {
            return this.packageOf;
        }

        @Override
        public boolean isTopLevel() {
            return this.isTopLevel;
        }

        @Override
        public Round.Interning interner() {
            return this.interner;
        }

        @Override
        public Proto.Environment environment() {
            return this.environment;
        }

        @Override
        public String simpleName() {
            return this.simpleName;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof DeclaringType && this.equalTo((DeclaringType)another);
        }

        private boolean equalTo(DeclaringType another) {
            return this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"DeclaringType").omitNullValues().add("name", (Object)this.name).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Proto.DeclaringType> enclosingTopLevel() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.enclosingTopLevel = (Optional)Preconditions.checkNotNull(super.enclosingTopLevel());
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.enclosingTopLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<RepositoryMirror> repository() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.repository = (Optional)Preconditions.checkNotNull(super.repository());
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Proto.DeclaringType> enclosingOf() {
            if ((this.lazyInitBitmap & 4L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 4L) == 0L) {
                        this.enclosingOf = (Optional)Preconditions.checkNotNull(super.enclosingOf());
                        this.lazyInitBitmap |= 4L;
                    }
                }
            }
            return this.enclosingOf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<ValueImmutableInfo> features() {
            if ((this.lazyInitBitmap & 8L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 8L) == 0L) {
                        this.features = (Optional)Preconditions.checkNotNull(super.features());
                        this.lazyInitBitmap |= 8L;
                    }
                }
            }
            return this.features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean useImmutableDefaults() {
            if ((this.lazyInitBitmap & 0x10L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x10L) == 0L) {
                        this.useImmutableDefaults = super.useImmutableDefaults();
                        this.lazyInitBitmap |= 0x10L;
                    }
                }
            }
            return this.useImmutableDefaults;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEnclosing() {
            if ((this.lazyInitBitmap & 0x20L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x20L) == 0L) {
                        this.isEnclosing = super.isEnclosing();
                        this.lazyInitBitmap |= 0x20L;
                    }
                }
            }
            return this.isEnclosing;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isModifiable() {
            if ((this.lazyInitBitmap & 0x40L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x40L) == 0L) {
                        this.isModifiable = super.isModifiable();
                        this.lazyInitBitmap |= 0x40L;
                    }
                }
            }
            return this.isModifiable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CharSequence headerComments() {
            if ((this.lazyInitBitmap & 0x80L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x80L) == 0L) {
                        this.headerComments = (CharSequence)Preconditions.checkNotNull((Object)super.headerComments());
                        this.lazyInitBitmap |= 0x80L;
                    }
                }
            }
            return this.headerComments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SourceExtraction.Imports sourceImports() {
            if ((this.lazyInitBitmap & 0x100L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x100L) == 0L) {
                        this.sourceImports = (SourceExtraction.Imports)Preconditions.checkNotNull((Object)super.sourceImports());
                        this.lazyInitBitmap |= 0x100L;
                    }
                }
            }
            return this.sourceImports;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<TransformMirror> getTransform() {
            if ((this.lazyInitBitmap & 0x200L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x200L) == 0L) {
                        this.getTransform = (Optional)Preconditions.checkNotNull(super.getTransform());
                        this.lazyInitBitmap |= 0x200L;
                    }
                }
            }
            return this.getTransform;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAst() {
            if ((this.lazyInitBitmap & 0x400L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x400L) == 0L) {
                        this.isAst = super.isAst();
                        this.lazyInitBitmap |= 0x400L;
                    }
                }
            }
            return this.isAst;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<IncludeMirror> include() {
            if ((this.lazyInitBitmap & 0x800L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x800L) == 0L) {
                        this.include = (Optional)Preconditions.checkNotNull(super.include());
                        this.lazyInitBitmap |= 0x800L;
                    }
                }
            }
            return this.include;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<TypeAdaptersMirror> typeAdapters() {
            if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                        this.typeAdapters = (Optional)Preconditions.checkNotNull(super.typeAdapters());
                        this.lazyInitBitmap |= 0x1000L;
                    }
                }
            }
            return this.typeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<OkTypeAdaptersMirror> okTypeAdapters() {
            if ((this.lazyInitBitmap & 0x2000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x2000L) == 0L) {
                        this.okTypeAdapters = (Optional)Preconditions.checkNotNull(super.okTypeAdapters());
                        this.lazyInitBitmap |= 0x2000L;
                    }
                }
            }
            return this.okTypeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TypeElement> includedTypes() {
            if ((this.lazyInitBitmap & 0x4000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x4000L) == 0L) {
                        this.includedTypes = (List)Preconditions.checkNotNull(super.includedTypes());
                        this.lazyInitBitmap |= 0x4000L;
                    }
                }
            }
            return this.includedTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<StyleInfo> style() {
            if ((this.lazyInitBitmap & 0x8000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x8000L) == 0L) {
                        this.style = (Optional)Preconditions.checkNotNull(super.style());
                        this.lazyInitBitmap |= 0x8000L;
                    }
                }
            }
            return this.style;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Long> serialVersion() {
            if ((this.lazyInitBitmap & 0x10000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x10000L) == 0L) {
                        this.serialVersion = (Optional)Preconditions.checkNotNull(super.serialVersion());
                        this.lazyInitBitmap |= 0x10000L;
                    }
                }
            }
            return this.serialVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSerialStructural() {
            if ((this.lazyInitBitmap & 0x20000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x20000L) == 0L) {
                        this.isSerialStructural = super.isSerialStructural();
                        this.lazyInitBitmap |= 0x20000L;
                    }
                }
            }
            return this.isSerialStructural;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonSerialized() {
            if ((this.lazyInitBitmap & 0x40000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x40000L) == 0L) {
                        this.isJacksonSerialized = super.isJacksonSerialized();
                        this.lazyInitBitmap |= 0x40000L;
                    }
                }
            }
            return this.isJacksonSerialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonDeserialized() {
            if ((this.lazyInitBitmap & 0x80000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x80000L) == 0L) {
                        this.isJacksonDeserialized = super.isJacksonDeserialized();
                        this.lazyInitBitmap |= 0x80000L;
                    }
                }
            }
            return this.isJacksonDeserialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonDeserializedAnnotated() {
            if ((this.lazyInitBitmap & 0x100000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x100000L) == 0L) {
                        this.isJacksonDeserializedAnnotated = super.isJacksonDeserializedAnnotated();
                        this.lazyInitBitmap |= 0x100000L;
                    }
                }
            }
            return this.isJacksonDeserializedAnnotated;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonJsonTypeInfo() {
            if ((this.lazyInitBitmap & 0x200000L) == 0L) {
                DeclaringType declaringType = this;
                synchronized (declaringType) {
                    if ((this.lazyInitBitmap & 0x200000L) == 0L) {
                        this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
                        this.lazyInitBitmap |= 0x200000L;
                    }
                }
            }
            return this.isJacksonJsonTypeInfo;
        }

        private static DeclaringType checkPreconditions(DeclaringType instance) {
            instance.validate();
            return instance;
        }

        public static DeclaringType copyOf(Proto.DeclaringType instance) {
            if (instance instanceof DeclaringType) {
                return (DeclaringType)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return DeclaringType.builder().element(instance.element()).interner(instance.interner()).environment(instance.environment()).build();
        }

        @Deprecated
        public static DeclaringType copyOf(DeclaringType instance) {
            return (DeclaringType)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 7L;
            private static final long INITIALIZED_BIT_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_INTERNER = 2L;
            private static final long INITIALIZED_BIT_ENVIRONMENT = 4L;
            private long initializedBitset;
            @Nullable
            private TypeElement element;
            @Nullable
            private Round.Interning interner;
            @Nullable
            private Proto.Environment environment;

            private Builder() {
            }

            public final Builder element(TypeElement element) {
                this.element = (TypeElement)Preconditions.checkNotNull((Object)element);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder interner(Round.Interning interner) {
                this.interner = (Round.Interning)Preconditions.checkNotNull((Object)interner);
                this.initializedBitset |= 2L;
                return this;
            }

            public final Builder environment(Proto.Environment environment) {
                this.environment = (Proto.Environment)Preconditions.checkNotNull((Object)environment);
                this.initializedBitset |= 4L;
                return this;
            }

            public DeclaringType build() {
                this.checkRequiredAttributes();
                return DeclaringType.checkPreconditions(new DeclaringType(this));
            }

            private boolean elementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean internerIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private boolean environmentIsSet() {
                return (this.initializedBitset & 4L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 7L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build DeclaringType, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.elementIsSet() ? "element" : null)).addValue((Object)(!this.internerIsSet() ? "interner" : null)).addValue((Object)(!this.environmentIsSet() ? "environment" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableProto.DeclaringType.Builder").omitNullValues().add("element", (Object)this.element).add("interner", (Object)this.interner).add("environment", (Object)this.environment).toString();
            }
        }
    }

    @Immutable
    public static final class Protoclass
    extends Proto.Protoclass {
        private final String name;
        private final Element sourceElement;
        private final Proto.DeclaringPackage packageOf;
        private final Optional<Proto.DeclaringType> declaringType;
        private final Proto.Protoclass.Kind kind;
        private final Visibility visibility;
        private final Element element;
        private final Optional<Proto.DeclaringType> enclosingOf;
        private final Proto.Environment environment;
        private final String simpleName;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long REPOSITORY_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private Optional<RepositoryMirror> repository;
        private static final long GSON_TYPE_ADAPTERS_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private Optional<TypeAdaptersMirror> gsonTypeAdapters;
        private static final long TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT = 4L;
        @GuardedBy(value="this")
        private Optional<Proto.AbstractDeclaring> typeAdaptersProvider;
        private static final long OK_JSON_TYPE_ADAPTERS_LAZY_INIT_BIT = 8L;
        @GuardedBy(value="this")
        private Optional<OkTypeAdaptersMirror> okJsonTypeAdapters;
        private static final long OK_TYPE_ADAPTERS_PROVIDER_LAZY_INIT_BIT = 16L;
        @GuardedBy(value="this")
        private Optional<Proto.AbstractDeclaring> okTypeAdaptersProvider;
        private static final long SERIAL_VERSION_LAZY_INIT_BIT = 32L;
        @GuardedBy(value="this")
        private Optional<Long> serialVersion;
        private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 64L;
        @GuardedBy(value="this")
        private boolean isSerialStructural;
        private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 128L;
        @GuardedBy(value="this")
        private boolean isJacksonSerialized;
        private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 256L;
        @GuardedBy(value="this")
        private boolean isJacksonDeserialized;
        private static final long FEATURES_LAZY_INIT_BIT = 512L;
        @GuardedBy(value="this")
        private ValueImmutableInfo features;
        private static final long STYLES_LAZY_INIT_BIT = 1024L;
        @GuardedBy(value="this")
        private Styles styles;
        private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 2048L;
        @GuardedBy(value="this")
        private boolean isJacksonJsonTypeInfo;
        private static final long CONSTITUTION_LAZY_INIT_BIT = 4096L;
        @GuardedBy(value="this")
        private Constitution constitution;

        private Protoclass(Builder builder) {
            this.sourceElement = builder.sourceElement;
            this.packageOf = builder.packageOf;
            this.declaringType = builder.declaringType;
            this.kind = builder.kind;
            this.environment = builder.environment;
            this.name = (String)Preconditions.checkNotNull((Object)super.name());
            this.visibility = (Visibility)((Object)Preconditions.checkNotNull((Object)((Object)super.visibility())));
            this.element = (Element)Preconditions.checkNotNull((Object)super.element());
            this.enclosingOf = (Optional)Preconditions.checkNotNull(super.enclosingOf());
            this.simpleName = (String)Preconditions.checkNotNull((Object)super.simpleName());
        }

        private Protoclass(Protoclass original, String name, Element sourceElement, Proto.DeclaringPackage packageOf, Optional<Proto.DeclaringType> declaringType, Proto.Protoclass.Kind kind, Visibility visibility, Element element, Optional<Proto.DeclaringType> enclosingOf, Proto.Environment environment, String simpleName) {
            this.name = name;
            this.sourceElement = sourceElement;
            this.packageOf = packageOf;
            this.declaringType = declaringType;
            this.kind = kind;
            this.visibility = visibility;
            this.element = element;
            this.enclosingOf = enclosingOf;
            this.environment = environment;
            this.simpleName = simpleName;
        }

        public final Protoclass withSourceElement(Element value) {
            if (this.sourceElement == value) {
                return this;
            }
            Element newValue = (Element)Preconditions.checkNotNull((Object)value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, newValue, this.packageOf, this.declaringType, this.kind, this.visibility, this.element, this.enclosingOf, this.environment, this.simpleName));
        }

        public final Protoclass withPackageOf(Proto.DeclaringPackage value) {
            if (this.packageOf == value) {
                return this;
            }
            Proto.DeclaringPackage newValue = (Proto.DeclaringPackage)Preconditions.checkNotNull((Object)value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, this.sourceElement, newValue, this.declaringType, this.kind, this.visibility, this.element, this.enclosingOf, this.environment, this.simpleName));
        }

        public final Protoclass withDeclaringType(Proto.DeclaringType value) {
            Optional newValue = Optional.of((Object)value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, this.sourceElement, this.packageOf, (Optional<Proto.DeclaringType>)newValue, this.kind, this.visibility, this.element, this.enclosingOf, this.environment, this.simpleName));
        }

        public final Protoclass withDeclaringType(Optional<Proto.DeclaringType> optional) {
            if (this.declaringType == optional) {
                return this;
            }
            Optional newValue = (Optional)Preconditions.checkNotNull(optional);
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, this.sourceElement, this.packageOf, (Optional<Proto.DeclaringType>)newValue, this.kind, this.visibility, this.element, this.enclosingOf, this.environment, this.simpleName));
        }

        public final Protoclass withKind(Proto.Protoclass.Kind value) {
            if (this.kind == value) {
                return this;
            }
            Proto.Protoclass.Kind newValue = (Proto.Protoclass.Kind)((Object)Preconditions.checkNotNull((Object)((Object)value)));
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, this.sourceElement, this.packageOf, this.declaringType, newValue, this.visibility, this.element, this.enclosingOf, this.environment, this.simpleName));
        }

        public final Protoclass withEnvironment(Proto.Environment value) {
            if (this.environment == value) {
                return this;
            }
            Proto.Environment newValue = (Proto.Environment)Preconditions.checkNotNull((Object)value);
            return Protoclass.checkPreconditions(new Protoclass(this, this.name, this.sourceElement, this.packageOf, this.declaringType, this.kind, this.visibility, this.element, this.enclosingOf, newValue, this.simpleName));
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Element sourceElement() {
            return this.sourceElement;
        }

        @Override
        public Proto.DeclaringPackage packageOf() {
            return this.packageOf;
        }

        @Override
        public Optional<Proto.DeclaringType> declaringType() {
            return this.declaringType;
        }

        @Override
        public Proto.Protoclass.Kind kind() {
            return this.kind;
        }

        @Override
        public Visibility visibility() {
            return this.visibility;
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public Optional<Proto.DeclaringType> enclosingOf() {
            return this.enclosingOf;
        }

        @Override
        public Proto.Environment environment() {
            return this.environment;
        }

        @Override
        public String simpleName() {
            return this.simpleName;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof Protoclass && this.equalTo((Protoclass)another);
        }

        private boolean equalTo(Protoclass another) {
            return this.name.equals(another.name) && this.packageOf.equals(another.packageOf) && this.declaringType.equals(another.declaringType) && this.kind.equals((Object)another.kind) && this.visibility.equals((Object)another.visibility);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            h = h * 17 + this.packageOf.hashCode();
            h = h * 17 + this.declaringType.hashCode();
            h = h * 17 + this.kind.hashCode();
            h = h * 17 + this.visibility.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Protoclass").omitNullValues().add("name", (Object)this.name).add("packageOf", (Object)this.packageOf).add("declaringType", this.declaringType.orNull()).add("kind", (Object)this.kind).add("visibility", (Object)this.visibility).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<RepositoryMirror> repository() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.repository = (Optional)Preconditions.checkNotNull(super.repository());
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<TypeAdaptersMirror> gsonTypeAdapters() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.gsonTypeAdapters = (Optional)Preconditions.checkNotNull(super.gsonTypeAdapters());
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.gsonTypeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Proto.AbstractDeclaring> typeAdaptersProvider() {
            if ((this.lazyInitBitmap & 4L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 4L) == 0L) {
                        this.typeAdaptersProvider = (Optional)Preconditions.checkNotNull(super.typeAdaptersProvider());
                        this.lazyInitBitmap |= 4L;
                    }
                }
            }
            return this.typeAdaptersProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<OkTypeAdaptersMirror> okJsonTypeAdapters() {
            if ((this.lazyInitBitmap & 8L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 8L) == 0L) {
                        this.okJsonTypeAdapters = (Optional)Preconditions.checkNotNull(super.okJsonTypeAdapters());
                        this.lazyInitBitmap |= 8L;
                    }
                }
            }
            return this.okJsonTypeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Proto.AbstractDeclaring> okTypeAdaptersProvider() {
            if ((this.lazyInitBitmap & 0x10L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x10L) == 0L) {
                        this.okTypeAdaptersProvider = (Optional)Preconditions.checkNotNull(super.okTypeAdaptersProvider());
                        this.lazyInitBitmap |= 0x10L;
                    }
                }
            }
            return this.okTypeAdaptersProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Long> serialVersion() {
            if ((this.lazyInitBitmap & 0x20L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x20L) == 0L) {
                        this.serialVersion = (Optional)Preconditions.checkNotNull(super.serialVersion());
                        this.lazyInitBitmap |= 0x20L;
                    }
                }
            }
            return this.serialVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSerialStructural() {
            if ((this.lazyInitBitmap & 0x40L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x40L) == 0L) {
                        this.isSerialStructural = super.isSerialStructural();
                        this.lazyInitBitmap |= 0x40L;
                    }
                }
            }
            return this.isSerialStructural;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonSerialized() {
            if ((this.lazyInitBitmap & 0x80L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x80L) == 0L) {
                        this.isJacksonSerialized = super.isJacksonSerialized();
                        this.lazyInitBitmap |= 0x80L;
                    }
                }
            }
            return this.isJacksonSerialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonDeserialized() {
            if ((this.lazyInitBitmap & 0x100L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x100L) == 0L) {
                        this.isJacksonDeserialized = super.isJacksonDeserialized();
                        this.lazyInitBitmap |= 0x100L;
                    }
                }
            }
            return this.isJacksonDeserialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ValueImmutableInfo features() {
            if ((this.lazyInitBitmap & 0x200L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x200L) == 0L) {
                        this.features = (ValueImmutableInfo)Preconditions.checkNotNull((Object)super.features());
                        this.lazyInitBitmap |= 0x200L;
                    }
                }
            }
            return this.features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Styles styles() {
            if ((this.lazyInitBitmap & 0x400L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x400L) == 0L) {
                        this.styles = (Styles)Preconditions.checkNotNull((Object)super.styles());
                        this.lazyInitBitmap |= 0x400L;
                    }
                }
            }
            return this.styles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonJsonTypeInfo() {
            if ((this.lazyInitBitmap & 0x800L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x800L) == 0L) {
                        this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
                        this.lazyInitBitmap |= 0x800L;
                    }
                }
            }
            return this.isJacksonJsonTypeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Constitution constitution() {
            if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                Protoclass protoclass = this;
                synchronized (protoclass) {
                    if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                        this.constitution = (Constitution)Preconditions.checkNotNull((Object)super.constitution());
                        this.lazyInitBitmap |= 0x1000L;
                    }
                }
            }
            return this.constitution;
        }

        private static Protoclass checkPreconditions(Protoclass instance) {
            return instance;
        }

        public static Protoclass copyOf(Proto.Protoclass instance) {
            if (instance instanceof Protoclass) {
                return (Protoclass)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Protoclass.builder().sourceElement(instance.sourceElement()).packageOf(instance.packageOf()).declaringType(instance.declaringType()).kind(instance.kind()).environment(instance.environment()).build();
        }

        @Deprecated
        public static Protoclass copyOf(Protoclass instance) {
            return (Protoclass)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 15L;
            private static final long INITIALIZED_BIT_SOURCE_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_PACKAGE_OF = 2L;
            private static final long INITIALIZED_BIT_KIND = 4L;
            private static final long INITIALIZED_BIT_ENVIRONMENT = 8L;
            private long initializedBitset;
            @Nullable
            private Element sourceElement;
            @Nullable
            private Proto.DeclaringPackage packageOf;
            private Optional<Proto.DeclaringType> declaringType = Optional.absent();
            @Nullable
            private Proto.Protoclass.Kind kind;
            @Nullable
            private Proto.Environment environment;

            private Builder() {
            }

            public final Builder sourceElement(Element sourceElement) {
                this.sourceElement = (Element)Preconditions.checkNotNull((Object)sourceElement);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder packageOf(Proto.DeclaringPackage packageOf) {
                this.packageOf = (Proto.DeclaringPackage)Preconditions.checkNotNull((Object)packageOf);
                this.initializedBitset |= 2L;
                return this;
            }

            public final Builder declaringType(Proto.DeclaringType declaringType) {
                this.declaringType = Optional.of((Object)declaringType);
                return this;
            }

            public final Builder declaringType(Optional<Proto.DeclaringType> declaringType) {
                this.declaringType = (Optional)Preconditions.checkNotNull(declaringType);
                return this;
            }

            public final Builder kind(Proto.Protoclass.Kind kind) {
                this.kind = (Proto.Protoclass.Kind)((Object)Preconditions.checkNotNull((Object)((Object)kind)));
                this.initializedBitset |= 4L;
                return this;
            }

            public final Builder environment(Proto.Environment environment) {
                this.environment = (Proto.Environment)Preconditions.checkNotNull((Object)environment);
                this.initializedBitset |= 8L;
                return this;
            }

            public Protoclass build() {
                this.checkRequiredAttributes();
                return Protoclass.checkPreconditions(new Protoclass(this));
            }

            private boolean sourceElementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean packageOfIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private boolean kindIsSet() {
                return (this.initializedBitset & 4L) != 0L;
            }

            private boolean environmentIsSet() {
                return (this.initializedBitset & 8L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 15L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build Protoclass, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.sourceElementIsSet() ? "sourceElement" : null)).addValue((Object)(!this.packageOfIsSet() ? "packageOf" : null)).addValue((Object)(!this.kindIsSet() ? "kind" : null)).addValue((Object)(!this.environmentIsSet() ? "environment" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableProto.Protoclass.Builder").omitNullValues().add("sourceElement", (Object)this.sourceElement).add("packageOf", (Object)this.packageOf).add("declaringType", this.declaringType.orNull()).add("kind", (Object)this.kind).add("environment", (Object)this.environment).toString();
            }
        }
    }

    @Immutable
    public static final class MetaAnnotated
    extends Proto.MetaAnnotated {
        private final Element element;
        private final Proto.Environment environment;
        private final Optional<StyleInfo> style;
        private final Optional<Long> serialVersion;
        private final boolean isSerialStructural;
        private final boolean isJacksonSerialized;
        private final boolean isJacksonDeserialized;
        private final boolean isJacksonJsonTypeInfo;
        private final boolean isJsonQualifier;

        private MetaAnnotated(Element element, Proto.Environment environment) {
            this.element = (Element)Preconditions.checkNotNull((Object)element);
            this.environment = (Proto.Environment)Preconditions.checkNotNull((Object)environment);
            this.style = (Optional)Preconditions.checkNotNull(super.style());
            this.serialVersion = (Optional)Preconditions.checkNotNull(super.serialVersion());
            this.isSerialStructural = super.isSerialStructural();
            this.isJacksonSerialized = super.isJacksonSerialized();
            this.isJacksonDeserialized = super.isJacksonDeserialized();
            this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
            this.isJsonQualifier = super.isJsonQualifier();
        }

        private MetaAnnotated(MetaAnnotated original, Element element, Proto.Environment environment, Optional<StyleInfo> style, Optional<Long> serialVersion, boolean isSerialStructural, boolean isJacksonSerialized, boolean isJacksonDeserialized, boolean isJacksonJsonTypeInfo, boolean isJsonQualifier) {
            this.element = element;
            this.environment = environment;
            this.style = style;
            this.serialVersion = serialVersion;
            this.isSerialStructural = isSerialStructural;
            this.isJacksonSerialized = isJacksonSerialized;
            this.isJacksonDeserialized = isJacksonDeserialized;
            this.isJacksonJsonTypeInfo = isJacksonJsonTypeInfo;
            this.isJsonQualifier = isJsonQualifier;
        }

        public final MetaAnnotated withElement(Element value) {
            if (this.element == value) {
                return this;
            }
            Element newValue = (Element)Preconditions.checkNotNull((Object)value);
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(this, newValue, this.environment, this.style, this.serialVersion, this.isSerialStructural, this.isJacksonSerialized, this.isJacksonDeserialized, this.isJacksonJsonTypeInfo, this.isJsonQualifier));
        }

        public final MetaAnnotated withEnvironment(Proto.Environment value) {
            if (this.environment == value) {
                return this;
            }
            Proto.Environment newValue = (Proto.Environment)Preconditions.checkNotNull((Object)value);
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(this, this.element, newValue, this.style, this.serialVersion, this.isSerialStructural, this.isJacksonSerialized, this.isJacksonDeserialized, this.isJacksonJsonTypeInfo, this.isJsonQualifier));
        }

        public final MetaAnnotated withIsJsonQualifier(boolean value) {
            if (this.isJsonQualifier == value) {
                return this;
            }
            boolean newValue = value;
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(this, this.element, this.environment, this.style, this.serialVersion, this.isSerialStructural, this.isJacksonSerialized, this.isJacksonDeserialized, this.isJacksonJsonTypeInfo, newValue));
        }

        @Override
        public Element element() {
            return this.element;
        }

        @Override
        public Proto.Environment environment() {
            return this.environment;
        }

        @Override
        public Optional<StyleInfo> style() {
            return this.style;
        }

        @Override
        public Optional<Long> serialVersion() {
            return this.serialVersion;
        }

        @Override
        public boolean isSerialStructural() {
            return this.isSerialStructural;
        }

        @Override
        public boolean isJacksonSerialized() {
            return this.isJacksonSerialized;
        }

        @Override
        public boolean isJacksonDeserialized() {
            return this.isJacksonDeserialized;
        }

        @Override
        public boolean isJacksonJsonTypeInfo() {
            return this.isJacksonJsonTypeInfo;
        }

        @Override
        public boolean isJsonQualifier() {
            return this.isJsonQualifier;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof MetaAnnotated && this.equalTo((MetaAnnotated)another);
        }

        private boolean equalTo(MetaAnnotated another) {
            return this.isJsonQualifier == another.isJsonQualifier;
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + Booleans.hashCode((boolean)this.isJsonQualifier);
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"MetaAnnotated").omitNullValues().add("isJsonQualifier", this.isJsonQualifier).toString();
        }

        public static MetaAnnotated of(Element element, Proto.Environment environment) {
            return MetaAnnotated.checkPreconditions(new MetaAnnotated(element, environment));
        }

        private static MetaAnnotated checkPreconditions(MetaAnnotated instance) {
            return instance;
        }

        public static MetaAnnotated copyOf(Proto.MetaAnnotated instance) {
            if (instance instanceof MetaAnnotated) {
                return (MetaAnnotated)instance;
            }
            return MetaAnnotated.of(instance.element(), instance.environment()).withIsJsonQualifier(instance.isJsonQualifier());
        }

        @Deprecated
        public static MetaAnnotated copyOf(MetaAnnotated instance) {
            return (MetaAnnotated)Preconditions.checkNotNull((Object)instance);
        }
    }

    @Immutable
    public static final class Environment
    extends Proto.Environment {
        private final ProcessingEnvironment processing;
        private final Round round;
        private final StyleInfo defaultStyles;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long TYPE_MORE_OBJECTS_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private String typeMoreObjects;
        private static final long HAS_OK_JSON_LIB_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private boolean hasOkJsonLib;
        private static final long HAS_GSON_LIB_LAZY_INIT_BIT = 4L;
        @GuardedBy(value="this")
        private boolean hasGsonLib;
        private static final long HAS_JACKSON_LIB_LAZY_INIT_BIT = 8L;
        @GuardedBy(value="this")
        private boolean hasJacksonLib;
        private static final long HAS_MONGO_MODULE_LAZY_INIT_BIT = 16L;
        @GuardedBy(value="this")
        private boolean hasMongoModule;
        private static final long HAS_SERIAL_MODULE_LAZY_INIT_BIT = 32L;
        @GuardedBy(value="this")
        private boolean hasSerialModule;
        private static final long HAS_TRANSFORM_MODULE_LAZY_INIT_BIT = 64L;
        @GuardedBy(value="this")
        private boolean hasTransformModule;
        private static final long HAS_AST_MODULE_LAZY_INIT_BIT = 128L;
        @GuardedBy(value="this")
        private boolean hasAstModule;
        private static final long HAS_ORDINAL_MODULE_LAZY_INIT_BIT = 256L;
        @GuardedBy(value="this")
        private boolean hasOrdinalModule;
        private static final long HAS_FUNCTIONAL_MODULE_LAZY_INIT_BIT = 512L;
        @GuardedBy(value="this")
        private boolean hasFunctionalModule;
        private static final long HAS_BUILDER_MODULE_LAZY_INIT_BIT = 1024L;
        @GuardedBy(value="this")
        private boolean hasBuilderModule;
        private static final long HAS_FUNC_MODULE_LAZY_INIT_BIT = 2048L;
        @GuardedBy(value="this")
        private boolean hasFuncModule;
        private static final long DEFAULT_TYPE_ADAPTERS_LAZY_INIT_BIT = 4096L;
        @GuardedBy(value="this")
        private TypeAdaptersMirror defaultTypeAdapters;

        private Environment(ProcessingEnvironment processing, Round round) {
            this.processing = (ProcessingEnvironment)Preconditions.checkNotNull((Object)processing);
            this.round = (Round)Preconditions.checkNotNull((Object)round);
            this.defaultStyles = (StyleInfo)Preconditions.checkNotNull((Object)super.defaultStyles());
        }

        private Environment(Builder builder) {
            this.processing = builder.processing;
            this.round = builder.round;
            this.defaultStyles = (StyleInfo)Preconditions.checkNotNull((Object)super.defaultStyles());
        }

        private Environment(Environment original, ProcessingEnvironment processing, Round round, StyleInfo defaultStyles) {
            this.processing = processing;
            this.round = round;
            this.defaultStyles = defaultStyles;
        }

        public final Environment withProcessing(ProcessingEnvironment value) {
            if (this.processing == value) {
                return this;
            }
            ProcessingEnvironment newValue = (ProcessingEnvironment)Preconditions.checkNotNull((Object)value);
            return Environment.checkPreconditions(new Environment(this, newValue, this.round, this.defaultStyles));
        }

        public final Environment withRound(Round value) {
            if (this.round == value) {
                return this;
            }
            Round newValue = (Round)Preconditions.checkNotNull((Object)value);
            return Environment.checkPreconditions(new Environment(this, this.processing, newValue, this.defaultStyles));
        }

        @Override
        public ProcessingEnvironment processing() {
            return this.processing;
        }

        @Override
        public Round round() {
            return this.round;
        }

        @Override
        public StyleInfo defaultStyles() {
            return this.defaultStyles;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof Environment && this.equalTo((Environment)another);
        }

        private boolean equalTo(Environment another) {
            return this.processing.equals(another.processing) && this.round.equals(another.round) && this.defaultStyles.equals(another.defaultStyles);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.processing.hashCode();
            h = h * 17 + this.round.hashCode();
            h = h * 17 + this.defaultStyles.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Environment").omitNullValues().add("processing", (Object)this.processing).add("round", (Object)this.round).add("defaultStyles", (Object)this.defaultStyles).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String typeMoreObjects() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.typeMoreObjects = super.typeMoreObjects();
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.typeMoreObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasOkJsonLib() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.hasOkJsonLib = super.hasOkJsonLib();
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.hasOkJsonLib;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasGsonLib() {
            if ((this.lazyInitBitmap & 4L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 4L) == 0L) {
                        this.hasGsonLib = super.hasGsonLib();
                        this.lazyInitBitmap |= 4L;
                    }
                }
            }
            return this.hasGsonLib;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasJacksonLib() {
            if ((this.lazyInitBitmap & 8L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 8L) == 0L) {
                        this.hasJacksonLib = super.hasJacksonLib();
                        this.lazyInitBitmap |= 8L;
                    }
                }
            }
            return this.hasJacksonLib;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasMongoModule() {
            if ((this.lazyInitBitmap & 0x10L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x10L) == 0L) {
                        this.hasMongoModule = super.hasMongoModule();
                        this.lazyInitBitmap |= 0x10L;
                    }
                }
            }
            return this.hasMongoModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasSerialModule() {
            if ((this.lazyInitBitmap & 0x20L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x20L) == 0L) {
                        this.hasSerialModule = super.hasSerialModule();
                        this.lazyInitBitmap |= 0x20L;
                    }
                }
            }
            return this.hasSerialModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasTransformModule() {
            if ((this.lazyInitBitmap & 0x40L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x40L) == 0L) {
                        this.hasTransformModule = super.hasTransformModule();
                        this.lazyInitBitmap |= 0x40L;
                    }
                }
            }
            return this.hasTransformModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasAstModule() {
            if ((this.lazyInitBitmap & 0x80L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x80L) == 0L) {
                        this.hasAstModule = super.hasAstModule();
                        this.lazyInitBitmap |= 0x80L;
                    }
                }
            }
            return this.hasAstModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasOrdinalModule() {
            if ((this.lazyInitBitmap & 0x100L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x100L) == 0L) {
                        this.hasOrdinalModule = super.hasOrdinalModule();
                        this.lazyInitBitmap |= 0x100L;
                    }
                }
            }
            return this.hasOrdinalModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasFunctionalModule() {
            if ((this.lazyInitBitmap & 0x200L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x200L) == 0L) {
                        this.hasFunctionalModule = super.hasFunctionalModule();
                        this.lazyInitBitmap |= 0x200L;
                    }
                }
            }
            return this.hasFunctionalModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasBuilderModule() {
            if ((this.lazyInitBitmap & 0x400L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x400L) == 0L) {
                        this.hasBuilderModule = super.hasBuilderModule();
                        this.lazyInitBitmap |= 0x400L;
                    }
                }
            }
            return this.hasBuilderModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasFuncModule() {
            if ((this.lazyInitBitmap & 0x800L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x800L) == 0L) {
                        this.hasFuncModule = super.hasFuncModule();
                        this.lazyInitBitmap |= 0x800L;
                    }
                }
            }
            return this.hasFuncModule;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TypeAdaptersMirror defaultTypeAdapters() {
            if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                Environment environment = this;
                synchronized (environment) {
                    if ((this.lazyInitBitmap & 0x1000L) == 0L) {
                        this.defaultTypeAdapters = (TypeAdaptersMirror)Preconditions.checkNotNull((Object)super.defaultTypeAdapters());
                        this.lazyInitBitmap |= 0x1000L;
                    }
                }
            }
            return this.defaultTypeAdapters;
        }

        public static Environment of(ProcessingEnvironment processing, Round round) {
            return Environment.checkPreconditions(new Environment(processing, round));
        }

        private static Environment checkPreconditions(Environment instance) {
            return instance;
        }

        public static Environment copyOf(Proto.Environment instance) {
            if (instance instanceof Environment) {
                return (Environment)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return Environment.builder().processing(instance.processing()).round(instance.round()).build();
        }

        @Deprecated
        public static Environment copyOf(Environment instance) {
            return (Environment)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 3L;
            private static final long INITIALIZED_BIT_PROCESSING = 1L;
            private static final long INITIALIZED_BIT_ROUND = 2L;
            private long initializedBitset;
            @Nullable
            private ProcessingEnvironment processing;
            @Nullable
            private Round round;

            private Builder() {
            }

            public final Builder processing(ProcessingEnvironment processing) {
                this.processing = (ProcessingEnvironment)Preconditions.checkNotNull((Object)processing);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder round(Round round) {
                this.round = (Round)Preconditions.checkNotNull((Object)round);
                this.initializedBitset |= 2L;
                return this;
            }

            public Environment build() {
                this.checkRequiredAttributes();
                return Environment.checkPreconditions(new Environment(this));
            }

            private boolean processingIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean roundIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 3L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build Environment, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.processingIsSet() ? "processing" : null)).addValue((Object)(!this.roundIsSet() ? "round" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableProto.Environment.Builder").omitNullValues().add("processing", (Object)this.processing).add("round", (Object)this.round).toString();
            }
        }
    }

    @Immutable
    public static final class DeclaringPackage
    extends Proto.DeclaringPackage {
        private final PackageElement element;
        private final String simpleName;
        private final String name;
        private final Round.Interning interner;
        private final Proto.Environment environment;
        @GuardedBy(value="this")
        private volatile long lazyInitBitmap;
        private static final long NAMED_PARENT_PACKAGE_LAZY_INIT_BIT = 1L;
        @GuardedBy(value="this")
        private Optional<Proto.DeclaringPackage> namedParentPackage;
        private static final long IS_JACKSON_SERIALIZED_LAZY_INIT_BIT = 2L;
        @GuardedBy(value="this")
        private boolean isJacksonSerialized;
        private static final long IS_JACKSON_DESERIALIZED_LAZY_INIT_BIT = 4L;
        @GuardedBy(value="this")
        private boolean isJacksonDeserialized;
        private static final long IS_JACKSON_JSON_TYPE_INFO_LAZY_INIT_BIT = 8L;
        @GuardedBy(value="this")
        private boolean isJacksonJsonTypeInfo;
        private static final long IS_SERIAL_STRUCTURAL_LAZY_INIT_BIT = 16L;
        @GuardedBy(value="this")
        private boolean isSerialStructural;
        private static final long SERIAL_VERSION_LAZY_INIT_BIT = 32L;
        @GuardedBy(value="this")
        private Optional<Long> serialVersion;
        private static final long STYLE_LAZY_INIT_BIT = 64L;
        @GuardedBy(value="this")
        private Optional<StyleInfo> style;
        private static final long INCLUDE_LAZY_INIT_BIT = 128L;
        @GuardedBy(value="this")
        private Optional<IncludeMirror> include;
        private static final long TYPE_ADAPTERS_LAZY_INIT_BIT = 256L;
        @GuardedBy(value="this")
        private Optional<TypeAdaptersMirror> typeAdapters;
        private static final long OK_TYPE_ADAPTERS_LAZY_INIT_BIT = 512L;
        @GuardedBy(value="this")
        private Optional<OkTypeAdaptersMirror> okTypeAdapters;
        private static final long INCLUDED_TYPES_LAZY_INIT_BIT = 1024L;
        @GuardedBy(value="this")
        private List<TypeElement> includedTypes;
        private static final long IS_JACKSON_DESERIALIZED_ANNOTATED_LAZY_INIT_BIT = 2048L;
        @GuardedBy(value="this")
        private boolean isJacksonDeserializedAnnotated;

        private DeclaringPackage(Builder builder) {
            this.element = builder.element;
            this.interner = builder.interner;
            this.environment = builder.environment;
            this.simpleName = (String)Preconditions.checkNotNull((Object)super.simpleName());
            this.name = (String)Preconditions.checkNotNull((Object)super.name());
        }

        private DeclaringPackage(DeclaringPackage original, PackageElement element, String simpleName, String name, Round.Interning interner, Proto.Environment environment) {
            this.element = element;
            this.simpleName = simpleName;
            this.name = name;
            this.interner = interner;
            this.environment = environment;
        }

        public final DeclaringPackage withElement(PackageElement value) {
            if (this.element == value) {
                return this;
            }
            PackageElement newValue = (PackageElement)Preconditions.checkNotNull((Object)value);
            return DeclaringPackage.checkPreconditions(new DeclaringPackage(this, newValue, this.simpleName, this.name, this.interner, this.environment));
        }

        public final DeclaringPackage withInterner(Round.Interning value) {
            if (this.interner == value) {
                return this;
            }
            Round.Interning newValue = (Round.Interning)Preconditions.checkNotNull((Object)value);
            return DeclaringPackage.checkPreconditions(new DeclaringPackage(this, this.element, this.simpleName, this.name, newValue, this.environment));
        }

        public final DeclaringPackage withEnvironment(Proto.Environment value) {
            if (this.environment == value) {
                return this;
            }
            Proto.Environment newValue = (Proto.Environment)Preconditions.checkNotNull((Object)value);
            return DeclaringPackage.checkPreconditions(new DeclaringPackage(this, this.element, this.simpleName, this.name, this.interner, newValue));
        }

        @Override
        public PackageElement element() {
            return this.element;
        }

        @Override
        public String simpleName() {
            return this.simpleName;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Round.Interning interner() {
            return this.interner;
        }

        @Override
        public Proto.Environment environment() {
            return this.environment;
        }

        public boolean equals(@Nullable Object another) {
            return this == another || another instanceof DeclaringPackage && this.equalTo((DeclaringPackage)another);
        }

        private boolean equalTo(DeclaringPackage another) {
            return this.name.equals(another.name);
        }

        private int computeHashCode() {
            int h = 31;
            h = h * 17 + this.name.hashCode();
            return h;
        }

        public int hashCode() {
            return this.computeHashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"DeclaringPackage").omitNullValues().add("name", (Object)this.name).toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Proto.DeclaringPackage> namedParentPackage() {
            if ((this.lazyInitBitmap & 1L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 1L) == 0L) {
                        this.namedParentPackage = (Optional)Preconditions.checkNotNull(super.namedParentPackage());
                        this.lazyInitBitmap |= 1L;
                    }
                }
            }
            return this.namedParentPackage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonSerialized() {
            if ((this.lazyInitBitmap & 2L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 2L) == 0L) {
                        this.isJacksonSerialized = super.isJacksonSerialized();
                        this.lazyInitBitmap |= 2L;
                    }
                }
            }
            return this.isJacksonSerialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonDeserialized() {
            if ((this.lazyInitBitmap & 4L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 4L) == 0L) {
                        this.isJacksonDeserialized = super.isJacksonDeserialized();
                        this.lazyInitBitmap |= 4L;
                    }
                }
            }
            return this.isJacksonDeserialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonJsonTypeInfo() {
            if ((this.lazyInitBitmap & 8L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 8L) == 0L) {
                        this.isJacksonJsonTypeInfo = super.isJacksonJsonTypeInfo();
                        this.lazyInitBitmap |= 8L;
                    }
                }
            }
            return this.isJacksonJsonTypeInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSerialStructural() {
            if ((this.lazyInitBitmap & 0x10L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x10L) == 0L) {
                        this.isSerialStructural = super.isSerialStructural();
                        this.lazyInitBitmap |= 0x10L;
                    }
                }
            }
            return this.isSerialStructural;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<Long> serialVersion() {
            if ((this.lazyInitBitmap & 0x20L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x20L) == 0L) {
                        this.serialVersion = (Optional)Preconditions.checkNotNull(super.serialVersion());
                        this.lazyInitBitmap |= 0x20L;
                    }
                }
            }
            return this.serialVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<StyleInfo> style() {
            if ((this.lazyInitBitmap & 0x40L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x40L) == 0L) {
                        this.style = (Optional)Preconditions.checkNotNull(super.style());
                        this.lazyInitBitmap |= 0x40L;
                    }
                }
            }
            return this.style;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<IncludeMirror> include() {
            if ((this.lazyInitBitmap & 0x80L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x80L) == 0L) {
                        this.include = (Optional)Preconditions.checkNotNull(super.include());
                        this.lazyInitBitmap |= 0x80L;
                    }
                }
            }
            return this.include;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<TypeAdaptersMirror> typeAdapters() {
            if ((this.lazyInitBitmap & 0x100L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x100L) == 0L) {
                        this.typeAdapters = (Optional)Preconditions.checkNotNull(super.typeAdapters());
                        this.lazyInitBitmap |= 0x100L;
                    }
                }
            }
            return this.typeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Optional<OkTypeAdaptersMirror> okTypeAdapters() {
            if ((this.lazyInitBitmap & 0x200L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x200L) == 0L) {
                        this.okTypeAdapters = (Optional)Preconditions.checkNotNull(super.okTypeAdapters());
                        this.lazyInitBitmap |= 0x200L;
                    }
                }
            }
            return this.okTypeAdapters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<TypeElement> includedTypes() {
            if ((this.lazyInitBitmap & 0x400L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x400L) == 0L) {
                        this.includedTypes = (List)Preconditions.checkNotNull(super.includedTypes());
                        this.lazyInitBitmap |= 0x400L;
                    }
                }
            }
            return this.includedTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isJacksonDeserializedAnnotated() {
            if ((this.lazyInitBitmap & 0x800L) == 0L) {
                DeclaringPackage declaringPackage = this;
                synchronized (declaringPackage) {
                    if ((this.lazyInitBitmap & 0x800L) == 0L) {
                        this.isJacksonDeserializedAnnotated = super.isJacksonDeserializedAnnotated();
                        this.lazyInitBitmap |= 0x800L;
                    }
                }
            }
            return this.isJacksonDeserializedAnnotated;
        }

        private static DeclaringPackage checkPreconditions(DeclaringPackage instance) {
            return instance;
        }

        public static DeclaringPackage copyOf(Proto.DeclaringPackage instance) {
            if (instance instanceof DeclaringPackage) {
                return (DeclaringPackage)instance;
            }
            Preconditions.checkNotNull((Object)instance);
            return DeclaringPackage.builder().element(instance.element()).interner(instance.interner()).environment(instance.environment()).build();
        }

        @Deprecated
        public static DeclaringPackage copyOf(DeclaringPackage instance) {
            return (DeclaringPackage)Preconditions.checkNotNull((Object)instance);
        }

        public static Builder builder() {
            return new Builder();
        }

        @NotThreadSafe
        public static final class Builder {
            private static final long INITIALIZED_BITSET_ALL_ = 7L;
            private static final long INITIALIZED_BIT_ELEMENT = 1L;
            private static final long INITIALIZED_BIT_INTERNER = 2L;
            private static final long INITIALIZED_BIT_ENVIRONMENT = 4L;
            private long initializedBitset;
            @Nullable
            private PackageElement element;
            @Nullable
            private Round.Interning interner;
            @Nullable
            private Proto.Environment environment;

            private Builder() {
            }

            public final Builder element(PackageElement element) {
                this.element = (PackageElement)Preconditions.checkNotNull((Object)element);
                this.initializedBitset |= 1L;
                return this;
            }

            public final Builder interner(Round.Interning interner) {
                this.interner = (Round.Interning)Preconditions.checkNotNull((Object)interner);
                this.initializedBitset |= 2L;
                return this;
            }

            public final Builder environment(Proto.Environment environment) {
                this.environment = (Proto.Environment)Preconditions.checkNotNull((Object)environment);
                this.initializedBitset |= 4L;
                return this;
            }

            public DeclaringPackage build() {
                this.checkRequiredAttributes();
                return DeclaringPackage.checkPreconditions(new DeclaringPackage(this));
            }

            private boolean elementIsSet() {
                return (this.initializedBitset & 1L) != 0L;
            }

            private boolean internerIsSet() {
                return (this.initializedBitset & 2L) != 0L;
            }

            private boolean environmentIsSet() {
                return (this.initializedBitset & 4L) != 0L;
            }

            private void checkRequiredAttributes() {
                if (this.initializedBitset != 7L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                return MoreObjects.toStringHelper((String)"Cannot build DeclaringPackage, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.elementIsSet() ? "element" : null)).addValue((Object)(!this.internerIsSet() ? "interner" : null)).addValue((Object)(!this.environmentIsSet() ? "environment" : null)).toString();
            }

            public String toString() {
                return MoreObjects.toStringHelper((String)"ImmutableProto.DeclaringPackage.Builder").omitNullValues().add("element", (Object)this.element).add("interner", (Object)this.interner).add("environment", (Object)this.environment).toString();
            }
        }
    }
}

