/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Round;
import org.immutables.value.processor.meta.ValueTypeComposer;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableRound
extends Round {
    private final ProcessingEnvironment processing;
    private final RoundEnvironment round;
    private final ImmutableSet<TypeElement> annotations;
    private final ImmutableSet<String> customImmutableAnnotations;
    private final ValueTypeComposer composer;
    @GuardedBy(value="this")
    private volatile long lazyInitBitmap;
    private static final long ENVIRONMENT_LAZY_INIT_BIT = 1L;
    @GuardedBy(value="this")
    private Proto.Environment environment;

    private ImmutableRound(Builder builder) {
        this.processing = builder.processing;
        this.round = builder.round;
        this.annotations = builder.annotationsBuilder.build();
        this.customImmutableAnnotations = builder.customImmutableAnnotationsBuilder.build();
        this.composer = (ValueTypeComposer)Preconditions.checkNotNull((Object)super.composer());
    }

    private ImmutableRound(ImmutableRound original, ProcessingEnvironment processing, RoundEnvironment round, ImmutableSet<TypeElement> annotations, ImmutableSet<String> customImmutableAnnotations, ValueTypeComposer composer) {
        this.processing = processing;
        this.round = round;
        this.annotations = annotations;
        this.customImmutableAnnotations = customImmutableAnnotations;
        this.composer = composer;
    }

    public final ImmutableRound withProcessing(ProcessingEnvironment value) {
        if (this.processing == value) {
            return this;
        }
        ProcessingEnvironment newValue = (ProcessingEnvironment)Preconditions.checkNotNull((Object)value);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, newValue, this.round, this.annotations, this.customImmutableAnnotations, this.composer));
    }

    public final ImmutableRound withRound(RoundEnvironment value) {
        if (this.round == value) {
            return this;
        }
        RoundEnvironment newValue = (RoundEnvironment)Preconditions.checkNotNull((Object)value);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, newValue, this.annotations, this.customImmutableAnnotations, this.composer));
    }

    public final ImmutableRound withAnnotations(TypeElement ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf(Arrays.asList(elements));
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, (ImmutableSet<TypeElement>)newValue, this.customImmutableAnnotations, this.composer));
    }

    public final ImmutableRound withAnnotations(Iterable<? extends TypeElement> elements) {
        if (this.annotations == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, (ImmutableSet<TypeElement>)newValue, this.customImmutableAnnotations, this.composer));
    }

    public final ImmutableRound withCustomImmutableAnnotations(String ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf(Arrays.asList(elements));
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, this.annotations, (ImmutableSet<String>)newValue, this.composer));
    }

    public final ImmutableRound withCustomImmutableAnnotations(Iterable<String> elements) {
        if (this.customImmutableAnnotations == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return ImmutableRound.checkPreconditions(new ImmutableRound(this, this.processing, this.round, this.annotations, (ImmutableSet<String>)newValue, this.composer));
    }

    @Override
    public ProcessingEnvironment processing() {
        return this.processing;
    }

    @Override
    public RoundEnvironment round() {
        return this.round;
    }

    public ImmutableSet<TypeElement> annotations() {
        return this.annotations;
    }

    public ImmutableSet<String> customImmutableAnnotations() {
        return this.customImmutableAnnotations;
    }

    @Override
    public ValueTypeComposer composer() {
        return this.composer;
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ImmutableRound && this.equalTo((ImmutableRound)another);
    }

    private boolean equalTo(ImmutableRound another) {
        return this.processing.equals(another.processing) && this.round.equals(another.round) && this.annotations.equals(another.annotations) && this.customImmutableAnnotations.equals(another.customImmutableAnnotations) && this.composer.equals(another.composer);
    }

    private int computeHashCode() {
        int h = 31;
        h = h * 17 + this.processing.hashCode();
        h = h * 17 + this.round.hashCode();
        h = h * 17 + this.annotations.hashCode();
        h = h * 17 + this.customImmutableAnnotations.hashCode();
        h = h * 17 + this.composer.hashCode();
        return h;
    }

    public int hashCode() {
        return this.computeHashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Round").omitNullValues().add("processing", (Object)this.processing).add("round", (Object)this.round).add("annotations", this.annotations).add("customImmutableAnnotations", this.customImmutableAnnotations).add("composer", (Object)this.composer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Proto.Environment environment() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableRound immutableRound = this;
            synchronized (immutableRound) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.environment = (Proto.Environment)Preconditions.checkNotNull((Object)super.environment());
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.environment;
    }

    private static ImmutableRound checkPreconditions(ImmutableRound instance) {
        return instance;
    }

    public static ImmutableRound copyOf(Round instance) {
        if (instance instanceof ImmutableRound) {
            return (ImmutableRound)instance;
        }
        Preconditions.checkNotNull((Object)instance);
        return ImmutableRound.builder().processing(instance.processing()).round(instance.round()).addAllAnnotations(instance.annotations()).addAllCustomImmutableAnnotations(instance.customImmutableAnnotations()).build();
    }

    @Deprecated
    public static ImmutableRound copyOf(ImmutableRound instance) {
        return (ImmutableRound)Preconditions.checkNotNull((Object)instance);
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL_ = 3L;
        private static final long INITIALIZED_BIT_PROCESSING = 1L;
        private static final long INITIALIZED_BIT_ROUND = 2L;
        private long initializedBitset;
        @Nullable
        private ProcessingEnvironment processing;
        @Nullable
        private RoundEnvironment round;
        private ImmutableSet.Builder<TypeElement> annotationsBuilder = ImmutableSet.builder();
        private ImmutableSet.Builder<String> customImmutableAnnotationsBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder processing(ProcessingEnvironment processing) {
            this.processing = (ProcessingEnvironment)Preconditions.checkNotNull((Object)processing);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder round(RoundEnvironment round) {
            this.round = (RoundEnvironment)Preconditions.checkNotNull((Object)round);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addAnnotations(TypeElement element) {
            this.annotationsBuilder.add((Object)element);
            return this;
        }

        public final Builder addAnnotations(TypeElement ... elements) {
            this.annotationsBuilder.addAll((Iterable)ImmutableSet.copyOf(Arrays.asList(elements)));
            return this;
        }

        public final Builder addAllAnnotations(Iterable<? extends TypeElement> elements) {
            this.annotationsBuilder.addAll(elements);
            return this;
        }

        public final Builder addCustomImmutableAnnotations(String element) {
            this.customImmutableAnnotationsBuilder.add((Object)element);
            return this;
        }

        public final Builder addCustomImmutableAnnotations(String ... elements) {
            this.customImmutableAnnotationsBuilder.addAll((Iterable)ImmutableSet.copyOf(Arrays.asList(elements)));
            return this;
        }

        public final Builder addAllCustomImmutableAnnotations(Iterable<String> elements) {
            this.customImmutableAnnotationsBuilder.addAll(elements);
            return this;
        }

        public ImmutableRound build() {
            this.checkRequiredAttributes();
            return ImmutableRound.checkPreconditions(new ImmutableRound(this));
        }

        private boolean processingIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean roundIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            return MoreObjects.toStringHelper((String)"Cannot build Round, some of required attributes are not set ").omitNullValues().addValue((Object)(!this.processingIsSet() ? "processing" : null)).addValue((Object)(!this.roundIsSet() ? "round" : null)).toString();
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"ImmutableRound.Builder").omitNullValues().add("processing", (Object)this.processing).add("round", (Object)this.round).add("annotations", (Object)this.annotationsBuilder.build()).add("customImmutableAnnotations", (Object)this.customImmutableAnnotationsBuilder.build()).toString();
        }
    }
}

