/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import java.lang.annotation.Annotation;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.immutables.value.processor.meta.CachingElements;
import org.immutables.value.processor.meta.ImmutableReporter;
import org.immutables.value.processor.meta.SuppressedWarnings;

abstract class Reporter {
    Reporter() {
    }

    abstract Messager messager();

    abstract Optional<Element> element();

    abstract Optional<AnnotationMirror> annotation();

    abstract Reporter withAnnotation(AnnotationMirror var1);

    abstract Reporter withElement(Element var1);

    static Reporter from(ProcessingEnvironment processing) {
        return ImmutableReporter.of(processing.getMessager());
    }

    Reporter forAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotationNamed(annotationType.getSimpleName());
    }

    Reporter annotationNamed(String simpleName) {
        if (this.element().isPresent()) {
            for (AnnotationMirror annotationMirror : ((Element)this.element().get()).getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(simpleName)) continue;
                return this.withAnnotation(annotationMirror);
            }
        }
        return this;
    }

    void error(String message, Object ... parameters) {
        this.reportMessage(Diagnostic.Kind.ERROR, message, parameters);
    }

    void warning(String message, Object ... parameters) {
        this.reportMessage(Diagnostic.Kind.MANDATORY_WARNING, message, parameters);
    }

    private void reportMessage(Diagnostic.Kind messageKind, String message, Object ... parameters) {
        if (messageKind == Diagnostic.Kind.WARNING || messageKind == Diagnostic.Kind.MANDATORY_WARNING) {
            SuppressedWarnings suppressed = SuppressedWarnings.forElement(this.getElement());
            if (suppressed.immutables) {
                return;
            }
        }
        String formattedMessage = String.format(message, parameters);
        if (this.element().isPresent() && this.annotation().isPresent()) {
            this.messager().printMessage(messageKind, formattedMessage, this.getElement(), this.getAnnotation());
        } else if (this.element().isPresent()) {
            this.messager().printMessage(messageKind, formattedMessage, this.getElement());
        } else {
            this.messager().printMessage(messageKind, formattedMessage);
        }
    }

    private AnnotationMirror getAnnotation() {
        return CachingElements.getDelegate((AnnotationMirror)this.annotation().get());
    }

    private Element getElement() {
        return CachingElements.getDelegate((Element)this.element().get());
    }
}

