package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepositoryModel.Facet}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFacet.builder()}.
 */
@Generated(from = "RepositoryModel.Facet", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFacet implements RepositoryModel.Facet {
  private final String name;
  private final TypeMirror interfaceType;
  private final TypeMirror fieldType;
  private final RepositoryModel.CodeBlock constructor;
  private final ImmutableList<RepositoryModel.DelegateMethod> methods;

  private ImmutableFacet(
      String name,
      TypeMirror interfaceType,
      TypeMirror fieldType,
      RepositoryModel.CodeBlock constructor,
      ImmutableList<RepositoryModel.DelegateMethod> methods) {
    this.name = name;
    this.interfaceType = interfaceType;
    this.fieldType = fieldType;
    this.constructor = constructor;
    this.methods = methods;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code interfaceType} attribute
   */
  @Override
  public TypeMirror interfaceType() {
    return interfaceType;
  }

  /**
   * @return The value of the {@code fieldType} attribute
   */
  @Override
  public TypeMirror fieldType() {
    return fieldType;
  }

  /**
   * @return The value of the {@code constructor} attribute
   */
  @Override
  public RepositoryModel.CodeBlock constructor() {
    return constructor;
  }

  /**
   * @return The value of the {@code methods} attribute
   */
  @Override
  public ImmutableList<RepositoryModel.DelegateMethod> methods() {
    return methods;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryModel.Facet#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFacet withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableFacet(newValue, this.interfaceType, this.fieldType, this.constructor, this.methods);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryModel.Facet#interfaceType() interfaceType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interfaceType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFacet withInterfaceType(TypeMirror value) {
    if (this.interfaceType == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "interfaceType");
    return new ImmutableFacet(this.name, newValue, this.fieldType, this.constructor, this.methods);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryModel.Facet#fieldType() fieldType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFacet withFieldType(TypeMirror value) {
    if (this.fieldType == value) return this;
    TypeMirror newValue = Objects.requireNonNull(value, "fieldType");
    return new ImmutableFacet(this.name, this.interfaceType, newValue, this.constructor, this.methods);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepositoryModel.Facet#constructor() constructor} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for constructor
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFacet withConstructor(RepositoryModel.CodeBlock value) {
    if (this.constructor == value) return this;
    RepositoryModel.CodeBlock newValue = Objects.requireNonNull(value, "constructor");
    return new ImmutableFacet(this.name, this.interfaceType, this.fieldType, newValue, this.methods);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RepositoryModel.Facet#methods() methods}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFacet withMethods(RepositoryModel.DelegateMethod... elements) {
    ImmutableList<RepositoryModel.DelegateMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFacet(this.name, this.interfaceType, this.fieldType, this.constructor, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RepositoryModel.Facet#methods() methods}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of methods elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFacet withMethods(Iterable<? extends RepositoryModel.DelegateMethod> elements) {
    if (this.methods == elements) return this;
    ImmutableList<RepositoryModel.DelegateMethod> newValue = ImmutableList.copyOf(elements);
    return new ImmutableFacet(this.name, this.interfaceType, this.fieldType, this.constructor, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFacet} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFacet
        && equalTo((ImmutableFacet) another);
  }

  private boolean equalTo(ImmutableFacet another) {
    return name.equals(another.name)
        && interfaceType.equals(another.interfaceType)
        && fieldType.equals(another.fieldType)
        && constructor.equals(another.constructor)
        && methods.equals(another.methods);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code interfaceType}, {@code fieldType}, {@code constructor}, {@code methods}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + interfaceType.hashCode();
    h += (h << 5) + fieldType.hashCode();
    h += (h << 5) + constructor.hashCode();
    h += (h << 5) + methods.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Facet} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Facet")
        .omitNullValues()
        .add("name", name)
        .add("interfaceType", interfaceType)
        .add("fieldType", fieldType)
        .add("constructor", constructor)
        .add("methods", methods)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RepositoryModel.Facet} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Facet instance
   */
  public static ImmutableFacet copyOf(RepositoryModel.Facet instance) {
    if (instance instanceof ImmutableFacet) {
      return (ImmutableFacet) instance;
    }
    return ImmutableFacet.builder()
        .name(instance.name())
        .interfaceType(instance.interfaceType())
        .fieldType(instance.fieldType())
        .constructor(instance.constructor())
        .addAllMethods(instance.methods())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFacet ImmutableFacet}.
   * <pre>
   * ImmutableFacet.builder()
   *    .name(String) // required {@link RepositoryModel.Facet#name() name}
   *    .interfaceType(javax.lang.model.type.TypeMirror) // required {@link RepositoryModel.Facet#interfaceType() interfaceType}
   *    .fieldType(javax.lang.model.type.TypeMirror) // required {@link RepositoryModel.Facet#fieldType() fieldType}
   *    .constructor(org.immutables.value.processor.meta.RepositoryModel.CodeBlock) // required {@link RepositoryModel.Facet#constructor() constructor}
   *    .addMethods|addAllMethods(org.immutables.value.processor.meta.RepositoryModel.DelegateMethod) // {@link RepositoryModel.Facet#methods() methods} elements
   *    .build();
   * </pre>
   * @return A new ImmutableFacet builder
   */
  public static ImmutableFacet.Builder builder() {
    return new ImmutableFacet.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFacet ImmutableFacet}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepositoryModel.Facet", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_INTERFACE_TYPE = 0x2L;
    private static final long INIT_BIT_FIELD_TYPE = 0x4L;
    private static final long INIT_BIT_CONSTRUCTOR = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String name;
    private @Nullable TypeMirror interfaceType;
    private @Nullable TypeMirror fieldType;
    private @Nullable RepositoryModel.CodeBlock constructor;
    private final ImmutableList.Builder<RepositoryModel.DelegateMethod> methods = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Initializes the value for the {@link RepositoryModel.Facet#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      checkNotIsSet(nameIsSet(), "name");
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryModel.Facet#interfaceType() interfaceType} attribute.
     * @param interfaceType The value for interfaceType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder interfaceType(TypeMirror interfaceType) {
      checkNotIsSet(interfaceTypeIsSet(), "interfaceType");
      this.interfaceType = Objects.requireNonNull(interfaceType, "interfaceType");
      initBits &= ~INIT_BIT_INTERFACE_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryModel.Facet#fieldType() fieldType} attribute.
     * @param fieldType The value for fieldType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fieldType(TypeMirror fieldType) {
      checkNotIsSet(fieldTypeIsSet(), "fieldType");
      this.fieldType = Objects.requireNonNull(fieldType, "fieldType");
      initBits &= ~INIT_BIT_FIELD_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link RepositoryModel.Facet#constructor() constructor} attribute.
     * @param constructor The value for constructor 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder constructor(RepositoryModel.CodeBlock constructor) {
      checkNotIsSet(constructorIsSet(), "constructor");
      this.constructor = Objects.requireNonNull(constructor, "constructor");
      initBits &= ~INIT_BIT_CONSTRUCTOR;
      return this;
    }

    /**
     * Adds one element to {@link RepositoryModel.Facet#methods() methods} list.
     * @param element A methods element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMethods(RepositoryModel.DelegateMethod element) {
      this.methods.add(element);
      return this;
    }

    /**
     * Adds elements to {@link RepositoryModel.Facet#methods() methods} list.
     * @param elements An array of methods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addMethods(RepositoryModel.DelegateMethod... elements) {
      this.methods.add(elements);
      return this;
    }


    /**
     * Adds elements to {@link RepositoryModel.Facet#methods() methods} list.
     * @param elements An iterable of methods elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllMethods(Iterable<? extends RepositoryModel.DelegateMethod> elements) {
      this.methods.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableFacet ImmutableFacet}.
     * @return An immutable instance of Facet
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFacet build() {
      checkRequiredAttributes();
      return new ImmutableFacet(name, interfaceType, fieldType, constructor, methods.build());
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean interfaceTypeIsSet() {
      return (initBits & INIT_BIT_INTERFACE_TYPE) == 0;
    }

    private boolean fieldTypeIsSet() {
      return (initBits & INIT_BIT_FIELD_TYPE) == 0;
    }

    private boolean constructorIsSet() {
      return (initBits & INIT_BIT_CONSTRUCTOR) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of Facet is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!nameIsSet()) attributes.add("name");
      if (!interfaceTypeIsSet()) attributes.add("interfaceType");
      if (!fieldTypeIsSet()) attributes.add("fieldType");
      if (!constructorIsSet()) attributes.add("constructor");
      return "Cannot build Facet, some of required attributes are not set " + attributes;
    }
  }
}
