/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.immutables.generator.Generator;
import org.immutables.value.Value;
import org.immutables.value.processor.ImmutableTypeAdapterTypes;
import org.immutables.value.processor.ValuesTemplate;
import org.immutables.value.processor.meta.GsonMirrors;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

@Generator.Template
abstract class Gsons
extends ValuesTemplate {
    final String gson = System.getProperty("gson.prefix", "com.google.gson");
    @Generator.Typedef
    Multimap<Character, Map.Entry<String, ValueAttribute>> Mm;
    @Generator.Typedef
    Map.Entry<String, ValueAttribute> Nv;
    public final Function<Iterable<ValueAttribute>, Multimap<Character, Map.Entry<String, ValueAttribute>>> byFirstCharacter = new Function<Iterable<ValueAttribute>, Multimap<Character, Map.Entry<String, ValueAttribute>>>(){

        public Multimap<Character, Map.Entry<String, ValueAttribute>> apply(Iterable<ValueAttribute> attributes) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (ValueAttribute attribute : attributes) {
                String serializedName = attribute.getMarshaledName();
                builder.put((Object)Character.valueOf(serializedName.charAt(0)), (Object)Maps.immutableEntry((Object)serializedName, (Object)attribute));
                for (String alternateName : attribute.getAlternateSerializedNames()) {
                    if (alternateName.isEmpty()) continue;
                    builder.put((Object)Character.valueOf(alternateName.charAt(0)), (Object)Maps.immutableEntry((Object)alternateName, (Object)attribute));
                }
            }
            return builder.build();
        }
    };

    Gsons() {
    }

    public Iterable<TypeAdapterTypes> typeAdapters() {
        HashMap mirrors = Maps.newHashMap();
        HashMultimap byDeclaring = HashMultimap.create();
        for (ValueType value : this.values.values()) {
            Proto.Protoclass protoclass = value.constitution.protoclass();
            if (!protoclass.kind().isValue()) continue;
            Optional<Proto.AbstractDeclaring> typeAdaptersProvider = protoclass.typeAdaptersProvider();
            if (typeAdaptersProvider.isPresent()) {
                Proto.AbstractDeclaring key = (Proto.AbstractDeclaring)typeAdaptersProvider.get();
                mirrors.put(key, key.typeAdapters().get());
                byDeclaring.put((Object)key, (Object)value);
                continue;
            }
            if (!protoclass.gsonTypeAdapters().isPresent() || !protoclass.declaringType().isPresent()) continue;
            Proto.DeclaringType topLevel = ((Proto.DeclaringType)protoclass.declaringType().get()).associatedTopLevel();
            mirrors.put(topLevel, protoclass.gsonTypeAdapters().get());
            byDeclaring.put((Object)topLevel, (Object)value);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : byDeclaring.asMap().entrySet()) {
            String pack = ((ValueType)Iterables.get((Iterable)((Iterable)entry.getValue()), (int)0)).$$package();
            builder.add((Object)ImmutableTypeAdapterTypes.builder().definedBy((Proto.AbstractDeclaring)entry.getKey()).mirror((GsonMirrors.TypeAdapters)mirrors.get(entry.getKey())).packageGenerated(pack).addAllTypes((Iterable)entry.getValue()).build());
        }
        return builder.build();
    }

    @Value.Immutable
    public static interface TypeAdapterTypes {
        public Proto.AbstractDeclaring definedBy();

        public String packageGenerated();

        public List<ValueType> types();

        public GsonMirrors.TypeAdapters mirror();
    }
}

