/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.generator.Naming;
import org.immutables.value.Generated;
import org.immutables.value.processor.encode.Code;
import org.immutables.value.processor.encode.EncodedElement;
import org.immutables.value.processor.encode.StandardNaming;
import org.immutables.value.processor.encode.Type;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EncodedElement", generator="Immutables")
@Immutable
final class ImmutableEncodedElement
extends EncodedElement {
    private final String name;
    private final Type type;
    private final Naming naming;
    private final ImmutableList<EncodedElement.Param> params;
    private final ImmutableList<Code.Term> code;
    private final ImmutableList<Type> thrown;
    private final ImmutableSet<EncodedElement.Tag> tags;
    private final Type.Parameters typeParameters;
    private final ImmutableList<EncodedElement.TypeParam> typeParams;
    private final ImmutableList<String> doc;
    private final ImmutableList<String> annotations;
    private final StandardNaming standardNaming;
    private final transient Code.Binding asBinding;
    private final transient boolean isToString;
    private final transient boolean isHashCode;
    private final transient boolean isEquals;
    private final transient boolean isFrom;
    private final transient boolean isBuild;
    private final transient boolean isInit;
    private final transient boolean isWasInit;
    private final transient boolean isCopy;
    private final transient boolean isBuilderCopy;
    private final transient boolean isExpose;
    private final transient boolean inBuilder;
    private final transient boolean isStatic;
    private final transient boolean isFinal;
    private final transient boolean isPrivate;
    private final transient boolean isSynthetic;
    private final transient boolean isImplField;
    private final transient boolean isValueField;
    private final transient boolean isStaticField;
    private final transient boolean isField;
    private final transient boolean isBuilderField;
    private final transient boolean isStaticMethod;
    private final transient boolean isValueMethod;
    private final transient boolean isBuilderMethod;
    private final transient boolean isBuilderStaticField;
    private final transient ImmutableList<Code.Term> oneLiner;
    private final transient boolean usesThis;
    private final transient boolean isInlinable;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEncodedElement(Builder builder) {
        this.name = builder.name;
        this.type = builder.type;
        this.naming = builder.naming;
        this.params = builder.params.build();
        this.code = builder.code.build();
        this.thrown = builder.thrown.build();
        this.tags = Sets.immutableEnumSet((Iterable)builder.tags.build());
        this.typeParameters = builder.typeParameters;
        this.typeParams = builder.typeParams.build();
        this.doc = builder.doc.build();
        this.annotations = builder.annotations.build();
        if (builder.standardNamingIsSet()) {
            this.initShim.standardNaming(builder.standardNaming);
        }
        this.standardNaming = this.initShim.standardNaming();
        this.asBinding = this.initShim.asBinding();
        this.isToString = this.initShim.isToString();
        this.isHashCode = this.initShim.isHashCode();
        this.isEquals = this.initShim.isEquals();
        this.isFrom = this.initShim.isFrom();
        this.isBuild = this.initShim.isBuild();
        this.isInit = this.initShim.isInit();
        this.isWasInit = this.initShim.isWasInit();
        this.isCopy = this.initShim.isCopy();
        this.isBuilderCopy = this.initShim.isBuilderCopy();
        this.isExpose = this.initShim.isExpose();
        this.inBuilder = this.initShim.inBuilder();
        this.isStatic = this.initShim.isStatic();
        this.isFinal = this.initShim.isFinal();
        this.isPrivate = this.initShim.isPrivate();
        this.isSynthetic = this.initShim.isSynthetic();
        this.isImplField = this.initShim.isImplField();
        this.isValueField = this.initShim.isValueField();
        this.isStaticField = this.initShim.isStaticField();
        this.isField = this.initShim.isField();
        this.isBuilderField = this.initShim.isBuilderField();
        this.isStaticMethod = this.initShim.isStaticMethod();
        this.isValueMethod = this.initShim.isValueMethod();
        this.isBuilderMethod = this.initShim.isBuilderMethod();
        this.isBuilderStaticField = this.initShim.isBuilderStaticField();
        this.oneLiner = this.initShim.oneLiner();
        this.usesThis = this.initShim.usesThis();
        this.isInlinable = this.initShim.isInlinable();
        this.initShim = null;
    }

    private ImmutableEncodedElement(String name, Type type, Naming naming, ImmutableList<EncodedElement.Param> params, ImmutableList<Code.Term> code, ImmutableList<Type> thrown, ImmutableSet<EncodedElement.Tag> tags, Type.Parameters typeParameters, ImmutableList<EncodedElement.TypeParam> typeParams, ImmutableList<String> doc, ImmutableList<String> annotations, StandardNaming standardNaming) {
        this.name = name;
        this.type = type;
        this.naming = naming;
        this.params = params;
        this.code = code;
        this.thrown = thrown;
        this.tags = tags;
        this.typeParameters = typeParameters;
        this.typeParams = typeParams;
        this.doc = doc;
        this.annotations = annotations;
        this.initShim.standardNaming(standardNaming);
        this.standardNaming = this.initShim.standardNaming();
        this.asBinding = this.initShim.asBinding();
        this.isToString = this.initShim.isToString();
        this.isHashCode = this.initShim.isHashCode();
        this.isEquals = this.initShim.isEquals();
        this.isFrom = this.initShim.isFrom();
        this.isBuild = this.initShim.isBuild();
        this.isInit = this.initShim.isInit();
        this.isWasInit = this.initShim.isWasInit();
        this.isCopy = this.initShim.isCopy();
        this.isBuilderCopy = this.initShim.isBuilderCopy();
        this.isExpose = this.initShim.isExpose();
        this.inBuilder = this.initShim.inBuilder();
        this.isStatic = this.initShim.isStatic();
        this.isFinal = this.initShim.isFinal();
        this.isPrivate = this.initShim.isPrivate();
        this.isSynthetic = this.initShim.isSynthetic();
        this.isImplField = this.initShim.isImplField();
        this.isValueField = this.initShim.isValueField();
        this.isStaticField = this.initShim.isStaticField();
        this.isField = this.initShim.isField();
        this.isBuilderField = this.initShim.isBuilderField();
        this.isStaticMethod = this.initShim.isStaticMethod();
        this.isValueMethod = this.initShim.isValueMethod();
        this.isBuilderMethod = this.initShim.isBuilderMethod();
        this.isBuilderStaticField = this.initShim.isBuilderStaticField();
        this.oneLiner = this.initShim.oneLiner();
        this.usesThis = this.initShim.usesThis();
        this.isInlinable = this.initShim.isInlinable();
        this.initShim = null;
    }

    @Override
    String name() {
        return this.name;
    }

    @Override
    Type type() {
        return this.type;
    }

    @Override
    Naming naming() {
        return this.naming;
    }

    ImmutableList<EncodedElement.Param> params() {
        return this.params;
    }

    ImmutableList<Code.Term> code() {
        return this.code;
    }

    ImmutableList<Type> thrown() {
        return this.thrown;
    }

    ImmutableSet<EncodedElement.Tag> tags() {
        return this.tags;
    }

    @Override
    Type.Parameters typeParameters() {
        return this.typeParameters;
    }

    ImmutableList<EncodedElement.TypeParam> typeParams() {
        return this.typeParams;
    }

    ImmutableList<String> doc() {
        return this.doc;
    }

    ImmutableList<String> annotations() {
        return this.annotations;
    }

    @Override
    StandardNaming standardNaming() {
        InitShim shim = this.initShim;
        return shim != null ? shim.standardNaming() : this.standardNaming;
    }

    @Override
    Code.Binding asBinding() {
        InitShim shim = this.initShim;
        return shim != null ? shim.asBinding() : this.asBinding;
    }

    @Override
    boolean isToString() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isToString() : this.isToString;
    }

    @Override
    boolean isHashCode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isHashCode() : this.isHashCode;
    }

    @Override
    boolean isEquals() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEquals() : this.isEquals;
    }

    @Override
    boolean isFrom() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFrom() : this.isFrom;
    }

    @Override
    boolean isBuild() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBuild() : this.isBuild;
    }

    @Override
    boolean isInit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isInit() : this.isInit;
    }

    @Override
    boolean isWasInit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isWasInit() : this.isWasInit;
    }

    @Override
    boolean isCopy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isCopy() : this.isCopy;
    }

    @Override
    boolean isBuilderCopy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBuilderCopy() : this.isBuilderCopy;
    }

    @Override
    boolean isExpose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isExpose() : this.isExpose;
    }

    @Override
    boolean inBuilder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inBuilder() : this.inBuilder;
    }

    @Override
    boolean isStatic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isStatic() : this.isStatic;
    }

    @Override
    boolean isFinal() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isFinal() : this.isFinal;
    }

    @Override
    boolean isPrivate() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isPrivate() : this.isPrivate;
    }

    @Override
    boolean isSynthetic() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSynthetic() : this.isSynthetic;
    }

    @Override
    boolean isImplField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isImplField() : this.isImplField;
    }

    @Override
    boolean isValueField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isValueField() : this.isValueField;
    }

    @Override
    boolean isStaticField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isStaticField() : this.isStaticField;
    }

    @Override
    boolean isField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isField() : this.isField;
    }

    @Override
    boolean isBuilderField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBuilderField() : this.isBuilderField;
    }

    @Override
    boolean isStaticMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isStaticMethod() : this.isStaticMethod;
    }

    @Override
    boolean isValueMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isValueMethod() : this.isValueMethod;
    }

    @Override
    boolean isBuilderMethod() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBuilderMethod() : this.isBuilderMethod;
    }

    @Override
    boolean isBuilderStaticField() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isBuilderStaticField() : this.isBuilderStaticField;
    }

    @Override
    ImmutableList<Code.Term> oneLiner() {
        InitShim shim = this.initShim;
        return shim != null ? shim.oneLiner() : this.oneLiner;
    }

    @Override
    boolean usesThis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.usesThis() : this.usesThis;
    }

    @Override
    boolean isInlinable() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isInlinable() : this.isInlinable;
    }

    public final ImmutableEncodedElement withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableEncodedElement(newValue, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableEncodedElement(this.name, newValue, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withNaming(Naming value) {
        if (this.naming == value) {
            return this;
        }
        Naming newValue = Objects.requireNonNull(value, "naming");
        return new ImmutableEncodedElement(this.name, this.type, newValue, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withParams(EncodedElement.Param ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, (ImmutableList<EncodedElement.Param>)newValue, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withParams(Iterable<? extends EncodedElement.Param> elements) {
        if (this.params == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, (ImmutableList<EncodedElement.Param>)newValue, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withCode(Code.Term ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, (ImmutableList<Code.Term>)newValue, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withCode(Iterable<? extends Code.Term> elements) {
        if (this.code == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, (ImmutableList<Code.Term>)newValue, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withThrown(Type ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, (ImmutableList<Type>)newValue, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withThrown(Iterable<? extends Type> elements) {
        if (this.thrown == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, (ImmutableList<Type>)newValue, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withTags(EncodedElement.Tag ... elements) {
        ImmutableSet newValue = Sets.immutableEnumSet(Arrays.asList(elements));
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, (ImmutableSet<EncodedElement.Tag>)newValue, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withTags(Iterable<EncodedElement.Tag> elements) {
        if (this.tags == elements) {
            return this;
        }
        ImmutableSet newValue = Sets.immutableEnumSet(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, (ImmutableSet<EncodedElement.Tag>)newValue, this.typeParameters, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withTypeParameters(Type.Parameters value) {
        if (this.typeParameters == value) {
            return this;
        }
        Type.Parameters newValue = Objects.requireNonNull(value, "typeParameters");
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, newValue, this.typeParams, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withTypeParams(EncodedElement.TypeParam ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, (ImmutableList<EncodedElement.TypeParam>)newValue, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withTypeParams(Iterable<? extends EncodedElement.TypeParam> elements) {
        if (this.typeParams == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, (ImmutableList<EncodedElement.TypeParam>)newValue, this.doc, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withDoc(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, (ImmutableList<String>)newValue, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withDoc(Iterable<String> elements) {
        if (this.doc == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, (ImmutableList<String>)newValue, this.annotations, this.standardNaming);
    }

    public final ImmutableEncodedElement withAnnotations(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, (ImmutableList<String>)newValue, this.standardNaming);
    }

    public final ImmutableEncodedElement withAnnotations(Iterable<String> elements) {
        if (this.annotations == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, (ImmutableList<String>)newValue, this.standardNaming);
    }

    public final ImmutableEncodedElement withStandardNaming(StandardNaming value) {
        if (this.standardNaming == value) {
            return this;
        }
        StandardNaming newValue = Objects.requireNonNull(value, "standardNaming");
        if (this.standardNaming.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableEncodedElement(this.name, this.type, this.naming, this.params, this.code, this.thrown, this.tags, this.typeParameters, this.typeParams, this.doc, this.annotations, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEncodedElement && this.equalTo((ImmutableEncodedElement)another);
    }

    private boolean equalTo(ImmutableEncodedElement another) {
        return this.name.equals(another.name) && this.type.equals(another.type) && this.naming.equals(another.naming) && this.params.equals(another.params) && this.code.equals(another.code) && this.thrown.equals(another.thrown) && this.tags.equals(another.tags) && this.typeParameters.equals(another.typeParameters) && this.typeParams.equals(another.typeParams) && this.doc.equals(another.doc) && this.annotations.equals(another.annotations) && this.standardNaming.equals((Object)another.standardNaming) && this.asBinding.equals(another.asBinding) && this.isToString == another.isToString && this.isHashCode == another.isHashCode && this.isEquals == another.isEquals && this.isFrom == another.isFrom && this.isBuild == another.isBuild && this.isInit == another.isInit && this.isWasInit == another.isWasInit && this.isCopy == another.isCopy && this.isBuilderCopy == another.isBuilderCopy && this.isExpose == another.isExpose && this.inBuilder == another.inBuilder && this.isStatic == another.isStatic && this.isFinal == another.isFinal && this.isPrivate == another.isPrivate && this.isSynthetic == another.isSynthetic && this.isImplField == another.isImplField && this.isValueField == another.isValueField && this.isStaticField == another.isStaticField && this.isField == another.isField && this.isBuilderField == another.isBuilderField && this.isStaticMethod == another.isStaticMethod && this.isValueMethod == another.isValueMethod && this.isBuilderMethod == another.isBuilderMethod && this.isBuilderStaticField == another.isBuilderStaticField && this.oneLiner.equals(another.oneLiner) && this.usesThis == another.usesThis && this.isInlinable == another.isInlinable;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.naming.hashCode();
        h += (h << 5) + this.params.hashCode();
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + this.thrown.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + this.typeParameters.hashCode();
        h += (h << 5) + this.typeParams.hashCode();
        h += (h << 5) + this.doc.hashCode();
        h += (h << 5) + this.annotations.hashCode();
        h += (h << 5) + this.standardNaming.hashCode();
        h += (h << 5) + this.asBinding.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isToString);
        h += (h << 5) + Booleans.hashCode((boolean)this.isHashCode);
        h += (h << 5) + Booleans.hashCode((boolean)this.isEquals);
        h += (h << 5) + Booleans.hashCode((boolean)this.isFrom);
        h += (h << 5) + Booleans.hashCode((boolean)this.isBuild);
        h += (h << 5) + Booleans.hashCode((boolean)this.isInit);
        h += (h << 5) + Booleans.hashCode((boolean)this.isWasInit);
        h += (h << 5) + Booleans.hashCode((boolean)this.isCopy);
        h += (h << 5) + Booleans.hashCode((boolean)this.isBuilderCopy);
        h += (h << 5) + Booleans.hashCode((boolean)this.isExpose);
        h += (h << 5) + Booleans.hashCode((boolean)this.inBuilder);
        h += (h << 5) + Booleans.hashCode((boolean)this.isStatic);
        h += (h << 5) + Booleans.hashCode((boolean)this.isFinal);
        h += (h << 5) + Booleans.hashCode((boolean)this.isPrivate);
        h += (h << 5) + Booleans.hashCode((boolean)this.isSynthetic);
        h += (h << 5) + Booleans.hashCode((boolean)this.isImplField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isValueField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isStaticField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isBuilderField);
        h += (h << 5) + Booleans.hashCode((boolean)this.isStaticMethod);
        h += (h << 5) + Booleans.hashCode((boolean)this.isValueMethod);
        h += (h << 5) + Booleans.hashCode((boolean)this.isBuilderMethod);
        h += (h << 5) + Booleans.hashCode((boolean)this.isBuilderStaticField);
        h += (h << 5) + this.oneLiner.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.usesThis);
        h += (h << 5) + Booleans.hashCode((boolean)this.isInlinable);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EncodedElement").omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("naming", (Object)this.naming).add("params", this.params).add("code", this.code).add("thrown", this.thrown).add("tags", this.tags).add("typeParameters", (Object)this.typeParameters).add("typeParams", this.typeParams).add("doc", this.doc).add("annotations", this.annotations).add("standardNaming", (Object)this.standardNaming).add("asBinding", (Object)this.asBinding).add("isToString", this.isToString).add("isHashCode", this.isHashCode).add("isEquals", this.isEquals).add("isFrom", this.isFrom).add("isBuild", this.isBuild).add("isInit", this.isInit).add("isWasInit", this.isWasInit).add("isCopy", this.isCopy).add("isBuilderCopy", this.isBuilderCopy).add("isExpose", this.isExpose).add("inBuilder", this.inBuilder).add("isStatic", this.isStatic).add("isFinal", this.isFinal).add("isPrivate", this.isPrivate).add("isSynthetic", this.isSynthetic).add("isImplField", this.isImplField).add("isValueField", this.isValueField).add("isStaticField", this.isStaticField).add("isField", this.isField).add("isBuilderField", this.isBuilderField).add("isStaticMethod", this.isStaticMethod).add("isValueMethod", this.isValueMethod).add("isBuilderMethod", this.isBuilderMethod).add("isBuilderStaticField", this.isBuilderStaticField).add("oneLiner", this.oneLiner).add("usesThis", this.usesThis).add("isInlinable", this.isInlinable).toString();
    }

    public static EncodedElement copyOf(EncodedElement instance) {
        if (instance instanceof ImmutableEncodedElement) {
            return (ImmutableEncodedElement)instance;
        }
        return new EncodedElement.Builder().name(instance.name()).type(instance.type()).naming(instance.naming()).addAllParams(instance.params()).addAllCode(instance.code()).addAllThrown(instance.thrown()).addAllTags(instance.tags()).typeParameters(instance.typeParameters()).addAllTypeParams(instance.typeParams()).addAllDoc(instance.doc()).addAllAnnotations(instance.annotations()).standardNaming(instance.standardNaming()).build();
    }

    @CheckReturnValue
    @Generated(from="EncodedElement.TypeParam", generator="Immutables")
    @Immutable
    static final class TypeParam
    extends EncodedElement.TypeParam {
        private final String name;
        private final ImmutableList<Type.Defined> bounds;

        private TypeParam(String name, ImmutableList<Type.Defined> bounds) {
            this.name = name;
            this.bounds = bounds;
        }

        @Override
        String name() {
            return this.name;
        }

        ImmutableList<Type.Defined> bounds() {
            return this.bounds;
        }

        public final TypeParam withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new TypeParam(newValue, this.bounds);
        }

        public final TypeParam withBounds(Type.Defined ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new TypeParam(this.name, (ImmutableList<Type.Defined>)newValue);
        }

        public final TypeParam withBounds(Iterable<? extends Type.Defined> elements) {
            if (this.bounds == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new TypeParam(this.name, (ImmutableList<Type.Defined>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof TypeParam && this.equalTo((TypeParam)another);
        }

        private boolean equalTo(TypeParam another) {
            return this.name.equals(another.name) && this.bounds.equals(another.bounds);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.bounds.hashCode();
            return h;
        }

        public static EncodedElement.TypeParam copyOf(EncodedElement.TypeParam instance) {
            if (instance instanceof TypeParam) {
                return (TypeParam)instance;
            }
            return new EncodedElement.TypeParam.Builder().name(instance.name()).addAllBounds(instance.bounds()).build();
        }

        @Generated(from="EncodedElement.TypeParam", generator="Immutables")
        @NotThreadSafe
        public static class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            @Nullable
            private String name;
            private final ImmutableList.Builder<Type.Defined> bounds = ImmutableList.builder();

            public Builder() {
                if (!(this instanceof EncodedElement.TypeParam.Builder)) {
                    throw new UnsupportedOperationException("Use: new EncodedElement.TypeParam.Builder()");
                }
            }

            @CanIgnoreReturnValue
            public final EncodedElement.TypeParam.Builder name(String name) {
                Builder.checkNotIsSet(this.nameIsSet(), "name");
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return (EncodedElement.TypeParam.Builder)this;
            }

            @CanIgnoreReturnValue
            public final EncodedElement.TypeParam.Builder addBounds(Type.Defined element) {
                this.bounds.add((Object)element);
                return (EncodedElement.TypeParam.Builder)this;
            }

            @CanIgnoreReturnValue
            public final EncodedElement.TypeParam.Builder addBounds(Type.Defined ... elements) {
                this.bounds.add((Object[])elements);
                return (EncodedElement.TypeParam.Builder)this;
            }

            @CanIgnoreReturnValue
            public final EncodedElement.TypeParam.Builder addAllBounds(Iterable<? extends Type.Defined> elements) {
                this.bounds.addAll(elements);
                return (EncodedElement.TypeParam.Builder)this;
            }

            public EncodedElement.TypeParam build() {
                this.checkRequiredAttributes();
                return new TypeParam(this.name, this.bounds.build());
            }

            private boolean nameIsSet() {
                return (this.initBits & 1L) == 0L;
            }

            private static void checkNotIsSet(boolean isSet, String name) {
                if (isSet) {
                    throw new IllegalStateException("Builder of TypeParam is strict, attribute is already set: ".concat(name));
                }
            }

            private void checkRequiredAttributes() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (!this.nameIsSet()) {
                    attributes.add("name");
                }
                return "Cannot build TypeParam, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="EncodedElement.Param", generator="Immutables")
    @Immutable
    static final class Param
    extends EncodedElement.Param {
        private final String name;
        private final Type type;
        private final ImmutableList<String> annotations;

        private Param(String name, Type type, Iterable<String> annotations) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
            this.annotations = ImmutableList.copyOf(annotations);
        }

        private Param(Param original, String name, Type type, ImmutableList<String> annotations) {
            this.name = name;
            this.type = type;
            this.annotations = annotations;
        }

        @Override
        String name() {
            return this.name;
        }

        @Override
        Type type() {
            return this.type;
        }

        ImmutableList<String> annotations() {
            return this.annotations;
        }

        public final Param withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Param(this, newValue, this.type, this.annotations);
        }

        public final Param withType(Type value) {
            if (this.type == value) {
                return this;
            }
            Type newValue = Objects.requireNonNull(value, "type");
            return new Param(this, this.name, newValue, this.annotations);
        }

        public final Param withAnnotations(String ... elements) {
            ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
            return new Param(this, this.name, this.type, (ImmutableList<String>)newValue);
        }

        public final Param withAnnotations(Iterable<String> elements) {
            if (this.annotations == elements) {
                return this;
            }
            ImmutableList newValue = ImmutableList.copyOf(elements);
            return new Param(this, this.name, this.type, (ImmutableList<String>)newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Param && this.equalTo((Param)another);
        }

        private boolean equalTo(Param another) {
            return this.name.equals(another.name) && this.type.equals(another.type) && this.annotations.equals(another.annotations);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.annotations.hashCode();
            return h;
        }

        public static EncodedElement.Param of(String name, Type type, List<String> annotations) {
            return Param.of(name, type, annotations);
        }

        public static EncodedElement.Param of(String name, Type type, Iterable<String> annotations) {
            return new Param(name, type, annotations);
        }

        public static EncodedElement.Param copyOf(EncodedElement.Param instance) {
            if (instance instanceof Param) {
                return (Param)instance;
            }
            return Param.of(instance.name(), instance.type(), instance.annotations());
        }
    }

    @Generated(from="EncodedElement", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private static final long INIT_BIT_NAMING = 4L;
        private static final long INIT_BIT_TYPE_PARAMETERS = 8L;
        private static final long OPT_BIT_STANDARD_NAMING = 1L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private String name;
        @Nullable
        private Type type;
        @Nullable
        private Naming naming;
        private final ImmutableList.Builder<EncodedElement.Param> params = ImmutableList.builder();
        private final ImmutableList.Builder<Code.Term> code = ImmutableList.builder();
        private final ImmutableList.Builder<Type> thrown = ImmutableList.builder();
        private final ImmutableSet.Builder<EncodedElement.Tag> tags = ImmutableSet.builder();
        @Nullable
        private Type.Parameters typeParameters;
        private final ImmutableList.Builder<EncodedElement.TypeParam> typeParams = ImmutableList.builder();
        private final ImmutableList.Builder<String> doc = ImmutableList.builder();
        private final ImmutableList.Builder<String> annotations = ImmutableList.builder();
        @Nullable
        private StandardNaming standardNaming;

        public Builder() {
            if (!(this instanceof EncodedElement.Builder)) {
                throw new UnsupportedOperationException("Use: new EncodedElement.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder name(String name) {
            Builder.checkNotIsSet(this.nameIsSet(), "name");
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder type(Type type) {
            Builder.checkNotIsSet(this.typeIsSet(), "type");
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder naming(Naming naming) {
            Builder.checkNotIsSet(this.namingIsSet(), "naming");
            this.naming = Objects.requireNonNull(naming, "naming");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addParams(EncodedElement.Param element) {
            this.params.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addParams(EncodedElement.Param ... elements) {
            this.params.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllParams(Iterable<? extends EncodedElement.Param> elements) {
            this.params.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addCode(Code.Term element) {
            this.code.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addCode(Code.Term ... elements) {
            this.code.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllCode(Iterable<? extends Code.Term> elements) {
            this.code.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addThrown(Type element) {
            this.thrown.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addThrown(Type ... elements) {
            this.thrown.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllThrown(Iterable<? extends Type> elements) {
            this.thrown.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addTags(EncodedElement.Tag element) {
            this.tags.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addTags(EncodedElement.Tag ... elements) {
            this.tags.addAll(Arrays.asList(elements));
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllTags(Iterable<EncodedElement.Tag> elements) {
            this.tags.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder typeParameters(Type.Parameters typeParameters) {
            Builder.checkNotIsSet(this.typeParametersIsSet(), "typeParameters");
            this.typeParameters = Objects.requireNonNull(typeParameters, "typeParameters");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addTypeParams(EncodedElement.TypeParam element) {
            this.typeParams.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addTypeParams(EncodedElement.TypeParam ... elements) {
            this.typeParams.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllTypeParams(Iterable<? extends EncodedElement.TypeParam> elements) {
            this.typeParams.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addDoc(String element) {
            this.doc.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addDoc(String ... elements) {
            this.doc.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllDoc(Iterable<String> elements) {
            this.doc.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAnnotations(String element) {
            this.annotations.add((Object)element);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAnnotations(String ... elements) {
            this.annotations.add((Object[])elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder addAllAnnotations(Iterable<String> elements) {
            this.annotations.addAll(elements);
            return (EncodedElement.Builder)this;
        }

        @CanIgnoreReturnValue
        public final EncodedElement.Builder standardNaming(StandardNaming standardNaming) {
            Builder.checkNotIsSet(this.standardNamingIsSet(), "standardNaming");
            this.standardNaming = Objects.requireNonNull(standardNaming, "standardNaming");
            this.optBits |= 1L;
            return (EncodedElement.Builder)this;
        }

        public EncodedElement build() {
            this.checkRequiredAttributes();
            return new ImmutableEncodedElement(this);
        }

        private boolean standardNamingIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean namingIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean typeParametersIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of EncodedElement is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.namingIsSet()) {
                attributes.add("naming");
            }
            if (!this.typeParametersIsSet()) {
                attributes.add("typeParameters");
            }
            return "Cannot build EncodedElement, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="EncodedElement", generator="Immutables")
    private final class InitShim {
        private byte standardNamingBuildStage = 0;
        private StandardNaming standardNaming;
        private byte asBindingBuildStage = 0;
        private Code.Binding asBinding;
        private byte isToStringBuildStage = 0;
        private boolean isToString;
        private byte isHashCodeBuildStage = 0;
        private boolean isHashCode;
        private byte isEqualsBuildStage = 0;
        private boolean isEquals;
        private byte isFromBuildStage = 0;
        private boolean isFrom;
        private byte isBuildBuildStage = 0;
        private boolean isBuild;
        private byte isInitBuildStage = 0;
        private boolean isInit;
        private byte isWasInitBuildStage = 0;
        private boolean isWasInit;
        private byte isCopyBuildStage = 0;
        private boolean isCopy;
        private byte isBuilderCopyBuildStage = 0;
        private boolean isBuilderCopy;
        private byte isExposeBuildStage = 0;
        private boolean isExpose;
        private byte inBuilderBuildStage = 0;
        private boolean inBuilder;
        private byte isStaticBuildStage = 0;
        private boolean isStatic;
        private byte isFinalBuildStage = 0;
        private boolean isFinal;
        private byte isPrivateBuildStage = 0;
        private boolean isPrivate;
        private byte isSyntheticBuildStage = 0;
        private boolean isSynthetic;
        private byte isImplFieldBuildStage = 0;
        private boolean isImplField;
        private byte isValueFieldBuildStage = 0;
        private boolean isValueField;
        private byte isStaticFieldBuildStage = 0;
        private boolean isStaticField;
        private byte isFieldBuildStage = 0;
        private boolean isField;
        private byte isBuilderFieldBuildStage = 0;
        private boolean isBuilderField;
        private byte isStaticMethodBuildStage = 0;
        private boolean isStaticMethod;
        private byte isValueMethodBuildStage = 0;
        private boolean isValueMethod;
        private byte isBuilderMethodBuildStage = 0;
        private boolean isBuilderMethod;
        private byte isBuilderStaticFieldBuildStage = 0;
        private boolean isBuilderStaticField;
        private byte oneLinerBuildStage = 0;
        private ImmutableList<Code.Term> oneLiner;
        private byte usesThisBuildStage = 0;
        private boolean usesThis;
        private byte isInlinableBuildStage = 0;
        private boolean isInlinable;

        private InitShim() {
        }

        StandardNaming standardNaming() {
            if (this.standardNamingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.standardNamingBuildStage == 0) {
                this.standardNamingBuildStage = (byte)-1;
                this.standardNaming = Objects.requireNonNull(ImmutableEncodedElement.super.standardNaming(), "standardNaming");
                this.standardNamingBuildStage = 1;
            }
            return this.standardNaming;
        }

        void standardNaming(StandardNaming standardNaming) {
            this.standardNaming = standardNaming;
            this.standardNamingBuildStage = 1;
        }

        Code.Binding asBinding() {
            if (this.asBindingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.asBindingBuildStage == 0) {
                this.asBindingBuildStage = (byte)-1;
                this.asBinding = Objects.requireNonNull(ImmutableEncodedElement.super.asBinding(), "asBinding");
                this.asBindingBuildStage = 1;
            }
            return this.asBinding;
        }

        boolean isToString() {
            if (this.isToStringBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isToStringBuildStage == 0) {
                this.isToStringBuildStage = (byte)-1;
                this.isToString = ImmutableEncodedElement.super.isToString();
                this.isToStringBuildStage = 1;
            }
            return this.isToString;
        }

        boolean isHashCode() {
            if (this.isHashCodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isHashCodeBuildStage == 0) {
                this.isHashCodeBuildStage = (byte)-1;
                this.isHashCode = ImmutableEncodedElement.super.isHashCode();
                this.isHashCodeBuildStage = 1;
            }
            return this.isHashCode;
        }

        boolean isEquals() {
            if (this.isEqualsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEqualsBuildStage == 0) {
                this.isEqualsBuildStage = (byte)-1;
                this.isEquals = ImmutableEncodedElement.super.isEquals();
                this.isEqualsBuildStage = 1;
            }
            return this.isEquals;
        }

        boolean isFrom() {
            if (this.isFromBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFromBuildStage == 0) {
                this.isFromBuildStage = (byte)-1;
                this.isFrom = ImmutableEncodedElement.super.isFrom();
                this.isFromBuildStage = 1;
            }
            return this.isFrom;
        }

        boolean isBuild() {
            if (this.isBuildBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBuildBuildStage == 0) {
                this.isBuildBuildStage = (byte)-1;
                this.isBuild = ImmutableEncodedElement.super.isBuild();
                this.isBuildBuildStage = 1;
            }
            return this.isBuild;
        }

        boolean isInit() {
            if (this.isInitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isInitBuildStage == 0) {
                this.isInitBuildStage = (byte)-1;
                this.isInit = ImmutableEncodedElement.super.isInit();
                this.isInitBuildStage = 1;
            }
            return this.isInit;
        }

        boolean isWasInit() {
            if (this.isWasInitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isWasInitBuildStage == 0) {
                this.isWasInitBuildStage = (byte)-1;
                this.isWasInit = ImmutableEncodedElement.super.isWasInit();
                this.isWasInitBuildStage = 1;
            }
            return this.isWasInit;
        }

        boolean isCopy() {
            if (this.isCopyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isCopyBuildStage == 0) {
                this.isCopyBuildStage = (byte)-1;
                this.isCopy = ImmutableEncodedElement.super.isCopy();
                this.isCopyBuildStage = 1;
            }
            return this.isCopy;
        }

        boolean isBuilderCopy() {
            if (this.isBuilderCopyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBuilderCopyBuildStage == 0) {
                this.isBuilderCopyBuildStage = (byte)-1;
                this.isBuilderCopy = ImmutableEncodedElement.super.isBuilderCopy();
                this.isBuilderCopyBuildStage = 1;
            }
            return this.isBuilderCopy;
        }

        boolean isExpose() {
            if (this.isExposeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isExposeBuildStage == 0) {
                this.isExposeBuildStage = (byte)-1;
                this.isExpose = ImmutableEncodedElement.super.isExpose();
                this.isExposeBuildStage = 1;
            }
            return this.isExpose;
        }

        boolean inBuilder() {
            if (this.inBuilderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inBuilderBuildStage == 0) {
                this.inBuilderBuildStage = (byte)-1;
                this.inBuilder = ImmutableEncodedElement.super.inBuilder();
                this.inBuilderBuildStage = 1;
            }
            return this.inBuilder;
        }

        boolean isStatic() {
            if (this.isStaticBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isStaticBuildStage == 0) {
                this.isStaticBuildStage = (byte)-1;
                this.isStatic = ImmutableEncodedElement.super.isStatic();
                this.isStaticBuildStage = 1;
            }
            return this.isStatic;
        }

        boolean isFinal() {
            if (this.isFinalBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFinalBuildStage == 0) {
                this.isFinalBuildStage = (byte)-1;
                this.isFinal = ImmutableEncodedElement.super.isFinal();
                this.isFinalBuildStage = 1;
            }
            return this.isFinal;
        }

        boolean isPrivate() {
            if (this.isPrivateBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isPrivateBuildStage == 0) {
                this.isPrivateBuildStage = (byte)-1;
                this.isPrivate = ImmutableEncodedElement.super.isPrivate();
                this.isPrivateBuildStage = 1;
            }
            return this.isPrivate;
        }

        boolean isSynthetic() {
            if (this.isSyntheticBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSyntheticBuildStage == 0) {
                this.isSyntheticBuildStage = (byte)-1;
                this.isSynthetic = ImmutableEncodedElement.super.isSynthetic();
                this.isSyntheticBuildStage = 1;
            }
            return this.isSynthetic;
        }

        boolean isImplField() {
            if (this.isImplFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isImplFieldBuildStage == 0) {
                this.isImplFieldBuildStage = (byte)-1;
                this.isImplField = ImmutableEncodedElement.super.isImplField();
                this.isImplFieldBuildStage = 1;
            }
            return this.isImplField;
        }

        boolean isValueField() {
            if (this.isValueFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isValueFieldBuildStage == 0) {
                this.isValueFieldBuildStage = (byte)-1;
                this.isValueField = ImmutableEncodedElement.super.isValueField();
                this.isValueFieldBuildStage = 1;
            }
            return this.isValueField;
        }

        boolean isStaticField() {
            if (this.isStaticFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isStaticFieldBuildStage == 0) {
                this.isStaticFieldBuildStage = (byte)-1;
                this.isStaticField = ImmutableEncodedElement.super.isStaticField();
                this.isStaticFieldBuildStage = 1;
            }
            return this.isStaticField;
        }

        boolean isField() {
            if (this.isFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isFieldBuildStage == 0) {
                this.isFieldBuildStage = (byte)-1;
                this.isField = ImmutableEncodedElement.super.isField();
                this.isFieldBuildStage = 1;
            }
            return this.isField;
        }

        boolean isBuilderField() {
            if (this.isBuilderFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBuilderFieldBuildStage == 0) {
                this.isBuilderFieldBuildStage = (byte)-1;
                this.isBuilderField = ImmutableEncodedElement.super.isBuilderField();
                this.isBuilderFieldBuildStage = 1;
            }
            return this.isBuilderField;
        }

        boolean isStaticMethod() {
            if (this.isStaticMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isStaticMethodBuildStage == 0) {
                this.isStaticMethodBuildStage = (byte)-1;
                this.isStaticMethod = ImmutableEncodedElement.super.isStaticMethod();
                this.isStaticMethodBuildStage = 1;
            }
            return this.isStaticMethod;
        }

        boolean isValueMethod() {
            if (this.isValueMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isValueMethodBuildStage == 0) {
                this.isValueMethodBuildStage = (byte)-1;
                this.isValueMethod = ImmutableEncodedElement.super.isValueMethod();
                this.isValueMethodBuildStage = 1;
            }
            return this.isValueMethod;
        }

        boolean isBuilderMethod() {
            if (this.isBuilderMethodBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBuilderMethodBuildStage == 0) {
                this.isBuilderMethodBuildStage = (byte)-1;
                this.isBuilderMethod = ImmutableEncodedElement.super.isBuilderMethod();
                this.isBuilderMethodBuildStage = 1;
            }
            return this.isBuilderMethod;
        }

        boolean isBuilderStaticField() {
            if (this.isBuilderStaticFieldBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isBuilderStaticFieldBuildStage == 0) {
                this.isBuilderStaticFieldBuildStage = (byte)-1;
                this.isBuilderStaticField = ImmutableEncodedElement.super.isBuilderStaticField();
                this.isBuilderStaticFieldBuildStage = 1;
            }
            return this.isBuilderStaticField;
        }

        ImmutableList<Code.Term> oneLiner() {
            if (this.oneLinerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oneLinerBuildStage == 0) {
                this.oneLinerBuildStage = (byte)-1;
                this.oneLiner = Objects.requireNonNull(ImmutableEncodedElement.super.oneLiner(), "oneLiner");
                this.oneLinerBuildStage = 1;
            }
            return this.oneLiner;
        }

        boolean usesThis() {
            if (this.usesThisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.usesThisBuildStage == 0) {
                this.usesThisBuildStage = (byte)-1;
                this.usesThis = ImmutableEncodedElement.super.usesThis();
                this.usesThisBuildStage = 1;
            }
            return this.usesThis;
        }

        boolean isInlinable() {
            if (this.isInlinableBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isInlinableBuildStage == 0) {
                this.isInlinableBuildStage = (byte)-1;
                this.isInlinable = ImmutableEncodedElement.super.isInlinable();
                this.isInlinableBuildStage = 1;
            }
            return this.isInlinable;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.standardNamingBuildStage == -1) {
                attributes.add("standardNaming");
            }
            if (this.asBindingBuildStage == -1) {
                attributes.add("asBinding");
            }
            if (this.isToStringBuildStage == -1) {
                attributes.add("isToString");
            }
            if (this.isHashCodeBuildStage == -1) {
                attributes.add("isHashCode");
            }
            if (this.isEqualsBuildStage == -1) {
                attributes.add("isEquals");
            }
            if (this.isFromBuildStage == -1) {
                attributes.add("isFrom");
            }
            if (this.isBuildBuildStage == -1) {
                attributes.add("isBuild");
            }
            if (this.isInitBuildStage == -1) {
                attributes.add("isInit");
            }
            if (this.isWasInitBuildStage == -1) {
                attributes.add("isWasInit");
            }
            if (this.isCopyBuildStage == -1) {
                attributes.add("isCopy");
            }
            if (this.isBuilderCopyBuildStage == -1) {
                attributes.add("isBuilderCopy");
            }
            if (this.isExposeBuildStage == -1) {
                attributes.add("isExpose");
            }
            if (this.inBuilderBuildStage == -1) {
                attributes.add("inBuilder");
            }
            if (this.isStaticBuildStage == -1) {
                attributes.add("isStatic");
            }
            if (this.isFinalBuildStage == -1) {
                attributes.add("isFinal");
            }
            if (this.isPrivateBuildStage == -1) {
                attributes.add("isPrivate");
            }
            if (this.isSyntheticBuildStage == -1) {
                attributes.add("isSynthetic");
            }
            if (this.isImplFieldBuildStage == -1) {
                attributes.add("isImplField");
            }
            if (this.isValueFieldBuildStage == -1) {
                attributes.add("isValueField");
            }
            if (this.isStaticFieldBuildStage == -1) {
                attributes.add("isStaticField");
            }
            if (this.isFieldBuildStage == -1) {
                attributes.add("isField");
            }
            if (this.isBuilderFieldBuildStage == -1) {
                attributes.add("isBuilderField");
            }
            if (this.isStaticMethodBuildStage == -1) {
                attributes.add("isStaticMethod");
            }
            if (this.isValueMethodBuildStage == -1) {
                attributes.add("isValueMethod");
            }
            if (this.isBuilderMethodBuildStage == -1) {
                attributes.add("isBuilderMethod");
            }
            if (this.isBuilderStaticFieldBuildStage == -1) {
                attributes.add("isBuilderStaticField");
            }
            if (this.oneLinerBuildStage == -1) {
                attributes.add("oneLiner");
            }
            if (this.usesThisBuildStage == -1) {
                attributes.add("usesThis");
            }
            if (this.isInlinableBuildStage == -1) {
                attributes.add("isInlinable");
            }
            return "Cannot build EncodedElement, attribute initializers form cycle " + attributes;
        }
    }
}

