/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.ImmutableMirror;
import org.immutables.value.processor.meta.ValueMirrors;

public class StyleMirror
implements ValueMirrors.Style {
    public static final String QUALIFIED_NAME = "org.immutables.value.Value.Style";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.ValueMirrors.Style";
    private final AnnotationMirror annotationMirror;
    private final String[] get;
    private final String init;
    private final String with;
    private final String withUnaryOperator;
    private final String add;
    private final String addAll;
    private final String put;
    private final String putAll;
    private final String copyOf;
    private final String of;
    private final String instance;
    private final String builder;
    private final String newBuilder;
    private final String from;
    private final String build;
    private final String buildOrThrow;
    private final String canBuild;
    private final String toBuilder;
    private final String underrideHashCode;
    private final String underrideEquals;
    private final String underrideToString;
    private final String delegateToString;
    private final String includeHashCode;
    private final String isInitialized;
    private final String isSet;
    private final String set;
    private final String unset;
    private final String clear;
    private final String create;
    private final String toImmutable;
    private final String typeBuilder;
    private final String typeInnerBuilder;
    private final String[] typeAbstract;
    private final String typeImmutable;
    private final String typeImmutableEnclosing;
    private final String typeImmutableNested;
    private final String typeModifiable;
    private final String typeInnerModifiable;
    private final String typeWith;
    private final String packageGenerated;
    private final AnnotationMirror defaults;
    private final ImmutableMirror defaultsMirror;
    private final boolean strictBuilder;
    private final ValueMirrors.Style.ValidationMethod validationMethod;
    private final boolean allParameters;
    private final boolean defaultAsDefault;
    private final boolean headerComments;
    private final boolean jdkOnly;
    private final TypeMirror[] passAnnotations;
    private final String[] passAnnotationsName;
    private final TypeMirror[] additionalJsonAnnotations;
    private final String[] additionalJsonAnnotationsName;
    private final ValueMirrors.Style.ImplementationVisibility visibility;
    private final boolean optionalAcceptNullable;
    private final boolean generateSuppressAllWarnings;
    private final boolean privateNoargConstructor;
    private final boolean protectedNoargConstructor;
    private final boolean attributelessSingleton;
    private final boolean unsafeDefaultAndDerived;
    private final boolean clearBuilder;
    private final boolean deferCollectionAllocation;
    private final boolean deepImmutablesDetection;
    private final boolean overshadowImplementation;
    private final boolean implementationNestedInBuilder;
    private final boolean forceJacksonPropertyNames;
    private final boolean forceJacksonIgnoreFields;
    private final boolean forceEqualsInWithers;
    private final boolean jacksonIntegration;
    private final boolean weakInterning;
    private final boolean alwaysPublicInitializers;
    private final ValueMirrors.Style.BuilderVisibility builderVisibility;
    private final TypeMirror throwForInvalidImmutableState;
    private final String throwForInvalidImmutableStateName;
    private final TypeMirror throwForNullPointer;
    private final String throwForNullPointerName;
    private final boolean depluralize;
    private final String[] depluralizeDictionary;
    private final TypeMirror[] immutableCopyOfRoutines;
    private final String[] immutableCopyOfRoutinesName;
    private final boolean stagedBuilder;
    private final boolean builtinContainerAttributes;
    private final boolean beanFriendlyModifiables;
    private final boolean allMandatoryParameters;
    private final String redactedMask;
    private final boolean attributeBuilderDetection;
    private final boolean transientDerivedFields;
    private final boolean finalInstanceFields;
    private final String[] attributeBuilder;
    private final String getBuilder;
    private final String setBuilder;
    private final String addBuilder;
    private final String addAllBuilder;
    private final String getBuilders;
    private final String nullableAnnotation;
    private final int limitStringLengthInToString;
    private final TypeMirror[] allowedClasspathAnnotations;
    private final String[] allowedClasspathAnnotationsName;
    private final TypeMirror fallbackNullableAnnotation;
    private final String fallbackNullableAnnotationName;
    private final boolean jakarta;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Style";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<StyleMirror> find(Element element) {
        return StyleMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<StyleMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new StyleMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<StyleMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new StyleMirror(annotationMirror));
        }
        return builder.build();
    }

    public static StyleMirror from(TypeElement element) {
        return new StyleMirror(element);
    }

    public static Optional<StyleMirror> from(AnnotationMirror mirror) {
        return StyleMirror.find(Collections.singleton(mirror));
    }

    private StyleMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        String[] get = null;
        String init = null;
        String with = null;
        String withUnaryOperator = null;
        String add = null;
        String addAll = null;
        String put = null;
        String putAll = null;
        String copyOf = null;
        String of = null;
        String instance = null;
        String builder = null;
        String newBuilder = null;
        String from = null;
        String build = null;
        String buildOrThrow = null;
        String canBuild = null;
        String toBuilder = null;
        String underrideHashCode = null;
        String underrideEquals = null;
        String underrideToString = null;
        String delegateToString = null;
        String includeHashCode = null;
        String isInitialized = null;
        String isSet = null;
        String set = null;
        String unset = null;
        String clear = null;
        String create = null;
        String toImmutable = null;
        String typeBuilder = null;
        String typeInnerBuilder = null;
        String[] typeAbstract = null;
        String typeImmutable = null;
        String typeImmutableEnclosing = null;
        String typeImmutableNested = null;
        String typeModifiable = null;
        String typeInnerModifiable = null;
        String typeWith = null;
        String packageGenerated = null;
        AnnotationMirror defaults = null;
        ImmutableMirror defaultsMirror = null;
        boolean strictBuilder = false;
        ValueMirrors.Style.ValidationMethod validationMethod = null;
        boolean allParameters = false;
        boolean defaultAsDefault = false;
        boolean headerComments = false;
        boolean jdkOnly = false;
        TypeMirror[] passAnnotations = null;
        String[] passAnnotationsName = null;
        TypeMirror[] additionalJsonAnnotations = null;
        String[] additionalJsonAnnotationsName = null;
        ValueMirrors.Style.ImplementationVisibility visibility = null;
        boolean optionalAcceptNullable = false;
        boolean generateSuppressAllWarnings = false;
        boolean privateNoargConstructor = false;
        boolean protectedNoargConstructor = false;
        boolean attributelessSingleton = false;
        boolean unsafeDefaultAndDerived = false;
        boolean clearBuilder = false;
        boolean deferCollectionAllocation = false;
        boolean deepImmutablesDetection = false;
        boolean overshadowImplementation = false;
        boolean implementationNestedInBuilder = false;
        boolean forceJacksonPropertyNames = false;
        boolean forceJacksonIgnoreFields = false;
        boolean forceEqualsInWithers = false;
        boolean jacksonIntegration = false;
        boolean weakInterning = false;
        boolean alwaysPublicInitializers = false;
        ValueMirrors.Style.BuilderVisibility builderVisibility = null;
        TypeMirror throwForInvalidImmutableState = null;
        String throwForInvalidImmutableStateName = null;
        TypeMirror throwForNullPointer = null;
        String throwForNullPointerName = null;
        boolean depluralize = false;
        String[] depluralizeDictionary = null;
        TypeMirror[] immutableCopyOfRoutines = null;
        String[] immutableCopyOfRoutinesName = null;
        boolean stagedBuilder = false;
        boolean builtinContainerAttributes = false;
        boolean beanFriendlyModifiables = false;
        boolean allMandatoryParameters = false;
        String redactedMask = null;
        boolean attributeBuilderDetection = false;
        boolean transientDerivedFields = false;
        boolean finalInstanceFields = false;
        String[] attributeBuilder = null;
        String getBuilder = null;
        String setBuilder = null;
        String addBuilder = null;
        String addAllBuilder = null;
        String getBuilders = null;
        String nullableAnnotation = null;
        int limitStringLengthInToString = 0;
        TypeMirror[] allowedClasspathAnnotations = null;
        String[] allowedClasspathAnnotationsName = null;
        TypeMirror fallbackNullableAnnotation = null;
        String fallbackNullableAnnotationName = null;
        boolean jakarta = false;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("get".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                GetExtractor getExtractor$ = new GetExtractor();
                annotationValue$.accept(getExtractor$, null);
                get = getExtractor$.get();
                continue;
            }
            if ("init".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                InitExtractor initExtractor$ = new InitExtractor();
                annotationValue$.accept(initExtractor$, null);
                init = initExtractor$.get();
                continue;
            }
            if ("with".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                WithExtractor withExtractor$ = new WithExtractor();
                annotationValue$.accept(withExtractor$, null);
                with = withExtractor$.get();
                continue;
            }
            if ("withUnaryOperator".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                WithUnaryOperatorExtractor withUnaryOperatorExtractor$ = new WithUnaryOperatorExtractor();
                annotationValue$.accept(withUnaryOperatorExtractor$, null);
                withUnaryOperator = withUnaryOperatorExtractor$.get();
                continue;
            }
            if ("add".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddExtractor addExtractor$ = new AddExtractor();
                annotationValue$.accept(addExtractor$, null);
                add = addExtractor$.get();
                continue;
            }
            if ("addAll".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddAllExtractor addAllExtractor$ = new AddAllExtractor();
                annotationValue$.accept(addAllExtractor$, null);
                addAll = addAllExtractor$.get();
                continue;
            }
            if ("put".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PutExtractor putExtractor$ = new PutExtractor();
                annotationValue$.accept(putExtractor$, null);
                put = putExtractor$.get();
                continue;
            }
            if ("putAll".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PutAllExtractor putAllExtractor$ = new PutAllExtractor();
                annotationValue$.accept(putAllExtractor$, null);
                putAll = putAllExtractor$.get();
                continue;
            }
            if ("copyOf".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                CopyOfExtractor copyOfExtractor$ = new CopyOfExtractor();
                annotationValue$.accept(copyOfExtractor$, null);
                copyOf = copyOfExtractor$.get();
                continue;
            }
            if ("of".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                OfExtractor ofExtractor$ = new OfExtractor();
                annotationValue$.accept(ofExtractor$, null);
                of = ofExtractor$.get();
                continue;
            }
            if ("instance".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                InstanceExtractor instanceExtractor$ = new InstanceExtractor();
                annotationValue$.accept(instanceExtractor$, null);
                instance = instanceExtractor$.get();
                continue;
            }
            if ("builder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuilderExtractor builderExtractor$ = new BuilderExtractor();
                annotationValue$.accept(builderExtractor$, null);
                builder = builderExtractor$.get();
                continue;
            }
            if ("newBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                NewBuilderExtractor newBuilderExtractor$ = new NewBuilderExtractor();
                annotationValue$.accept(newBuilderExtractor$, null);
                newBuilder = newBuilderExtractor$.get();
                continue;
            }
            if ("from".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                FromExtractor fromExtractor$ = new FromExtractor();
                annotationValue$.accept(fromExtractor$, null);
                from = fromExtractor$.get();
                continue;
            }
            if ("build".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuildExtractor buildExtractor$ = new BuildExtractor();
                annotationValue$.accept(buildExtractor$, null);
                build = buildExtractor$.get();
                continue;
            }
            if ("buildOrThrow".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuildOrThrowExtractor buildOrThrowExtractor$ = new BuildOrThrowExtractor();
                annotationValue$.accept(buildOrThrowExtractor$, null);
                buildOrThrow = buildOrThrowExtractor$.get();
                continue;
            }
            if ("canBuild".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                CanBuildExtractor canBuildExtractor$ = new CanBuildExtractor();
                annotationValue$.accept(canBuildExtractor$, null);
                canBuild = canBuildExtractor$.get();
                continue;
            }
            if ("toBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ToBuilderExtractor toBuilderExtractor$ = new ToBuilderExtractor();
                annotationValue$.accept(toBuilderExtractor$, null);
                toBuilder = toBuilderExtractor$.get();
                continue;
            }
            if ("underrideHashCode".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                UnderrideHashCodeExtractor underrideHashCodeExtractor$ = new UnderrideHashCodeExtractor();
                annotationValue$.accept(underrideHashCodeExtractor$, null);
                underrideHashCode = underrideHashCodeExtractor$.get();
                continue;
            }
            if ("underrideEquals".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                UnderrideEqualsExtractor underrideEqualsExtractor$ = new UnderrideEqualsExtractor();
                annotationValue$.accept(underrideEqualsExtractor$, null);
                underrideEquals = underrideEqualsExtractor$.get();
                continue;
            }
            if ("underrideToString".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                UnderrideToStringExtractor underrideToStringExtractor$ = new UnderrideToStringExtractor();
                annotationValue$.accept(underrideToStringExtractor$, null);
                underrideToString = underrideToStringExtractor$.get();
                continue;
            }
            if ("delegateToString".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DelegateToStringExtractor delegateToStringExtractor$ = new DelegateToStringExtractor();
                annotationValue$.accept(delegateToStringExtractor$, null);
                delegateToString = delegateToStringExtractor$.get();
                continue;
            }
            if ("includeHashCode".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                IncludeHashCodeExtractor includeHashCodeExtractor$ = new IncludeHashCodeExtractor();
                annotationValue$.accept(includeHashCodeExtractor$, null);
                includeHashCode = includeHashCodeExtractor$.get();
                continue;
            }
            if ("isInitialized".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                IsInitializedExtractor isInitializedExtractor$ = new IsInitializedExtractor();
                annotationValue$.accept(isInitializedExtractor$, null);
                isInitialized = isInitializedExtractor$.get();
                continue;
            }
            if ("isSet".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                IsSetExtractor isSetExtractor$ = new IsSetExtractor();
                annotationValue$.accept(isSetExtractor$, null);
                isSet = isSetExtractor$.get();
                continue;
            }
            if ("set".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                SetExtractor setExtractor$ = new SetExtractor();
                annotationValue$.accept(setExtractor$, null);
                set = setExtractor$.get();
                continue;
            }
            if ("unset".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                UnsetExtractor unsetExtractor$ = new UnsetExtractor();
                annotationValue$.accept(unsetExtractor$, null);
                unset = unsetExtractor$.get();
                continue;
            }
            if ("clear".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ClearExtractor clearExtractor$ = new ClearExtractor();
                annotationValue$.accept(clearExtractor$, null);
                clear = clearExtractor$.get();
                continue;
            }
            if ("create".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                CreateExtractor createExtractor$ = new CreateExtractor();
                annotationValue$.accept(createExtractor$, null);
                create = createExtractor$.get();
                continue;
            }
            if ("toImmutable".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ToImmutableExtractor toImmutableExtractor$ = new ToImmutableExtractor();
                annotationValue$.accept(toImmutableExtractor$, null);
                toImmutable = toImmutableExtractor$.get();
                continue;
            }
            if ("typeBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeBuilderExtractor typeBuilderExtractor$ = new TypeBuilderExtractor();
                annotationValue$.accept(typeBuilderExtractor$, null);
                typeBuilder = typeBuilderExtractor$.get();
                continue;
            }
            if ("typeInnerBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeInnerBuilderExtractor typeInnerBuilderExtractor$ = new TypeInnerBuilderExtractor();
                annotationValue$.accept(typeInnerBuilderExtractor$, null);
                typeInnerBuilder = typeInnerBuilderExtractor$.get();
                continue;
            }
            if ("typeAbstract".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeAbstractExtractor typeAbstractExtractor$ = new TypeAbstractExtractor();
                annotationValue$.accept(typeAbstractExtractor$, null);
                typeAbstract = typeAbstractExtractor$.get();
                continue;
            }
            if ("typeImmutable".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableExtractor typeImmutableExtractor$ = new TypeImmutableExtractor();
                annotationValue$.accept(typeImmutableExtractor$, null);
                typeImmutable = typeImmutableExtractor$.get();
                continue;
            }
            if ("typeImmutableEnclosing".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableEnclosingExtractor typeImmutableEnclosingExtractor$ = new TypeImmutableEnclosingExtractor();
                annotationValue$.accept(typeImmutableEnclosingExtractor$, null);
                typeImmutableEnclosing = typeImmutableEnclosingExtractor$.get();
                continue;
            }
            if ("typeImmutableNested".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeImmutableNestedExtractor typeImmutableNestedExtractor$ = new TypeImmutableNestedExtractor();
                annotationValue$.accept(typeImmutableNestedExtractor$, null);
                typeImmutableNested = typeImmutableNestedExtractor$.get();
                continue;
            }
            if ("typeModifiable".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeModifiableExtractor typeModifiableExtractor$ = new TypeModifiableExtractor();
                annotationValue$.accept(typeModifiableExtractor$, null);
                typeModifiable = typeModifiableExtractor$.get();
                continue;
            }
            if ("typeInnerModifiable".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeInnerModifiableExtractor typeInnerModifiableExtractor$ = new TypeInnerModifiableExtractor();
                annotationValue$.accept(typeInnerModifiableExtractor$, null);
                typeInnerModifiable = typeInnerModifiableExtractor$.get();
                continue;
            }
            if ("typeWith".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TypeWithExtractor typeWithExtractor$ = new TypeWithExtractor();
                annotationValue$.accept(typeWithExtractor$, null);
                typeWith = typeWithExtractor$.get();
                continue;
            }
            if ("packageGenerated".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PackageGeneratedExtractor packageGeneratedExtractor$ = new PackageGeneratedExtractor();
                annotationValue$.accept(packageGeneratedExtractor$, null);
                packageGenerated = packageGeneratedExtractor$.get();
                continue;
            }
            if ("defaults".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DefaultsExtractor defaultsExtractor$ = new DefaultsExtractor();
                annotationValue$.accept(defaultsExtractor$, null);
                defaults = defaultsExtractor$.get();
                defaultsMirror = defaultsExtractor$.mirror();
                continue;
            }
            if ("strictBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                StrictBuilderExtractor strictBuilderExtractor$ = new StrictBuilderExtractor();
                annotationValue$.accept(strictBuilderExtractor$, null);
                strictBuilder = strictBuilderExtractor$.get();
                continue;
            }
            if ("validationMethod".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ValidationMethodExtractor validationMethodExtractor$ = new ValidationMethodExtractor();
                annotationValue$.accept(validationMethodExtractor$, null);
                validationMethod = validationMethodExtractor$.get();
                continue;
            }
            if ("allParameters".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AllParametersExtractor allParametersExtractor$ = new AllParametersExtractor();
                annotationValue$.accept(allParametersExtractor$, null);
                allParameters = allParametersExtractor$.get();
                continue;
            }
            if ("defaultAsDefault".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DefaultAsDefaultExtractor defaultAsDefaultExtractor$ = new DefaultAsDefaultExtractor();
                annotationValue$.accept(defaultAsDefaultExtractor$, null);
                defaultAsDefault = defaultAsDefaultExtractor$.get();
                continue;
            }
            if ("headerComments".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                HeaderCommentsExtractor headerCommentsExtractor$ = new HeaderCommentsExtractor();
                annotationValue$.accept(headerCommentsExtractor$, null);
                headerComments = headerCommentsExtractor$.get();
                continue;
            }
            if ("jdkOnly".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                JdkOnlyExtractor jdkOnlyExtractor$ = new JdkOnlyExtractor();
                annotationValue$.accept(jdkOnlyExtractor$, null);
                jdkOnly = jdkOnlyExtractor$.get();
                continue;
            }
            if ("passAnnotations".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PassAnnotationsExtractor passAnnotationsExtractor$ = new PassAnnotationsExtractor();
                annotationValue$.accept(passAnnotationsExtractor$, null);
                passAnnotations = passAnnotationsExtractor$.get();
                passAnnotationsName = passAnnotationsExtractor$.name();
                continue;
            }
            if ("additionalJsonAnnotations".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AdditionalJsonAnnotationsExtractor additionalJsonAnnotationsExtractor$ = new AdditionalJsonAnnotationsExtractor();
                annotationValue$.accept(additionalJsonAnnotationsExtractor$, null);
                additionalJsonAnnotations = additionalJsonAnnotationsExtractor$.get();
                additionalJsonAnnotationsName = additionalJsonAnnotationsExtractor$.name();
                continue;
            }
            if ("visibility".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                VisibilityExtractor visibilityExtractor$ = new VisibilityExtractor();
                annotationValue$.accept(visibilityExtractor$, null);
                visibility = visibilityExtractor$.get();
                continue;
            }
            if ("optionalAcceptNullable".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                OptionalAcceptNullableExtractor optionalAcceptNullableExtractor$ = new OptionalAcceptNullableExtractor();
                annotationValue$.accept(optionalAcceptNullableExtractor$, null);
                optionalAcceptNullable = optionalAcceptNullableExtractor$.get();
                continue;
            }
            if ("generateSuppressAllWarnings".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                GenerateSuppressAllWarningsExtractor generateSuppressAllWarningsExtractor$ = new GenerateSuppressAllWarningsExtractor();
                annotationValue$.accept(generateSuppressAllWarningsExtractor$, null);
                generateSuppressAllWarnings = generateSuppressAllWarningsExtractor$.get();
                continue;
            }
            if ("privateNoargConstructor".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                PrivateNoargConstructorExtractor privateNoargConstructorExtractor$ = new PrivateNoargConstructorExtractor();
                annotationValue$.accept(privateNoargConstructorExtractor$, null);
                privateNoargConstructor = privateNoargConstructorExtractor$.get();
                continue;
            }
            if ("protectedNoargConstructor".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ProtectedNoargConstructorExtractor protectedNoargConstructorExtractor$ = new ProtectedNoargConstructorExtractor();
                annotationValue$.accept(protectedNoargConstructorExtractor$, null);
                protectedNoargConstructor = protectedNoargConstructorExtractor$.get();
                continue;
            }
            if ("attributelessSingleton".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AttributelessSingletonExtractor attributelessSingletonExtractor$ = new AttributelessSingletonExtractor();
                annotationValue$.accept(attributelessSingletonExtractor$, null);
                attributelessSingleton = attributelessSingletonExtractor$.get();
                continue;
            }
            if ("unsafeDefaultAndDerived".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                UnsafeDefaultAndDerivedExtractor unsafeDefaultAndDerivedExtractor$ = new UnsafeDefaultAndDerivedExtractor();
                annotationValue$.accept(unsafeDefaultAndDerivedExtractor$, null);
                unsafeDefaultAndDerived = unsafeDefaultAndDerivedExtractor$.get();
                continue;
            }
            if ("clearBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ClearBuilderExtractor clearBuilderExtractor$ = new ClearBuilderExtractor();
                annotationValue$.accept(clearBuilderExtractor$, null);
                clearBuilder = clearBuilderExtractor$.get();
                continue;
            }
            if ("deferCollectionAllocation".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DeferCollectionAllocationExtractor deferCollectionAllocationExtractor$ = new DeferCollectionAllocationExtractor();
                annotationValue$.accept(deferCollectionAllocationExtractor$, null);
                deferCollectionAllocation = deferCollectionAllocationExtractor$.get();
                continue;
            }
            if ("deepImmutablesDetection".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DeepImmutablesDetectionExtractor deepImmutablesDetectionExtractor$ = new DeepImmutablesDetectionExtractor();
                annotationValue$.accept(deepImmutablesDetectionExtractor$, null);
                deepImmutablesDetection = deepImmutablesDetectionExtractor$.get();
                continue;
            }
            if ("overshadowImplementation".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                OvershadowImplementationExtractor overshadowImplementationExtractor$ = new OvershadowImplementationExtractor();
                annotationValue$.accept(overshadowImplementationExtractor$, null);
                overshadowImplementation = overshadowImplementationExtractor$.get();
                continue;
            }
            if ("implementationNestedInBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ImplementationNestedInBuilderExtractor implementationNestedInBuilderExtractor$ = new ImplementationNestedInBuilderExtractor();
                annotationValue$.accept(implementationNestedInBuilderExtractor$, null);
                implementationNestedInBuilder = implementationNestedInBuilderExtractor$.get();
                continue;
            }
            if ("forceJacksonPropertyNames".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ForceJacksonPropertyNamesExtractor forceJacksonPropertyNamesExtractor$ = new ForceJacksonPropertyNamesExtractor();
                annotationValue$.accept(forceJacksonPropertyNamesExtractor$, null);
                forceJacksonPropertyNames = forceJacksonPropertyNamesExtractor$.get();
                continue;
            }
            if ("forceJacksonIgnoreFields".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ForceJacksonIgnoreFieldsExtractor forceJacksonIgnoreFieldsExtractor$ = new ForceJacksonIgnoreFieldsExtractor();
                annotationValue$.accept(forceJacksonIgnoreFieldsExtractor$, null);
                forceJacksonIgnoreFields = forceJacksonIgnoreFieldsExtractor$.get();
                continue;
            }
            if ("forceEqualsInWithers".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ForceEqualsInWithersExtractor forceEqualsInWithersExtractor$ = new ForceEqualsInWithersExtractor();
                annotationValue$.accept(forceEqualsInWithersExtractor$, null);
                forceEqualsInWithers = forceEqualsInWithersExtractor$.get();
                continue;
            }
            if ("jacksonIntegration".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                JacksonIntegrationExtractor jacksonIntegrationExtractor$ = new JacksonIntegrationExtractor();
                annotationValue$.accept(jacksonIntegrationExtractor$, null);
                jacksonIntegration = jacksonIntegrationExtractor$.get();
                continue;
            }
            if ("weakInterning".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                WeakInterningExtractor weakInterningExtractor$ = new WeakInterningExtractor();
                annotationValue$.accept(weakInterningExtractor$, null);
                weakInterning = weakInterningExtractor$.get();
                continue;
            }
            if ("alwaysPublicInitializers".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AlwaysPublicInitializersExtractor alwaysPublicInitializersExtractor$ = new AlwaysPublicInitializersExtractor();
                annotationValue$.accept(alwaysPublicInitializersExtractor$, null);
                alwaysPublicInitializers = alwaysPublicInitializersExtractor$.get();
                continue;
            }
            if ("builderVisibility".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuilderVisibilityExtractor builderVisibilityExtractor$ = new BuilderVisibilityExtractor();
                annotationValue$.accept(builderVisibilityExtractor$, null);
                builderVisibility = builderVisibilityExtractor$.get();
                continue;
            }
            if ("throwForInvalidImmutableState".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ThrowForInvalidImmutableStateExtractor throwForInvalidImmutableStateExtractor$ = new ThrowForInvalidImmutableStateExtractor();
                annotationValue$.accept(throwForInvalidImmutableStateExtractor$, null);
                throwForInvalidImmutableState = throwForInvalidImmutableStateExtractor$.get();
                throwForInvalidImmutableStateName = throwForInvalidImmutableStateExtractor$.name();
                continue;
            }
            if ("throwForNullPointer".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ThrowForNullPointerExtractor throwForNullPointerExtractor$ = new ThrowForNullPointerExtractor();
                annotationValue$.accept(throwForNullPointerExtractor$, null);
                throwForNullPointer = throwForNullPointerExtractor$.get();
                throwForNullPointerName = throwForNullPointerExtractor$.name();
                continue;
            }
            if ("depluralize".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DepluralizeExtractor depluralizeExtractor$ = new DepluralizeExtractor();
                annotationValue$.accept(depluralizeExtractor$, null);
                depluralize = depluralizeExtractor$.get();
                continue;
            }
            if ("depluralizeDictionary".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                DepluralizeDictionaryExtractor depluralizeDictionaryExtractor$ = new DepluralizeDictionaryExtractor();
                annotationValue$.accept(depluralizeDictionaryExtractor$, null);
                depluralizeDictionary = depluralizeDictionaryExtractor$.get();
                continue;
            }
            if ("immutableCopyOfRoutines".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                ImmutableCopyOfRoutinesExtractor immutableCopyOfRoutinesExtractor$ = new ImmutableCopyOfRoutinesExtractor();
                annotationValue$.accept(immutableCopyOfRoutinesExtractor$, null);
                immutableCopyOfRoutines = immutableCopyOfRoutinesExtractor$.get();
                immutableCopyOfRoutinesName = immutableCopyOfRoutinesExtractor$.name();
                continue;
            }
            if ("stagedBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                StagedBuilderExtractor stagedBuilderExtractor$ = new StagedBuilderExtractor();
                annotationValue$.accept(stagedBuilderExtractor$, null);
                stagedBuilder = stagedBuilderExtractor$.get();
                continue;
            }
            if ("builtinContainerAttributes".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BuiltinContainerAttributesExtractor builtinContainerAttributesExtractor$ = new BuiltinContainerAttributesExtractor();
                annotationValue$.accept(builtinContainerAttributesExtractor$, null);
                builtinContainerAttributes = builtinContainerAttributesExtractor$.get();
                continue;
            }
            if ("beanFriendlyModifiables".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                BeanFriendlyModifiablesExtractor beanFriendlyModifiablesExtractor$ = new BeanFriendlyModifiablesExtractor();
                annotationValue$.accept(beanFriendlyModifiablesExtractor$, null);
                beanFriendlyModifiables = beanFriendlyModifiablesExtractor$.get();
                continue;
            }
            if ("allMandatoryParameters".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AllMandatoryParametersExtractor allMandatoryParametersExtractor$ = new AllMandatoryParametersExtractor();
                annotationValue$.accept(allMandatoryParametersExtractor$, null);
                allMandatoryParameters = allMandatoryParametersExtractor$.get();
                continue;
            }
            if ("redactedMask".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                RedactedMaskExtractor redactedMaskExtractor$ = new RedactedMaskExtractor();
                annotationValue$.accept(redactedMaskExtractor$, null);
                redactedMask = redactedMaskExtractor$.get();
                continue;
            }
            if ("attributeBuilderDetection".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AttributeBuilderDetectionExtractor attributeBuilderDetectionExtractor$ = new AttributeBuilderDetectionExtractor();
                annotationValue$.accept(attributeBuilderDetectionExtractor$, null);
                attributeBuilderDetection = attributeBuilderDetectionExtractor$.get();
                continue;
            }
            if ("transientDerivedFields".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                TransientDerivedFieldsExtractor transientDerivedFieldsExtractor$ = new TransientDerivedFieldsExtractor();
                annotationValue$.accept(transientDerivedFieldsExtractor$, null);
                transientDerivedFields = transientDerivedFieldsExtractor$.get();
                continue;
            }
            if ("finalInstanceFields".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                FinalInstanceFieldsExtractor finalInstanceFieldsExtractor$ = new FinalInstanceFieldsExtractor();
                annotationValue$.accept(finalInstanceFieldsExtractor$, null);
                finalInstanceFields = finalInstanceFieldsExtractor$.get();
                continue;
            }
            if ("attributeBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AttributeBuilderExtractor attributeBuilderExtractor$ = new AttributeBuilderExtractor();
                annotationValue$.accept(attributeBuilderExtractor$, null);
                attributeBuilder = attributeBuilderExtractor$.get();
                continue;
            }
            if ("getBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                GetBuilderExtractor getBuilderExtractor$ = new GetBuilderExtractor();
                annotationValue$.accept(getBuilderExtractor$, null);
                getBuilder = getBuilderExtractor$.get();
                continue;
            }
            if ("setBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                SetBuilderExtractor setBuilderExtractor$ = new SetBuilderExtractor();
                annotationValue$.accept(setBuilderExtractor$, null);
                setBuilder = setBuilderExtractor$.get();
                continue;
            }
            if ("addBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddBuilderExtractor addBuilderExtractor$ = new AddBuilderExtractor();
                annotationValue$.accept(addBuilderExtractor$, null);
                addBuilder = addBuilderExtractor$.get();
                continue;
            }
            if ("addAllBuilder".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AddAllBuilderExtractor addAllBuilderExtractor$ = new AddAllBuilderExtractor();
                annotationValue$.accept(addAllBuilderExtractor$, null);
                addAllBuilder = addAllBuilderExtractor$.get();
                continue;
            }
            if ("getBuilders".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                GetBuildersExtractor getBuildersExtractor$ = new GetBuildersExtractor();
                annotationValue$.accept(getBuildersExtractor$, null);
                getBuilders = getBuildersExtractor$.get();
                continue;
            }
            if ("nullableAnnotation".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                NullableAnnotationExtractor nullableAnnotationExtractor$ = new NullableAnnotationExtractor();
                annotationValue$.accept(nullableAnnotationExtractor$, null);
                nullableAnnotation = nullableAnnotationExtractor$.get();
                continue;
            }
            if ("limitStringLengthInToString".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                LimitStringLengthInToStringExtractor limitStringLengthInToStringExtractor$ = new LimitStringLengthInToStringExtractor();
                annotationValue$.accept(limitStringLengthInToStringExtractor$, null);
                limitStringLengthInToString = limitStringLengthInToStringExtractor$.get();
                continue;
            }
            if ("allowedClasspathAnnotations".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                AllowedClasspathAnnotationsExtractor allowedClasspathAnnotationsExtractor$ = new AllowedClasspathAnnotationsExtractor();
                annotationValue$.accept(allowedClasspathAnnotationsExtractor$, null);
                allowedClasspathAnnotations = allowedClasspathAnnotationsExtractor$.get();
                allowedClasspathAnnotationsName = allowedClasspathAnnotationsExtractor$.name();
                continue;
            }
            if ("fallbackNullableAnnotation".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
                }
                FallbackNullableAnnotationExtractor fallbackNullableAnnotationExtractor$ = new FallbackNullableAnnotationExtractor();
                annotationValue$.accept(fallbackNullableAnnotationExtractor$, null);
                fallbackNullableAnnotation = fallbackNullableAnnotationExtractor$.get();
                fallbackNullableAnnotationName = fallbackNullableAnnotationExtractor$.name();
                continue;
            }
            if (!"jakarta".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Style");
            }
            JakartaExtractor jakartaExtractor$ = new JakartaExtractor();
            annotationValue$.accept(jakartaExtractor$, null);
            jakarta = jakartaExtractor$.get();
        }
        this.get = (String[])Preconditions.checkNotNull(get, (Object)"default attribute 'get'");
        this.init = (String)Preconditions.checkNotNull(init, (Object)"default attribute 'init'");
        this.with = (String)Preconditions.checkNotNull(with, (Object)"default attribute 'with'");
        this.withUnaryOperator = (String)Preconditions.checkNotNull(withUnaryOperator, (Object)"default attribute 'withUnaryOperator'");
        this.add = (String)Preconditions.checkNotNull(add, (Object)"default attribute 'add'");
        this.addAll = (String)Preconditions.checkNotNull(addAll, (Object)"default attribute 'addAll'");
        this.put = (String)Preconditions.checkNotNull(put, (Object)"default attribute 'put'");
        this.putAll = (String)Preconditions.checkNotNull(putAll, (Object)"default attribute 'putAll'");
        this.copyOf = (String)Preconditions.checkNotNull(copyOf, (Object)"default attribute 'copyOf'");
        this.of = (String)Preconditions.checkNotNull(of, (Object)"default attribute 'of'");
        this.instance = (String)Preconditions.checkNotNull(instance, (Object)"default attribute 'instance'");
        this.builder = (String)Preconditions.checkNotNull(builder, (Object)"default attribute 'builder'");
        this.newBuilder = (String)Preconditions.checkNotNull(newBuilder, (Object)"default attribute 'newBuilder'");
        this.from = (String)Preconditions.checkNotNull((Object)from, (Object)"default attribute 'from'");
        this.build = (String)Preconditions.checkNotNull((Object)build, (Object)"default attribute 'build'");
        this.buildOrThrow = (String)Preconditions.checkNotNull((Object)buildOrThrow, (Object)"default attribute 'buildOrThrow'");
        this.canBuild = (String)Preconditions.checkNotNull((Object)canBuild, (Object)"default attribute 'canBuild'");
        this.toBuilder = (String)Preconditions.checkNotNull((Object)toBuilder, (Object)"default attribute 'toBuilder'");
        this.underrideHashCode = (String)Preconditions.checkNotNull((Object)underrideHashCode, (Object)"default attribute 'underrideHashCode'");
        this.underrideEquals = (String)Preconditions.checkNotNull((Object)underrideEquals, (Object)"default attribute 'underrideEquals'");
        this.underrideToString = (String)Preconditions.checkNotNull((Object)underrideToString, (Object)"default attribute 'underrideToString'");
        this.delegateToString = (String)Preconditions.checkNotNull((Object)delegateToString, (Object)"default attribute 'delegateToString'");
        this.includeHashCode = (String)Preconditions.checkNotNull((Object)includeHashCode, (Object)"default attribute 'includeHashCode'");
        this.isInitialized = (String)Preconditions.checkNotNull((Object)isInitialized, (Object)"default attribute 'isInitialized'");
        this.isSet = (String)Preconditions.checkNotNull((Object)isSet, (Object)"default attribute 'isSet'");
        this.set = (String)Preconditions.checkNotNull((Object)set, (Object)"default attribute 'set'");
        this.unset = (String)Preconditions.checkNotNull((Object)unset, (Object)"default attribute 'unset'");
        this.clear = (String)Preconditions.checkNotNull((Object)clear, (Object)"default attribute 'clear'");
        this.create = (String)Preconditions.checkNotNull((Object)create, (Object)"default attribute 'create'");
        this.toImmutable = (String)Preconditions.checkNotNull((Object)toImmutable, (Object)"default attribute 'toImmutable'");
        this.typeBuilder = (String)Preconditions.checkNotNull((Object)typeBuilder, (Object)"default attribute 'typeBuilder'");
        this.typeInnerBuilder = (String)Preconditions.checkNotNull((Object)typeInnerBuilder, (Object)"default attribute 'typeInnerBuilder'");
        this.typeAbstract = (String[])Preconditions.checkNotNull((Object)typeAbstract, (Object)"default attribute 'typeAbstract'");
        this.typeImmutable = (String)Preconditions.checkNotNull((Object)typeImmutable, (Object)"default attribute 'typeImmutable'");
        this.typeImmutableEnclosing = (String)Preconditions.checkNotNull((Object)typeImmutableEnclosing, (Object)"default attribute 'typeImmutableEnclosing'");
        this.typeImmutableNested = (String)Preconditions.checkNotNull((Object)typeImmutableNested, (Object)"default attribute 'typeImmutableNested'");
        this.typeModifiable = (String)Preconditions.checkNotNull((Object)typeModifiable, (Object)"default attribute 'typeModifiable'");
        this.typeInnerModifiable = (String)Preconditions.checkNotNull((Object)typeInnerModifiable, (Object)"default attribute 'typeInnerModifiable'");
        this.typeWith = (String)Preconditions.checkNotNull((Object)typeWith, (Object)"default attribute 'typeWith'");
        this.packageGenerated = (String)Preconditions.checkNotNull((Object)packageGenerated, (Object)"default attribute 'packageGenerated'");
        this.defaults = (AnnotationMirror)Preconditions.checkNotNull((Object)defaults, (Object)"default attribute 'defaults'");
        this.defaultsMirror = (ImmutableMirror)Preconditions.checkNotNull((Object)defaultsMirror, (Object)"default attribute 'defaults'");
        this.strictBuilder = strictBuilder;
        this.validationMethod = (ValueMirrors.Style.ValidationMethod)((Object)Preconditions.checkNotNull((Object)((Object)validationMethod), (Object)"default attribute 'validationMethod'"));
        this.allParameters = allParameters;
        this.defaultAsDefault = defaultAsDefault;
        this.headerComments = headerComments;
        this.jdkOnly = jdkOnly;
        this.passAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)passAnnotations, (Object)"default attribute 'passAnnotations'");
        this.passAnnotationsName = (String[])Preconditions.checkNotNull((Object)passAnnotationsName, (Object)"default attribute 'passAnnotations'");
        this.additionalJsonAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)additionalJsonAnnotations, (Object)"default attribute 'additionalJsonAnnotations'");
        this.additionalJsonAnnotationsName = (String[])Preconditions.checkNotNull((Object)additionalJsonAnnotationsName, (Object)"default attribute 'additionalJsonAnnotations'");
        this.visibility = (ValueMirrors.Style.ImplementationVisibility)((Object)Preconditions.checkNotNull((Object)((Object)visibility), (Object)"default attribute 'visibility'"));
        this.optionalAcceptNullable = optionalAcceptNullable;
        this.generateSuppressAllWarnings = generateSuppressAllWarnings;
        this.privateNoargConstructor = privateNoargConstructor;
        this.protectedNoargConstructor = protectedNoargConstructor;
        this.attributelessSingleton = attributelessSingleton;
        this.unsafeDefaultAndDerived = unsafeDefaultAndDerived;
        this.clearBuilder = clearBuilder;
        this.deferCollectionAllocation = deferCollectionAllocation;
        this.deepImmutablesDetection = deepImmutablesDetection;
        this.overshadowImplementation = overshadowImplementation;
        this.implementationNestedInBuilder = implementationNestedInBuilder;
        this.forceJacksonPropertyNames = forceJacksonPropertyNames;
        this.forceJacksonIgnoreFields = forceJacksonIgnoreFields;
        this.forceEqualsInWithers = forceEqualsInWithers;
        this.jacksonIntegration = jacksonIntegration;
        this.weakInterning = weakInterning;
        this.alwaysPublicInitializers = alwaysPublicInitializers;
        this.builderVisibility = (ValueMirrors.Style.BuilderVisibility)((Object)Preconditions.checkNotNull((Object)((Object)builderVisibility), (Object)"default attribute 'builderVisibility'"));
        this.throwForInvalidImmutableState = (TypeMirror)Preconditions.checkNotNull((Object)throwForInvalidImmutableState, (Object)"default attribute 'throwForInvalidImmutableState'");
        this.throwForInvalidImmutableStateName = (String)Preconditions.checkNotNull((Object)throwForInvalidImmutableStateName, (Object)"default attribute 'throwForInvalidImmutableState'");
        this.throwForNullPointer = (TypeMirror)Preconditions.checkNotNull((Object)throwForNullPointer, (Object)"default attribute 'throwForNullPointer'");
        this.throwForNullPointerName = (String)Preconditions.checkNotNull((Object)throwForNullPointerName, (Object)"default attribute 'throwForNullPointer'");
        this.depluralize = depluralize;
        this.depluralizeDictionary = (String[])Preconditions.checkNotNull((Object)depluralizeDictionary, (Object)"default attribute 'depluralizeDictionary'");
        this.immutableCopyOfRoutines = (TypeMirror[])Preconditions.checkNotNull((Object)immutableCopyOfRoutines, (Object)"default attribute 'immutableCopyOfRoutines'");
        this.immutableCopyOfRoutinesName = (String[])Preconditions.checkNotNull((Object)immutableCopyOfRoutinesName, (Object)"default attribute 'immutableCopyOfRoutines'");
        this.stagedBuilder = stagedBuilder;
        this.builtinContainerAttributes = builtinContainerAttributes;
        this.beanFriendlyModifiables = beanFriendlyModifiables;
        this.allMandatoryParameters = allMandatoryParameters;
        this.redactedMask = (String)Preconditions.checkNotNull((Object)redactedMask, (Object)"default attribute 'redactedMask'");
        this.attributeBuilderDetection = attributeBuilderDetection;
        this.transientDerivedFields = transientDerivedFields;
        this.finalInstanceFields = finalInstanceFields;
        this.attributeBuilder = (String[])Preconditions.checkNotNull((Object)attributeBuilder, (Object)"default attribute 'attributeBuilder'");
        this.getBuilder = (String)Preconditions.checkNotNull((Object)getBuilder, (Object)"default attribute 'getBuilder'");
        this.setBuilder = (String)Preconditions.checkNotNull((Object)setBuilder, (Object)"default attribute 'setBuilder'");
        this.addBuilder = (String)Preconditions.checkNotNull((Object)addBuilder, (Object)"default attribute 'addBuilder'");
        this.addAllBuilder = (String)Preconditions.checkNotNull((Object)addAllBuilder, (Object)"default attribute 'addAllBuilder'");
        this.getBuilders = (String)Preconditions.checkNotNull((Object)getBuilders, (Object)"default attribute 'getBuilders'");
        this.nullableAnnotation = (String)Preconditions.checkNotNull((Object)nullableAnnotation, (Object)"default attribute 'nullableAnnotation'");
        this.limitStringLengthInToString = limitStringLengthInToString;
        this.allowedClasspathAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)allowedClasspathAnnotations, (Object)"default attribute 'allowedClasspathAnnotations'");
        this.allowedClasspathAnnotationsName = (String[])Preconditions.checkNotNull((Object)allowedClasspathAnnotationsName, (Object)"default attribute 'allowedClasspathAnnotations'");
        this.fallbackNullableAnnotation = (TypeMirror)Preconditions.checkNotNull((Object)fallbackNullableAnnotation, (Object)"default attribute 'fallbackNullableAnnotation'");
        this.fallbackNullableAnnotationName = (String)Preconditions.checkNotNull((Object)fallbackNullableAnnotationName, (Object)"default attribute 'fallbackNullableAnnotation'");
        this.jakarta = jakarta;
    }

    private StyleMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String[] get = null;
        String init = null;
        String with = null;
        String withUnaryOperator = null;
        String add = null;
        String addAll = null;
        String put = null;
        String putAll = null;
        String copyOf = null;
        String of = null;
        String instance = null;
        String builder = null;
        String newBuilder = null;
        String from = null;
        String build = null;
        String buildOrThrow = null;
        String canBuild = null;
        String toBuilder = null;
        String underrideHashCode = null;
        String underrideEquals = null;
        String underrideToString = null;
        String delegateToString = null;
        String includeHashCode = null;
        String isInitialized = null;
        String isSet = null;
        String set = null;
        String unset = null;
        String clear = null;
        String create = null;
        String toImmutable = null;
        String typeBuilder = null;
        String typeInnerBuilder = null;
        String[] typeAbstract = null;
        String typeImmutable = null;
        String typeImmutableEnclosing = null;
        String typeImmutableNested = null;
        String typeModifiable = null;
        String typeInnerModifiable = null;
        String typeWith = null;
        String packageGenerated = null;
        AnnotationMirror defaults = null;
        ImmutableMirror defaultsMirror = null;
        boolean strictBuilder = false;
        ValueMirrors.Style.ValidationMethod validationMethod = null;
        boolean allParameters = false;
        boolean defaultAsDefault = false;
        boolean headerComments = false;
        boolean jdkOnly = false;
        TypeMirror[] passAnnotations = null;
        String[] passAnnotationsName = null;
        TypeMirror[] additionalJsonAnnotations = null;
        String[] additionalJsonAnnotationsName = null;
        ValueMirrors.Style.ImplementationVisibility visibility = null;
        boolean optionalAcceptNullable = false;
        boolean generateSuppressAllWarnings = false;
        boolean privateNoargConstructor = false;
        boolean protectedNoargConstructor = false;
        boolean attributelessSingleton = false;
        boolean unsafeDefaultAndDerived = false;
        boolean clearBuilder = false;
        boolean deferCollectionAllocation = false;
        boolean deepImmutablesDetection = false;
        boolean overshadowImplementation = false;
        boolean implementationNestedInBuilder = false;
        boolean forceJacksonPropertyNames = false;
        boolean forceJacksonIgnoreFields = false;
        boolean forceEqualsInWithers = false;
        boolean jacksonIntegration = false;
        boolean weakInterning = false;
        boolean alwaysPublicInitializers = false;
        ValueMirrors.Style.BuilderVisibility builderVisibility = null;
        TypeMirror throwForInvalidImmutableState = null;
        String throwForInvalidImmutableStateName = null;
        TypeMirror throwForNullPointer = null;
        String throwForNullPointerName = null;
        boolean depluralize = false;
        String[] depluralizeDictionary = null;
        TypeMirror[] immutableCopyOfRoutines = null;
        String[] immutableCopyOfRoutinesName = null;
        boolean stagedBuilder = false;
        boolean builtinContainerAttributes = false;
        boolean beanFriendlyModifiables = false;
        boolean allMandatoryParameters = false;
        String redactedMask = null;
        boolean attributeBuilderDetection = false;
        boolean transientDerivedFields = false;
        boolean finalInstanceFields = false;
        String[] attributeBuilder = null;
        String getBuilder = null;
        String setBuilder = null;
        String addBuilder = null;
        String addAllBuilder = null;
        String getBuilders = null;
        String nullableAnnotation = null;
        int limitStringLengthInToString = 0;
        TypeMirror[] allowedClasspathAnnotations = null;
        String[] allowedClasspathAnnotationsName = null;
        TypeMirror fallbackNullableAnnotation = null;
        String fallbackNullableAnnotationName = null;
        boolean jakarta = false;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("get".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'get' attribute of @Style");
                }
                GetExtractor getExtractor$ = new GetExtractor();
                annotationValue$.accept(getExtractor$, null);
                get = getExtractor$.get();
                continue;
            }
            if ("init".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'init' attribute of @Style");
                }
                InitExtractor initExtractor$ = new InitExtractor();
                annotationValue$.accept(initExtractor$, null);
                init = initExtractor$.get();
                continue;
            }
            if ("with".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'with' attribute of @Style");
                }
                WithExtractor withExtractor$ = new WithExtractor();
                annotationValue$.accept(withExtractor$, null);
                with = withExtractor$.get();
                continue;
            }
            if ("withUnaryOperator".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'withUnaryOperator' attribute of @Style");
                }
                WithUnaryOperatorExtractor withUnaryOperatorExtractor$ = new WithUnaryOperatorExtractor();
                annotationValue$.accept(withUnaryOperatorExtractor$, null);
                withUnaryOperator = withUnaryOperatorExtractor$.get();
                continue;
            }
            if ("add".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'add' attribute of @Style");
                }
                AddExtractor addExtractor$ = new AddExtractor();
                annotationValue$.accept(addExtractor$, null);
                add = addExtractor$.get();
                continue;
            }
            if ("addAll".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'addAll' attribute of @Style");
                }
                AddAllExtractor addAllExtractor$ = new AddAllExtractor();
                annotationValue$.accept(addAllExtractor$, null);
                addAll = addAllExtractor$.get();
                continue;
            }
            if ("put".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'put' attribute of @Style");
                }
                PutExtractor putExtractor$ = new PutExtractor();
                annotationValue$.accept(putExtractor$, null);
                put = putExtractor$.get();
                continue;
            }
            if ("putAll".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'putAll' attribute of @Style");
                }
                PutAllExtractor putAllExtractor$ = new PutAllExtractor();
                annotationValue$.accept(putAllExtractor$, null);
                putAll = putAllExtractor$.get();
                continue;
            }
            if ("copyOf".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'copyOf' attribute of @Style");
                }
                CopyOfExtractor copyOfExtractor$ = new CopyOfExtractor();
                annotationValue$.accept(copyOfExtractor$, null);
                copyOf = copyOfExtractor$.get();
                continue;
            }
            if ("of".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'of' attribute of @Style");
                }
                OfExtractor ofExtractor$ = new OfExtractor();
                annotationValue$.accept(ofExtractor$, null);
                of = ofExtractor$.get();
                continue;
            }
            if ("instance".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'instance' attribute of @Style");
                }
                InstanceExtractor instanceExtractor$ = new InstanceExtractor();
                annotationValue$.accept(instanceExtractor$, null);
                instance = instanceExtractor$.get();
                continue;
            }
            if ("builder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'builder' attribute of @Style");
                }
                BuilderExtractor builderExtractor$ = new BuilderExtractor();
                annotationValue$.accept(builderExtractor$, null);
                builder = builderExtractor$.get();
                continue;
            }
            if ("newBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'newBuilder' attribute of @Style");
                }
                NewBuilderExtractor newBuilderExtractor$ = new NewBuilderExtractor();
                annotationValue$.accept(newBuilderExtractor$, null);
                newBuilder = newBuilderExtractor$.get();
                continue;
            }
            if ("from".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'from' attribute of @Style");
                }
                FromExtractor fromExtractor$ = new FromExtractor();
                annotationValue$.accept(fromExtractor$, null);
                from = fromExtractor$.get();
                continue;
            }
            if ("build".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'build' attribute of @Style");
                }
                BuildExtractor buildExtractor$ = new BuildExtractor();
                annotationValue$.accept(buildExtractor$, null);
                build = buildExtractor$.get();
                continue;
            }
            if ("buildOrThrow".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'buildOrThrow' attribute of @Style");
                }
                BuildOrThrowExtractor buildOrThrowExtractor$ = new BuildOrThrowExtractor();
                annotationValue$.accept(buildOrThrowExtractor$, null);
                buildOrThrow = buildOrThrowExtractor$.get();
                continue;
            }
            if ("canBuild".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'canBuild' attribute of @Style");
                }
                CanBuildExtractor canBuildExtractor$ = new CanBuildExtractor();
                annotationValue$.accept(canBuildExtractor$, null);
                canBuild = canBuildExtractor$.get();
                continue;
            }
            if ("toBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'toBuilder' attribute of @Style");
                }
                ToBuilderExtractor toBuilderExtractor$ = new ToBuilderExtractor();
                annotationValue$.accept(toBuilderExtractor$, null);
                toBuilder = toBuilderExtractor$.get();
                continue;
            }
            if ("underrideHashCode".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'underrideHashCode' attribute of @Style");
                }
                UnderrideHashCodeExtractor underrideHashCodeExtractor$ = new UnderrideHashCodeExtractor();
                annotationValue$.accept(underrideHashCodeExtractor$, null);
                underrideHashCode = underrideHashCodeExtractor$.get();
                continue;
            }
            if ("underrideEquals".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'underrideEquals' attribute of @Style");
                }
                UnderrideEqualsExtractor underrideEqualsExtractor$ = new UnderrideEqualsExtractor();
                annotationValue$.accept(underrideEqualsExtractor$, null);
                underrideEquals = underrideEqualsExtractor$.get();
                continue;
            }
            if ("underrideToString".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'underrideToString' attribute of @Style");
                }
                UnderrideToStringExtractor underrideToStringExtractor$ = new UnderrideToStringExtractor();
                annotationValue$.accept(underrideToStringExtractor$, null);
                underrideToString = underrideToStringExtractor$.get();
                continue;
            }
            if ("delegateToString".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'delegateToString' attribute of @Style");
                }
                DelegateToStringExtractor delegateToStringExtractor$ = new DelegateToStringExtractor();
                annotationValue$.accept(delegateToStringExtractor$, null);
                delegateToString = delegateToStringExtractor$.get();
                continue;
            }
            if ("includeHashCode".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'includeHashCode' attribute of @Style");
                }
                IncludeHashCodeExtractor includeHashCodeExtractor$ = new IncludeHashCodeExtractor();
                annotationValue$.accept(includeHashCodeExtractor$, null);
                includeHashCode = includeHashCodeExtractor$.get();
                continue;
            }
            if ("isInitialized".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'isInitialized' attribute of @Style");
                }
                IsInitializedExtractor isInitializedExtractor$ = new IsInitializedExtractor();
                annotationValue$.accept(isInitializedExtractor$, null);
                isInitialized = isInitializedExtractor$.get();
                continue;
            }
            if ("isSet".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'isSet' attribute of @Style");
                }
                IsSetExtractor isSetExtractor$ = new IsSetExtractor();
                annotationValue$.accept(isSetExtractor$, null);
                isSet = isSetExtractor$.get();
                continue;
            }
            if ("set".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'set' attribute of @Style");
                }
                SetExtractor setExtractor$ = new SetExtractor();
                annotationValue$.accept(setExtractor$, null);
                set = setExtractor$.get();
                continue;
            }
            if ("unset".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'unset' attribute of @Style");
                }
                UnsetExtractor unsetExtractor$ = new UnsetExtractor();
                annotationValue$.accept(unsetExtractor$, null);
                unset = unsetExtractor$.get();
                continue;
            }
            if ("clear".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'clear' attribute of @Style");
                }
                ClearExtractor clearExtractor$ = new ClearExtractor();
                annotationValue$.accept(clearExtractor$, null);
                clear = clearExtractor$.get();
                continue;
            }
            if ("create".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'create' attribute of @Style");
                }
                CreateExtractor createExtractor$ = new CreateExtractor();
                annotationValue$.accept(createExtractor$, null);
                create = createExtractor$.get();
                continue;
            }
            if ("toImmutable".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'toImmutable' attribute of @Style");
                }
                ToImmutableExtractor toImmutableExtractor$ = new ToImmutableExtractor();
                annotationValue$.accept(toImmutableExtractor$, null);
                toImmutable = toImmutableExtractor$.get();
                continue;
            }
            if ("typeBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeBuilder' attribute of @Style");
                }
                TypeBuilderExtractor typeBuilderExtractor$ = new TypeBuilderExtractor();
                annotationValue$.accept(typeBuilderExtractor$, null);
                typeBuilder = typeBuilderExtractor$.get();
                continue;
            }
            if ("typeInnerBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeInnerBuilder' attribute of @Style");
                }
                TypeInnerBuilderExtractor typeInnerBuilderExtractor$ = new TypeInnerBuilderExtractor();
                annotationValue$.accept(typeInnerBuilderExtractor$, null);
                typeInnerBuilder = typeInnerBuilderExtractor$.get();
                continue;
            }
            if ("typeAbstract".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeAbstract' attribute of @Style");
                }
                TypeAbstractExtractor typeAbstractExtractor$ = new TypeAbstractExtractor();
                annotationValue$.accept(typeAbstractExtractor$, null);
                typeAbstract = typeAbstractExtractor$.get();
                continue;
            }
            if ("typeImmutable".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutable' attribute of @Style");
                }
                TypeImmutableExtractor typeImmutableExtractor$ = new TypeImmutableExtractor();
                annotationValue$.accept(typeImmutableExtractor$, null);
                typeImmutable = typeImmutableExtractor$.get();
                continue;
            }
            if ("typeImmutableEnclosing".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutableEnclosing' attribute of @Style");
                }
                TypeImmutableEnclosingExtractor typeImmutableEnclosingExtractor$ = new TypeImmutableEnclosingExtractor();
                annotationValue$.accept(typeImmutableEnclosingExtractor$, null);
                typeImmutableEnclosing = typeImmutableEnclosingExtractor$.get();
                continue;
            }
            if ("typeImmutableNested".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeImmutableNested' attribute of @Style");
                }
                TypeImmutableNestedExtractor typeImmutableNestedExtractor$ = new TypeImmutableNestedExtractor();
                annotationValue$.accept(typeImmutableNestedExtractor$, null);
                typeImmutableNested = typeImmutableNestedExtractor$.get();
                continue;
            }
            if ("typeModifiable".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeModifiable' attribute of @Style");
                }
                TypeModifiableExtractor typeModifiableExtractor$ = new TypeModifiableExtractor();
                annotationValue$.accept(typeModifiableExtractor$, null);
                typeModifiable = typeModifiableExtractor$.get();
                continue;
            }
            if ("typeInnerModifiable".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeInnerModifiable' attribute of @Style");
                }
                TypeInnerModifiableExtractor typeInnerModifiableExtractor$ = new TypeInnerModifiableExtractor();
                annotationValue$.accept(typeInnerModifiableExtractor$, null);
                typeInnerModifiable = typeInnerModifiableExtractor$.get();
                continue;
            }
            if ("typeWith".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeWith' attribute of @Style");
                }
                TypeWithExtractor typeWithExtractor$ = new TypeWithExtractor();
                annotationValue$.accept(typeWithExtractor$, null);
                typeWith = typeWithExtractor$.get();
                continue;
            }
            if ("packageGenerated".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'packageGenerated' attribute of @Style");
                }
                PackageGeneratedExtractor packageGeneratedExtractor$ = new PackageGeneratedExtractor();
                annotationValue$.accept(packageGeneratedExtractor$, null);
                packageGenerated = packageGeneratedExtractor$.get();
                continue;
            }
            if ("defaults".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'defaults' attribute of @Style");
                }
                DefaultsExtractor defaultsExtractor$ = new DefaultsExtractor();
                annotationValue$.accept(defaultsExtractor$, null);
                defaults = defaultsExtractor$.get();
                defaultsMirror = defaultsExtractor$.mirror();
                continue;
            }
            if ("strictBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'strictBuilder' attribute of @Style");
                }
                StrictBuilderExtractor strictBuilderExtractor$ = new StrictBuilderExtractor();
                annotationValue$.accept(strictBuilderExtractor$, null);
                strictBuilder = strictBuilderExtractor$.get();
                continue;
            }
            if ("validationMethod".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'validationMethod' attribute of @Style");
                }
                ValidationMethodExtractor validationMethodExtractor$ = new ValidationMethodExtractor();
                annotationValue$.accept(validationMethodExtractor$, null);
                validationMethod = validationMethodExtractor$.get();
                continue;
            }
            if ("allParameters".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'allParameters' attribute of @Style");
                }
                AllParametersExtractor allParametersExtractor$ = new AllParametersExtractor();
                annotationValue$.accept(allParametersExtractor$, null);
                allParameters = allParametersExtractor$.get();
                continue;
            }
            if ("defaultAsDefault".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'defaultAsDefault' attribute of @Style");
                }
                DefaultAsDefaultExtractor defaultAsDefaultExtractor$ = new DefaultAsDefaultExtractor();
                annotationValue$.accept(defaultAsDefaultExtractor$, null);
                defaultAsDefault = defaultAsDefaultExtractor$.get();
                continue;
            }
            if ("headerComments".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'headerComments' attribute of @Style");
                }
                HeaderCommentsExtractor headerCommentsExtractor$ = new HeaderCommentsExtractor();
                annotationValue$.accept(headerCommentsExtractor$, null);
                headerComments = headerCommentsExtractor$.get();
                continue;
            }
            if ("jdkOnly".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'jdkOnly' attribute of @Style");
                }
                JdkOnlyExtractor jdkOnlyExtractor$ = new JdkOnlyExtractor();
                annotationValue$.accept(jdkOnlyExtractor$, null);
                jdkOnly = jdkOnlyExtractor$.get();
                continue;
            }
            if ("passAnnotations".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'passAnnotations' attribute of @Style");
                }
                PassAnnotationsExtractor passAnnotationsExtractor$ = new PassAnnotationsExtractor();
                annotationValue$.accept(passAnnotationsExtractor$, null);
                passAnnotations = passAnnotationsExtractor$.get();
                passAnnotationsName = passAnnotationsExtractor$.name();
                continue;
            }
            if ("additionalJsonAnnotations".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'additionalJsonAnnotations' attribute of @Style");
                }
                AdditionalJsonAnnotationsExtractor additionalJsonAnnotationsExtractor$ = new AdditionalJsonAnnotationsExtractor();
                annotationValue$.accept(additionalJsonAnnotationsExtractor$, null);
                additionalJsonAnnotations = additionalJsonAnnotationsExtractor$.get();
                additionalJsonAnnotationsName = additionalJsonAnnotationsExtractor$.name();
                continue;
            }
            if ("visibility".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'visibility' attribute of @Style");
                }
                VisibilityExtractor visibilityExtractor$ = new VisibilityExtractor();
                annotationValue$.accept(visibilityExtractor$, null);
                visibility = visibilityExtractor$.get();
                continue;
            }
            if ("optionalAcceptNullable".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'optionalAcceptNullable' attribute of @Style");
                }
                OptionalAcceptNullableExtractor optionalAcceptNullableExtractor$ = new OptionalAcceptNullableExtractor();
                annotationValue$.accept(optionalAcceptNullableExtractor$, null);
                optionalAcceptNullable = optionalAcceptNullableExtractor$.get();
                continue;
            }
            if ("generateSuppressAllWarnings".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'generateSuppressAllWarnings' attribute of @Style");
                }
                GenerateSuppressAllWarningsExtractor generateSuppressAllWarningsExtractor$ = new GenerateSuppressAllWarningsExtractor();
                annotationValue$.accept(generateSuppressAllWarningsExtractor$, null);
                generateSuppressAllWarnings = generateSuppressAllWarningsExtractor$.get();
                continue;
            }
            if ("privateNoargConstructor".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'privateNoargConstructor' attribute of @Style");
                }
                PrivateNoargConstructorExtractor privateNoargConstructorExtractor$ = new PrivateNoargConstructorExtractor();
                annotationValue$.accept(privateNoargConstructorExtractor$, null);
                privateNoargConstructor = privateNoargConstructorExtractor$.get();
                continue;
            }
            if ("protectedNoargConstructor".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'protectedNoargConstructor' attribute of @Style");
                }
                ProtectedNoargConstructorExtractor protectedNoargConstructorExtractor$ = new ProtectedNoargConstructorExtractor();
                annotationValue$.accept(protectedNoargConstructorExtractor$, null);
                protectedNoargConstructor = protectedNoargConstructorExtractor$.get();
                continue;
            }
            if ("attributelessSingleton".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'attributelessSingleton' attribute of @Style");
                }
                AttributelessSingletonExtractor attributelessSingletonExtractor$ = new AttributelessSingletonExtractor();
                annotationValue$.accept(attributelessSingletonExtractor$, null);
                attributelessSingleton = attributelessSingletonExtractor$.get();
                continue;
            }
            if ("unsafeDefaultAndDerived".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'unsafeDefaultAndDerived' attribute of @Style");
                }
                UnsafeDefaultAndDerivedExtractor unsafeDefaultAndDerivedExtractor$ = new UnsafeDefaultAndDerivedExtractor();
                annotationValue$.accept(unsafeDefaultAndDerivedExtractor$, null);
                unsafeDefaultAndDerived = unsafeDefaultAndDerivedExtractor$.get();
                continue;
            }
            if ("clearBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'clearBuilder' attribute of @Style");
                }
                ClearBuilderExtractor clearBuilderExtractor$ = new ClearBuilderExtractor();
                annotationValue$.accept(clearBuilderExtractor$, null);
                clearBuilder = clearBuilderExtractor$.get();
                continue;
            }
            if ("deferCollectionAllocation".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'deferCollectionAllocation' attribute of @Style");
                }
                DeferCollectionAllocationExtractor deferCollectionAllocationExtractor$ = new DeferCollectionAllocationExtractor();
                annotationValue$.accept(deferCollectionAllocationExtractor$, null);
                deferCollectionAllocation = deferCollectionAllocationExtractor$.get();
                continue;
            }
            if ("deepImmutablesDetection".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'deepImmutablesDetection' attribute of @Style");
                }
                DeepImmutablesDetectionExtractor deepImmutablesDetectionExtractor$ = new DeepImmutablesDetectionExtractor();
                annotationValue$.accept(deepImmutablesDetectionExtractor$, null);
                deepImmutablesDetection = deepImmutablesDetectionExtractor$.get();
                continue;
            }
            if ("overshadowImplementation".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'overshadowImplementation' attribute of @Style");
                }
                OvershadowImplementationExtractor overshadowImplementationExtractor$ = new OvershadowImplementationExtractor();
                annotationValue$.accept(overshadowImplementationExtractor$, null);
                overshadowImplementation = overshadowImplementationExtractor$.get();
                continue;
            }
            if ("implementationNestedInBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'implementationNestedInBuilder' attribute of @Style");
                }
                ImplementationNestedInBuilderExtractor implementationNestedInBuilderExtractor$ = new ImplementationNestedInBuilderExtractor();
                annotationValue$.accept(implementationNestedInBuilderExtractor$, null);
                implementationNestedInBuilder = implementationNestedInBuilderExtractor$.get();
                continue;
            }
            if ("forceJacksonPropertyNames".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'forceJacksonPropertyNames' attribute of @Style");
                }
                ForceJacksonPropertyNamesExtractor forceJacksonPropertyNamesExtractor$ = new ForceJacksonPropertyNamesExtractor();
                annotationValue$.accept(forceJacksonPropertyNamesExtractor$, null);
                forceJacksonPropertyNames = forceJacksonPropertyNamesExtractor$.get();
                continue;
            }
            if ("forceJacksonIgnoreFields".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'forceJacksonIgnoreFields' attribute of @Style");
                }
                ForceJacksonIgnoreFieldsExtractor forceJacksonIgnoreFieldsExtractor$ = new ForceJacksonIgnoreFieldsExtractor();
                annotationValue$.accept(forceJacksonIgnoreFieldsExtractor$, null);
                forceJacksonIgnoreFields = forceJacksonIgnoreFieldsExtractor$.get();
                continue;
            }
            if ("forceEqualsInWithers".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'forceEqualsInWithers' attribute of @Style");
                }
                ForceEqualsInWithersExtractor forceEqualsInWithersExtractor$ = new ForceEqualsInWithersExtractor();
                annotationValue$.accept(forceEqualsInWithersExtractor$, null);
                forceEqualsInWithers = forceEqualsInWithersExtractor$.get();
                continue;
            }
            if ("jacksonIntegration".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'jacksonIntegration' attribute of @Style");
                }
                JacksonIntegrationExtractor jacksonIntegrationExtractor$ = new JacksonIntegrationExtractor();
                annotationValue$.accept(jacksonIntegrationExtractor$, null);
                jacksonIntegration = jacksonIntegrationExtractor$.get();
                continue;
            }
            if ("weakInterning".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'weakInterning' attribute of @Style");
                }
                WeakInterningExtractor weakInterningExtractor$ = new WeakInterningExtractor();
                annotationValue$.accept(weakInterningExtractor$, null);
                weakInterning = weakInterningExtractor$.get();
                continue;
            }
            if ("alwaysPublicInitializers".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'alwaysPublicInitializers' attribute of @Style");
                }
                AlwaysPublicInitializersExtractor alwaysPublicInitializersExtractor$ = new AlwaysPublicInitializersExtractor();
                annotationValue$.accept(alwaysPublicInitializersExtractor$, null);
                alwaysPublicInitializers = alwaysPublicInitializersExtractor$.get();
                continue;
            }
            if ("builderVisibility".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'builderVisibility' attribute of @Style");
                }
                BuilderVisibilityExtractor builderVisibilityExtractor$ = new BuilderVisibilityExtractor();
                annotationValue$.accept(builderVisibilityExtractor$, null);
                builderVisibility = builderVisibilityExtractor$.get();
                continue;
            }
            if ("throwForInvalidImmutableState".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'throwForInvalidImmutableState' attribute of @Style");
                }
                ThrowForInvalidImmutableStateExtractor throwForInvalidImmutableStateExtractor$ = new ThrowForInvalidImmutableStateExtractor();
                annotationValue$.accept(throwForInvalidImmutableStateExtractor$, null);
                throwForInvalidImmutableState = throwForInvalidImmutableStateExtractor$.get();
                throwForInvalidImmutableStateName = throwForInvalidImmutableStateExtractor$.name();
                continue;
            }
            if ("throwForNullPointer".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'throwForNullPointer' attribute of @Style");
                }
                ThrowForNullPointerExtractor throwForNullPointerExtractor$ = new ThrowForNullPointerExtractor();
                annotationValue$.accept(throwForNullPointerExtractor$, null);
                throwForNullPointer = throwForNullPointerExtractor$.get();
                throwForNullPointerName = throwForNullPointerExtractor$.name();
                continue;
            }
            if ("depluralize".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'depluralize' attribute of @Style");
                }
                DepluralizeExtractor depluralizeExtractor$ = new DepluralizeExtractor();
                annotationValue$.accept(depluralizeExtractor$, null);
                depluralize = depluralizeExtractor$.get();
                continue;
            }
            if ("depluralizeDictionary".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'depluralizeDictionary' attribute of @Style");
                }
                DepluralizeDictionaryExtractor depluralizeDictionaryExtractor$ = new DepluralizeDictionaryExtractor();
                annotationValue$.accept(depluralizeDictionaryExtractor$, null);
                depluralizeDictionary = depluralizeDictionaryExtractor$.get();
                continue;
            }
            if ("immutableCopyOfRoutines".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'immutableCopyOfRoutines' attribute of @Style");
                }
                ImmutableCopyOfRoutinesExtractor immutableCopyOfRoutinesExtractor$ = new ImmutableCopyOfRoutinesExtractor();
                annotationValue$.accept(immutableCopyOfRoutinesExtractor$, null);
                immutableCopyOfRoutines = immutableCopyOfRoutinesExtractor$.get();
                immutableCopyOfRoutinesName = immutableCopyOfRoutinesExtractor$.name();
                continue;
            }
            if ("stagedBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'stagedBuilder' attribute of @Style");
                }
                StagedBuilderExtractor stagedBuilderExtractor$ = new StagedBuilderExtractor();
                annotationValue$.accept(stagedBuilderExtractor$, null);
                stagedBuilder = stagedBuilderExtractor$.get();
                continue;
            }
            if ("builtinContainerAttributes".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'builtinContainerAttributes' attribute of @Style");
                }
                BuiltinContainerAttributesExtractor builtinContainerAttributesExtractor$ = new BuiltinContainerAttributesExtractor();
                annotationValue$.accept(builtinContainerAttributesExtractor$, null);
                builtinContainerAttributes = builtinContainerAttributesExtractor$.get();
                continue;
            }
            if ("beanFriendlyModifiables".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'beanFriendlyModifiables' attribute of @Style");
                }
                BeanFriendlyModifiablesExtractor beanFriendlyModifiablesExtractor$ = new BeanFriendlyModifiablesExtractor();
                annotationValue$.accept(beanFriendlyModifiablesExtractor$, null);
                beanFriendlyModifiables = beanFriendlyModifiablesExtractor$.get();
                continue;
            }
            if ("allMandatoryParameters".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'allMandatoryParameters' attribute of @Style");
                }
                AllMandatoryParametersExtractor allMandatoryParametersExtractor$ = new AllMandatoryParametersExtractor();
                annotationValue$.accept(allMandatoryParametersExtractor$, null);
                allMandatoryParameters = allMandatoryParametersExtractor$.get();
                continue;
            }
            if ("redactedMask".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'redactedMask' attribute of @Style");
                }
                RedactedMaskExtractor redactedMaskExtractor$ = new RedactedMaskExtractor();
                annotationValue$.accept(redactedMaskExtractor$, null);
                redactedMask = redactedMaskExtractor$.get();
                continue;
            }
            if ("attributeBuilderDetection".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'attributeBuilderDetection' attribute of @Style");
                }
                AttributeBuilderDetectionExtractor attributeBuilderDetectionExtractor$ = new AttributeBuilderDetectionExtractor();
                annotationValue$.accept(attributeBuilderDetectionExtractor$, null);
                attributeBuilderDetection = attributeBuilderDetectionExtractor$.get();
                continue;
            }
            if ("transientDerivedFields".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'transientDerivedFields' attribute of @Style");
                }
                TransientDerivedFieldsExtractor transientDerivedFieldsExtractor$ = new TransientDerivedFieldsExtractor();
                annotationValue$.accept(transientDerivedFieldsExtractor$, null);
                transientDerivedFields = transientDerivedFieldsExtractor$.get();
                continue;
            }
            if ("finalInstanceFields".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'finalInstanceFields' attribute of @Style");
                }
                FinalInstanceFieldsExtractor finalInstanceFieldsExtractor$ = new FinalInstanceFieldsExtractor();
                annotationValue$.accept(finalInstanceFieldsExtractor$, null);
                finalInstanceFields = finalInstanceFieldsExtractor$.get();
                continue;
            }
            if ("attributeBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'attributeBuilder' attribute of @Style");
                }
                AttributeBuilderExtractor attributeBuilderExtractor$ = new AttributeBuilderExtractor();
                annotationValue$.accept(attributeBuilderExtractor$, null);
                attributeBuilder = attributeBuilderExtractor$.get();
                continue;
            }
            if ("getBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'getBuilder' attribute of @Style");
                }
                GetBuilderExtractor getBuilderExtractor$ = new GetBuilderExtractor();
                annotationValue$.accept(getBuilderExtractor$, null);
                getBuilder = getBuilderExtractor$.get();
                continue;
            }
            if ("setBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'setBuilder' attribute of @Style");
                }
                SetBuilderExtractor setBuilderExtractor$ = new SetBuilderExtractor();
                annotationValue$.accept(setBuilderExtractor$, null);
                setBuilder = setBuilderExtractor$.get();
                continue;
            }
            if ("addBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'addBuilder' attribute of @Style");
                }
                AddBuilderExtractor addBuilderExtractor$ = new AddBuilderExtractor();
                annotationValue$.accept(addBuilderExtractor$, null);
                addBuilder = addBuilderExtractor$.get();
                continue;
            }
            if ("addAllBuilder".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'addAllBuilder' attribute of @Style");
                }
                AddAllBuilderExtractor addAllBuilderExtractor$ = new AddAllBuilderExtractor();
                annotationValue$.accept(addAllBuilderExtractor$, null);
                addAllBuilder = addAllBuilderExtractor$.get();
                continue;
            }
            if ("getBuilders".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'getBuilders' attribute of @Style");
                }
                GetBuildersExtractor getBuildersExtractor$ = new GetBuildersExtractor();
                annotationValue$.accept(getBuildersExtractor$, null);
                getBuilders = getBuildersExtractor$.get();
                continue;
            }
            if ("nullableAnnotation".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'nullableAnnotation' attribute of @Style");
                }
                NullableAnnotationExtractor nullableAnnotationExtractor$ = new NullableAnnotationExtractor();
                annotationValue$.accept(nullableAnnotationExtractor$, null);
                nullableAnnotation = nullableAnnotationExtractor$.get();
                continue;
            }
            if ("limitStringLengthInToString".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'limitStringLengthInToString' attribute of @Style");
                }
                LimitStringLengthInToStringExtractor limitStringLengthInToStringExtractor$ = new LimitStringLengthInToStringExtractor();
                annotationValue$.accept(limitStringLengthInToStringExtractor$, null);
                limitStringLengthInToString = limitStringLengthInToStringExtractor$.get();
                continue;
            }
            if ("allowedClasspathAnnotations".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'allowedClasspathAnnotations' attribute of @Style");
                }
                AllowedClasspathAnnotationsExtractor allowedClasspathAnnotationsExtractor$ = new AllowedClasspathAnnotationsExtractor();
                annotationValue$.accept(allowedClasspathAnnotationsExtractor$, null);
                allowedClasspathAnnotations = allowedClasspathAnnotationsExtractor$.get();
                allowedClasspathAnnotationsName = allowedClasspathAnnotationsExtractor$.name();
                continue;
            }
            if ("fallbackNullableAnnotation".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'fallbackNullableAnnotation' attribute of @Style");
                }
                FallbackNullableAnnotationExtractor fallbackNullableAnnotationExtractor$ = new FallbackNullableAnnotationExtractor();
                annotationValue$.accept(fallbackNullableAnnotationExtractor$, null);
                fallbackNullableAnnotation = fallbackNullableAnnotationExtractor$.get();
                fallbackNullableAnnotationName = fallbackNullableAnnotationExtractor$.name();
                continue;
            }
            if (!"jakarta".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'jakarta' attribute of @Style");
            }
            JakartaExtractor jakartaExtractor$ = new JakartaExtractor();
            annotationValue$.accept(jakartaExtractor$, null);
            jakarta = jakartaExtractor$.get();
        }
        this.get = (String[])Preconditions.checkNotNull(get, (Object)"value for 'get'");
        this.init = (String)Preconditions.checkNotNull(init, (Object)"value for 'init'");
        this.with = (String)Preconditions.checkNotNull(with, (Object)"value for 'with'");
        this.withUnaryOperator = (String)Preconditions.checkNotNull(withUnaryOperator, (Object)"value for 'withUnaryOperator'");
        this.add = (String)Preconditions.checkNotNull(add, (Object)"value for 'add'");
        this.addAll = (String)Preconditions.checkNotNull(addAll, (Object)"value for 'addAll'");
        this.put = (String)Preconditions.checkNotNull(put, (Object)"value for 'put'");
        this.putAll = (String)Preconditions.checkNotNull(putAll, (Object)"value for 'putAll'");
        this.copyOf = (String)Preconditions.checkNotNull(copyOf, (Object)"value for 'copyOf'");
        this.of = (String)Preconditions.checkNotNull(of, (Object)"value for 'of'");
        this.instance = (String)Preconditions.checkNotNull(instance, (Object)"value for 'instance'");
        this.builder = (String)Preconditions.checkNotNull(builder, (Object)"value for 'builder'");
        this.newBuilder = (String)Preconditions.checkNotNull(newBuilder, (Object)"value for 'newBuilder'");
        this.from = (String)Preconditions.checkNotNull(from, (Object)"value for 'from'");
        this.build = (String)Preconditions.checkNotNull(build, (Object)"value for 'build'");
        this.buildOrThrow = (String)Preconditions.checkNotNull((Object)buildOrThrow, (Object)"value for 'buildOrThrow'");
        this.canBuild = (String)Preconditions.checkNotNull((Object)canBuild, (Object)"value for 'canBuild'");
        this.toBuilder = (String)Preconditions.checkNotNull((Object)toBuilder, (Object)"value for 'toBuilder'");
        this.underrideHashCode = (String)Preconditions.checkNotNull((Object)underrideHashCode, (Object)"value for 'underrideHashCode'");
        this.underrideEquals = (String)Preconditions.checkNotNull((Object)underrideEquals, (Object)"value for 'underrideEquals'");
        this.underrideToString = (String)Preconditions.checkNotNull((Object)underrideToString, (Object)"value for 'underrideToString'");
        this.delegateToString = (String)Preconditions.checkNotNull((Object)delegateToString, (Object)"value for 'delegateToString'");
        this.includeHashCode = (String)Preconditions.checkNotNull((Object)includeHashCode, (Object)"value for 'includeHashCode'");
        this.isInitialized = (String)Preconditions.checkNotNull((Object)isInitialized, (Object)"value for 'isInitialized'");
        this.isSet = (String)Preconditions.checkNotNull((Object)isSet, (Object)"value for 'isSet'");
        this.set = (String)Preconditions.checkNotNull((Object)set, (Object)"value for 'set'");
        this.unset = (String)Preconditions.checkNotNull((Object)unset, (Object)"value for 'unset'");
        this.clear = (String)Preconditions.checkNotNull((Object)clear, (Object)"value for 'clear'");
        this.create = (String)Preconditions.checkNotNull((Object)create, (Object)"value for 'create'");
        this.toImmutable = (String)Preconditions.checkNotNull((Object)toImmutable, (Object)"value for 'toImmutable'");
        this.typeBuilder = (String)Preconditions.checkNotNull((Object)typeBuilder, (Object)"value for 'typeBuilder'");
        this.typeInnerBuilder = (String)Preconditions.checkNotNull((Object)typeInnerBuilder, (Object)"value for 'typeInnerBuilder'");
        this.typeAbstract = (String[])Preconditions.checkNotNull((Object)typeAbstract, (Object)"value for 'typeAbstract'");
        this.typeImmutable = (String)Preconditions.checkNotNull((Object)typeImmutable, (Object)"value for 'typeImmutable'");
        this.typeImmutableEnclosing = (String)Preconditions.checkNotNull((Object)typeImmutableEnclosing, (Object)"value for 'typeImmutableEnclosing'");
        this.typeImmutableNested = (String)Preconditions.checkNotNull((Object)typeImmutableNested, (Object)"value for 'typeImmutableNested'");
        this.typeModifiable = (String)Preconditions.checkNotNull((Object)typeModifiable, (Object)"value for 'typeModifiable'");
        this.typeInnerModifiable = (String)Preconditions.checkNotNull((Object)typeInnerModifiable, (Object)"value for 'typeInnerModifiable'");
        this.typeWith = (String)Preconditions.checkNotNull((Object)typeWith, (Object)"value for 'typeWith'");
        this.packageGenerated = (String)Preconditions.checkNotNull((Object)packageGenerated, (Object)"value for 'packageGenerated'");
        this.defaults = (AnnotationMirror)Preconditions.checkNotNull((Object)defaults, (Object)"value for 'defaults'");
        this.defaultsMirror = (ImmutableMirror)Preconditions.checkNotNull((Object)defaultsMirror, (Object)"value for 'defaults'");
        this.strictBuilder = strictBuilder;
        this.validationMethod = (ValueMirrors.Style.ValidationMethod)((Object)Preconditions.checkNotNull((Object)((Object)validationMethod), (Object)"value for 'validationMethod'"));
        this.allParameters = allParameters;
        this.defaultAsDefault = defaultAsDefault;
        this.headerComments = headerComments;
        this.jdkOnly = jdkOnly;
        this.passAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)passAnnotations, (Object)"value for 'passAnnotations'");
        this.passAnnotationsName = (String[])Preconditions.checkNotNull((Object)passAnnotationsName, (Object)"Value for 'passAnnotations'");
        this.additionalJsonAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)additionalJsonAnnotations, (Object)"value for 'additionalJsonAnnotations'");
        this.additionalJsonAnnotationsName = (String[])Preconditions.checkNotNull((Object)additionalJsonAnnotationsName, (Object)"Value for 'additionalJsonAnnotations'");
        this.visibility = (ValueMirrors.Style.ImplementationVisibility)((Object)Preconditions.checkNotNull((Object)((Object)visibility), (Object)"value for 'visibility'"));
        this.optionalAcceptNullable = optionalAcceptNullable;
        this.generateSuppressAllWarnings = generateSuppressAllWarnings;
        this.privateNoargConstructor = privateNoargConstructor;
        this.protectedNoargConstructor = protectedNoargConstructor;
        this.attributelessSingleton = attributelessSingleton;
        this.unsafeDefaultAndDerived = unsafeDefaultAndDerived;
        this.clearBuilder = clearBuilder;
        this.deferCollectionAllocation = deferCollectionAllocation;
        this.deepImmutablesDetection = deepImmutablesDetection;
        this.overshadowImplementation = overshadowImplementation;
        this.implementationNestedInBuilder = implementationNestedInBuilder;
        this.forceJacksonPropertyNames = forceJacksonPropertyNames;
        this.forceJacksonIgnoreFields = forceJacksonIgnoreFields;
        this.forceEqualsInWithers = forceEqualsInWithers;
        this.jacksonIntegration = jacksonIntegration;
        this.weakInterning = weakInterning;
        this.alwaysPublicInitializers = alwaysPublicInitializers;
        this.builderVisibility = (ValueMirrors.Style.BuilderVisibility)((Object)Preconditions.checkNotNull((Object)((Object)builderVisibility), (Object)"value for 'builderVisibility'"));
        this.throwForInvalidImmutableState = (TypeMirror)Preconditions.checkNotNull((Object)throwForInvalidImmutableState, (Object)"value for 'throwForInvalidImmutableState'");
        this.throwForInvalidImmutableStateName = (String)Preconditions.checkNotNull((Object)throwForInvalidImmutableStateName, (Object)"Value for 'throwForInvalidImmutableState'");
        this.throwForNullPointer = (TypeMirror)Preconditions.checkNotNull((Object)throwForNullPointer, (Object)"value for 'throwForNullPointer'");
        this.throwForNullPointerName = (String)Preconditions.checkNotNull((Object)throwForNullPointerName, (Object)"Value for 'throwForNullPointer'");
        this.depluralize = depluralize;
        this.depluralizeDictionary = (String[])Preconditions.checkNotNull((Object)depluralizeDictionary, (Object)"value for 'depluralizeDictionary'");
        this.immutableCopyOfRoutines = (TypeMirror[])Preconditions.checkNotNull((Object)immutableCopyOfRoutines, (Object)"value for 'immutableCopyOfRoutines'");
        this.immutableCopyOfRoutinesName = (String[])Preconditions.checkNotNull((Object)immutableCopyOfRoutinesName, (Object)"Value for 'immutableCopyOfRoutines'");
        this.stagedBuilder = stagedBuilder;
        this.builtinContainerAttributes = builtinContainerAttributes;
        this.beanFriendlyModifiables = beanFriendlyModifiables;
        this.allMandatoryParameters = allMandatoryParameters;
        this.redactedMask = (String)Preconditions.checkNotNull((Object)redactedMask, (Object)"value for 'redactedMask'");
        this.attributeBuilderDetection = attributeBuilderDetection;
        this.transientDerivedFields = transientDerivedFields;
        this.finalInstanceFields = finalInstanceFields;
        this.attributeBuilder = (String[])Preconditions.checkNotNull((Object)attributeBuilder, (Object)"value for 'attributeBuilder'");
        this.getBuilder = (String)Preconditions.checkNotNull((Object)getBuilder, (Object)"value for 'getBuilder'");
        this.setBuilder = (String)Preconditions.checkNotNull((Object)setBuilder, (Object)"value for 'setBuilder'");
        this.addBuilder = (String)Preconditions.checkNotNull((Object)addBuilder, (Object)"value for 'addBuilder'");
        this.addAllBuilder = (String)Preconditions.checkNotNull((Object)addAllBuilder, (Object)"value for 'addAllBuilder'");
        this.getBuilders = (String)Preconditions.checkNotNull((Object)getBuilders, (Object)"value for 'getBuilders'");
        this.nullableAnnotation = (String)Preconditions.checkNotNull((Object)nullableAnnotation, (Object)"value for 'nullableAnnotation'");
        this.limitStringLengthInToString = limitStringLengthInToString;
        this.allowedClasspathAnnotations = (TypeMirror[])Preconditions.checkNotNull((Object)allowedClasspathAnnotations, (Object)"value for 'allowedClasspathAnnotations'");
        this.allowedClasspathAnnotationsName = (String[])Preconditions.checkNotNull((Object)allowedClasspathAnnotationsName, (Object)"Value for 'allowedClasspathAnnotations'");
        this.fallbackNullableAnnotation = (TypeMirror)Preconditions.checkNotNull((Object)fallbackNullableAnnotation, (Object)"value for 'fallbackNullableAnnotation'");
        this.fallbackNullableAnnotationName = (String)Preconditions.checkNotNull((Object)fallbackNullableAnnotationName, (Object)"Value for 'fallbackNullableAnnotation'");
        this.jakarta = jakarta;
    }

    @Override
    public String[] get() {
        return (String[])this.get.clone();
    }

    @Override
    public String init() {
        return this.init;
    }

    @Override
    public String with() {
        return this.with;
    }

    @Override
    public String withUnaryOperator() {
        return this.withUnaryOperator;
    }

    @Override
    public String add() {
        return this.add;
    }

    @Override
    public String addAll() {
        return this.addAll;
    }

    @Override
    public String put() {
        return this.put;
    }

    @Override
    public String putAll() {
        return this.putAll;
    }

    @Override
    public String copyOf() {
        return this.copyOf;
    }

    @Override
    public String of() {
        return this.of;
    }

    @Override
    public String instance() {
        return this.instance;
    }

    @Override
    public String builder() {
        return this.builder;
    }

    @Override
    public String newBuilder() {
        return this.newBuilder;
    }

    @Override
    public String from() {
        return this.from;
    }

    @Override
    public String build() {
        return this.build;
    }

    @Override
    public String buildOrThrow() {
        return this.buildOrThrow;
    }

    @Override
    public String canBuild() {
        return this.canBuild;
    }

    @Override
    public String toBuilder() {
        return this.toBuilder;
    }

    @Override
    public String underrideHashCode() {
        return this.underrideHashCode;
    }

    @Override
    public String underrideEquals() {
        return this.underrideEquals;
    }

    @Override
    public String underrideToString() {
        return this.underrideToString;
    }

    @Override
    public String delegateToString() {
        return this.delegateToString;
    }

    @Override
    public String includeHashCode() {
        return this.includeHashCode;
    }

    @Override
    public String isInitialized() {
        return this.isInitialized;
    }

    @Override
    public String isSet() {
        return this.isSet;
    }

    @Override
    public String set() {
        return this.set;
    }

    @Override
    public String unset() {
        return this.unset;
    }

    @Override
    public String clear() {
        return this.clear;
    }

    @Override
    public String create() {
        return this.create;
    }

    @Override
    public String toImmutable() {
        return this.toImmutable;
    }

    @Override
    public String typeBuilder() {
        return this.typeBuilder;
    }

    @Override
    public String typeInnerBuilder() {
        return this.typeInnerBuilder;
    }

    @Override
    public String[] typeAbstract() {
        return (String[])this.typeAbstract.clone();
    }

    @Override
    public String typeImmutable() {
        return this.typeImmutable;
    }

    @Override
    public String typeImmutableEnclosing() {
        return this.typeImmutableEnclosing;
    }

    @Override
    public String typeImmutableNested() {
        return this.typeImmutableNested;
    }

    @Override
    public String typeModifiable() {
        return this.typeModifiable;
    }

    @Override
    public String typeInnerModifiable() {
        return this.typeInnerModifiable;
    }

    @Override
    public String typeWith() {
        return this.typeWith;
    }

    @Override
    public String packageGenerated() {
        return this.packageGenerated;
    }

    public AnnotationMirror defaultsMirror() {
        return this.defaults;
    }

    @Override
    public ImmutableMirror defaults() {
        return this.defaultsMirror;
    }

    @Override
    public boolean strictBuilder() {
        return this.strictBuilder;
    }

    @Override
    public ValueMirrors.Style.ValidationMethod validationMethod() {
        return this.validationMethod;
    }

    @Override
    public boolean allParameters() {
        return this.allParameters;
    }

    @Override
    public boolean defaultAsDefault() {
        return this.defaultAsDefault;
    }

    @Override
    public boolean headerComments() {
        return this.headerComments;
    }

    @Override
    public boolean jdkOnly() {
        return this.jdkOnly;
    }

    public String[] passAnnotationsName() {
        return (String[])this.passAnnotationsName.clone();
    }

    public TypeMirror[] passAnnotationsMirror() {
        return (TypeMirror[])this.passAnnotations.clone();
    }

    @Override
    @Deprecated
    public Class<? extends Annotation>[] passAnnotations() {
        throw new UnsupportedOperationException("Use 'passAnnotationsMirror()' or 'passAnnotationsName()'");
    }

    public String[] additionalJsonAnnotationsName() {
        return (String[])this.additionalJsonAnnotationsName.clone();
    }

    public TypeMirror[] additionalJsonAnnotationsMirror() {
        return (TypeMirror[])this.additionalJsonAnnotations.clone();
    }

    @Override
    @Deprecated
    public Class<? extends Annotation>[] additionalJsonAnnotations() {
        throw new UnsupportedOperationException("Use 'additionalJsonAnnotationsMirror()' or 'additionalJsonAnnotationsName()'");
    }

    @Override
    public ValueMirrors.Style.ImplementationVisibility visibility() {
        return this.visibility;
    }

    @Override
    public boolean optionalAcceptNullable() {
        return this.optionalAcceptNullable;
    }

    @Override
    public boolean generateSuppressAllWarnings() {
        return this.generateSuppressAllWarnings;
    }

    @Override
    public boolean privateNoargConstructor() {
        return this.privateNoargConstructor;
    }

    @Override
    public boolean protectedNoargConstructor() {
        return this.protectedNoargConstructor;
    }

    @Override
    public boolean attributelessSingleton() {
        return this.attributelessSingleton;
    }

    @Override
    public boolean unsafeDefaultAndDerived() {
        return this.unsafeDefaultAndDerived;
    }

    @Override
    public boolean clearBuilder() {
        return this.clearBuilder;
    }

    @Override
    public boolean deferCollectionAllocation() {
        return this.deferCollectionAllocation;
    }

    @Override
    public boolean deepImmutablesDetection() {
        return this.deepImmutablesDetection;
    }

    @Override
    public boolean overshadowImplementation() {
        return this.overshadowImplementation;
    }

    @Override
    public boolean implementationNestedInBuilder() {
        return this.implementationNestedInBuilder;
    }

    @Override
    public boolean forceJacksonPropertyNames() {
        return this.forceJacksonPropertyNames;
    }

    @Override
    public boolean forceJacksonIgnoreFields() {
        return this.forceJacksonIgnoreFields;
    }

    @Override
    public boolean forceEqualsInWithers() {
        return this.forceEqualsInWithers;
    }

    @Override
    public boolean jacksonIntegration() {
        return this.jacksonIntegration;
    }

    @Override
    public boolean weakInterning() {
        return this.weakInterning;
    }

    @Override
    public boolean alwaysPublicInitializers() {
        return this.alwaysPublicInitializers;
    }

    @Override
    public ValueMirrors.Style.BuilderVisibility builderVisibility() {
        return this.builderVisibility;
    }

    public String throwForInvalidImmutableStateName() {
        return this.throwForInvalidImmutableStateName;
    }

    public TypeMirror throwForInvalidImmutableStateMirror() {
        return this.throwForInvalidImmutableState;
    }

    @Override
    @Deprecated
    public Class<? extends Exception> throwForInvalidImmutableState() {
        throw new UnsupportedOperationException("Use 'throwForInvalidImmutableStateMirror()' or 'throwForInvalidImmutableStateName()'");
    }

    public String throwForNullPointerName() {
        return this.throwForNullPointerName;
    }

    public TypeMirror throwForNullPointerMirror() {
        return this.throwForNullPointer;
    }

    @Override
    @Deprecated
    public Class<? extends Exception> throwForNullPointer() {
        throw new UnsupportedOperationException("Use 'throwForNullPointerMirror()' or 'throwForNullPointerName()'");
    }

    @Override
    public boolean depluralize() {
        return this.depluralize;
    }

    @Override
    public String[] depluralizeDictionary() {
        return (String[])this.depluralizeDictionary.clone();
    }

    public String[] immutableCopyOfRoutinesName() {
        return (String[])this.immutableCopyOfRoutinesName.clone();
    }

    public TypeMirror[] immutableCopyOfRoutinesMirror() {
        return (TypeMirror[])this.immutableCopyOfRoutines.clone();
    }

    @Override
    @Deprecated
    public Class<?>[] immutableCopyOfRoutines() {
        throw new UnsupportedOperationException("Use 'immutableCopyOfRoutinesMirror()' or 'immutableCopyOfRoutinesName()'");
    }

    @Override
    public boolean stagedBuilder() {
        return this.stagedBuilder;
    }

    @Override
    public boolean builtinContainerAttributes() {
        return this.builtinContainerAttributes;
    }

    @Override
    public boolean beanFriendlyModifiables() {
        return this.beanFriendlyModifiables;
    }

    @Override
    public boolean allMandatoryParameters() {
        return this.allMandatoryParameters;
    }

    @Override
    public String redactedMask() {
        return this.redactedMask;
    }

    @Override
    public boolean attributeBuilderDetection() {
        return this.attributeBuilderDetection;
    }

    @Override
    public boolean transientDerivedFields() {
        return this.transientDerivedFields;
    }

    @Override
    public boolean finalInstanceFields() {
        return this.finalInstanceFields;
    }

    @Override
    public String[] attributeBuilder() {
        return (String[])this.attributeBuilder.clone();
    }

    @Override
    public String getBuilder() {
        return this.getBuilder;
    }

    @Override
    public String setBuilder() {
        return this.setBuilder;
    }

    @Override
    public String addBuilder() {
        return this.addBuilder;
    }

    @Override
    public String addAllBuilder() {
        return this.addAllBuilder;
    }

    @Override
    public String getBuilders() {
        return this.getBuilders;
    }

    @Override
    public String nullableAnnotation() {
        return this.nullableAnnotation;
    }

    @Override
    public int limitStringLengthInToString() {
        return this.limitStringLengthInToString;
    }

    public String[] allowedClasspathAnnotationsName() {
        return (String[])this.allowedClasspathAnnotationsName.clone();
    }

    public TypeMirror[] allowedClasspathAnnotationsMirror() {
        return (TypeMirror[])this.allowedClasspathAnnotations.clone();
    }

    @Override
    @Deprecated
    public Class<? extends Annotation>[] allowedClasspathAnnotations() {
        throw new UnsupportedOperationException("Use 'allowedClasspathAnnotationsMirror()' or 'allowedClasspathAnnotationsName()'");
    }

    public String fallbackNullableAnnotationName() {
        return this.fallbackNullableAnnotationName;
    }

    public TypeMirror fallbackNullableAnnotationMirror() {
        return this.fallbackNullableAnnotation;
    }

    @Override
    @Deprecated
    public Class<? extends Annotation> fallbackNullableAnnotation() {
        throw new UnsupportedOperationException("Use 'fallbackNullableAnnotationMirror()' or 'fallbackNullableAnnotationName()'");
    }

    @Override
    public boolean jakarta() {
        return this.jakarta;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return ValueMirrors.Style.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "get".hashCode() ^ Arrays.hashCode(this.get);
        h += 127 * "init".hashCode() ^ this.init.hashCode();
        h += 127 * "with".hashCode() ^ this.with.hashCode();
        h += 127 * "withUnaryOperator".hashCode() ^ this.withUnaryOperator.hashCode();
        h += 127 * "add".hashCode() ^ this.add.hashCode();
        h += 127 * "addAll".hashCode() ^ this.addAll.hashCode();
        h += 127 * "put".hashCode() ^ this.put.hashCode();
        h += 127 * "putAll".hashCode() ^ this.putAll.hashCode();
        h += 127 * "copyOf".hashCode() ^ this.copyOf.hashCode();
        h += 127 * "of".hashCode() ^ this.of.hashCode();
        h += 127 * "instance".hashCode() ^ this.instance.hashCode();
        h += 127 * "builder".hashCode() ^ this.builder.hashCode();
        h += 127 * "newBuilder".hashCode() ^ this.newBuilder.hashCode();
        h += 127 * "from".hashCode() ^ this.from.hashCode();
        h += 127 * "build".hashCode() ^ this.build.hashCode();
        h += 127 * "buildOrThrow".hashCode() ^ this.buildOrThrow.hashCode();
        h += 127 * "canBuild".hashCode() ^ this.canBuild.hashCode();
        h += 127 * "toBuilder".hashCode() ^ this.toBuilder.hashCode();
        h += 127 * "underrideHashCode".hashCode() ^ this.underrideHashCode.hashCode();
        h += 127 * "underrideEquals".hashCode() ^ this.underrideEquals.hashCode();
        h += 127 * "underrideToString".hashCode() ^ this.underrideToString.hashCode();
        h += 127 * "delegateToString".hashCode() ^ this.delegateToString.hashCode();
        h += 127 * "includeHashCode".hashCode() ^ this.includeHashCode.hashCode();
        h += 127 * "isInitialized".hashCode() ^ this.isInitialized.hashCode();
        h += 127 * "isSet".hashCode() ^ this.isSet.hashCode();
        h += 127 * "set".hashCode() ^ this.set.hashCode();
        h += 127 * "unset".hashCode() ^ this.unset.hashCode();
        h += 127 * "clear".hashCode() ^ this.clear.hashCode();
        h += 127 * "create".hashCode() ^ this.create.hashCode();
        h += 127 * "toImmutable".hashCode() ^ this.toImmutable.hashCode();
        h += 127 * "typeBuilder".hashCode() ^ this.typeBuilder.hashCode();
        h += 127 * "typeInnerBuilder".hashCode() ^ this.typeInnerBuilder.hashCode();
        h += 127 * "typeAbstract".hashCode() ^ Arrays.hashCode(this.typeAbstract);
        h += 127 * "typeImmutable".hashCode() ^ this.typeImmutable.hashCode();
        h += 127 * "typeImmutableEnclosing".hashCode() ^ this.typeImmutableEnclosing.hashCode();
        h += 127 * "typeImmutableNested".hashCode() ^ this.typeImmutableNested.hashCode();
        h += 127 * "typeModifiable".hashCode() ^ this.typeModifiable.hashCode();
        h += 127 * "typeInnerModifiable".hashCode() ^ this.typeInnerModifiable.hashCode();
        h += 127 * "typeWith".hashCode() ^ this.typeWith.hashCode();
        h += 127 * "packageGenerated".hashCode() ^ this.packageGenerated.hashCode();
        h += 127 * "defaults".hashCode() ^ this.defaults.hashCode();
        h += 127 * "strictBuilder".hashCode() ^ Booleans.hashCode((boolean)this.strictBuilder);
        h += 127 * "validationMethod".hashCode() ^ this.validationMethod.hashCode();
        h += 127 * "allParameters".hashCode() ^ Booleans.hashCode((boolean)this.allParameters);
        h += 127 * "defaultAsDefault".hashCode() ^ Booleans.hashCode((boolean)this.defaultAsDefault);
        h += 127 * "headerComments".hashCode() ^ Booleans.hashCode((boolean)this.headerComments);
        h += 127 * "jdkOnly".hashCode() ^ Booleans.hashCode((boolean)this.jdkOnly);
        h += 127 * "passAnnotations".hashCode() ^ Arrays.hashCode(this.passAnnotationsName);
        h += 127 * "additionalJsonAnnotations".hashCode() ^ Arrays.hashCode(this.additionalJsonAnnotationsName);
        h += 127 * "visibility".hashCode() ^ this.visibility.hashCode();
        h += 127 * "optionalAcceptNullable".hashCode() ^ Booleans.hashCode((boolean)this.optionalAcceptNullable);
        h += 127 * "generateSuppressAllWarnings".hashCode() ^ Booleans.hashCode((boolean)this.generateSuppressAllWarnings);
        h += 127 * "privateNoargConstructor".hashCode() ^ Booleans.hashCode((boolean)this.privateNoargConstructor);
        h += 127 * "protectedNoargConstructor".hashCode() ^ Booleans.hashCode((boolean)this.protectedNoargConstructor);
        h += 127 * "attributelessSingleton".hashCode() ^ Booleans.hashCode((boolean)this.attributelessSingleton);
        h += 127 * "unsafeDefaultAndDerived".hashCode() ^ Booleans.hashCode((boolean)this.unsafeDefaultAndDerived);
        h += 127 * "clearBuilder".hashCode() ^ Booleans.hashCode((boolean)this.clearBuilder);
        h += 127 * "deferCollectionAllocation".hashCode() ^ Booleans.hashCode((boolean)this.deferCollectionAllocation);
        h += 127 * "deepImmutablesDetection".hashCode() ^ Booleans.hashCode((boolean)this.deepImmutablesDetection);
        h += 127 * "overshadowImplementation".hashCode() ^ Booleans.hashCode((boolean)this.overshadowImplementation);
        h += 127 * "implementationNestedInBuilder".hashCode() ^ Booleans.hashCode((boolean)this.implementationNestedInBuilder);
        h += 127 * "forceJacksonPropertyNames".hashCode() ^ Booleans.hashCode((boolean)this.forceJacksonPropertyNames);
        h += 127 * "forceJacksonIgnoreFields".hashCode() ^ Booleans.hashCode((boolean)this.forceJacksonIgnoreFields);
        h += 127 * "forceEqualsInWithers".hashCode() ^ Booleans.hashCode((boolean)this.forceEqualsInWithers);
        h += 127 * "jacksonIntegration".hashCode() ^ Booleans.hashCode((boolean)this.jacksonIntegration);
        h += 127 * "weakInterning".hashCode() ^ Booleans.hashCode((boolean)this.weakInterning);
        h += 127 * "alwaysPublicInitializers".hashCode() ^ Booleans.hashCode((boolean)this.alwaysPublicInitializers);
        h += 127 * "builderVisibility".hashCode() ^ this.builderVisibility.hashCode();
        h += 127 * "throwForInvalidImmutableState".hashCode() ^ this.throwForInvalidImmutableStateName.hashCode();
        h += 127 * "throwForNullPointer".hashCode() ^ this.throwForNullPointerName.hashCode();
        h += 127 * "depluralize".hashCode() ^ Booleans.hashCode((boolean)this.depluralize);
        h += 127 * "depluralizeDictionary".hashCode() ^ Arrays.hashCode(this.depluralizeDictionary);
        h += 127 * "immutableCopyOfRoutines".hashCode() ^ Arrays.hashCode(this.immutableCopyOfRoutinesName);
        h += 127 * "stagedBuilder".hashCode() ^ Booleans.hashCode((boolean)this.stagedBuilder);
        h += 127 * "builtinContainerAttributes".hashCode() ^ Booleans.hashCode((boolean)this.builtinContainerAttributes);
        h += 127 * "beanFriendlyModifiables".hashCode() ^ Booleans.hashCode((boolean)this.beanFriendlyModifiables);
        h += 127 * "allMandatoryParameters".hashCode() ^ Booleans.hashCode((boolean)this.allMandatoryParameters);
        h += 127 * "redactedMask".hashCode() ^ this.redactedMask.hashCode();
        h += 127 * "attributeBuilderDetection".hashCode() ^ Booleans.hashCode((boolean)this.attributeBuilderDetection);
        h += 127 * "transientDerivedFields".hashCode() ^ Booleans.hashCode((boolean)this.transientDerivedFields);
        h += 127 * "finalInstanceFields".hashCode() ^ Booleans.hashCode((boolean)this.finalInstanceFields);
        h += 127 * "attributeBuilder".hashCode() ^ Arrays.hashCode(this.attributeBuilder);
        h += 127 * "getBuilder".hashCode() ^ this.getBuilder.hashCode();
        h += 127 * "setBuilder".hashCode() ^ this.setBuilder.hashCode();
        h += 127 * "addBuilder".hashCode() ^ this.addBuilder.hashCode();
        h += 127 * "addAllBuilder".hashCode() ^ this.addAllBuilder.hashCode();
        h += 127 * "getBuilders".hashCode() ^ this.getBuilders.hashCode();
        h += 127 * "nullableAnnotation".hashCode() ^ this.nullableAnnotation.hashCode();
        h += 127 * "limitStringLengthInToString".hashCode() ^ Ints.hashCode((int)this.limitStringLengthInToString);
        h += 127 * "allowedClasspathAnnotations".hashCode() ^ Arrays.hashCode(this.allowedClasspathAnnotationsName);
        h += 127 * "fallbackNullableAnnotation".hashCode() ^ this.fallbackNullableAnnotationName.hashCode();
        return h += 127 * "jakarta".hashCode() ^ Booleans.hashCode((boolean)this.jakarta);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof StyleMirror) {
            StyleMirror otherMirror = (StyleMirror)other;
            return Arrays.equals(this.get, otherMirror.get) && this.init.equals(otherMirror.init) && this.with.equals(otherMirror.with) && this.withUnaryOperator.equals(otherMirror.withUnaryOperator) && this.add.equals(otherMirror.add) && this.addAll.equals(otherMirror.addAll) && this.put.equals(otherMirror.put) && this.putAll.equals(otherMirror.putAll) && this.copyOf.equals(otherMirror.copyOf) && this.of.equals(otherMirror.of) && this.instance.equals(otherMirror.instance) && this.builder.equals(otherMirror.builder) && this.newBuilder.equals(otherMirror.newBuilder) && this.from.equals(otherMirror.from) && this.build.equals(otherMirror.build) && this.buildOrThrow.equals(otherMirror.buildOrThrow) && this.canBuild.equals(otherMirror.canBuild) && this.toBuilder.equals(otherMirror.toBuilder) && this.underrideHashCode.equals(otherMirror.underrideHashCode) && this.underrideEquals.equals(otherMirror.underrideEquals) && this.underrideToString.equals(otherMirror.underrideToString) && this.delegateToString.equals(otherMirror.delegateToString) && this.includeHashCode.equals(otherMirror.includeHashCode) && this.isInitialized.equals(otherMirror.isInitialized) && this.isSet.equals(otherMirror.isSet) && this.set.equals(otherMirror.set) && this.unset.equals(otherMirror.unset) && this.clear.equals(otherMirror.clear) && this.create.equals(otherMirror.create) && this.toImmutable.equals(otherMirror.toImmutable) && this.typeBuilder.equals(otherMirror.typeBuilder) && this.typeInnerBuilder.equals(otherMirror.typeInnerBuilder) && Arrays.equals(this.typeAbstract, otherMirror.typeAbstract) && this.typeImmutable.equals(otherMirror.typeImmutable) && this.typeImmutableEnclosing.equals(otherMirror.typeImmutableEnclosing) && this.typeImmutableNested.equals(otherMirror.typeImmutableNested) && this.typeModifiable.equals(otherMirror.typeModifiable) && this.typeInnerModifiable.equals(otherMirror.typeInnerModifiable) && this.typeWith.equals(otherMirror.typeWith) && this.packageGenerated.equals(otherMirror.packageGenerated) && this.defaults.equals(otherMirror.defaults) && this.strictBuilder == otherMirror.strictBuilder && this.validationMethod.equals((Object)otherMirror.validationMethod) && this.allParameters == otherMirror.allParameters && this.defaultAsDefault == otherMirror.defaultAsDefault && this.headerComments == otherMirror.headerComments && this.jdkOnly == otherMirror.jdkOnly && Arrays.equals(this.passAnnotationsName, otherMirror.passAnnotationsName) && Arrays.equals(this.additionalJsonAnnotationsName, otherMirror.additionalJsonAnnotationsName) && this.visibility.equals((Object)otherMirror.visibility) && this.optionalAcceptNullable == otherMirror.optionalAcceptNullable && this.generateSuppressAllWarnings == otherMirror.generateSuppressAllWarnings && this.privateNoargConstructor == otherMirror.privateNoargConstructor && this.protectedNoargConstructor == otherMirror.protectedNoargConstructor && this.attributelessSingleton == otherMirror.attributelessSingleton && this.unsafeDefaultAndDerived == otherMirror.unsafeDefaultAndDerived && this.clearBuilder == otherMirror.clearBuilder && this.deferCollectionAllocation == otherMirror.deferCollectionAllocation && this.deepImmutablesDetection == otherMirror.deepImmutablesDetection && this.overshadowImplementation == otherMirror.overshadowImplementation && this.implementationNestedInBuilder == otherMirror.implementationNestedInBuilder && this.forceJacksonPropertyNames == otherMirror.forceJacksonPropertyNames && this.forceJacksonIgnoreFields == otherMirror.forceJacksonIgnoreFields && this.forceEqualsInWithers == otherMirror.forceEqualsInWithers && this.jacksonIntegration == otherMirror.jacksonIntegration && this.weakInterning == otherMirror.weakInterning && this.alwaysPublicInitializers == otherMirror.alwaysPublicInitializers && this.builderVisibility.equals((Object)otherMirror.builderVisibility) && this.throwForInvalidImmutableStateName.equals(otherMirror.throwForInvalidImmutableStateName) && this.throwForNullPointerName.equals(otherMirror.throwForNullPointerName) && this.depluralize == otherMirror.depluralize && Arrays.equals(this.depluralizeDictionary, otherMirror.depluralizeDictionary) && Arrays.equals(this.immutableCopyOfRoutinesName, otherMirror.immutableCopyOfRoutinesName) && this.stagedBuilder == otherMirror.stagedBuilder && this.builtinContainerAttributes == otherMirror.builtinContainerAttributes && this.beanFriendlyModifiables == otherMirror.beanFriendlyModifiables && this.allMandatoryParameters == otherMirror.allMandatoryParameters && this.redactedMask.equals(otherMirror.redactedMask) && this.attributeBuilderDetection == otherMirror.attributeBuilderDetection && this.transientDerivedFields == otherMirror.transientDerivedFields && this.finalInstanceFields == otherMirror.finalInstanceFields && Arrays.equals(this.attributeBuilder, otherMirror.attributeBuilder) && this.getBuilder.equals(otherMirror.getBuilder) && this.setBuilder.equals(otherMirror.setBuilder) && this.addBuilder.equals(otherMirror.addBuilder) && this.addAllBuilder.equals(otherMirror.addAllBuilder) && this.getBuilders.equals(otherMirror.getBuilders) && this.nullableAnnotation.equals(otherMirror.nullableAnnotation) && this.limitStringLengthInToString == otherMirror.limitStringLengthInToString && Arrays.equals(this.allowedClasspathAnnotationsName, otherMirror.allowedClasspathAnnotationsName) && this.fallbackNullableAnnotationName.equals(otherMirror.fallbackNullableAnnotationName) && this.jakarta == otherMirror.jakarta;
        }
        return false;
    }

    @Override
    public String toString() {
        return "StyleMirror:" + this.annotationMirror;
    }

    private static class JakartaExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private JakartaExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'jakarta' in @org.immutables.value.Value.Style");
        }
    }

    private static class FallbackNullableAnnotationExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror value;

        private FallbackNullableAnnotationExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        TypeMirror get() {
            return this.value;
        }

        public String name() {
            return this.value.toString();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'fallbackNullableAnnotation' in @org.immutables.value.Value.Style");
        }
    }

    private static class AllowedClasspathAnnotationsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private AllowedClasspathAnnotationsExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'allowedClasspathAnnotations' in @org.immutables.value.Value.Style");
        }
    }

    private static class LimitStringLengthInToStringExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        int value;

        private LimitStringLengthInToStringExtractor() {
        }

        @Override
        public Void visitInt(int value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        int get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'limitStringLengthInToString' in @org.immutables.value.Value.Style");
        }
    }

    private static class NullableAnnotationExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NullableAnnotationExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'nullableAnnotation' in @org.immutables.value.Value.Style");
        }
    }

    private static class GetBuildersExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private GetBuildersExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'getBuilders' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddAllBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddAllBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'addAllBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'addBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class SetBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private SetBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'setBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class GetBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private GetBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'getBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class AttributeBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private AttributeBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'attributeBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class FinalInstanceFieldsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private FinalInstanceFieldsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'finalInstanceFields' in @org.immutables.value.Value.Style");
        }
    }

    private static class TransientDerivedFieldsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private TransientDerivedFieldsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'transientDerivedFields' in @org.immutables.value.Value.Style");
        }
    }

    private static class AttributeBuilderDetectionExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private AttributeBuilderDetectionExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'attributeBuilderDetection' in @org.immutables.value.Value.Style");
        }
    }

    private static class RedactedMaskExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private RedactedMaskExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'redactedMask' in @org.immutables.value.Value.Style");
        }
    }

    private static class AllMandatoryParametersExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private AllMandatoryParametersExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'allMandatoryParameters' in @org.immutables.value.Value.Style");
        }
    }

    private static class BeanFriendlyModifiablesExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private BeanFriendlyModifiablesExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'beanFriendlyModifiables' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuiltinContainerAttributesExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private BuiltinContainerAttributesExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'builtinContainerAttributes' in @org.immutables.value.Value.Style");
        }
    }

    private static class StagedBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private StagedBuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'stagedBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class ImmutableCopyOfRoutinesExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private ImmutableCopyOfRoutinesExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'immutableCopyOfRoutines' in @org.immutables.value.Value.Style");
        }
    }

    private static class DepluralizeDictionaryExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private DepluralizeDictionaryExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'depluralizeDictionary' in @org.immutables.value.Value.Style");
        }
    }

    private static class DepluralizeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private DepluralizeExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'depluralize' in @org.immutables.value.Value.Style");
        }
    }

    private static class ThrowForNullPointerExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror value;

        private ThrowForNullPointerExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        TypeMirror get() {
            return this.value;
        }

        public String name() {
            return this.value.toString();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'throwForNullPointer' in @org.immutables.value.Value.Style");
        }
    }

    private static class ThrowForInvalidImmutableStateExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror value;

        private ThrowForInvalidImmutableStateExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        TypeMirror get() {
            return this.value;
        }

        public String name() {
            return this.value.toString();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'throwForInvalidImmutableState' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuilderVisibilityExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        ValueMirrors.Style.BuilderVisibility value;

        private BuilderVisibilityExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.value = ValueMirrors.Style.BuilderVisibility.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        ValueMirrors.Style.BuilderVisibility get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'builderVisibility' in @org.immutables.value.Value.Style");
        }
    }

    private static class AlwaysPublicInitializersExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private AlwaysPublicInitializersExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'alwaysPublicInitializers' in @org.immutables.value.Value.Style");
        }
    }

    private static class WeakInterningExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private WeakInterningExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'weakInterning' in @org.immutables.value.Value.Style");
        }
    }

    private static class JacksonIntegrationExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private JacksonIntegrationExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'jacksonIntegration' in @org.immutables.value.Value.Style");
        }
    }

    private static class ForceEqualsInWithersExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ForceEqualsInWithersExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'forceEqualsInWithers' in @org.immutables.value.Value.Style");
        }
    }

    private static class ForceJacksonIgnoreFieldsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ForceJacksonIgnoreFieldsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'forceJacksonIgnoreFields' in @org.immutables.value.Value.Style");
        }
    }

    private static class ForceJacksonPropertyNamesExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ForceJacksonPropertyNamesExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'forceJacksonPropertyNames' in @org.immutables.value.Value.Style");
        }
    }

    private static class ImplementationNestedInBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ImplementationNestedInBuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'implementationNestedInBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class OvershadowImplementationExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private OvershadowImplementationExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'overshadowImplementation' in @org.immutables.value.Value.Style");
        }
    }

    private static class DeepImmutablesDetectionExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private DeepImmutablesDetectionExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'deepImmutablesDetection' in @org.immutables.value.Value.Style");
        }
    }

    private static class DeferCollectionAllocationExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private DeferCollectionAllocationExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'deferCollectionAllocation' in @org.immutables.value.Value.Style");
        }
    }

    private static class ClearBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ClearBuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'clearBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class UnsafeDefaultAndDerivedExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private UnsafeDefaultAndDerivedExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'unsafeDefaultAndDerived' in @org.immutables.value.Value.Style");
        }
    }

    private static class AttributelessSingletonExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private AttributelessSingletonExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'attributelessSingleton' in @org.immutables.value.Value.Style");
        }
    }

    private static class ProtectedNoargConstructorExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private ProtectedNoargConstructorExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'protectedNoargConstructor' in @org.immutables.value.Value.Style");
        }
    }

    private static class PrivateNoargConstructorExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private PrivateNoargConstructorExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'privateNoargConstructor' in @org.immutables.value.Value.Style");
        }
    }

    private static class GenerateSuppressAllWarningsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private GenerateSuppressAllWarningsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'generateSuppressAllWarnings' in @org.immutables.value.Value.Style");
        }
    }

    private static class OptionalAcceptNullableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private OptionalAcceptNullableExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'optionalAcceptNullable' in @org.immutables.value.Value.Style");
        }
    }

    private static class VisibilityExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        ValueMirrors.Style.ImplementationVisibility value;

        private VisibilityExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.value = ValueMirrors.Style.ImplementationVisibility.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        ValueMirrors.Style.ImplementationVisibility get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'visibility' in @org.immutables.value.Value.Style");
        }
    }

    private static class AdditionalJsonAnnotationsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private AdditionalJsonAnnotationsExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'additionalJsonAnnotations' in @org.immutables.value.Value.Style");
        }
    }

    private static class PassAnnotationsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        TypeMirror[] values;
        int position;

        private PassAnnotationsExtractor() {
        }

        @Override
        public Void visitType(TypeMirror value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new TypeMirror[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        TypeMirror[] get() {
            return this.values;
        }

        public String[] name() {
            String[] names = new String[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                names[i] = this.values[i].toString();
            }
            return names;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'passAnnotations' in @org.immutables.value.Value.Style");
        }
    }

    private static class JdkOnlyExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private JdkOnlyExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'jdkOnly' in @org.immutables.value.Value.Style");
        }
    }

    private static class HeaderCommentsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private HeaderCommentsExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'headerComments' in @org.immutables.value.Value.Style");
        }
    }

    private static class DefaultAsDefaultExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private DefaultAsDefaultExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'defaultAsDefault' in @org.immutables.value.Value.Style");
        }
    }

    private static class AllParametersExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private AllParametersExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'allParameters' in @org.immutables.value.Value.Style");
        }
    }

    private static class ValidationMethodExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        ValueMirrors.Style.ValidationMethod value;

        private ValidationMethodExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.value = ValueMirrors.Style.ValidationMethod.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        ValueMirrors.Style.ValidationMethod get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'validationMethod' in @org.immutables.value.Value.Style");
        }
    }

    private static class StrictBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private StrictBuilderExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'strictBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class DefaultsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        AnnotationMirror value;

        private DefaultsExtractor() {
        }

        @Override
        public Void visitAnnotation(AnnotationMirror value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        AnnotationMirror get() {
            return this.value;
        }

        public ImmutableMirror mirror() {
            return (ImmutableMirror)ImmutableMirror.from(this.value).get();
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'defaults' in @org.immutables.value.Value.Style");
        }
    }

    private static class PackageGeneratedExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private PackageGeneratedExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'packageGenerated' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeWithExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeWithExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeWith' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeInnerModifiableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeInnerModifiableExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeInnerModifiable' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeModifiableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeModifiableExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeModifiable' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableNestedExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableNestedExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutableNested' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableEnclosingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableEnclosingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutableEnclosing' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeImmutableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeImmutableExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeImmutable' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeAbstractExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TypeAbstractExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeAbstract' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeInnerBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeInnerBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeInnerBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class TypeBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class ToImmutableExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ToImmutableExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'toImmutable' in @org.immutables.value.Value.Style");
        }
    }

    private static class CreateExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CreateExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'create' in @org.immutables.value.Value.Style");
        }
    }

    private static class ClearExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ClearExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'clear' in @org.immutables.value.Value.Style");
        }
    }

    private static class UnsetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private UnsetExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'unset' in @org.immutables.value.Value.Style");
        }
    }

    private static class SetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private SetExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'set' in @org.immutables.value.Value.Style");
        }
    }

    private static class IsSetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private IsSetExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'isSet' in @org.immutables.value.Value.Style");
        }
    }

    private static class IsInitializedExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private IsInitializedExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'isInitialized' in @org.immutables.value.Value.Style");
        }
    }

    private static class IncludeHashCodeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private IncludeHashCodeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'includeHashCode' in @org.immutables.value.Value.Style");
        }
    }

    private static class DelegateToStringExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private DelegateToStringExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'delegateToString' in @org.immutables.value.Value.Style");
        }
    }

    private static class UnderrideToStringExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private UnderrideToStringExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'underrideToString' in @org.immutables.value.Value.Style");
        }
    }

    private static class UnderrideEqualsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private UnderrideEqualsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'underrideEquals' in @org.immutables.value.Value.Style");
        }
    }

    private static class UnderrideHashCodeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private UnderrideHashCodeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'underrideHashCode' in @org.immutables.value.Value.Style");
        }
    }

    private static class ToBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ToBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'toBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class CanBuildExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CanBuildExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'canBuild' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuildOrThrowExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private BuildOrThrowExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'buildOrThrow' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuildExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private BuildExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'build' in @org.immutables.value.Value.Style");
        }
    }

    private static class FromExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private FromExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'from' in @org.immutables.value.Value.Style");
        }
    }

    private static class NewBuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NewBuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'newBuilder' in @org.immutables.value.Value.Style");
        }
    }

    private static class BuilderExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private BuilderExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'builder' in @org.immutables.value.Value.Style");
        }
    }

    private static class InstanceExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private InstanceExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'instance' in @org.immutables.value.Value.Style");
        }
    }

    private static class OfExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private OfExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'of' in @org.immutables.value.Value.Style");
        }
    }

    private static class CopyOfExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CopyOfExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'copyOf' in @org.immutables.value.Value.Style");
        }
    }

    private static class PutAllExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private PutAllExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'putAll' in @org.immutables.value.Value.Style");
        }
    }

    private static class PutExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private PutExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'put' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddAllExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddAllExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'addAll' in @org.immutables.value.Value.Style");
        }
    }

    private static class AddExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private AddExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'add' in @org.immutables.value.Value.Style");
        }
    }

    private static class WithUnaryOperatorExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private WithUnaryOperatorExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'withUnaryOperator' in @org.immutables.value.Value.Style");
        }
    }

    private static class WithExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private WithExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'with' in @org.immutables.value.Value.Style");
        }
    }

    private static class InitExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private InitExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'init' in @org.immutables.value.Value.Style");
        }
    }

    private static class GetExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private GetExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'get' in @org.immutables.value.Value.Style");
        }
    }
}

