/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.immutables.generator.Generator;
import org.immutables.value.Value;
import org.immutables.value.processor.ImmutableDatatypeTypes;
import org.immutables.value.processor.ValuesTemplate;
import org.immutables.value.processor.encode.Generator_Renderers;
import org.immutables.value.processor.encode.Renderers;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

@Generator.Template
abstract class Datatypes
extends ValuesTemplate {
    final Renderers rr = new Generator_Renderers();
    @Generator.Typedef
    DatatypeTypes Datatypes;
    DatatypeTypes current;
    final Function<DatatypeTypes, Void> setCurrent = new Function<DatatypeTypes, Void>(){

        public Void apply(DatatypeTypes input) {
            Datatypes.this.current = input;
            return null;
        }
    };
    ValueType currentType;
    private Map<ValueAttribute, Integer> attributeIndexMap;
    final Function<ValueType, Void> setCurrentType = new Function<ValueType, Void>(){

        public Void apply(ValueType input) {
            Datatypes.this.currentType = input;
            Datatypes.this.attributeIndexMap = new IdentityHashMap();
            int counter = 0;
            for (ValueAttribute a : input.getAllAccessibleAttributes()) {
                Datatypes.this.attributeIndexMap.put(a, counter++);
            }
            return null;
        }
    };
    final Function<ValueAttribute, Integer> attributeIndex = new Function<ValueAttribute, Integer>(){

        public Integer apply(ValueAttribute input) {
            return (Integer)Datatypes.this.attributeIndexMap.get(input);
        }
    };

    Datatypes() {
    }

    Iterable<DatatypeTypes> allDefinitions() {
        ArrayListMultimap byDeclaring = ArrayListMultimap.create();
        for (ValueType value : this.values.values()) {
            Proto.Protoclass protoclass = value.constitution.protoclass();
            if (!protoclass.kind().isValue() && !protoclass.kind().isEnclosing()) continue;
            Optional<Proto.AbstractDeclaring> typeAdaptersProvider = protoclass.datatypeProvider();
            if (typeAdaptersProvider.isPresent()) {
                byDeclaring.put(typeAdaptersProvider.get(), (Object)value);
                continue;
            }
            if (!protoclass.datatypeMarker().isPresent() || !protoclass.declaringType().isPresent()) continue;
            Proto.DeclaringType topLevel = ((Proto.DeclaringType)protoclass.declaringType().get()).associatedTopLevel();
            byDeclaring.put((Object)topLevel, (Object)value);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry entry : byDeclaring.asMap().entrySet()) {
            String pack = ((ValueType)Iterables.get((Iterable)((Iterable)entry.getValue()), (int)0)).$$package();
            builder.add((Object)ImmutableDatatypeTypes.builder().definedBy((Proto.AbstractDeclaring)entry.getKey()).packageGenerated(pack).addAllTypes((Iterable)entry.getValue()).build());
        }
        return builder.build();
    }

    @Value.Immutable
    static abstract class DatatypeTypes {
        DatatypeTypes() {
        }

        abstract Proto.AbstractDeclaring definedBy();

        abstract String packageGenerated();

        abstract List<ValueType> types();
    }
}

