/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import javax.lang.model.type.TypeMirror;
import org.immutables.generator.TypeHierarchyCollector;

public abstract class TypeIntrospectionBase {
    private static final String PARCELABLE_INTERFACE_TYPE = "android.os.Parcelable";
    private static final String COMPARABLE_INTERFACE_PREFIX = Comparable.class.getName();
    private static final String ENUM_CLASS_PREFIX = Enum.class.getName();
    private static final String ORDINAL_VALUE_INTERFACE_PREFIX = "org.immutables.ordinal.OrdinalValue";
    protected static final ImmutableBiMap<String, String> BOXED_TO_PRIMITIVE_TYPES;
    private volatile boolean introspected;
    protected ImmutableSet<String> extendedClassesNames = ImmutableSet.of();
    protected ImmutableSet<String> implementedInterfacesNames = ImmutableSet.of();
    protected ImmutableSet<String> unresolvedYetArguments = ImmutableSet.of();
    private boolean isOrdinalValue;
    private boolean isEnum;
    private boolean isComparable;

    protected static boolean isPrimitiveType(String typeName) {
        return BOXED_TO_PRIMITIVE_TYPES.containsValue((Object)typeName);
    }

    protected static boolean isPrimitiveWrappedType(String name) {
        return BOXED_TO_PRIMITIVE_TYPES.containsKey((Object)name);
    }

    protected static boolean isPrimitiveOrWrapped(String name) {
        return TypeIntrospectionBase.isPrimitiveType(name) || TypeIntrospectionBase.isPrimitiveWrappedType(name);
    }

    protected static String wrapType(String typeName) {
        return (String)MoreObjects.firstNonNull((Object)BOXED_TO_PRIMITIVE_TYPES.inverse().get((Object)typeName), (Object)typeName);
    }

    protected static String unwrapType(String typeName) {
        return (String)MoreObjects.firstNonNull((Object)BOXED_TO_PRIMITIVE_TYPES.get((Object)typeName), (Object)typeName);
    }

    protected abstract TypeMirror internalTypeMirror();

    protected void ensureTypeIntrospected() {
        if (!this.introspected) {
            this.introspectType();
            this.introspected = true;
        }
    }

    public ImmutableSet<String> getExtendedClassesNames() {
        this.ensureTypeIntrospected();
        return this.extendedClassesNames;
    }

    public ImmutableSet<String> getImplementedInterfacesNames() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames;
    }

    public boolean isParcelable() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains((Object)PARCELABLE_INTERFACE_TYPE);
    }

    public boolean isComparable() {
        this.ensureTypeIntrospected();
        return this.isComparable;
    }

    public boolean isOrdinalValue() {
        this.ensureTypeIntrospected();
        return this.isOrdinalValue;
    }

    public boolean isEnumType() {
        this.ensureTypeIntrospected();
        return this.isEnum;
    }

    public boolean isSerializable() {
        this.ensureTypeIntrospected();
        return this.implementedInterfacesNames.contains((Object)Serializable.class.getName());
    }

    public String getDirectSupertype() {
        this.ensureTypeIntrospected();
        return (String)Iterables.getFirst(this.extendedClassesNames, null);
    }

    protected void introspectType() {
        this.introspectTypeMirror(this.internalTypeMirror());
        this.introspectSupertypes();
    }

    protected void introspectSupertypes() {
        for (String t : this.extendedClassesNames) {
            if (!t.startsWith(ENUM_CLASS_PREFIX)) continue;
            this.isEnum = true;
        }
        for (String t : this.implementedInterfacesNames) {
            if (t.startsWith(ORDINAL_VALUE_INTERFACE_PREFIX)) {
                this.isOrdinalValue = true;
                continue;
            }
            if (!t.startsWith(COMPARABLE_INTERFACE_PREFIX)) continue;
            this.isComparable = true;
        }
    }

    protected void introspectTypeMirror(TypeMirror typeMirror) {
        TypeHierarchyCollector collector = this.collectTypeHierarchy(typeMirror);
        this.extendedClassesNames = collector.extendedClassNames();
        this.implementedInterfacesNames = collector.implementedInterfaceNames();
        this.unresolvedYetArguments = collector.unresolvedYetArguments();
    }

    protected TypeHierarchyCollector collectTypeHierarchy(TypeMirror typeMirror) {
        TypeHierarchyCollector collector = new TypeHierarchyCollector();
        collector.collectFrom(typeMirror);
        return collector;
    }

    static {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (Class primitive : Primitives.allPrimitiveTypes()) {
            if (primitive == Void.TYPE) continue;
            builder.put((Object)Primitives.wrap((Class)primitive).getName(), (Object)primitive.getName());
        }
        BOXED_TO_PRIMITIVE_TYPES = builder.build();
    }
}

