/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import org.immutables.generator.AbstractGenerator;
import org.immutables.generator.ForwardingFiler;
import org.immutables.generator.ForwardingProcessingEnvironment;
import org.immutables.value.processor.Generator_Asts;
import org.immutables.value.processor.Generator_Criteria;
import org.immutables.value.processor.Generator_CriteriaRepository;
import org.immutables.value.processor.Generator_Datatypes;
import org.immutables.value.processor.Generator_Funcs;
import org.immutables.value.processor.Generator_Gsons;
import org.immutables.value.processor.Generator_Immutables;
import org.immutables.value.processor.Generator_Modifiables;
import org.immutables.value.processor.Generator_Repositories;
import org.immutables.value.processor.Generator_Transformers;
import org.immutables.value.processor.Generator_Visitors;
import org.immutables.value.processor.encode.Generator_Encodings;
import org.immutables.value.processor.meta.CustomImmutableAnnotations;
import org.immutables.value.processor.meta.ImmutableRound;
import org.immutables.value.processor.meta.Proto;
import org.immutables.value.processor.meta.Round;
import org.immutables.value.processor.meta.UnshadeGuava;
import org.immutables.value.processor.meta.ValueType;

@SupportedAnnotationTypes(value={"org.immutables.value.Value.Immutable", "org.immutables.value.Value.Enclosing", "org.immutables.value.Value.Include", "org.immutables.value.Value.Modifiable", "org.immutables.value.Value", "org.immutables.builder.Builder.Factory", "org.immutables.builder.Builder.Constructor", "org.immutables.builder.Builder.Include", "org.immutables.encode.Encoding", "org.immutables.criteria.Criteria", "org.immutables.criteria.Criteria.Repository"})
public final class Processor
extends AbstractGenerator {
    private static final String GRADLE_INCREMENTAL = "immutables.gradle.incremental";
    private static final String GUAVA_PREFIX = "immutables.guava.prefix";

    protected void process() {
        this.prepareOptions();
        ImmutableRound round = ImmutableRound.builder().addAllAnnotations(this.annotations()).processing(this.processing()).addAllCustomImmutableAnnotations((Iterable<String>)CustomImmutableAnnotations.annotations()).round(this.round()).build();
        Multimap<Proto.DeclaringPackage, ValueType> values = round.collectValues();
        this.invoke(new Generator_Immutables().usingValues(values).generate());
        this.invoke(new Generator_Modifiables().usingValues(values).generate());
        if (((Round)round).environment().hasGsonLib()) {
            this.invoke(new Generator_Gsons().usingValues(values).generate());
        }
        if (((Round)round).environment().hasCriteriaModule()) {
            this.invoke(new Generator_Criteria().usingValues(values).generate());
            this.invoke(new Generator_CriteriaRepository().usingValues(values).generate());
        }
        if (((Round)round).environment().hasMongoModule()) {
            this.invoke(new Generator_Repositories().usingValues(values).generate());
        }
        if (((Round)round).environment().hasFuncModule()) {
            this.invoke(new Generator_Funcs().usingValues(values).generate());
        }
        if (((Round)round).environment().hasTreesModule()) {
            this.invoke(new Generator_Transformers().usingValues(values).generate());
            this.invoke(new Generator_Visitors().usingValues(values).generate());
        }
        if (((Round)round).environment().hasAstModule()) {
            this.invoke(new Generator_Asts().usingValues(values).generate());
        }
        if (((Round)round).environment().hasEncodeModule()) {
            this.invoke(new Generator_Encodings().generate());
        }
        if (((Round)round).environment().hasDatatypesModule()) {
            this.invoke(new Generator_Datatypes().usingValues(values).generate());
        }
    }

    private void prepareOptions() {
        UnshadeGuava.overridePrefix(this.processing().getOptions().get(GUAVA_PREFIX));
    }

    public Set<String> getSupportedAnnotationTypes() {
        return FluentIterable.from((Iterable)super.getSupportedAnnotationTypes()).append(CustomImmutableAnnotations.annotations()).toSet();
    }

    public Set<String> getSupportedOptions() {
        ImmutableSet.Builder options = ImmutableSet.builder();
        options.add((Object)GRADLE_INCREMENTAL);
        if (this.processingEnv.getOptions().containsKey(GRADLE_INCREMENTAL)) {
            options.add((Object)"org.gradle.annotation.processing.isolating");
        }
        options.add((Object)GUAVA_PREFIX);
        return options.build();
    }

    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init((ProcessingEnvironment)((Object)new RestrictingIncrementalProcessingEnvironment(processingEnv)));
    }

    private final class RestrictingIncrementalProcessingEnvironment
    extends ForwardingProcessingEnvironment {
        private final ProcessingEnvironment processingEnv;
        boolean incrementalRestrictions;
        private Filer restrictedFiler;

        private RestrictingIncrementalProcessingEnvironment(ProcessingEnvironment processingEnv) {
            this.processingEnv = processingEnv;
            this.incrementalRestrictions = processingEnv.getOptions().containsKey(Processor.GRADLE_INCREMENTAL);
        }

        protected ProcessingEnvironment delegate() {
            return this.processingEnv;
        }

        public Filer getFiler() {
            final Filer filer = super.getFiler();
            if (this.incrementalRestrictions) {
                if (this.restrictedFiler == null) {
                    this.restrictedFiler = new ForwardingFiler(){

                        protected Filer delegate() {
                            return filer;
                        }

                        public FileObject createResource(JavaFileManager.Location location, CharSequence pkg, CharSequence relativeName, Element ... originatingElements) throws IOException {
                            String message = String.format("Suppressed writing of resource %s/%s/%s (triggered by enabling -A%s)", location, pkg, relativeName, Processor.GRADLE_INCREMENTAL);
                            RestrictingIncrementalProcessingEnvironment.this.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, message);
                            throw new FileNotFoundException(message);
                        }
                    };
                }
                return this.restrictedFiler;
            }
            return filer;
        }
    }
}

