/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.immutables.value.processor.meta.CustomImmutableCollections;
import org.immutables.value.processor.meta.UnshadeGuava;

public enum AttributeTypeKind {
    REGULAR("", new String[0]),
    ENCODING("", new String[0]),
    ARRAY("", new String[0]),
    LIST("List", List.class.getName(), UnshadeGuava.typeString("collect.ImmutableList")),
    SET("Set", Set.class.getName(), UnshadeGuava.typeString("collect.ImmutableSet")),
    ENUM_SET("Set", new String[0]),
    SORTED_SET("SortedSet", SortedSet.class.getName(), NavigableSet.class.getName(), UnshadeGuava.typeString("collect.ImmutableSortedSet")),
    MAP("Map", Map.class.getName(), UnshadeGuava.typeString("collect.ImmutableMap")),
    ENUM_MAP("Map", new String[0]),
    SORTED_MAP("SortedMap", SortedMap.class.getName(), NavigableMap.class.getName(), UnshadeGuava.typeString("collect.ImmutableSortedMap")),
    MULTISET("Multiset", UnshadeGuava.typeString("collect.Multiset"), UnshadeGuava.typeString("collect.ImmutableMultiset")),
    SORTED_MULTISET("SortedMultiset", UnshadeGuava.typeString("collect.SortedMultiset"), UnshadeGuava.typeString("collect.ImmutableSortedMultiset")),
    MULTIMAP("Multimap", UnshadeGuava.typeString("collect.Multimap"), UnshadeGuava.typeString("collect.ImmutableMultimap")),
    LIST_MULTIMAP("ListMultimap", UnshadeGuava.typeString("collect.ListMultimap"), UnshadeGuava.typeString("collect.ImmutableListMultimap")),
    SET_MULTIMAP("SetMultimap", UnshadeGuava.typeString("collect.SetMultimap"), UnshadeGuava.typeString("collect.ImmutableSetMultimap")),
    BI_MAP("BiMap", UnshadeGuava.typeString("collect.BiMap"), UnshadeGuava.typeString("collect.ImmutableBiMap")),
    OPTIONAL_JDK("Optional", "java.util.Optional"),
    OPTIONAL_INT_JDK("OptionalInt", "java.util.OptionalInt"),
    OPTIONAL_LONG_JDK("OptionalLong", "java.util.OptionalLong"),
    OPTIONAL_DOUBLE_JDK("OptionalDouble", "java.util.OptionalDouble"),
    OPTIONAL_GUAVA("Optional", UnshadeGuava.typeString("base.Optional")),
    OPTION_FUGUE("Option", "com.atlassian.fugue.Option", "io.atlassian.fugue.Option"),
    OPTION_JAVASLANG("Option", "javaslang.control.Option"),
    CUSTOM_COLLECTION("", "");

    private final String[] rawTypes;
    private final String rawSimpleName;
    private static final ImmutableMap<String, AttributeTypeKind> rawTypeMapping;

    private AttributeTypeKind(String rawSimpleName, String ... rawTypes) {
        this.rawSimpleName = rawSimpleName;
        this.rawTypes = rawTypes;
    }

    public String rawSimpleName(String rawType) {
        if (this.isCustomCollection()) {
            int lastDot = rawType.lastIndexOf(46);
            return lastDot < 0 ? rawType : rawType.substring(lastDot + 1);
        }
        return this.rawSimpleName;
    }

    static AttributeTypeKind forRawType(String rawType) {
        return (AttributeTypeKind)((Object)MoreObjects.firstNonNull((Object)((Object)((AttributeTypeKind)((Object)rawTypeMapping.get((Object)rawType)))), (Object)((Object)REGULAR)));
    }

    AttributeTypeKind havingEnumFirstTypeParameter(boolean isEnum) {
        if (isEnum) {
            switch (this) {
                case SET: {
                    return ENUM_SET;
                }
                case MAP: {
                    return ENUM_MAP;
                }
            }
        }
        return this;
    }

    public boolean isSortedKind() {
        switch (this) {
            case SORTED_MAP: 
            case SORTED_SET: 
            case SORTED_MULTISET: {
                return true;
            }
        }
        return false;
    }

    public boolean isSetKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case SORTED_MULTISET: 
            case ENUM_SET: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public boolean isContainerKind() {
        switch (this) {
            case REGULAR: 
            case ENCODING: 
            case ARRAY: {
                return false;
            }
        }
        return true;
    }

    public boolean isCollectionKind() {
        switch (this) {
            case SET: 
            case SORTED_SET: 
            case SORTED_MULTISET: 
            case ENUM_SET: 
            case MULTISET: 
            case LIST: 
            case CUSTOM_COLLECTION: {
                return true;
            }
        }
        return false;
    }

    public boolean isMapKind() {
        switch (this) {
            case MAP: 
            case SORTED_MAP: 
            case ENUM_MAP: 
            case BI_MAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isMappingKind() {
        switch (this) {
            case MAP: 
            case SORTED_MAP: 
            case ENUM_MAP: 
            case BI_MAP: 
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isKeyedKind() {
        return this.isMappingKind() || this.isSetKind();
    }

    public boolean isJdkOnlyContainerKind() {
        switch (this) {
            case OPTIONAL_JDK: 
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: {
                return true;
            }
        }
        return false;
    }

    public boolean isGuavaContainerKind() {
        switch (this) {
            case SORTED_MULTISET: 
            case MULTISET: 
            case BI_MAP: 
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalJdk() {
        return this == OPTIONAL_JDK;
    }

    public boolean isOptionalSpecializedJdk() {
        switch (this) {
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: {
                return true;
            }
        }
        return false;
    }

    public boolean isOptionalGuava() {
        return this == OPTIONAL_GUAVA;
    }

    public boolean isOptionFugue() {
        return this == OPTION_FUGUE;
    }

    public boolean isOptionJavaslang() {
        return this == OPTION_JAVASLANG;
    }

    public boolean isOptionalKind() {
        switch (this) {
            case OPTIONAL_JDK: 
            case OPTIONAL_INT_JDK: 
            case OPTIONAL_LONG_JDK: 
            case OPTIONAL_DOUBLE_JDK: 
            case OPTIONAL_GUAVA: 
            case OPTION_FUGUE: 
            case OPTION_JAVASLANG: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnumKeyed() {
        switch (this) {
            case ENUM_SET: 
            case ENUM_MAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isCollectionOrMapping() {
        return this.isCollectionKind() || this.isMappingKind();
    }

    public boolean isMultisetKind() {
        switch (this) {
            case SORTED_MULTISET: 
            case MULTISET: {
                return true;
            }
        }
        return false;
    }

    public boolean isMultimapKind() {
        switch (this) {
            case MULTIMAP: 
            case LIST_MULTIMAP: 
            case SET_MULTIMAP: {
                return true;
            }
        }
        return false;
    }

    public boolean isCustomCollection() {
        return this == CUSTOM_COLLECTION;
    }

    public boolean isSet() {
        return this == SET;
    }

    public boolean isEnumSet() {
        return this == ENUM_SET;
    }

    public boolean isSortedSet() {
        return this == SORTED_SET;
    }

    public boolean isList() {
        return this == LIST;
    }

    public boolean isMap() {
        return this == MAP;
    }

    public boolean isPlainMapKind() {
        return this == MAP || this == ENUM_MAP;
    }

    public boolean isBiMap() {
        return this == BI_MAP;
    }

    public boolean isSortedMap() {
        return this == SORTED_MAP;
    }

    public boolean isArray() {
        return this == ARRAY;
    }

    public boolean isRegular() {
        return this == REGULAR;
    }

    public boolean isEncoding() {
        return this == ENCODING;
    }

    public boolean isMultiset() {
        return this == MULTISET;
    }

    public boolean isSortedMultiset() {
        return this == SORTED_MULTISET;
    }

    public boolean isMultimap() {
        return this == MULTIMAP;
    }

    public boolean isSetMultimap() {
        return this == SET_MULTIMAP;
    }

    public boolean isListMultimap() {
        return this == LIST_MULTIMAP;
    }

    public boolean isEnumMap() {
        return this == ENUM_MAP;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AttributeTypeKind k : AttributeTypeKind.values()) {
            if (k.isCustomCollection()) {
                for (String c : CustomImmutableCollections.collections()) {
                    builder.put((Object)c, (Object)k);
                }
                continue;
            }
            for (String r : k.rawTypes) {
                builder.put((Object)r, (Object)k);
            }
        }
        rawTypeMapping = builder.build();
    }
}

