/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.meta.GsonMirrors;

public class SerializedNameMirror
implements GsonMirrors.SerializedName {
    public static final String QUALIFIED_NAME = "com.google.gson.annotations.SerializedName";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.meta.GsonMirrors.SerializedName";
    private final AnnotationMirror annotationMirror;
    private final String value;
    private final String[] alternate;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "SerializedName";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<SerializedNameMirror> find(Element element) {
        return SerializedNameMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<SerializedNameMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new SerializedNameMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<SerializedNameMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new SerializedNameMirror(annotationMirror));
        }
        return builder.build();
    }

    public static SerializedNameMirror from(TypeElement element) {
        return new SerializedNameMirror(element);
    }

    public static Optional<SerializedNameMirror> from(AnnotationMirror mirror) {
        return SerializedNameMirror.find(Collections.singleton(mirror));
    }

    private SerializedNameMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        String value = null;
        String[] alternate = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("value".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @SerializedName");
                }
                ValueExtractor valueExtractor$ = new ValueExtractor();
                annotationValue$.accept(valueExtractor$, null);
                value = valueExtractor$.get();
                continue;
            }
            if (!"alternate".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @SerializedName");
            }
            AlternateExtractor alternateExtractor$ = new AlternateExtractor();
            annotationValue$.accept(alternateExtractor$, null);
            alternate = alternateExtractor$.get();
        }
        this.value = (String)Preconditions.checkNotNull(value, (Object)"default attribute 'value'");
        this.alternate = (String[])Preconditions.checkNotNull(alternate, (Object)"default attribute 'alternate'");
    }

    private SerializedNameMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String value = null;
        String[] alternate = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("value".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @SerializedName");
                }
                ValueExtractor valueExtractor$ = new ValueExtractor();
                annotationValue$.accept(valueExtractor$, null);
                value = valueExtractor$.get();
                continue;
            }
            if (!"alternate".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'alternate' attribute of @SerializedName");
            }
            AlternateExtractor alternateExtractor$ = new AlternateExtractor();
            annotationValue$.accept(alternateExtractor$, null);
            alternate = alternateExtractor$.get();
        }
        this.value = (String)Preconditions.checkNotNull(value, (Object)"value for 'value'");
        this.alternate = (String[])Preconditions.checkNotNull(alternate, (Object)"value for 'alternate'");
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String[] alternate() {
        return (String[])this.alternate.clone();
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return GsonMirrors.SerializedName.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value.hashCode();
        return h += 127 * "alternate".hashCode() ^ Arrays.hashCode(this.alternate);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SerializedNameMirror) {
            SerializedNameMirror otherMirror = (SerializedNameMirror)other;
            return this.value.equals(otherMirror.value) && Arrays.equals(this.alternate, otherMirror.alternate);
        }
        return false;
    }

    @Override
    public String toString() {
        return "SerializedNameMirror:" + this.annotationMirror;
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ValueExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @com.google.gson.annotations.SerializedName");
        }
    }

    private static class AlternateExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private AlternateExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'alternate' in @com.google.gson.annotations.SerializedName");
        }
    }
}

