/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

final class SourceNames {
    private SourceNames() {
    }

    static String sourceQualifiedNameFor(Element element) {
        if (SourceNames.isTypeElement(element)) {
            return ((TypeElement)element).getQualifiedName().toString();
        }
        Element enclosingElement = element.getEnclosingElement();
        if (SourceNames.isTypeElement(enclosingElement)) {
            return Joiner.on((char)'.').join((Object)((TypeElement)enclosingElement).getQualifiedName(), (Object)element.getSimpleName(), new Object[0]);
        }
        return element.getSimpleName().toString();
    }

    private static boolean isTypeElement(Element element) {
        ElementKind kind = element.getKind();
        return kind.isClass() || kind.isInterface();
    }

    static String parentPackageName(PackageElement element) {
        return SourceNames.parentPackageName(element.getQualifiedName().toString());
    }

    static String parentPackageName(String qualifiedName) {
        int lastIndexOfDot = qualifiedName.lastIndexOf(46);
        if (lastIndexOfDot > 0) {
            return qualifiedName.substring(0, lastIndexOfDot);
        }
        return "";
    }

    static Element collectClassSegments(Element start, List<String> classSegments) {
        Element e = start;
        while (e.getKind() != ElementKind.PACKAGE) {
            classSegments.add(e.getSimpleName().toString());
            e = e.getEnclosingElement();
        }
        Collections.reverse(classSegments);
        return e;
    }
}

