package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ValueImmutableInfo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableValueImmutableInfo.theBuilder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableValueImmutableInfo.theOf()}.
 */
@Generated(from = "ValueImmutableInfo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@javax.annotation.concurrent.Immutable
@CheckReturnValue
public final class ImmutableValueImmutableInfo extends ValueImmutableInfo {
  private final boolean isDefault;
  private final boolean builder;
  private final boolean copy;
  private final boolean intern;
  private final boolean prehash;
  private final boolean lazyhash;
  private final boolean singleton;

  private ImmutableValueImmutableInfo(boolean builder, boolean copy, boolean intern, boolean prehash, boolean lazyhash, boolean singleton) {
    this.builder = builder;
    this.copy = copy;
    this.intern = intern;
    this.prehash = prehash;
    this.lazyhash = lazyhash;
    this.singleton = singleton;
    this.isDefault = super.isDefault();
  }

  private ImmutableValueImmutableInfo(ImmutableValueImmutableInfo.Builder builder) {
    this.builder = builder.builder;
    this.copy = builder.copy;
    this.intern = builder.intern;
    this.prehash = builder.prehash;
    this.lazyhash = builder.lazyhash;
    this.singleton = builder.singleton;
    this.isDefault = builder.isDefaultIsSet()
        ? builder.isDefault
        : super.isDefault();
  }

  private ImmutableValueImmutableInfo(
      boolean isDefault,
      boolean builder,
      boolean copy,
      boolean intern,
      boolean prehash,
      boolean lazyhash,
      boolean singleton) {
    this.isDefault = isDefault;
    this.builder = builder;
    this.copy = copy;
    this.intern = intern;
    this.prehash = prehash;
    this.lazyhash = lazyhash;
    this.singleton = singleton;
  }

  /**
   * @return The value of the {@code isDefault} attribute
   */
  @Override
  public boolean isDefault() {
    return isDefault;
  }

  /**
   * @return The value of the {@code builder} attribute
   */
  @Override
  public boolean builder() {
    return builder;
  }

  /**
   * @return The value of the {@code copy} attribute
   */
  @Override
  public boolean copy() {
    return copy;
  }

  /**
   * @return The value of the {@code intern} attribute
   */
  @Override
  public boolean intern() {
    return intern;
  }

  /**
   * @return The value of the {@code prehash} attribute
   */
  @Override
  public boolean prehash() {
    return prehash;
  }

  /**
   * @return The value of the {@code lazyhash} attribute
   */
  @Override
  public boolean lazyhash() {
    return lazyhash;
  }

  /**
   * @return The value of the {@code singleton} attribute
   */
  @Override
  public boolean singleton() {
    return singleton;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#isDefault() isDefault} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isDefault
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withIsDefault(boolean value) {
    if (this.isDefault == value) return this;
    return validate(new ImmutableValueImmutableInfo(value, this.builder, this.copy, this.intern, this.prehash, this.lazyhash, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#builder() builder} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builder
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withBuilder(boolean value) {
    if (this.builder == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, value, this.copy, this.intern, this.prehash, this.lazyhash, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#copy() copy} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for copy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withCopy(boolean value) {
    if (this.copy == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, this.builder, value, this.intern, this.prehash, this.lazyhash, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#intern() intern} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for intern
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withIntern(boolean value) {
    if (this.intern == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, this.builder, this.copy, value, this.prehash, this.lazyhash, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#prehash() prehash} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for prehash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withPrehash(boolean value) {
    if (this.prehash == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, this.builder, this.copy, this.intern, value, this.lazyhash, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#lazyhash() lazyhash} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lazyhash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withLazyhash(boolean value) {
    if (this.lazyhash == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, this.builder, this.copy, this.intern, this.prehash, value, this.singleton));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ValueImmutableInfo#singleton() singleton} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for singleton
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableValueImmutableInfo withSingleton(boolean value) {
    if (this.singleton == value) return this;
    return validate(new ImmutableValueImmutableInfo(this.isDefault, this.builder, this.copy, this.intern, this.prehash, this.lazyhash, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableValueImmutableInfo} that have equal attribute values.
   * As instances of the {@code ImmutableValueImmutableInfo} class are interned, the {@code equals} method is implemented
   * as an efficient reference equality check.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another;
  }

  private boolean equalTo(ImmutableValueImmutableInfo another) {
    return isDefault == another.isDefault
        && builder == another.builder
        && copy == another.copy
        && intern == another.intern
        && prehash == another.prehash
        && lazyhash == another.lazyhash
        && singleton == another.singleton;
  }

  /**
   * Computes a hash code from attributes: {@code isDefault}, {@code builder}, {@code copy}, {@code intern}, {@code prehash}, {@code lazyhash}, {@code singleton}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(isDefault);
    h += (h << 5) + Booleans.hashCode(builder);
    h += (h << 5) + Booleans.hashCode(copy);
    h += (h << 5) + Booleans.hashCode(intern);
    h += (h << 5) + Booleans.hashCode(prehash);
    h += (h << 5) + Booleans.hashCode(lazyhash);
    h += (h << 5) + Booleans.hashCode(singleton);
    return h;
  }

  /**
   * Prints the immutable value {@code ValueImmutableInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ValueImmutableInfo")
        .omitNullValues()
        .add("isDefault", isDefault)
        .add("builder", builder)
        .add("copy", copy)
        .add("intern", intern)
        .add("prehash", prehash)
        .add("lazyhash", lazyhash)
        .add("singleton", singleton)
        .toString();
  }

  @Generated(from = "ValueImmutableInfo", generator = "Immutables")
  private static class InternProxy {
    final ImmutableValueImmutableInfo instance;

    InternProxy(ImmutableValueImmutableInfo instance) {
      this.instance = instance;
    }

    @Override
    public boolean equals(@Nullable Object another) {
      return another != null && instance.equalTo(((InternProxy) another).instance);
    }

    @Override
    public int hashCode() {
      return instance.hashCode();
    }
  }

  private static final Interner<InternProxy> INTERNER = Interners.newStrongInterner();

  /**
   * Construct a new immutable {@code ValueImmutableInfo} instance.
   * @param builder The value for the {@code builder} attribute
   * @param copy The value for the {@code copy} attribute
   * @param intern The value for the {@code intern} attribute
   * @param prehash The value for the {@code prehash} attribute
   * @param lazyhash The value for the {@code lazyhash} attribute
   * @param singleton The value for the {@code singleton} attribute
   * @return An immutable ValueImmutableInfo instance
   */
  public static ImmutableValueImmutableInfo theOf(boolean builder, boolean copy, boolean intern, boolean prehash, boolean lazyhash, boolean singleton) {
    return validate(new ImmutableValueImmutableInfo(builder, copy, intern, prehash, lazyhash, singleton));
  }

  private static ImmutableValueImmutableInfo validate(ImmutableValueImmutableInfo instance) {
    return INTERNER.intern(new InternProxy(instance)).instance;
  }

  /**
   * Creates an immutable copy of a {@link ValueImmutableInfo} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ValueImmutableInfo instance
   */
  public static ImmutableValueImmutableInfo theCopyOf(ValueImmutableInfo instance) {
    if (instance instanceof ImmutableValueImmutableInfo) {
      return (ImmutableValueImmutableInfo) instance;
    }
    return ImmutableValueImmutableInfo.theBuilder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableValueImmutableInfo ImmutableValueImmutableInfo}.
   * <pre>
   * ImmutableValueImmutableInfo.theBuilder()
   *    .isDefault(boolean) // optional {@link ValueImmutableInfo#isDefault() isDefault}
   *    .builder(boolean) // required {@link ValueImmutableInfo#builder() builder}
   *    .copy(boolean) // required {@link ValueImmutableInfo#copy() copy}
   *    .intern(boolean) // required {@link ValueImmutableInfo#intern() intern}
   *    .prehash(boolean) // required {@link ValueImmutableInfo#prehash() prehash}
   *    .lazyhash(boolean) // required {@link ValueImmutableInfo#lazyhash() lazyhash}
   *    .singleton(boolean) // required {@link ValueImmutableInfo#singleton() singleton}
   *    .build();
   * </pre>
   * @return A new ImmutableValueImmutableInfo builder
   */
  public static ImmutableValueImmutableInfo.Builder theBuilder() {
    return new ImmutableValueImmutableInfo.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableValueImmutableInfo ImmutableValueImmutableInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ValueImmutableInfo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BUILDER = 0x1L;
    private static final long INIT_BIT_COPY = 0x2L;
    private static final long INIT_BIT_INTERN = 0x4L;
    private static final long INIT_BIT_PREHASH = 0x8L;
    private static final long INIT_BIT_LAZYHASH = 0x10L;
    private static final long INIT_BIT_SINGLETON = 0x20L;
    private static final long OPT_BIT_IS_DEFAULT = 0x1L;
    private long initBits = 0x3fL;
    private long optBits;

    private boolean isDefault;
    private boolean builder;
    private boolean copy;
    private boolean intern;
    private boolean prehash;
    private boolean lazyhash;
    private boolean singleton;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.value.processor.meta.ValueImmutableInfo} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueImmutableInfo instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.value.processor.meta.ValueMirrors.Immutable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ValueMirrors.Immutable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof ValueImmutableInfo) {
        ValueImmutableInfo instance = (ValueImmutableInfo) object;
        if ((bits & 0x1L) == 0) {
          singleton(instance.singleton());
          bits |= 0x1L;
        }
        isDefault(instance.isDefault());
        if ((bits & 0x2L) == 0) {
          intern(instance.intern());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          prehash(instance.prehash());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          lazyhash(instance.lazyhash());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          builder(instance.builder());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          copy(instance.copy());
          bits |= 0x20L;
        }
      }
      if (object instanceof ValueMirrors.Immutable) {
        ValueMirrors.Immutable instance = (ValueMirrors.Immutable) object;
        if ((bits & 0x1L) == 0) {
          singleton(instance.singleton());
          bits |= 0x1L;
        }
        if ((bits & 0x10L) == 0) {
          builder(instance.builder());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          intern(instance.intern());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          prehash(instance.prehash());
          bits |= 0x4L;
        }
        if ((bits & 0x20L) == 0) {
          copy(instance.copy());
          bits |= 0x20L;
        }
        if ((bits & 0x8L) == 0) {
          lazyhash(instance.lazyhash());
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#isDefault() isDefault} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ValueImmutableInfo#isDefault() isDefault}.</em>
     * @param isDefault The value for isDefault 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isDefault(boolean isDefault) {
      this.isDefault = isDefault;
      optBits |= OPT_BIT_IS_DEFAULT;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#builder() builder} attribute.
     * @param builder The value for builder 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder builder(boolean builder) {
      this.builder = builder;
      initBits &= ~INIT_BIT_BUILDER;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#copy() copy} attribute.
     * @param copy The value for copy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copy(boolean copy) {
      this.copy = copy;
      initBits &= ~INIT_BIT_COPY;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#intern() intern} attribute.
     * @param intern The value for intern 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder intern(boolean intern) {
      this.intern = intern;
      initBits &= ~INIT_BIT_INTERN;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#prehash() prehash} attribute.
     * @param prehash The value for prehash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prehash(boolean prehash) {
      this.prehash = prehash;
      initBits &= ~INIT_BIT_PREHASH;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#lazyhash() lazyhash} attribute.
     * @param lazyhash The value for lazyhash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder lazyhash(boolean lazyhash) {
      this.lazyhash = lazyhash;
      initBits &= ~INIT_BIT_LAZYHASH;
      return this;
    }

    /**
     * Initializes the value for the {@link ValueImmutableInfo#singleton() singleton} attribute.
     * @param singleton The value for singleton 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder singleton(boolean singleton) {
      this.singleton = singleton;
      initBits &= ~INIT_BIT_SINGLETON;
      return this;
    }

    /**
     * Builds a new {@link ImmutableValueImmutableInfo ImmutableValueImmutableInfo}.
     * @return An immutable instance of ValueImmutableInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableValueImmutableInfo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return ImmutableValueImmutableInfo.validate(new ImmutableValueImmutableInfo(this));
    }

    private boolean isDefaultIsSet() {
      return (optBits & OPT_BIT_IS_DEFAULT) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_BUILDER) != 0) attributes.add("builder");
      if ((initBits & INIT_BIT_COPY) != 0) attributes.add("copy");
      if ((initBits & INIT_BIT_INTERN) != 0) attributes.add("intern");
      if ((initBits & INIT_BIT_PREHASH) != 0) attributes.add("prehash");
      if ((initBits & INIT_BIT_LAZYHASH) != 0) attributes.add("lazyhash");
      if ((initBits & INIT_BIT_SINGLETON) != 0) attributes.add("singleton");
      return "Cannot build ValueImmutableInfo, some of required attributes are not set " + attributes;
    }
  }
}
