/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class LongBits
implements Function<Iterable<? extends Object>, LongPositions> {
    private static final int BITS_IN_LONG = 64;

    public LongPositions apply(Iterable<? extends Object> input) {
        return this.forIterable(input, 64);
    }

    public LongPositions forIterable(Iterable<? extends Object> input, int bitPerLong) {
        return new LongPositions(input, bitPerLong);
    }

    public static final class LongPositions
    implements Function<Object, BitPosition> {
        private final IdentityHashMap<Object, BitPosition> positions = Maps.newIdentityHashMap();
        private final ImmutableList<Object> elements;
        private final ImmutableMap<Integer, LongSet> longPositions;

        LongPositions(Iterable<? extends Object> elements, int bitPerLong) {
            this.elements = ImmutableList.copyOf(elements);
            Preconditions.checkArgument((bitPerLong <= 64 ? 1 : 0) != 0, (Object)bitPerLong);
            for (int i = 0; i < this.elements.size(); ++i) {
                this.positions.put(this.elements.get(i), new BitPosition(i / bitPerLong, i % bitPerLong));
            }
            this.longPositions = ImmutableSortedMap.copyOf((Map)Maps.transformEntries((Map)Multimaps.index(this.positions.values(), (Function)ToLongIndex.FUNCTION).asMap(), (Maps.EntryTransformer)new Maps.EntryTransformer<Integer, Collection<BitPosition>, LongSet>(){

                public LongSet transformEntry(Integer key, Collection<BitPosition> position) {
                    return new LongSet(key, position);
                }
            }));
        }

        public Set<Integer> longsIndeces() {
            return this.longPositions.keySet();
        }

        public Collection<LongSet> longs() {
            return this.longPositions.values();
        }

        @Nullable
        public BitPosition apply(Object input) {
            return this.positions.get(input);
        }
    }

    public static final class BitPosition {
        public final int index;
        public final int bit;
        public final long mask;

        BitPosition(int index, int bit) {
            this.index = index;
            this.bit = bit;
            this.mask = 1L << bit;
        }
    }

    static enum ToLongIndex implements Function<BitPosition, Integer>
    {
        FUNCTION;


        public Integer apply(BitPosition input) {
            return input.index;
        }
    }

    public static final class LongSet {
        public final int index;
        public final long occupation;
        public final Iterable<BitPosition> positions;

        LongSet(int index, Iterable<BitPosition> positions) {
            this.index = index;
            this.positions = ImmutableList.copyOf(positions);
            this.occupation = this.computeOccupation();
        }

        private long computeOccupation() {
            long occupation = 0L;
            for (BitPosition position : this.positions) {
                occupation |= position.mask;
            }
            return occupation;
        }
    }
}

