package org.immutables.value.processor.meta;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AttributeBuilderThirdPartyModel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAttributeBuilderThirdPartyModel.builder()}.
 */
@Generated(from = "AttributeBuilderThirdPartyModel", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableAttributeBuilderThirdPartyModel
    extends AttributeBuilderThirdPartyModel {
  private final ExecutableElement buildMethod;
  private final ExecutableElement copyMethod;
  private final ExecutableElement builderMethod;
  private final TypeElement builderType;

  private ImmutableAttributeBuilderThirdPartyModel(
      ExecutableElement buildMethod,
      ExecutableElement copyMethod,
      ExecutableElement builderMethod,
      TypeElement builderType) {
    this.buildMethod = buildMethod;
    this.copyMethod = copyMethod;
    this.builderMethod = builderMethod;
    this.builderType = builderType;
  }

  /**
   * @return The value of the {@code buildMethod} attribute
   */
  @Override
  protected ExecutableElement buildMethod() {
    return buildMethod;
  }

  /**
   * @return The value of the {@code copyMethod} attribute
   */
  @Override
  protected ExecutableElement copyMethod() {
    return copyMethod;
  }

  /**
   * @return The value of the {@code builderMethod} attribute
   */
  @Override
  protected ExecutableElement builderMethod() {
    return builderMethod;
  }

  /**
   * @return The value of the {@code builderType} attribute
   */
  @Override
  protected TypeElement builderType() {
    return builderType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderThirdPartyModel#buildMethod() buildMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buildMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderThirdPartyModel withBuildMethod(ExecutableElement value) {
    if (this.buildMethod == value) return this;
    ExecutableElement newValue = Objects.requireNonNull(value, "buildMethod");
    return new ImmutableAttributeBuilderThirdPartyModel(newValue, this.copyMethod, this.builderMethod, this.builderType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderThirdPartyModel#copyMethod() copyMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for copyMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderThirdPartyModel withCopyMethod(ExecutableElement value) {
    if (this.copyMethod == value) return this;
    ExecutableElement newValue = Objects.requireNonNull(value, "copyMethod");
    return new ImmutableAttributeBuilderThirdPartyModel(this.buildMethod, newValue, this.builderMethod, this.builderType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderThirdPartyModel#builderMethod() builderMethod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderMethod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderThirdPartyModel withBuilderMethod(ExecutableElement value) {
    if (this.builderMethod == value) return this;
    ExecutableElement newValue = Objects.requireNonNull(value, "builderMethod");
    return new ImmutableAttributeBuilderThirdPartyModel(this.buildMethod, this.copyMethod, newValue, this.builderType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AttributeBuilderThirdPartyModel#builderType() builderType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for builderType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributeBuilderThirdPartyModel withBuilderType(TypeElement value) {
    if (this.builderType == value) return this;
    TypeElement newValue = Objects.requireNonNull(value, "builderType");
    return new ImmutableAttributeBuilderThirdPartyModel(this.buildMethod, this.copyMethod, this.builderMethod, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttributeBuilderThirdPartyModel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttributeBuilderThirdPartyModel
        && equalTo((ImmutableAttributeBuilderThirdPartyModel) another);
  }

  private boolean equalTo(ImmutableAttributeBuilderThirdPartyModel another) {
    return buildMethod.equals(another.buildMethod)
        && copyMethod.equals(another.copyMethod)
        && builderMethod.equals(another.builderMethod)
        && builderType.equals(another.builderType);
  }

  /**
   * Computes a hash code from attributes: {@code buildMethod}, {@code copyMethod}, {@code builderMethod}, {@code builderType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + buildMethod.hashCode();
    h += (h << 5) + copyMethod.hashCode();
    h += (h << 5) + builderMethod.hashCode();
    h += (h << 5) + builderType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AttributeBuilderThirdPartyModel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AttributeBuilderThirdPartyModel")
        .omitNullValues()
        .add("buildMethod", buildMethod)
        .add("copyMethod", copyMethod)
        .add("builderMethod", builderMethod)
        .add("builderType", builderType)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AttributeBuilderThirdPartyModel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AttributeBuilderThirdPartyModel instance
   */
  public static ImmutableAttributeBuilderThirdPartyModel copyOf(AttributeBuilderThirdPartyModel instance) {
    if (instance instanceof ImmutableAttributeBuilderThirdPartyModel) {
      return (ImmutableAttributeBuilderThirdPartyModel) instance;
    }
    return ImmutableAttributeBuilderThirdPartyModel.builder()
        .buildMethod(instance.buildMethod())
        .copyMethod(instance.copyMethod())
        .builderMethod(instance.builderMethod())
        .builderType(instance.builderType())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAttributeBuilderThirdPartyModel ImmutableAttributeBuilderThirdPartyModel}.
   * <pre>
   * ImmutableAttributeBuilderThirdPartyModel.builder()
   *    .buildMethod(javax.lang.model.element.ExecutableElement) // required {@link AttributeBuilderThirdPartyModel#buildMethod() buildMethod}
   *    .copyMethod(javax.lang.model.element.ExecutableElement) // required {@link AttributeBuilderThirdPartyModel#copyMethod() copyMethod}
   *    .builderMethod(javax.lang.model.element.ExecutableElement) // required {@link AttributeBuilderThirdPartyModel#builderMethod() builderMethod}
   *    .builderType(javax.lang.model.element.TypeElement) // required {@link AttributeBuilderThirdPartyModel#builderType() builderType}
   *    .build();
   * </pre>
   * @return A new ImmutableAttributeBuilderThirdPartyModel builder
   */
  public static ImmutableAttributeBuilderThirdPartyModel.Builder builder() {
    return new ImmutableAttributeBuilderThirdPartyModel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAttributeBuilderThirdPartyModel ImmutableAttributeBuilderThirdPartyModel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AttributeBuilderThirdPartyModel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_BUILD_METHOD = 0x1L;
    private static final long INIT_BIT_COPY_METHOD = 0x2L;
    private static final long INIT_BIT_BUILDER_METHOD = 0x4L;
    private static final long INIT_BIT_BUILDER_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable ExecutableElement buildMethod;
    private @Nullable ExecutableElement copyMethod;
    private @Nullable ExecutableElement builderMethod;
    private @Nullable TypeElement builderType;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link AttributeBuilderThirdPartyModel#buildMethod() buildMethod} attribute.
     * @param buildMethod The value for buildMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder buildMethod(ExecutableElement buildMethod) {
      checkNotIsSet(buildMethodIsSet(), "buildMethod");
      this.buildMethod = Objects.requireNonNull(buildMethod, "buildMethod");
      initBits &= ~INIT_BIT_BUILD_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderThirdPartyModel#copyMethod() copyMethod} attribute.
     * @param copyMethod The value for copyMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder copyMethod(ExecutableElement copyMethod) {
      checkNotIsSet(copyMethodIsSet(), "copyMethod");
      this.copyMethod = Objects.requireNonNull(copyMethod, "copyMethod");
      initBits &= ~INIT_BIT_COPY_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderThirdPartyModel#builderMethod() builderMethod} attribute.
     * @param builderMethod The value for builderMethod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder builderMethod(ExecutableElement builderMethod) {
      checkNotIsSet(builderMethodIsSet(), "builderMethod");
      this.builderMethod = Objects.requireNonNull(builderMethod, "builderMethod");
      initBits &= ~INIT_BIT_BUILDER_METHOD;
      return this;
    }

    /**
     * Initializes the value for the {@link AttributeBuilderThirdPartyModel#builderType() builderType} attribute.
     * @param builderType The value for builderType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder builderType(TypeElement builderType) {
      checkNotIsSet(builderTypeIsSet(), "builderType");
      this.builderType = Objects.requireNonNull(builderType, "builderType");
      initBits &= ~INIT_BIT_BUILDER_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAttributeBuilderThirdPartyModel ImmutableAttributeBuilderThirdPartyModel}.
     * @return An immutable instance of AttributeBuilderThirdPartyModel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAttributeBuilderThirdPartyModel build() {
      checkRequiredAttributes();
      return new ImmutableAttributeBuilderThirdPartyModel(buildMethod, copyMethod, builderMethod, builderType);
    }

    private boolean buildMethodIsSet() {
      return (initBits & INIT_BIT_BUILD_METHOD) == 0;
    }

    private boolean copyMethodIsSet() {
      return (initBits & INIT_BIT_COPY_METHOD) == 0;
    }

    private boolean builderMethodIsSet() {
      return (initBits & INIT_BIT_BUILDER_METHOD) == 0;
    }

    private boolean builderTypeIsSet() {
      return (initBits & INIT_BIT_BUILDER_TYPE) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of AttributeBuilderThirdPartyModel is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!buildMethodIsSet()) attributes.add("buildMethod");
      if (!copyMethodIsSet()) attributes.add("copyMethod");
      if (!builderMethodIsSet()) attributes.add("builderMethod");
      if (!builderTypeIsSet()) attributes.add("builderType");
      return "Cannot build AttributeBuilderThirdPartyModel, some of required attributes are not set " + attributes;
    }
  }
}
