/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Preconditions;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

final class CheckedExceptionProbe {
    private final Types types;
    private final DeclaredType exceptionType;
    private final DeclaredType runtimeExceptionType;

    CheckedExceptionProbe(Types types, Elements elements) {
        this.types = types;
        this.exceptionType = CheckedExceptionProbe.getTypeMirror(types, elements, Exception.class);
        this.runtimeExceptionType = CheckedExceptionProbe.getTypeMirror(types, elements, RuntimeException.class);
    }

    private static DeclaredType getTypeMirror(Types types, Elements elements, Class<?> reflected) {
        TypeElement typeElement = elements.getTypeElement(reflected.getName());
        Preconditions.checkState((typeElement != null ? 1 : 0) != 0, (String)"type must be present: %s", (Object[])new Object[]{reflected.getName()});
        return types.getDeclaredType(typeElement, new TypeMirror[0]);
    }

    boolean isCheckedException(TypeMirror throwable) {
        return this.types.isSubtype(throwable, this.exceptionType) && !this.types.isSubtype(throwable, this.runtimeExceptionType);
    }
}

