/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.meta;

import com.google.common.base.Ascii;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.immutables.generator.AnnotationMirrors;
import org.immutables.generator.SourceExtraction;
import org.immutables.generator.SourceTypes;
import org.immutables.value.processor.encode.SourceStructureGet;
import org.immutables.value.processor.meta.Annotations;
import org.immutables.value.processor.meta.ImportsTypeStringResolver;
import org.immutables.value.processor.meta.Reporter;
import org.immutables.value.processor.meta.ValueAttribute;

class TypeStringProvider {
    private final TypeMirror startType;
    private final Element element;
    private final List<String> typeParameterStrings = Lists.newArrayListWithCapacity((int)2);
    private StringBuilder buffer;
    boolean unresolvedTypeHasOccured;
    boolean hasMaybeUnresolvedYetAfter;
    boolean hasTypeVariables;
    private String rawTypeName;
    private String returnTypeName;
    private boolean ended;
    @Nullable
    private List<String> workaroundTypeParameters;
    @Nullable
    private String workaroundTypeString;
    private final Reporter reporter;
    private final String[] allowedTypevars;
    @Nullable
    private final String[] typevarArguments;
    private final ImportsTypeStringResolver importsResolver;
    @Nullable
    String elementTypeAnnotations;
    @Nullable
    String secondaryElementTypeAnnotation;
    boolean processNestedTypeUseAnnotations;
    boolean forAttribute = false;
    ValueAttribute.NullElements nullElements = ValueAttribute.NullElements.BAN;
    boolean nullableTypeAnnotation;
    @Nullable
    SourceExtractionCache sourceExtractionCache;
    private Set<String> unresolvedYetArguments;
    static final String EPHEMERAL_ANNOTATION_NULLABLE = "Nullable";
    static final String EPHEMERAL_ANNOTATION_ALLOW_NULLS = "AllowNulls";
    static final String EPHEMERAL_ANNOTATION_SKIP_NULLS = "SkipNulls";

    TypeStringProvider(Reporter reporter, Element element, TypeMirror startType, ImportsTypeStringResolver importsResolver, String[] allowedTypevars, @Nullable String[] typevarArguments) {
        this.reporter = reporter;
        this.startType = startType;
        this.element = element;
        this.allowedTypevars = allowedTypevars;
        this.typevarArguments = typevarArguments;
        this.importsResolver = importsResolver;
        Preconditions.checkArgument((typevarArguments == null || allowedTypevars.length == typevarArguments.length ? 1 : 0) != 0, (String)"Element %s, mismatching type variables, allowed: %s, given: %s", (Object[])new Object[]{element.getSimpleName(), Arrays.asList(allowedTypevars), typevarArguments == null ? null : Arrays.asList(typevarArguments)});
    }

    String rawTypeName() {
        return this.rawTypeName;
    }

    String returnTypeName() {
        return this.returnTypeName;
    }

    boolean hasSomeUnresovedTypes() {
        return this.hasMaybeUnresolvedYetAfter;
    }

    ImmutableList<String> typeParameters() {
        return ImmutableList.copyOf(this.workaroundTypeParameters != null ? this.workaroundTypeParameters : this.typeParameterStrings);
    }

    void process() {
        if (this.startType.getKind().isPrimitive()) {
            String typeName;
            this.rawTypeName = typeName = Ascii.toLowerCase((String)this.startType.getKind().name());
            this.returnTypeName = typeName;
            List annotations = AnnotationMirrors.from((TypeMirror)this.startType);
            if (!annotations.isEmpty()) {
                this.returnTypeName = this.typeAnnotationsToBuffer(annotations, false).append(typeName).toString();
            }
        } else {
            TypeKind k;
            this.buffer = new StringBuilder(100);
            this.caseType(this.startType);
            if (this.workaroundTypeString != null) {
                this.buffer = new StringBuilder(this.workaroundTypeString);
            }
            if ((k = this.startType.getKind()) == TypeKind.DECLARED || k == TypeKind.ERROR) {
                this.insertTypeAnnotationsIfPresent(this.startType, 0, this.rawTypeName.length());
            }
            this.returnTypeName = this.buffer.toString();
        }
    }

    private void appendResolved(DeclaredType type) {
        TypeElement typeElement = (TypeElement)type.asElement();
        String typeName = typeElement.getQualifiedName().toString();
        if (this.unresolvedTypeHasOccured) {
            typeName = type == this.startType && this.forAttribute ? this.importsResolver.resolveTopForAttribute(typeName) : this.importsResolver.apply(typeName);
            if (type != this.startType && this.importsResolver.unresolved && this.unresolvedYetArguments != null) {
                this.unresolvedYetArguments.add(typeName);
            }
            this.hasMaybeUnresolvedYetAfter |= this.importsResolver.unresolved;
        }
        this.buffer.append(typeName);
        if (this.startType == type) {
            this.rawTypeName = typeName;
        }
    }

    private void insertTypeAnnotationsIfPresent(TypeMirror type, int typeStart, int typeEnd) {
        List annotations = AnnotationMirrors.from((TypeMirror)type);
        if (!annotations.isEmpty()) {
            StringBuilder annotationBuffer = this.typeAnnotationsToBuffer(annotations, false);
            int insertionIndex = typeStart + this.buffer.substring(typeStart, typeEnd).lastIndexOf(46) + 1;
            this.buffer.insert(insertionIndex, annotationBuffer);
        }
    }

    private StringBuilder typeAnnotationsToBuffer(List<? extends AnnotationMirror> annotations, boolean nestedTypeUse) {
        StringBuilder annotationBuffer = new StringBuilder(100);
        for (AnnotationMirror annotationMirror : annotations) {
            boolean canBeAppliedToMethodAsWell;
            boolean bl = canBeAppliedToMethodAsWell = !nestedTypeUse && Annotations.annotationMatchesTarget(annotationMirror.getAnnotationType().asElement(), ElementType.METHOD);
            if (canBeAppliedToMethodAsWell) continue;
            CharSequence sequence = AnnotationMirrors.toCharSequence((AnnotationMirror)annotationMirror, (Function)this.importsResolver);
            if (!this.nullableTypeAnnotation && sequence.toString().endsWith(EPHEMERAL_ANNOTATION_NULLABLE)) {
                this.nullableTypeAnnotation = true;
            }
            annotationBuffer.append(sequence).append(' ');
        }
        return annotationBuffer;
    }

    private boolean tryToUseSourceAsAWorkaround() {
        if (this.element.getKind() != ElementKind.METHOD) {
            return false;
        }
        CharSequence returnTypeString = SourceExtraction.getReturnTypeString((ExecutableElement)((ExecutableElement)this.element));
        if (returnTypeString.length() == 0 && this.sourceExtractionCache != null) {
            try {
                SourceStructureGet sourceStructure = this.sourceExtractionCache.readCachedSourceGet();
                if (sourceStructure != null) {
                    String accessorPath = this.computePath((ExecutableElement)this.element);
                    returnTypeString = sourceStructure.getReturnType(accessorPath);
                }
            }
            catch (Error | RuntimeException bestEffortsMiserablyFailed) {
                return false;
            }
        }
        if (returnTypeString.length() == 0) {
            return false;
        }
        Map.Entry extractedTypes = SourceTypes.extract((CharSequence)returnTypeString);
        Map.Entry<String, List<String>> resolvedTypes = this.resolveTypes(extractedTypes);
        this.rawTypeName = resolvedTypes.getKey();
        this.workaroundTypeParameters = resolvedTypes.getValue();
        this.workaroundTypeString = SourceTypes.stringify(resolvedTypes);
        return true;
    }

    private String computePath(ExecutableElement element) {
        String path = element.getSimpleName().toString();
        Element e = element.getEnclosingElement();
        while (e.getKind().isClass() || e.getKind().isInterface()) {
            path = e.getSimpleName() + "." + path;
            e = e.getEnclosingElement();
        }
        if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return path;
        }
        return path + "()";
    }

    private Map.Entry<String, List<String>> resolveTypes(Map.Entry<String, List<String>> sourceTypes) {
        String typeName = sourceTypes.getKey();
        typeName = this.importsResolver.apply(typeName);
        this.hasMaybeUnresolvedYetAfter |= this.importsResolver.unresolved;
        ArrayList typeArguments = Lists.newArrayListWithCapacity((int)sourceTypes.getValue().size());
        for (String typeArgument : sourceTypes.getValue()) {
            String resolvedTypeArgument = SourceTypes.stringify(this.resolveTypes(SourceTypes.extract((CharSequence)typeArgument)));
            typeArguments.add(resolvedTypeArgument);
        }
        return Maps.immutableEntry((Object)typeName, (Object)typeArguments);
    }

    void caseType(TypeMirror type) {
        if (this.ended) {
            return;
        }
        switch (type.getKind()) {
            case ERROR: {
                this.unresolvedTypeHasOccured = true;
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                this.appendResolved(declaredType);
                this.appendTypeArguments(type, declaredType);
                break;
            }
            case ARRAY: {
                TypeMirror componentType = ((ArrayType)type).getComponentType();
                int mark = this.buffer.length();
                this.caseType(componentType);
                this.cutTypeArgument(type, mark);
                this.buffer.append('[').append(']');
                break;
            }
            case WILDCARD: {
                WildcardType wildcard = (WildcardType)type;
                TypeMirror extendsBound = wildcard.getExtendsBound();
                TypeMirror superBound = wildcard.getSuperBound();
                if (extendsBound != null) {
                    this.buffer.append("? extends ");
                    this.caseType(extendsBound);
                    break;
                }
                if (superBound != null) {
                    this.buffer.append("? super ");
                    this.caseType(superBound);
                    break;
                }
                this.buffer.append('?');
                break;
            }
            case TYPEVAR: {
                if (this.allowedTypevars.length != 0) {
                    TypeVariable typeVariable = (TypeVariable)type;
                    String var = typeVariable.toString();
                    int indexOfVar = Arrays.asList(this.allowedTypevars).indexOf(var);
                    if (indexOfVar >= 0) {
                        if (this.typevarArguments != null) {
                            this.buffer.append(this.typevarArguments[indexOfVar]);
                            break;
                        }
                        this.hasTypeVariables = true;
                        this.buffer.append(var);
                        break;
                    }
                }
                if (this.tryToUseSourceAsAWorkaround()) {
                    this.ended = true;
                    break;
                }
                this.reporter.withElement(this.element).error("It is a compiler/annotation processing bug to receive type variable '%s' here. To avoid it \u2014 do not use not yet generated types in %s attribute", type, this.element.getSimpleName());
                this.buffer.append(type);
                break;
            }
            default: {
                this.buffer.append(type);
            }
        }
        if (this.unresolvedTypeHasOccured && this.buffer.toString().contains("<any>") && this.tryToUseSourceAsAWorkaround()) {
            this.ended = true;
        }
    }

    private void appendTypeArguments(TypeMirror type, DeclaredType declaredType) {
        List<? extends TypeMirror> arguments = declaredType.getTypeArguments();
        if (!arguments.isEmpty()) {
            this.buffer.append('<');
            boolean notFirst = false;
            for (TypeMirror typeMirror : arguments) {
                this.typeAnnotationHandle(typeMirror);
                if (notFirst) {
                    this.buffer.append(',').append(' ');
                }
                notFirst = true;
                int mark = this.buffer.length();
                this.caseType(typeMirror);
                this.cutTypeArgument(type, mark);
            }
            this.buffer.append('>');
        }
    }

    private void typeAnnotationHandle(TypeMirror argument) {
        if (!this.processNestedTypeUseAnnotations) {
            return;
        }
        List annotations = AnnotationMirrors.from((TypeMirror)argument);
        if (!annotations.isEmpty()) {
            String typeAnnotations = this.typeAnnotationsToBuffer(annotations, true).toString();
            this.assignElementNullness(typeAnnotations);
        }
    }

    private void assignElementNullness(String annotationString) {
        if (annotationString != null) {
            if (annotationString.contains(EPHEMERAL_ANNOTATION_NULLABLE) || annotationString.contains(EPHEMERAL_ANNOTATION_ALLOW_NULLS)) {
                this.nullElements = ValueAttribute.NullElements.ALLOW;
            } else if (annotationString.contains(EPHEMERAL_ANNOTATION_SKIP_NULLS)) {
                this.nullElements = ValueAttribute.NullElements.SKIP;
            }
        }
    }

    private void cutTypeArgument(TypeMirror type, int mark) {
        if (this.startType == type) {
            this.typeParameterStrings.add(this.buffer.substring(mark));
        }
    }

    void collectUnresolvedYetArgumentsTo(Set<String> unresolvedYetArguments) {
        this.unresolvedYetArguments = unresolvedYetArguments;
    }

    static interface SourceExtractionCache {
        @Nullable
        public SourceStructureGet readCachedSourceGet();
    }
}

