/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import org.immutables.generator.Intrinsics;
import org.immutables.generator.Templates;
import org.immutables.value.processor.Repositories;
import org.immutables.value.processor.meta.HasStyleInfo;
import org.immutables.value.processor.meta.ValueAttribute;
import org.immutables.value.processor.meta.ValueType;

public class Generator_Repositories
extends Repositories {
    private final Templates.Invokable generate = new FragmentDispatch(0, 0);
    private final Templates.Invokable generateRepository = new FragmentDispatch(1, 1);
    private final Templates.Invokable generateOrderingAndExcludes = new FragmentDispatch(2, 2);
    private final Templates.Invokable generateFinder = new FragmentDispatch(1, 3);
    private final Templates.Invokable generateAndReplaceFirst = new FragmentDispatch(1, 4);
    private final Templates.Invokable generateAndModifyFirst = new FragmentDispatch(1, 5);
    private final Templates.Invokable generateIndexer = new FragmentDispatch(1, 6);
    private final Templates.Invokable generateUpdater = new FragmentDispatch(1, 7);
    private final Templates.Invokable generateReplacer = new FragmentDispatch(1, 8);
    private final Templates.Invokable generateModifier = new FragmentDispatch(1, 9);
    private final Templates.Invokable generateUpdatingMethods = new FragmentDispatch(2, 10);
    private final Templates.Invokable generateCriteria = new FragmentDispatch(1, 11);
    private final Templates.Invokable generateSerializationHelpers = new FragmentDispatch(1, 12);
    private final Templates.Invokable getEncoder = new FragmentDispatch(2, 13);
    private final Templates.Invokable wrapMarshalable = new FragmentDispatch(1, 14);
    private final Templates.Invokable wrapSecondaryMarshalable = new FragmentDispatch(1, 15);
    private final Templates.Invokable atCheckReturnValue = new FragmentDispatch(1, 16);
    private final Templates.Invokable atNotThreadSafe = new FragmentDispatch(1, 17);
    private final Templates.Invokable atGenerated = new FragmentDispatch(1, 18);

    @Override
    public Templates.Invokable generate() {
        return this.generate;
    }

    void _t0__generate(Templates.Invokation __) {
        __.dl();
        __.ln();
        __.out("  ");
        Templates.Iteration _it1 = new Templates.Iteration();
        for (final ValueType type : Intrinsics.$in((Iterable)this.values.values())) {
            if (!Intrinsics.$if((boolean)type.isGenerateRepository())) continue;
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type.kind().isValue(), (Templates.Binary)this.andnot, (Object)type.generics())))) {
                __.dl();
                __.ln();
                Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.output.java, (Object[])new Object[]{type.$$package(), Intrinsics.$((String)type.name(), (String)"Repository"), type.element, new Templates.Fragment(0){

                    public void run(Templates.Invokation __) {
                        __.dl();
                        __.ln();
                        Intrinsics.$((Templates.Invokation)__, (Object)type.sourceHeader());
                        __.ln();
                        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)Generator_Repositories.this.generateRepository, (Object[])new Object[]{type});
                        __.ln();
                        __.dl();
                    }
                }});
                __.ln();
                __.out("    ");
            } else {
                __.dl();
                __.ln();
                Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.output.error, (Object[])new Object[]{new Templates.Fragment(0){

                    public void run(Templates.Invokation __) {
                        __.dl();
                        __.ln();
                        __.out("Use @Mongo.Repository to annotate @Value.Immutable abstract value types with no type variables").ln();
                        __.dl();
                    }
                }});
                __.ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("  ");
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable generateRepository() {
        return this.generateRepository;
    }

    void _t1__generateRepository(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.dl();
        if (Intrinsics.$if((String)type.$$package())) {
            __.dl();
            __.ln();
            __.out("package ");
            Intrinsics.$((Templates.Invokation)__, (String)type.$$package());
            __.out(";").ln();
        }
        __.dl();
        __.ln();
        __.ln();
        __.out("import com.mongodb.DBCollection;").ln();
        __.out("import com.mongodb.DBObject;").ln();
        __.out("import org.immutables.mongo.repository.Repositories;").ln();
        __.out("import org.immutables.mongo.repository.RepositorySetup;").ln();
        __.out("import org.immutables.mongo.concurrent.FluentFuture;").ln();
        __.out("import org.immutables.mongo.repository.internal.Constraints;").ln();
        __.out("import org.immutables.mongo.repository.internal.Support;").ln();
        __.ln();
        __.out("import org.bson.codecs.Encoder;").ln();
        __.out("import org.bson.codecs.configuration.CodecRegistry;").ln();
        __.out("import org.bson.conversions.Bson;").ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        for (String starImport : Intrinsics.$in(type.getRequiredSourceStarImports())) {
            __.dl();
            __.ln();
            __.out("import ");
            Intrinsics.$((Templates.Invokation)__, (String)starImport);
            __.out(";").ln();
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * A {@code ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository} provides type-safe access for storing and retrieving documents").ln();
        __.out(" * from the MongoDB collection {@code \"");
        Intrinsics.$((Templates.Invokation)__, (String)type.getDocumentName());
        __.out("\"}.").ln();
        __.out(" ");
        __.dl();
        if (Intrinsics.$if((boolean)type.getRepository().readonly())) {
            __.dl();
            __.ln();
            __.out(" *").ln();
            __.out(" * This repository was marked as readonly and therefore write operations have been disabled.").ln();
            __.out(" ");
        }
        __.dl();
        __.ln();
        __.out(" */").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        __.dl();
        if (Intrinsics.$if(type.generatedSuppressWarnings())) {
            __.dl();
            __.ln();
            __.out("@SuppressWarnings({");
            _it1 = new Templates.Iteration();
            for (String k : Intrinsics.$in(type.generatedSuppressWarnings())) {
                __.dl();
                __.dl();
                if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)_it1.first))) {
                    __.dl();
                    __.out(", ");
                }
                __.dl();
                Intrinsics.$((Templates.Invokation)__, (Function)this.literal, (Object)k);
                __.dl();
                ++_it1.index;
                _it1.first = false;
            }
            __.dl();
            __.out("})").ln();
        }
        __.dl();
        __.ln();
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.ParametersAreNonnullByDefault")))) {
            __.dl();
            __.ln();
            __.out("@javax.annotation.ParametersAreNonnullByDefault").ln();
        }
        __.dl();
        __.ln();
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.processing.Generated")))) {
            __.dl();
            __.ln();
            __.out("@javax.annotation.processing.Generated(\"org.immutables.processor.ProxyProcessor\")").ln();
        } else if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.Generated")))) {
            __.dl();
            __.ln();
            __.out("@javax.annotation.Generated(\"org.immutables.processor.ProxyProcessor\")").ln();
        }
        __.dl();
        __.ln();
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.concurrent.ThreadSafe")))) {
            __.dl();
            __.ln();
            __.out("@javax.annotation.concurrent.ThreadSafe").ln();
        }
        __.dl();
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (String)type.typeDocument().access());
        __.out("class ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository extends Repositories.Repository<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out("> {").ln();
        __.out("  private static final String DOCUMENT_COLLECTION_NAME = \"");
        Intrinsics.$((Templates.Invokation)__, (String)type.getDocumentName());
        __.out("\";").ln();
        __.ln();
        __.out("  private final Serialization serialization;").ln();
        __.out("  private final Criteria anyCriteria;").ln();
        __.ln();
        __.out("  /**").ln();
        __.out("   * Constructs a {@link ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("} repository using {@link RepositorySetup configuration}.").ln();
        __.out("   * @param configuration The repository configuration").ln();
        __.out("   */").ln();
        __.out("  public ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository(RepositorySetup configuration) {").ln();
        __.out("    super(configuration, DOCUMENT_COLLECTION_NAME, ");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(".class);").ln();
        __.out("    this.serialization = new Serialization(codecRegistry(), fieldNamingStrategy());").ln();
        __.out("    this.anyCriteria = new Criteria(this.serialization, Constraints.nilConstraint());").ln();
        __.out("  }").ln();
        __.out("  ");
        __.dl();
        if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
            __.dl();
            __.ln();
            __.ln();
            __.out("  /**").ln();
            __.out("   * Inserts a single document into the collection.").ln();
            __.out("   * @param document The ");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)type.name());
            __.out(" to insert").ln();
            __.out("   * @return A future representing the number of inserted documents (1) if WriteConcern allows the insertion.").ln();
            __.out("   */").ln();
            __.out("  public FluentFuture<Integer> insert(");
            Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
            __.out(" document) {").ln();
            __.out("    return super.doInsert(com.google.common.collect.ImmutableList.of(document));").ln();
            __.out("  }").ln();
            __.ln();
            __.out("  /**").ln();
            __.out("   * Insert documents into the collection.").ln();
            __.out("   * @param documents The documents to insert").ln();
            __.out("   * @return A future representing the number of inserted documents if WriteConcern allows the insertion.").ln();
            __.out("   */").ln();
            __.out("  public FluentFuture<Integer> insert(Iterable<? extends ");
            Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
            __.out("> documents) {").ln();
            __.out("    return super.doInsert(com.google.common.collect.ImmutableList.copyOf(documents));").ln();
            __.out("  }").ln();
            __.out("  ");
        }
        __.dl();
        __.ln();
        __.ln();
        __.out("  /**").ln();
        __.out("   * Finds all documents. Use the returned {@link Finder} object to complete").ln();
        __.out("   * {@link Finder#fetchAll() fetch all} or other operations.").ln();
        __.out("   * @return A finder object used to complete operations").ln();
        __.out("   */").ln();
        __.out("  ");
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("  public Finder findAll() {").ln();
        __.out("    return find(criteria());").ln();
        __.out("  }").ln();
        __.ln();
        __.out("  /**").ln();
        __.out("   * Find documents by the criteria expressed as a JSON string. Use the returned {@link Finder} object to complete").ln();
        __.out("   * {@link Finder#fetchAll() fetch} or {@link Finder#fetchFirst() fetch} operations.").ln();
        __.out("   * @param jsonCriteria A JSON string for native criteria").ln();
        __.out("   * @return A finder object used to complete operations").ln();
        __.out("   */").ln();
        __.out("  ");
        s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("  public Finder find(String jsonCriteria) {").ln();
        __.out("    return new Finder(this, Support.jsonQuery(jsonCriteria));").ln();
        __.out("  }").ln();
        _it1 = new Templates.Iteration();
        ValueAttribute a = (ValueAttribute)Intrinsics.$cast((Object)type.getIdAttribute());
        __.dl();
        __.ln();
        __.dl();
        if (Intrinsics.$if((Object)a)) {
            __.dl();
            __.ln();
            __.ln();
            __.out("  /**").ln();
            __.out("   * Find documents by the {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} identity attribute. Use the returned {@link Finder} object to complete").ln();
            __.out("   * {@link Finder#fetchFirst() fetch} or {@link Finder#fetchAll() fetchAll} read operations.").ln();
            __.out("   ");
            __.dl();
            if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
                __.dl();
                __.ln();
                __.out("   * You can also use {@link Finder#andModifyFirst() modify}, {@link Finder#andReplaceFirst(");
                Intrinsics.$((Templates.Invokation)__, (String)type.typeDocument().relativeRaw());
                __.out(") replace}").ln();
                __.out("   * or {@link Finder#deleteFirst() delete} operations to update / delete the document.").ln();
                __.out("   ");
            }
            __.dl();
            __.ln();
            __.out("   * @param ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out(" The exact {@code ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} value").ln();
            __.out("   * @return A finder object used to complete operations").ln();
            __.out("   */").ln();
            __.out("  ");
            HasStyleInfo s_atCheckReturnValue_20405237042 = (HasStyleInfo)Intrinsics.$cast((Object)type);
            __.dl();
            if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_20405237042, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
                __.dl();
                __.out("@javax.annotation.CheckReturnValue");
            }
            __.dl();
            __.ln();
            __.out("  public Finder findBy");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("(");
            Intrinsics.$((Templates.Invokation)__, (String)a.getType());
            __.out(" ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out(") {").ln();
            __.out("    return find(criteria().");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("(");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("));").ln();
            __.out("  }").ln();
            __.out("  ");
            __.dl();
            if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
                __.dl();
                __.ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Update or insert a document, matched by the identifier value of the '");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("' attribute.").ln();
                __.out("   * @param document The ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)type.name());
                __.out(" to upsert").ln();
                __.out("   * @return A future representing the of number of inserted documents (1) if WriteConcern allows the insertion.").ln();
                __.out("   */").ln();
                __.out("  public FluentFuture<Integer> upsert(");
                Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
                __.out(" document) {").ln();
                __.out("    Criteria byId = criteria().");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("(document.");
                Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
                __.out("());").ln();
                __.out("    return super.doUpsert(byId.constraint, document);").ln();
                __.out("  }").ln();
                __.out("  ");
            }
            __.dl();
            __.ln();
        }
        __.dl();
        __.ln();
        __.dl();
        ++_it1.index;
        _it1.first = false;
        __.dl();
        __.ln();
        __.out("  ");
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateFinder, (Object[])new Object[]{type});
        __.ln();
        __.dl();
        if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
            __.dl();
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateUpdater, (Object[])new Object[]{type});
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateModifier, (Object[])new Object[]{type});
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateReplacer, (Object[])new Object[]{type});
            __.ln();
        }
        __.dl();
        __.ln();
        __.dl();
        if (Intrinsics.$if((boolean)type.getRepository().index())) {
            __.dl();
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateIndexer, (Object[])new Object[]{type});
            __.ln();
        }
        __.dl();
        __.ln();
        __.out("  ");
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateCriteria, (Object[])new Object[]{type});
        __.ln();
        __.out("  ");
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateSerializationHelpers, (Object[])new Object[]{type});
        __.ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateOrderingAndExcludes() {
        return this.generateOrderingAndExcludes;
    }

    void _t2__generateOrderingAndExcludes(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        String tT = __.param(1).toString();
        __.ln();
        __.out("  ");
        Templates.Iteration _it1 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in(type.allMarshalingAttributes())) {
            __.dl();
            __.ln();
            __.ln();
            __.out("/**").ln();
            __.out(" * Order by {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} in the ascending direction.").ln();
            __.out(" * Specify that the next attribute to sort will be the {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} attribute using ascending order").ln();
            __.out(" * in the the chain of comparisons performed to sort results.").ln();
            __.out(" * @return {@code this} ");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
            __.out(" for use in a chained invocation").ln();
            __.out(" */").ln();
            __.out("public ");
            Intrinsics.$((Templates.Invokation)__, (String)tT);
            __.out(" orderBy");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("() {").ln();
            __.out("  ordering = ordering.equal(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name, false, 1);").ln();
            __.out("  return this;").ln();
            __.out("}").ln();
            __.ln();
            __.out("/**").ln();
            __.out(" * Order by {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} in the descending direction.").ln();
            __.out(" * Specify that the next attribute to sort will be the {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} attribute using descending order").ln();
            __.out(" * in the the chain of comparisons performed to sort results.").ln();
            __.out(" * @return {@code this} ");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
            __.out(" for use in a chained invocation").ln();
            __.out(" */").ln();
            __.out("public ");
            Intrinsics.$((Templates.Invokation)__, (String)tT);
            __.out(" orderBy");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("Desceding() {").ln();
            __.out("  ordering = ordering.equal(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name, false, -1);").ln();
            __.out("  return this;").ln();
            __.out("}").ln();
            __.out("  ");
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.out("  ");
        _it1 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in(type.getExcludableAttributes())) {
            __.dl();
            __.ln();
            __.ln();
            __.out("/**").ln();
            __.out(" * Exclude the {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("} attribute from each document in the results.").ln();
            __.out(" * @return {@code this} ");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
            __.out(" for use in a chained invocation").ln();
            __.out(" */").ln();
            __.out("public ");
            Intrinsics.$((Templates.Invokation)__, (String)tT);
            __.out(" exclude");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("() {").ln();
            __.out("  exclusion = exclusion.equal(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name, false, -1);").ln();
            __.out("  return this;").ln();
            __.out("}").ln();
            __.out("  ");
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable generateFinder() {
        return this.generateFinder;
    }

    void _t3__generateFinder(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * Find a document by the given {@link ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository#criteria() criteria}. Use the returned {@link Finder} object to complete").ln();
        __.out(" * {@link Finder#fetchAll() fetch}  operations.").ln();
        __.out(" ");
        __.dl();
        if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
            __.dl();
            __.ln();
            __.out(" * You can also use {@link Finder#andModifyFirst() modify} or {@link Finder#deleteFirst() delete}").ln();
            __.out(" * operations to update / delete the document(s).").ln();
            __.out(" ");
        }
        __.dl();
        __.ln();
        __.out(" * @param criteria The search criteria").ln();
        __.out(" * @return A finder object used to complete operations").ln();
        __.out(" */").ln();
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("public Finder find(Criteria criteria) {").ln();
        __.out("  return new Finder(this, criteria.constraint);").ln();
        __.out("}").ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * The finder object used to proceed with find operations via the").ln();
        __.out(" * {@link Finder#fetchAll()}, {@link Finder#fetchFirst()}");
        __.dl();
        if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
            __.dl();
            __.out(", {@link Finder#andModifyFirst()}, or {@link Finder#deleteFirst()}");
        }
        __.dl();
        __.out(" methods.").ln();
        __.out(" * Configure exclusion and sort ordering for results using the family of {@code exclude*()} and {@code orderBy*()} attribute-specific methods.").ln();
        __.out(" * @see ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository#find(Criteria)").ln();
        __.out(" */").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atNotThreadSafe, (Object[])new Object[]{type});
        __.ln();
        __.out("public static final class Finder extends Repositories.");
        __.dl();
        if (Intrinsics.$if((boolean)type.getRepository().readonly())) {
            __.dl();
            __.out("Finder");
        } else {
            __.dl();
            __.out("FinderWithDelete");
        }
        __.dl();
        __.out("<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(", Finder> {").ln();
        __.out("  private final Serialization serialization;").ln();
        __.ln();
        __.out("  private Finder(");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository repository, Constraints.ConstraintHost criteria) {").ln();
        __.out("    super(repository);").ln();
        __.out("    this.criteria = criteria;").ln();
        __.out("    this.serialization = repository.serialization;").ln();
        __.out("  }").ln();
        __.out("  ");
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateOrderingAndExcludes, (Object[])new Object[]{type, "Finder"});
        __.ln();
        __.dl();
        if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)type.getRepository().readonly()))) {
            __.dl();
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateAndModifyFirst, (Object[])new Object[]{type});
            __.ln();
            __.out("  ");
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateAndReplaceFirst, (Object[])new Object[]{type});
            __.ln();
        }
        __.dl();
        __.ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateAndReplaceFirst() {
        return this.generateAndReplaceFirst;
    }

    void _t4__generateAndReplaceFirst(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * Used to replace in-place existing version of the document").ln();
        __.out(" */").ln();
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("public Replacer andReplaceFirst(");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(" document) {").ln();
        __.out("  return new Replacer((");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository) repository, document, criteria, ordering);").ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateAndModifyFirst() {
        return this.generateAndModifyFirst;
    }

    void _t5__generateAndModifyFirst(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * Turn a find operation into an atomic {@link DBCollection#findAndModify(DBObject, DBObject, DBObject, boolean, DBObject, boolean, boolean) findAndModify}").ln();
        __.out(" * operation. Use the family of {@code set*()}, {@code unset*()}, {@code add*()}, {@code remove*()}, {@code put*()}m and {@code init*()}").ln();
        __.out(" * (and other attribute-specific) methods to describe the modification.").ln();
        __.out(" * @return A modifier object to complete the {@code findAndModify} operation").ln();
        __.out(" */").ln();
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("public Modifier andModifyFirst() {").ln();
        __.out("  return new Modifier((");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository) repository, criteria, ordering, exclusion);").ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateIndexer() {
        return this.generateIndexer;
    }

    void _t6__generateIndexer(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * {@link DBCollection#createIndex(DBObject, DBObject) Ensure an index} on collection ");
        Intrinsics.$((Templates.Invokation)__, (String)type.getDocumentName());
        __.out(" by one or").ln();
        __.out(" * more attributes using the family of {@code with*()} attribute-specific methods.").ln();
        __.out(" * While indexes will usually be maintained by special administration scripts, for simple cases it is convenient").ln();
        __.out(" * to ensure an index on application startup.").ln();
        __.out(" * @see Indexer#named(String)").ln();
        __.out(" * @see Indexer#unique()").ln();
        __.out(" * @return An indexer object to be completed with the {@link Indexer#ensure()} operation.").ln();
        __.out(" */").ln();
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("public Indexer index() {").ln();
        __.out("  return new Indexer(this);").ln();
        __.out("}").ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * An indexer used to create an index on the {@code \"");
        Intrinsics.$((Templates.Invokation)__, (String)type.getDocumentName());
        __.out("\"} collection if it does not exist by one or more attributes.").ln();
        __.out(" * @see DBCollection#createIndex(DBObject, DBObject)").ln();
        __.out(" */").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atNotThreadSafe, (Object[])new Object[]{type});
        __.ln();
        __.out("public static final class Indexer extends Repositories.Indexer<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(", Indexer> {").ln();
        __.out("  private final Serialization serialization;").ln();
        __.ln();
        __.out("  private Indexer(");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository repository) {").ln();
        __.out("    super(repository);").ln();
        __.out("    this.serialization = repository.serialization;").ln();
        __.out("  }").ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in(type.allMarshalingAttributes())) {
            __.dl();
            __.ln();
            __.ln();
            __.out("  /**").ln();
            __.out("   * Specify that the next attribute to index will be {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("}, in the ascending direction.").ln();
            __.out("   * @return {@code this} indexer for use in a chained invocation").ln();
            __.out("   */").ln();
            __.out("  public Indexer with");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("() {").ln();
            __.out("    fields = fields.equal(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name, false, 1);").ln();
            __.out("    return this;").ln();
            __.out("  }").ln();
            __.ln();
            __.out("  /**").ln();
            __.out("   * Specify that the next attribute to index will be {@link ");
            Intrinsics.$((Templates.Invokation)__, (String)type.name());
            __.out("#");
            Intrinsics.$((Templates.Invokation)__, (String)a.names.get);
            __.out("() ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("}, in the descending direction.").ln();
            __.out("   * @return {@code this} indexer for use in a chained invocation").ln();
            __.out("   */").ln();
            __.out("  public Indexer with");
            Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
            __.out("Desceding() {").ln();
            __.out("    fields = fields.equal(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name, false, -1);").ln();
            __.out("    return this;").ln();
            __.out("  }").ln();
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateUpdater() {
        return this.generateUpdater;
    }

    void _t7__generateUpdater(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * Update the set of {@code \"");
        Intrinsics.$((Templates.Invokation)__, (String)type.getDocumentName());
        __.out("\"} documents.").ln();
        __.out(" * @param criteria The search criteria for update").ln();
        __.out(" * @return An updater object that will be used to complete the update.").ln();
        __.out(" */").ln();
        HasStyleInfo s_atCheckReturnValue_2040523704 = (HasStyleInfo)Intrinsics.$cast((Object)type);
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s_atCheckReturnValue_2040523704, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.ln();
        __.out("public Updater update(Criteria criteria) {").ln();
        __.out("  return new Updater(this, criteria);").ln();
        __.out("}").ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * {@link #update(Criteria) Given} the criteria updater describes how to perform").ln();
        __.out(" * update operations on sets of documents.").ln();
        __.out(" */").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atNotThreadSafe, (Object[])new Object[]{type});
        __.ln();
        __.out("public static final class Updater extends Repositories.Updater<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out("> {").ln();
        __.out("  private final Serialization serialization;").ln();
        __.ln();
        __.out("  private Updater(");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository repository, Criteria criteria) {").ln();
        __.out("    super(repository);").ln();
        __.out("    this.criteria = criteria.constraint;").ln();
        __.out("    this.serialization = repository.serialization;").ln();
        __.out("  }").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateUpdatingMethods, (Object[])new Object[]{type, "Updater"});
        __.ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateReplacer() {
        return this.generateReplacer;
    }

    void _t8__generateReplacer(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atNotThreadSafe, (Object[])new Object[]{type});
        __.ln();
        __.out("public static final class Replacer extends Repositories.Replacer<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(", Replacer> {").ln();
        __.out("  protected Replacer(");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository repository, ");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(" document, Constraints.ConstraintHost criteria, Constraints.Constraint ordering) {").ln();
        __.out("    super(repository, document, criteria, ordering);").ln();
        __.out("  }").ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateModifier() {
        return this.generateModifier;
    }

    void _t9__generateModifier(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atNotThreadSafe, (Object[])new Object[]{type});
        __.ln();
        __.out("public static final class Modifier extends Repositories.Modifier<");
        Intrinsics.$((Templates.Invokation)__, (Object)type.typeDocument());
        __.out(", Modifier> {").ln();
        __.out("  private final Serialization serialization;").ln();
        __.ln();
        __.out("  private Modifier(").ln();
        __.out("      ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository repository,").ln();
        __.out("      Constraints.ConstraintHost criteria,").ln();
        __.out("      Constraints.Constraint ordering,").ln();
        __.out("      Constraints.Constraint exclusion) {").ln();
        __.out("    super(repository);").ln();
        __.out("    this.serialization = repository.serialization;").ln();
        __.out("    this.criteria = criteria;").ln();
        __.out("    this.ordering = ordering;").ln();
        __.out("    this.exclusion = exclusion;").ln();
        __.out("  }").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.generateUpdatingMethods, (Object[])new Object[]{type, "Modifier"});
        __.ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateUpdatingMethods() {
        return this.generateUpdatingMethods;
    }

    void _t10__generateUpdatingMethods(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        String tT = __.param(1).toString();
        __.ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in(type.allMarshalingAttributes())) {
            ValueAttribute a_wrapMarshalable_232215993;
            String wW = (String)Intrinsics.$cast((Object)a.getWrappedElementType());
            String uU = (String)Intrinsics.$cast((Object)a.getUnwrappedElementType());
            __.dl();
            __.ln();
            __.out("  ");
            __.dl();
            if (Intrinsics.$if((boolean)a.isCollectionType())) {
                __.dl();
                __.ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Clear the {@code ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)a.getRawCollectionType());
                __.out(" attribute.").ln();
                __.out("   * <p>").ln();
                __.dl();
                if (Intrinsics.$if((boolean)a.isForcedEmpty())) {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $set} operator resetting to empty array").ln();
                } else {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $unset} operator").ln();
                }
                __.dl();
                __.ln();
                __.out("   * @return {@code this} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                __.out(" to be used to complete the update operation").ln();
                __.out("   */").ln();
                __.out("  public ");
                Intrinsics.$((Templates.Invokation)__, (String)tT);
                __.out(" clear");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                __.out("() {").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isForcedEmpty())) {
                    __.dl();
                    __.ln();
                    __.out("    setFields = setFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, com.google.common.collect.ImmutableList.<Object>of());").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("    unsetFields = unsetFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, 1);").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.out("    return this;").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Remove a value from the {@code ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)a.getRawCollectionType());
                __.out(" attribute.").ln();
                __.out("   * <p>").ln();
                __.out("   * Corresponds to the MongoDB {@code $pull} operator.").ln();
                __.out("   * @param value The value to remove").ln();
                __.out("   * @return {@code this} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                __.out(" to be used to complete the update operation").ln();
                __.out("   */").ln();
                __.out("  public ");
                Intrinsics.$((Templates.Invokation)__, (String)tT);
                __.out(" remove");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                __.out("(");
                Intrinsics.$((Templates.Invokation)__, (String)uU);
                __.out(" value) {").ln();
                __.out("    pullFields = pullFields.equal(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, ");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value));").ln();
                __.out("    return this;").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Add a value to the {@code ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)a.getRawCollectionType());
                __.out(" attribute.").ln();
                __.out("   * <p>").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isSetType())) {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $addToSet} operator.").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $push} operator.").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.out("   * @param value The value to add").ln();
                __.out("   * @return {@code this} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                __.out(" to be used to complete the update operation").ln();
                __.out("   */").ln();
                __.out("  public ");
                Intrinsics.$((Templates.Invokation)__, (String)tT);
                __.out(" add");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                __.out("(");
                Intrinsics.$((Templates.Invokation)__, (String)uU);
                __.out(" value) {").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isSetType())) {
                    __.dl();
                    __.ln();
                    __.out("    addToSetFields = addToSetFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("    pushFields = pushFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.out("    return this;").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Override all values of {@code ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)a.getRawCollectionType());
                __.out(" attribute.").ln();
                __.out("   *").ln();
                __.out("   * <p>Corresponds to the MongoDB {@code $set} operator on the array field.").ln();
                __.out("   * @param values The values to set").ln();
                __.out("   * @return {@code this} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                __.out(" to be used to complete the update operation").ln();
                __.out("   */").ln();
                __.out("   public ");
                Intrinsics.$((Templates.Invokation)__, (String)tT);
                __.out(" set");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                __.out("(Iterable<");
                Intrinsics.$((Templates.Invokation)__, (String)a.getConsumedElementType());
                __.out("> values) {").ln();
                __.out("     java.util.List<Object> wrappedValues = new java.util.ArrayList");
                Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                __.out("();").ln();
                __.out("     for (");
                Intrinsics.$((Templates.Invokation)__, (String)wW);
                __.out(" value : values) {").ln();
                __.out("       wrappedValues.add(");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value));").ln();
                __.out("     }").ln();
                __.ln();
                __.out("     setFields = setFields.equal(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, wrappedValues);").ln();
                __.out("     return this;").ln();
                __.out("   }").ln();
                __.ln();
                __.out("  /**").ln();
                __.out("   * Add all of the given values to the {@code ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)a.getRawCollectionType());
                __.out(" attribute.").ln();
                __.out("   * <p>").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isSetType())) {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $addToSet} operator with the {@code $each} modifier.").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("   * Corresponds to the MongoDB {@code $push} operator with the {@code $each} modifier.").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.out("   * @param values The values to add").ln();
                __.out("   * @return {@code this} ");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                __.out(" to be used to complete the update operation").ln();
                __.out("   */").ln();
                __.out("  public ");
                Intrinsics.$((Templates.Invokation)__, (String)tT);
                __.out(" addAll");
                Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                __.out("(Iterable<");
                Intrinsics.$((Templates.Invokation)__, (String)a.getConsumedElementType());
                __.out("> values) {").ln();
                __.out("    java.util.List<Object> wrappedValues = new java.util.ArrayList");
                Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                __.out("();").ln();
                __.out("    for (");
                Intrinsics.$((Templates.Invokation)__, (String)wW);
                __.out(" value : values) {").ln();
                __.out("      wrappedValues.add(");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value));").ln();
                __.out("    }").ln();
                __.out("    if (wrappedValues.isEmpty()) {").ln();
                __.out("      return this;").ln();
                __.out("    }").ln();
                __.out("    Object v = wrappedValues.size() == 1").ln();
                __.out("        ? wrappedValues.get(0)").ln();
                __.out("        : Support.bsonObjectAttribute(\"$each\", wrappedValues);").ln();
                __.ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isSetType())) {
                    __.dl();
                    __.ln();
                    __.out("    addToSetFields = addToSetFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, v);").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("    pushFields = pushFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, v);").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.out("    return this;").ln();
                __.out("  }").ln();
                __.ln();
            }
            __.dl();
            __.ln();
            __.dl();
            if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)a.isCollectionType()))) {
                __.dl();
                __.ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((boolean)a.isMapType())) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  /**").ln();
                    __.out("   * Clear the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} map attribute.").ln();
                    __.out("   * <p>").ln();
                    __.out("   * Corresponds to the MongoDB {@code $set} operator, used to reset to empty object").ln();
                    __.out("   * @return {@code this} ");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                    __.out(" to be used to complete the update operation").ln();
                    __.out("   */").ln();
                    __.out("  public ");
                    Intrinsics.$((Templates.Invokation)__, (String)tT);
                    __.out(" clear");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                    __.out("() {").ln();
                    __.out("    setFields = setFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, Support.emptyBsonObject());").ln();
                    __.out("    return this;").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  /**").ln();
                    __.out("   * Put the given key and value into the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} map attribute.").ln();
                    __.out("   * <p>").ln();
                    __.out("   * Corresponds to the MongoDB {@code $set} operator for nested objects").ln();
                    __.out("   * @param key The key").ln();
                    __.out("   * @param value The value").ln();
                    __.out("   * @return {@code this} ");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                    __.out(" to be used to complete the update operation").ln();
                    __.out("   */").ln();
                    __.out("  public ");
                    Intrinsics.$((Templates.Invokation)__, (String)tT);
                    __.out(" put");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                    __.out("(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" key, ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrappedSecondaryElementType());
                    __.out(" value) {").ln();
                    __.out("    setFields = setFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name + \".\" + key, false, ");
                    ValueAttribute a_wrapSecondaryMarshalable_1417580037 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapSecondaryMarshalable_1417580037.isRequiresMarshalingSecondaryAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapSecondaryMarshalable_1417580037.name());
                        __.out("SecondaryEncoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    return this;").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  /**").ln();
                    __.out("   * Remove the key to value mapping from the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} map attribute.").ln();
                    __.out("   * <p>").ln();
                    __.out("   * Corresponds to MongoDB {@code $unset} operator for nested objects").ln();
                    __.out("   * @param key The key").ln();
                    __.out("   * @return {@code this} ");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                    __.out(" to be used to complete the update operation").ln();
                    __.out("   */").ln();
                    __.out("  public ");
                    Intrinsics.$((Templates.Invokation)__, (String)tT);
                    __.out(" remove");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                    __.out("(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" key) {").ln();
                    __.out("    unsetFields = unsetFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name + \".\" + key, false, 1);").ln();
                    __.out("    return this;").ln();
                    __.out("  }").ln();
                    __.out("  ");
                } else {
                    __.dl();
                    __.ln();
                    __.out("    ");
                    __.dl();
                    if (Intrinsics.$if((boolean)a.isOptionalType())) {
                        __.dl();
                        __.ln();
                        __.ln();
                        __.out("  /**").ln();
                        __.out("   * Clear the optional {@code ");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("} attribute.").ln();
                        __.out("   * <p>").ln();
                        __.dl();
                        if (Intrinsics.$if((boolean)a.isForcedEmpty())) {
                            __.dl();
                            __.ln();
                            __.out("   * Corresponds to the MongoDB {@code $set} operator resetting to {@code null}").ln();
                        } else {
                            __.dl();
                            __.ln();
                            __.out("   * Corresponds to the MongoDB {@code $unset} operator").ln();
                        }
                        __.dl();
                        __.ln();
                        __.out("   * @return {@code this} ");
                        Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                        __.out(" to be used to complete the update operation").ln();
                        __.out("   */").ln();
                        __.out("  public ");
                        Intrinsics.$((Templates.Invokation)__, (String)tT);
                        __.out(" empty");
                        Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                        __.out("() {").ln();
                        __.out("      ");
                        __.dl();
                        if (Intrinsics.$if((boolean)a.isForcedEmpty())) {
                            __.dl();
                            __.ln();
                            __.out("    setFields = setFields.equal(serialization.");
                            Intrinsics.$((Templates.Invokation)__, (String)a.name());
                            __.out("Name, false, null);").ln();
                            __.out("      ");
                        } else {
                            __.dl();
                            __.ln();
                            __.out("    unsetFields = unsetFields.equal(serialization.");
                            Intrinsics.$((Templates.Invokation)__, (String)a.name());
                            __.out("Name, false, 1);").ln();
                            __.out("      ");
                        }
                        __.dl();
                        __.ln();
                        __.out("    return this;").ln();
                        __.out("  }").ln();
                        __.out("    ");
                    }
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  /**").ln();
                    __.out("   * Specify a new value for the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} attribute.").ln();
                    __.out("   * <p>").ln();
                    __.out("   * Corresponds to the MongoDB {@code $set} operator.").ln();
                    __.out("   * @param value A new value for the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} attribute").ln();
                    __.out("   * @return {@code this} ");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                    __.out(" to be used to complete the update operation").ln();
                    __.out("   */").ln();
                    __.out("  public ");
                    Intrinsics.$((Templates.Invokation)__, (String)tT);
                    __.out(" set");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                    __.out("(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" value) {").ln();
                    __.out("    setFields = setFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    return this;").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  /**").ln();
                    __.out("   * Specify an initial value for the {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} attribute. The value will be used if the document is").ln();
                    __.out("   * to be inserted. If one or more documents are found for an update, this value will not be used.").ln();
                    __.out("   * <p>").ln();
                    __.out("   * Corresponds to the MongoDB {@code $setOnInsert} operator.").ln();
                    __.out("   * @param value The {@code ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("} value for an insert.").ln();
                    __.out("   * @return {@code this} ");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                    __.out(" to be used to complete the update operation").ln();
                    __.out("   */").ln();
                    __.out("  public ");
                    Intrinsics.$((Templates.Invokation)__, (String)tT);
                    __.out(" init");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                    __.out("(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" value) {").ln();
                    __.out("    setOnInsertFields = setOnInsertFields.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    return this;").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("    ");
                    __.dl();
                    if (Intrinsics.$if((boolean)a.isNumberType())) {
                        __.dl();
                        __.ln();
                        __.out("  /**").ln();
                        __.out("   * Specify an increment amount for the {@code ");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("} attribute. If the document is to inserted").ln();
                        __.out("   * and no initial value has been provided, then {@code 0} will be the default value and the increment will adjust it.").ln();
                        __.out("   * <p>").ln();
                        __.out("   * Corresponds to the MongoDB {@code $inc} operator.").ln();
                        __.out("   * @param increment An amount by which to increment the {@code ");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("} attribute (may be negative)").ln();
                        __.out("   * @return {@code this} ");
                        Intrinsics.$((Templates.Invokation)__, (Function)this.toLower, (Object)tT);
                        __.out(" to be used to complete the update operation").ln();
                        __.out("   */").ln();
                        __.out("  public ");
                        Intrinsics.$((Templates.Invokation)__, (String)tT);
                        __.out(" increment");
                        Intrinsics.$((Templates.Invokation)__, (Function)this.toUpper, (Object)a.name());
                        __.out("(");
                        Intrinsics.$((Templates.Invokation)__, (String)uU);
                        __.out(" increment) {").ln();
                        __.out("    incrementFields = incrementFields.equal(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("Name, false, increment);").ln();
                        __.out("    return this;").ln();
                        __.out("  }").ln();
                        __.out("      ");
                    }
                    __.dl();
                    __.ln();
                    __.out("    ");
                }
                __.dl();
                __.ln();
                __.out("  ");
            }
            __.dl();
            __.ln();
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable generateCriteria() {
        return this.generateCriteria;
    }

    void _t11__generateCriteria(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * Search criteria.").ln();
        __.out(" * Returns an initial object to create criteria by invoking methods that describe attribute specific constraints.").ln();
        __.out(" * @return An empty immutable criteria").ln();
        __.out(" */").ln();
        __.out("public Criteria criteria() {").ln();
        __.out("  return anyCriteria;").ln();
        __.out("}").ln();
        __.ln();
        __.out("@com.google.common.annotations.Beta").ln();
        __.out("Bson toBson(Criteria criteria) {").ln();
        __.out("  return Support.convertToBson(criteria.constraint);").ln();
        __.out("}").ln();
        __.ln();
        __.out("/**").ln();
        __.out(" * {@code ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository.Criteria} is a ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out(" document search query.").ln();
        __.out(" * Call methods on the criteria to add constraints for search queries.").ln();
        __.out(" */").ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        __.out("@javax.annotation.concurrent.Immutable").ln();
        __.out("@SuppressWarnings(\"unchecked\")").ln();
        __.out("public static final class Criteria extends Repositories.Criteria {").ln();
        __.out("  private final Constraints.Constraint constraint;").ln();
        __.out("  private final Serialization serialization;").ln();
        __.ln();
        __.out("  Criteria(Serialization serialization, Constraints.Constraint constraint) {").ln();
        __.out("    this.constraint = constraint;").ln();
        __.out("    this.serialization = serialization;").ln();
        __.out("  }").ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in(type.allMarshalingAttributes())) {
            ValueAttribute a_wrapMarshalable_232215993;
            String wW = (String)Intrinsics.$cast((Object)a.getWrappedElementType());
            String uU = (String)Intrinsics.$cast((Object)a.getUnwrappedElementType());
            __.dl();
            __.ln();
            __.dl();
            if (Intrinsics.$if((boolean)a.isCollectionType())) {
                __.dl();
                __.ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Empty() {").ln();
                __.out("    return new Criteria(serialization, constraint.size(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, 0));").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("NonEmpty() {").ln();
                __.out("    return new Criteria(serialization, constraint.size(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, true, 0));").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Size(int size) {").ln();
                __.out("    return new Criteria(serialization, constraint.size(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, size));").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Contains(");
                Intrinsics.$((Templates.Invokation)__, (String)uU);
                __.out(" value) {").ln();
                __.out("    return new Criteria(serialization, constraint.equal(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, ");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value)));").ln();
                __.out("  }").ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("ContainsAll(Iterable<");
                Intrinsics.$((Templates.Invokation)__, (String)wW);
                __.out("> values) {").ln();
                __.out("    java.util.List<Object> wrappedValues = new java.util.ArrayList");
                Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                __.out("();").ln();
                __.out("    for (");
                Intrinsics.$((Templates.Invokation)__, (String)wW);
                __.out(" value : values) {").ln();
                __.out("      wrappedValues.add(");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value));").ln();
                __.out("    }").ln();
                __.out("    return new Criteria(serialization, constraint.nested(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, Constraints.nilConstraint().equal(\"$all\", false, wrappedValues)));").ln();
                __.out("  }").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)wW, (Templates.Binary)this.eq, (Object)"java.lang.String")))) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("AnyStartsWith(String prefix) {").ln();
                    __.out("    return new Criteria(serialization, constraint.match(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, Constraints.prefixPatternOf(prefix)));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("AnyMatches(java.util.regex.Pattern pattern) {").ln();
                    __.out("    return new Criteria(serialization, constraint.match(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, pattern));").ln();
                    __.out("  }").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
            }
            __.dl();
            __.ln();
            __.dl();
            if (Intrinsics.$if((boolean)Intrinsics.$((Predicate)this.not, (Object)a.isCollectionType()))) {
                __.dl();
                __.ln();
                __.out("  ");
                __.dl();
                __.ln();
                __.ln();
                __.out("  public Criteria ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("(");
                Intrinsics.$((Templates.Invokation)__, (String)uU);
                __.out(" value) {").ln();
                __.out("    return new Criteria(serialization, constraint.equal(serialization.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name, false, ");
                a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                __.dl();
                if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                    __.dl();
                    __.out("Support.writable(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                    __.out("Encoder, ");
                } else {
                    __.dl();
                    __.out("Support.writable(");
                }
                __.dl();
                __.out("value)));").ln();
                __.out("  }").ln();
                __.out("  ");
                __.dl();
                if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)uU, (Templates.Binary)this.ne, (Object)"boolean")))) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Not(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" value) {").ln();
                    __.out("    return new Criteria(serialization, constraint.equal(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, true, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value)));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(Iterable<");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out("> values) {").ln();
                    __.out("    java.util.List<Object> wrappedValues = new java.util.ArrayList");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                    __.out("();").ln();
                    __.out("    for (");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out(" value : values) {").ln();
                    __.out("      wrappedValues.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    }").ln();
                    __.out("    return new Criteria(serialization, constraint.in(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, wrappedValues));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" first, ");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" second, ");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out("... rest) {").ln();
                    __.out("    java.util.List<Object> values = new java.util.ArrayList");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                    __.out("(2 + rest.length);").ln();
                    __.out("    values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("first));").ln();
                    __.out("    values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("second));").ln();
                    __.out("    for (");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" value : rest) {").ln();
                    __.out("      values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    }").ln();
                    __.out("    return new Criteria(serialization, constraint.in(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, values));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("NotIn(Iterable<");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out("> values) {").ln();
                    __.out("    java.util.List<Object> wrappedValues = new java.util.ArrayList");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                    __.out("();").ln();
                    __.out("    for (");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out(" value : values) {").ln();
                    __.out("      wrappedValues.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    }").ln();
                    __.out("    return new Criteria(serialization, constraint.in(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, true, wrappedValues));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("NotIn(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" first, ");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" second, ");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out("... rest) {").ln();
                    __.out("    java.util.List<Object> values = new java.util.ArrayList");
                    Intrinsics.$((Templates.Invokation)__, (Function)this.asDiamond, (Object)"Object");
                    __.out("(2 + rest.length);").ln();
                    __.out("    values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("first));").ln();
                    __.out("    values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("second));").ln();
                    __.out("    for (");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" value : rest) {").ln();
                    __.out("      values.add(");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("value));").ln();
                    __.out("    }").ln();
                    __.out("    return new Criteria(serialization, constraint.in(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, true, values));").ln();
                    __.out("  }").ln();
                    __.out("  ");
                }
                __.dl();
                __.ln();
                __.dl();
                if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)a.isStringType(), (Templates.Binary)this.or, (Object)Intrinsics.$((Object)a.isOptionalType(), (Templates.Binary)this.and, (Object)Intrinsics.$((Object)uU, (Templates.Binary)this.eq, (Object)"java.lang.String")))))) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("StartsWith(String prefix) {").ln();
                    __.out("    return new Criteria(serialization, constraint.match(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, Constraints.prefixPatternOf(prefix)));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Matches(java.util.regex.Pattern pattern) {").ln();
                    __.out("    return new Criteria(serialization, constraint.match(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, pattern));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("NotMatches(java.util.regex.Pattern pattern) {").ln();
                    __.out("    return new Criteria(serialization, constraint.match(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, true, pattern));").ln();
                    __.out("  }").ln();
                }
                __.dl();
                __.ln();
                __.dl();
                if (Intrinsics.$if((boolean)a.isOptionalType())) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Present() {").ln();
                    __.out("  ");
                    __.dl();
                    if (Intrinsics.$if((boolean)type.isUseConstructorOnly())) {
                        __.dl();
                        __.ln();
                        __.out("    return new Criteria(serialization, constraint.equal(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("Name, true, null));").ln();
                        __.out("  ");
                    } else {
                        __.dl();
                        __.ln();
                        __.out("    return new Criteria(serialization, constraint.present(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("Name, false));").ln();
                        __.out("  ");
                    }
                    __.dl();
                    __.ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Absent() {").ln();
                    __.out("  ");
                    __.dl();
                    if (Intrinsics.$if((boolean)type.isUseConstructorOnly())) {
                        __.dl();
                        __.ln();
                        __.out("    return new Criteria(serialization, constraint.equal(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("Name, false, null));").ln();
                        __.out("  ");
                    } else {
                        __.dl();
                        __.ln();
                        __.out("    return new Criteria(serialization, constraint.present(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a.name());
                        __.out("Name, true));").ln();
                        __.out("  ");
                    }
                    __.dl();
                    __.ln();
                    __.out("  }").ln();
                }
                __.dl();
                __.ln();
                __.dl();
                if (Intrinsics.$if((boolean)a.isComparable())) {
                    __.dl();
                    __.ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("GreaterThan(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" lower) {").ln();
                    __.out("    return ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(com.google.common.collect.Range.greaterThan(lower));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("LessThan(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" upper) {").ln();
                    __.out("    return ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(com.google.common.collect.Range.lessThan(upper));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("AtMost(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" upperInclusive) {").ln();
                    __.out("    return ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(com.google.common.collect.Range.atMost(upperInclusive));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("AtLeast(");
                    Intrinsics.$((Templates.Invokation)__, (String)uU);
                    __.out(" lowerInclusive) {").ln();
                    __.out("    return ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(com.google.common.collect.Range.atLeast(lowerInclusive));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("In(com.google.common.collect.Range<");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out("> range) {").ln();
                    __.out("    return new Criteria(serialization, constraint.range(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, false, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("range)));").ln();
                    __.out("  }").ln();
                    __.ln();
                    __.out("  public Criteria ");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("NotIn(com.google.common.collect.Range<");
                    Intrinsics.$((Templates.Invokation)__, (String)wW);
                    __.out("> range) {").ln();
                    __.out("    return new Criteria(serialization, constraint.range(serialization.");
                    Intrinsics.$((Templates.Invokation)__, (String)a.name());
                    __.out("Name, true, ");
                    a_wrapMarshalable_232215993 = (ValueAttribute)Intrinsics.$cast((Object)a);
                    __.dl();
                    if (Intrinsics.$if((boolean)a_wrapMarshalable_232215993.isRequiresMarshalingAdapter())) {
                        __.dl();
                        __.out("Support.writable(serialization.");
                        Intrinsics.$((Templates.Invokation)__, (String)a_wrapMarshalable_232215993.name());
                        __.out("Encoder, ");
                    } else {
                        __.dl();
                        __.out("Support.writable(");
                    }
                    __.dl();
                    __.out("range)));").ln();
                    __.out("  }").ln();
                }
                __.dl();
                __.ln();
            }
            __.dl();
            __.ln();
            __.dl();
            ++_it1.index;
            _it1.first = false;
        }
        __.dl();
        __.ln();
        __.ln();
        __.out("  @Override").ln();
        __.out("  public Criteria or() {").ln();
        __.out("    return new Criteria(serialization, constraint.disjunction());").ln();
        __.out("  }").ln();
        __.ln();
        __.out("  public Criteria with(Criteria criteria) {").ln();
        __.out("    return new Criteria(serialization, criteria.constraint.accept(constraint));").ln();
        __.out("  }").ln();
        __.ln();
        __.out("  @Override").ln();
        __.out("  public String toString() {").ln();
        __.out("    return \"");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("Repository.criteria(\" + Support.stringify(constraint) + \")\";").ln();
        __.out("  }").ln();
        __.out("}").ln();
        __.dl();
    }

    Templates.Invokable generateSerializationHelpers() {
        return this.generateSerializationHelpers;
    }

    void _t12__generateSerializationHelpers(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        List allAttributes = (List)Intrinsics.$cast(type.allMarshalingAttributes());
        __.dl();
        __.ln();
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        __.out("private static class Serialization {").ln();
        __.out("  ");
        Templates.Iteration _it2 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in((Iterable)allAttributes)) {
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((boolean)a.isRequiresMarshalingAdapter())) {
                __.dl();
                __.ln();
                __.out("  final Encoder<");
                Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawElementType());
                __.out("> ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Encoder;").ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((boolean)a.isRequiresMarshalingSecondaryAdapter())) {
                __.dl();
                __.ln();
                __.out("  final Encoder<");
                Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawSecondaryElementType());
                __.out("> ");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("SecondaryEncoder;").ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("  ");
            __.dl();
            ++_it2.index;
            _it2.first = false;
        }
        __.dl();
        __.ln();
        __.out("  final CodecRegistry registry;").ln();
        __.out("  ");
        _it2 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in((Iterable)allAttributes)) {
            __.dl();
            __.ln();
            __.out("  final String ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Name;").ln();
            __.out("  ");
            __.dl();
            ++_it2.index;
            _it2.first = false;
        }
        __.dl();
        __.ln();
        __.ln();
        __.out("  Serialization(CodecRegistry registry, RepositorySetup.FieldNamingStrategy fieldNamingStrategy) {").ln();
        __.out("    this.registry = registry;").ln();
        __.out("  ");
        _it2 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in((Iterable)allAttributes)) {
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((boolean)a.isRequiresMarshalingAdapter())) {
                __.dl();
                __.ln();
                __.out("    ");
                Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.getEncoder, (Object[])new Object[]{a, false});
                __.ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((boolean)a.isRequiresMarshalingSecondaryAdapter())) {
                __.dl();
                __.ln();
                __.out("    ");
                Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.getEncoder, (Object[])new Object[]{a, true});
                __.ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("  ");
            __.dl();
            ++_it2.index;
            _it2.first = false;
        }
        __.dl();
        __.ln();
        __.out("  ");
        _it2 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in((Iterable)allAttributes)) {
            __.dl();
            __.ln();
            __.out("    ");
            __.dl();
            if (Intrinsics.$if((String)a.getSerializedName())) {
                __.dl();
                __.ln();
                __.out("    this.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name = \"");
                Intrinsics.$((Templates.Invokation)__, (String)a.getSerializedName());
                __.out("\";").ln();
                __.out("    ");
            } else {
                __.dl();
                __.ln();
                __.out("    this.");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("Name = translateName(fieldNamingStrategy, \"");
                Intrinsics.$((Templates.Invokation)__, (String)a.name());
                __.out("\");").ln();
                __.out("    ");
            }
            __.dl();
            __.ln();
            __.out("  ");
            __.dl();
            ++_it2.index;
            _it2.first = false;
        }
        __.dl();
        __.ln();
        __.out("  }").ln();
        __.ln();
        __.out("  ");
        Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.atGenerated, (Object[])new Object[]{type});
        __.ln();
        __.out("  static final class ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("NamingFields");
        Intrinsics.$((Templates.Invokation)__, (Object)type.generics());
        __.out(" {").ln();
        __.out("  ");
        _it2 = new Templates.Iteration();
        for (ValueAttribute a : Intrinsics.$in((Iterable)allAttributes)) {
            __.dl();
            __.ln();
            __.out("    public ");
            Intrinsics.$((Templates.Invokation)__, (String)a.getType());
            __.out(" ");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out(";").ln();
            __.out("  ");
            __.dl();
            ++_it2.index;
            _it2.first = false;
        }
        __.dl();
        __.ln();
        __.out("  }").ln();
        __.ln();
        __.out("  private static String translateName(RepositorySetup.FieldNamingStrategy fieldNamingStrategy, String fieldName) {").ln();
        __.out("    try {").ln();
        __.out("      return fieldNamingStrategy.translateName(").ln();
        __.out("          ");
        Intrinsics.$((Templates.Invokation)__, (String)type.name());
        __.out("NamingFields.class.getField(fieldName));").ln();
        __.out("    } catch (NoSuchFieldException noSuchField) {").ln();
        __.out("      throw new AssertionError(noSuchField);").ln();
        __.out("    }").ln();
        __.out("  }").ln();
        __.out("}").ln();
        __.dl();
        ++_it1.index;
        _it1.first = false;
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable getEncoder() {
        return this.getEncoder;
    }

    void _t13__getEncoder(Templates.Invokation __) {
        __.dl();
        final ValueAttribute a = (ValueAttribute)Intrinsics.$cast((Object)__.param(0));
        final Boolean secondary = Intrinsics.$if((Object)__.param(1));
        __.ln();
        Templates.Iteration _it1 = new Templates.Iteration();
        final List subs = (List)Intrinsics.$cast(a.getExpectedSubtypes());
        Boolean suppotedSubs = (Boolean)Intrinsics.$cast((Object)Intrinsics.$((Object)Intrinsics.$((Object)a.typeKind().isMapKind(), (Templates.Binary)this.and, (Object)secondary), (Templates.Binary)this.ornot, (Object)a.typeKind().isMapKind()));
        __.dl();
        __.ln();
        __.out("  ");
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)subs, (Templates.Binary)this.and, (Object)suppotedSubs)))) {
            __.dl();
            __.ln();
            Intrinsics.$((Templates.Invokation)__, (Templates.Invokable)this.output.error, (Object[])new Object[]{a.originalElement(), new Templates.Fragment(0){

                public void run(Templates.Invokation __) {
                    __.dl();
                    __.out("Repositories do not support inline @Gson.ExpectedSubtypes, please put this annotations").ln();
                    __.out("on the interface nested in class covered with @Gson.TypeAdapters. Or manually register on GsonBuilder following adapter:").ln();
                    __.out("org.immutables.gson.adapter.ExpectedSubtypesAdapter.create(gson, ");
                    __.dl();
                    if (Intrinsics.$if((Boolean)secondary)) {
                        __.dl();
                        Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawSecondaryElementType());
                    } else {
                        __.dl();
                        Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawElementType());
                    }
                    __.dl();
                    Templates.Iteration _it2 = new Templates.Iteration();
                    for (String s : Intrinsics.$in((Iterable)subs)) {
                        __.dl();
                        __.out(", TypeToken.get(");
                        Intrinsics.$((Templates.Invokation)__, (String)s);
                        __.out(".class)");
                        __.dl();
                        ++_it2.index;
                        _it2.first = false;
                    }
                    __.dl();
                    __.out(")").ln();
                    __.dl();
                }
            }});
            __.ln();
            __.out("  ");
        } else {
            __.dl();
            __.ln();
            __.out("this.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.dl();
            if (Intrinsics.$if((Boolean)secondary)) {
                __.dl();
                __.out("Secondary");
            }
            __.dl();
            __.out("Encoder = this.registry.get(");
            __.dl();
            if (Intrinsics.$if((Boolean)secondary)) {
                __.dl();
                Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawSecondaryElementType());
                __.out(".class");
            } else {
                __.dl();
                Intrinsics.$((Templates.Invokation)__, (String)a.getUnwrapperOrRawElementType());
                __.out(".class");
            }
            __.dl();
            __.out(");").ln();
            __.out("  ");
        }
        __.dl();
        __.ln();
        __.dl();
        ++_it1.index;
        _it1.first = false;
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable wrapMarshalable() {
        return this.wrapMarshalable;
    }

    void _t14__wrapMarshalable(Templates.Invokation __) {
        __.dl();
        ValueAttribute a = (ValueAttribute)Intrinsics.$cast((Object)__.param(0));
        __.dl();
        if (Intrinsics.$if((boolean)a.isRequiresMarshalingAdapter())) {
            __.dl();
            __.out("Support.writable(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("Encoder, ");
        } else {
            __.dl();
            __.out("Support.writable(");
        }
        __.dl();
        __.dl();
    }

    Templates.Invokable wrapSecondaryMarshalable() {
        return this.wrapSecondaryMarshalable;
    }

    void _t15__wrapSecondaryMarshalable(Templates.Invokation __) {
        __.dl();
        ValueAttribute a = (ValueAttribute)Intrinsics.$cast((Object)__.param(0));
        __.dl();
        if (Intrinsics.$if((boolean)a.isRequiresMarshalingSecondaryAdapter())) {
            __.dl();
            __.out("Support.writable(serialization.");
            Intrinsics.$((Templates.Invokation)__, (String)a.name());
            __.out("SecondaryEncoder, ");
        } else {
            __.dl();
            __.out("Support.writable(");
        }
        __.dl();
        __.dl();
    }

    Templates.Invokable atCheckReturnValue() {
        return this.atCheckReturnValue;
    }

    void _t16__atCheckReturnValue(Templates.Invokation __) {
        __.dl();
        HasStyleInfo s = (HasStyleInfo)Intrinsics.$cast((Object)__.param(0));
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)s, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.CheckReturnValue")))) {
            __.dl();
            __.out("@javax.annotation.CheckReturnValue");
        }
        __.dl();
        __.dl();
    }

    Templates.Invokable atNotThreadSafe() {
        return this.atNotThreadSafe;
    }

    void _t17__atNotThreadSafe(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"javax.annotation.concurrent.NotThreadSafe")))) {
            __.dl();
            __.ln();
            __.out("@javax.annotation.concurrent.NotThreadSafe").ln();
        }
        __.dl();
        __.ln();
        __.dl();
    }

    Templates.Invokable atGenerated() {
        return this.atGenerated;
    }

    void _t18__atGenerated(Templates.Invokation __) {
        __.dl();
        ValueType type = (ValueType)Intrinsics.$cast((Object)__.param(0));
        __.ln();
        __.dl();
        if (Intrinsics.$if((Boolean)((Boolean)Intrinsics.$((Object)type, (Templates.Binary)this.allowsClasspathAnnotation, (Object)"org.immutables.value.Generated")))) {
            __.dl();
            __.ln();
            __.out("@org.immutables.value.Generated(from = \"");
            Intrinsics.$((Templates.Invokation)__, (String)type.typeAbstract().relativeRaw());
            __.out("\", generator = \"Repositories\")").ln();
        }
        __.dl();
        __.ln();
        __.dl();
    }

    private class FragmentDispatch
    extends Templates.Fragment {
        private final int index;

        FragmentDispatch(int arity, int index) {
            super(arity);
            this.index = index;
        }

        public void run(Templates.Invokation invokation) {
            switch (this.index) {
                case 0: {
                    Generator_Repositories.this._t0__generate(invokation);
                    break;
                }
                case 1: {
                    Generator_Repositories.this._t1__generateRepository(invokation);
                    break;
                }
                case 2: {
                    Generator_Repositories.this._t2__generateOrderingAndExcludes(invokation);
                    break;
                }
                case 3: {
                    Generator_Repositories.this._t3__generateFinder(invokation);
                    break;
                }
                case 4: {
                    Generator_Repositories.this._t4__generateAndReplaceFirst(invokation);
                    break;
                }
                case 5: {
                    Generator_Repositories.this._t5__generateAndModifyFirst(invokation);
                    break;
                }
                case 6: {
                    Generator_Repositories.this._t6__generateIndexer(invokation);
                    break;
                }
                case 7: {
                    Generator_Repositories.this._t7__generateUpdater(invokation);
                    break;
                }
                case 8: {
                    Generator_Repositories.this._t8__generateReplacer(invokation);
                    break;
                }
                case 9: {
                    Generator_Repositories.this._t9__generateModifier(invokation);
                    break;
                }
                case 10: {
                    Generator_Repositories.this._t10__generateUpdatingMethods(invokation);
                    break;
                }
                case 11: {
                    Generator_Repositories.this._t11__generateCriteria(invokation);
                    break;
                }
                case 12: {
                    Generator_Repositories.this._t12__generateSerializationHelpers(invokation);
                    break;
                }
                case 13: {
                    Generator_Repositories.this._t13__getEncoder(invokation);
                    break;
                }
                case 14: {
                    Generator_Repositories.this._t14__wrapMarshalable(invokation);
                    break;
                }
                case 15: {
                    Generator_Repositories.this._t15__wrapSecondaryMarshalable(invokation);
                    break;
                }
                case 16: {
                    Generator_Repositories.this._t16__atCheckReturnValue(invokation);
                    break;
                }
                case 17: {
                    Generator_Repositories.this._t17__atNotThreadSafe(invokation);
                    break;
                }
                case 18: {
                    Generator_Repositories.this._t18__atGenerated(invokation);
                    break;
                }
            }
        }
    }
}

